// chrome/browser/lens/core/mojom/polygon.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/lens/core/mojom/polygon.mojom-shared-internal.h"


namespace lens::mojom {
class PolygonDataView;

class VertexDataView;



}  // lens::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::lens::mojom::PolygonDataView> {
  using Data = ::lens::mojom::internal::Polygon_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::lens::mojom::VertexDataView> {
  using Data = ::lens::mojom::internal::Vertex_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace lens::mojom {


enum class Polygon_VertexOrdering : int32_t {
  
  kUnspecified = 0,
  
  kClockwise = 1,
  
  kCounterClockwise = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, Polygon_VertexOrdering value);
inline bool IsKnownEnumValue(Polygon_VertexOrdering value) {
  return internal::Polygon_VertexOrdering_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Polygon_CoordinateType : int32_t {
  
  kUnspecified = 0,
  
  kNormalized = 1,
  
  kImage = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, Polygon_CoordinateType value);
inline bool IsKnownEnumValue(Polygon_CoordinateType value) {
  return internal::Polygon_CoordinateType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PolygonDataView {
 public:
  PolygonDataView() = default;

  PolygonDataView(
      internal::Polygon_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVertexDataView(
      mojo::ArrayDataView<VertexDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVertex(UserType* output) {
    
    auto* pointer = data_->vertex.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::lens::mojom::VertexDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVertexOrdering(UserType* output) const {
    auto data_value = data_->vertex_ordering;
    return mojo::internal::Deserialize<::lens::mojom::Polygon_VertexOrdering>(
        data_value, output);
  }
  Polygon_VertexOrdering vertex_ordering() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::Polygon_VertexOrdering>(data_->vertex_ordering));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCoordinateType(UserType* output) const {
    auto data_value = data_->coordinate_type;
    return mojo::internal::Deserialize<::lens::mojom::Polygon_CoordinateType>(
        data_value, output);
  }
  Polygon_CoordinateType coordinate_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::Polygon_CoordinateType>(data_->coordinate_type));
  }
 private:
  internal::Polygon_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VertexDataView {
 public:
  VertexDataView() = default;

  VertexDataView(
      internal::Vertex_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float y() const {
    return data_->y;
  }
 private:
  internal::Vertex_Data* data_ = nullptr;
};


}  // lens::mojom

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_POLYGON_MOJOM_DATA_VIEW_H_