// chrome/browser/lens/core/mojom/lens_side_panel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-params-data.h"
#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-shared-message-ids.h"

#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-import-headers.h"
#include "chrome/browser/lens/core/mojom/lens_side_panel.mojom-test-utils.h"


namespace lens::mojom {
// The declaration includes the definition on other builds.

LensSidePanelPageHandlerFactory::IPCStableHashFunction LensSidePanelPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensSidePanelPageHandlerFactory>(message.name())) {
    case messages::LensSidePanelPageHandlerFactory::kCreateSidePanelPageHandler: {
      return &LensSidePanelPageHandlerFactory::CreateSidePanelPageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensSidePanelPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensSidePanelPageHandlerFactory>(message.name())) {
      case messages::LensSidePanelPageHandlerFactory::kCreateSidePanelPageHandler:
            return "Receive lens::mojom::LensSidePanelPageHandlerFactory::CreateSidePanelPageHandler";
    }
  } else {
    switch (static_cast<messages::LensSidePanelPageHandlerFactory>(message.name())) {
      case messages::LensSidePanelPageHandlerFactory::kCreateSidePanelPageHandler:
            return "Receive reply lens::mojom::LensSidePanelPageHandlerFactory::CreateSidePanelPageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensSidePanelPageHandlerFactory::CreateSidePanelPageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed60dd27;  // IPCStableHash for lens::mojom::LensSidePanelPageHandlerFactory::CreateSidePanelPageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LensSidePanelPageHandlerFactoryProxy::LensSidePanelPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensSidePanelPageHandlerFactoryProxy::CreateSidePanelPageHandler(
    ::mojo::PendingReceiver<LensSidePanelPageHandler> in_handler, ::mojo::PendingRemote<LensSidePanelPage> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPageHandlerFactory::CreateSidePanelPageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<LensSidePanelPageHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<LensSidePanelPage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandlerFactory::kCreateSidePanelPageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::lens::mojom::LensSidePanelPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in LensSidePanelPageHandlerFactory.CreateSidePanelPageHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::lens::mojom::LensSidePanelPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in LensSidePanelPageHandlerFactory.CreateSidePanelPageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandlerFactory::Name_);
  message.set_method_name("CreateSidePanelPageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LensSidePanelPageHandlerFactoryStubDispatch::Accept(
    LensSidePanelPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensSidePanelPageHandlerFactory>(message->header()->name)) {
    case messages::LensSidePanelPageHandlerFactory::kCreateSidePanelPageHandler: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<LensSidePanelPageHandler> p_handler{};
      ::mojo::PendingRemote<LensSidePanelPage> p_page{};
      LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSidePanelPageHandler(        
        std::move(p_handler), 
        std::move(p_page));
      return true;
    }
  }
  return false;
}

// static
bool LensSidePanelPageHandlerFactoryStubDispatch::AcceptWithResponder(
    LensSidePanelPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensSidePanelPageHandlerFactory>(message->header()->name)) {
    case messages::LensSidePanelPageHandlerFactory::kCreateSidePanelPageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensSidePanelPageHandlerFactoryValidationInfo[] = {
    { &internal::LensSidePanelPageHandlerFactory_CreateSidePanelPageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensSidePanelPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensSidePanelPageHandlerFactory::Name_,
    kLensSidePanelPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

LensSidePanelPageHandler::IPCStableHashFunction LensSidePanelPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensSidePanelPageHandler>(message.name())) {
    case messages::LensSidePanelPageHandler::kPopAndLoadQueryFromHistory: {
      return &LensSidePanelPageHandler::PopAndLoadQueryFromHistory_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPageHandler::kGetIsContextualSearchbox: {
      return &LensSidePanelPageHandler::GetIsContextualSearchbox_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPageHandler::kOnScrollToMessage: {
      return &LensSidePanelPageHandler::OnScrollToMessage_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPageHandler::kRequestSendFeedback: {
      return &LensSidePanelPageHandler::RequestSendFeedback_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPageHandler::kOnAimMessage: {
      return &LensSidePanelPageHandler::OnAimMessage_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPageHandler::kOnImageQueryWithEmptyText: {
      return &LensSidePanelPageHandler::OnImageQueryWithEmptyText_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensSidePanelPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensSidePanelPageHandler>(message.name())) {
      case messages::LensSidePanelPageHandler::kPopAndLoadQueryFromHistory:
            return "Receive lens::mojom::LensSidePanelPageHandler::PopAndLoadQueryFromHistory";
      case messages::LensSidePanelPageHandler::kGetIsContextualSearchbox:
            return "Receive lens::mojom::LensSidePanelPageHandler::GetIsContextualSearchbox";
      case messages::LensSidePanelPageHandler::kOnScrollToMessage:
            return "Receive lens::mojom::LensSidePanelPageHandler::OnScrollToMessage";
      case messages::LensSidePanelPageHandler::kRequestSendFeedback:
            return "Receive lens::mojom::LensSidePanelPageHandler::RequestSendFeedback";
      case messages::LensSidePanelPageHandler::kOnAimMessage:
            return "Receive lens::mojom::LensSidePanelPageHandler::OnAimMessage";
      case messages::LensSidePanelPageHandler::kOnImageQueryWithEmptyText:
            return "Receive lens::mojom::LensSidePanelPageHandler::OnImageQueryWithEmptyText";
    }
  } else {
    switch (static_cast<messages::LensSidePanelPageHandler>(message.name())) {
      case messages::LensSidePanelPageHandler::kPopAndLoadQueryFromHistory:
            return "Receive reply lens::mojom::LensSidePanelPageHandler::PopAndLoadQueryFromHistory";
      case messages::LensSidePanelPageHandler::kGetIsContextualSearchbox:
            return "Receive reply lens::mojom::LensSidePanelPageHandler::GetIsContextualSearchbox";
      case messages::LensSidePanelPageHandler::kOnScrollToMessage:
            return "Receive reply lens::mojom::LensSidePanelPageHandler::OnScrollToMessage";
      case messages::LensSidePanelPageHandler::kRequestSendFeedback:
            return "Receive reply lens::mojom::LensSidePanelPageHandler::RequestSendFeedback";
      case messages::LensSidePanelPageHandler::kOnAimMessage:
            return "Receive reply lens::mojom::LensSidePanelPageHandler::OnAimMessage";
      case messages::LensSidePanelPageHandler::kOnImageQueryWithEmptyText:
            return "Receive reply lens::mojom::LensSidePanelPageHandler::OnImageQueryWithEmptyText";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensSidePanelPageHandler::PopAndLoadQueryFromHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41985ad1;  // IPCStableHash for lens::mojom::LensSidePanelPageHandler::PopAndLoadQueryFromHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPageHandler::GetIsContextualSearchbox_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc097cc88;  // IPCStableHash for lens::mojom::LensSidePanelPageHandler::GetIsContextualSearchbox
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPageHandler::OnScrollToMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ab96f77;  // IPCStableHash for lens::mojom::LensSidePanelPageHandler::OnScrollToMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPageHandler::RequestSendFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x66539419;  // IPCStableHash for lens::mojom::LensSidePanelPageHandler::RequestSendFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPageHandler::OnAimMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12f2518b;  // IPCStableHash for lens::mojom::LensSidePanelPageHandler::OnAimMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPageHandler::OnImageQueryWithEmptyText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71c6d7d0;  // IPCStableHash for lens::mojom::LensSidePanelPageHandler::OnImageQueryWithEmptyText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback(
      LensSidePanelPageHandler::GetIsContextualSearchboxCallback callback
      ) : callback_(std::move(callback)) {
  }

  LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback(const LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback&) = delete;
  LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback& operator=(const LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LensSidePanelPageHandler::GetIsContextualSearchboxCallback callback_;
};

LensSidePanelPageHandlerProxy::LensSidePanelPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensSidePanelPageHandlerProxy::PopAndLoadQueryFromHistory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPageHandler::PopAndLoadQueryFromHistory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kPopAndLoadQueryFromHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("PopAndLoadQueryFromHistory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageHandlerProxy::GetIsContextualSearchbox(
    GetIsContextualSearchboxCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPageHandler::GetIsContextualSearchbox");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kGetIsContextualSearchbox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("GetIsContextualSearchbox");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LensSidePanelPageHandlerProxy::OnScrollToMessage(
    const std::vector<std::string>& in_text_fragments, uint32_t in_pdf_page_number) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPageHandler::OnScrollToMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_fragments"), in_text_fragments,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_page_number"), in_pdf_page_number,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kOnScrollToMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_OnScrollToMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text_fragments)::BaseType>
      text_fragments_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& text_fragments_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_text_fragments,
    text_fragments_fragment,
    &text_fragments_validate_params);

  params->text_fragments.Set(
      text_fragments_fragment.is_null() ? nullptr : text_fragments_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text_fragments.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text_fragments in LensSidePanelPageHandler.OnScrollToMessage request");

  params->pdf_page_number = in_pdf_page_number;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("OnScrollToMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageHandlerProxy::RequestSendFeedback(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPageHandler::RequestSendFeedback");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kRequestSendFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_RequestSendFeedback_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("RequestSendFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageHandlerProxy::OnAimMessage(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPageHandler::OnAimMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kOnAimMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_OnAimMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in LensSidePanelPageHandler.OnAimMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("OnAimMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageHandlerProxy::OnImageQueryWithEmptyText(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPageHandler::OnImageQueryWithEmptyText");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kOnImageQueryWithEmptyText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("OnImageQueryWithEmptyText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LensSidePanelPageHandler::GetIsContextualSearchboxCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder> proxy(
        new LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LensSidePanelPageHandler::GetIsContextualSearchboxCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_contextual_searchbox);
};

bool LensSidePanelPageHandler_GetIsContextualSearchbox_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LensSidePanelPageHandler.1
  bool success = true;
  bool p_is_contextual_searchbox{};
  LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_contextual_searchbox = input_data_view.is_contextual_searchbox();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LensSidePanelPageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_contextual_searchbox));
  }
  return true;
}

void LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder::Run(
    bool in_is_contextual_searchbox) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply lens::mojom::LensSidePanelPageHandler::GetIsContextualSearchbox", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_contextual_searchbox"), in_is_contextual_searchbox,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPageHandler::kGetIsContextualSearchbox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_contextual_searchbox = in_is_contextual_searchbox;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPageHandler::Name_);
  message.set_method_name("GetIsContextualSearchbox");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LensSidePanelPageHandlerStubDispatch::Accept(
    LensSidePanelPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensSidePanelPageHandler>(message->header()->name)) {
    case messages::LensSidePanelPageHandler::kPopAndLoadQueryFromHistory: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPageHandler.0
      bool success = true;
      LensSidePanelPageHandler_PopAndLoadQueryFromHistory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PopAndLoadQueryFromHistory(        );
      return true;
    }
    case messages::LensSidePanelPageHandler::kGetIsContextualSearchbox: {
      break;
    }
    case messages::LensSidePanelPageHandler::kOnScrollToMessage: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPageHandler_OnScrollToMessage_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPageHandler_OnScrollToMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPageHandler.2
      bool success = true;
      std::vector<std::string> p_text_fragments{};
      uint32_t p_pdf_page_number{};
      LensSidePanelPageHandler_OnScrollToMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTextFragments(&p_text_fragments))
        success = false;
      if (success)
        p_pdf_page_number = input_data_view.pdf_page_number();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnScrollToMessage(        
        std::move(p_text_fragments), 
        std::move(p_pdf_page_number));
      return true;
    }
    case messages::LensSidePanelPageHandler::kRequestSendFeedback: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPageHandler_RequestSendFeedback_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPageHandler_RequestSendFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPageHandler.3
      bool success = true;
      LensSidePanelPageHandler_RequestSendFeedback_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSendFeedback(        );
      return true;
    }
    case messages::LensSidePanelPageHandler::kOnAimMessage: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPageHandler_OnAimMessage_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPageHandler_OnAimMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPageHandler.4
      bool success = true;
      std::vector<uint8_t> p_message{};
      LensSidePanelPageHandler_OnAimMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAimMessage(        
        std::move(p_message));
      return true;
    }
    case messages::LensSidePanelPageHandler::kOnImageQueryWithEmptyText: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPageHandler.5
      bool success = true;
      LensSidePanelPageHandler_OnImageQueryWithEmptyText_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnImageQueryWithEmptyText(        );
      return true;
    }
  }
  return false;
}

// static
bool LensSidePanelPageHandlerStubDispatch::AcceptWithResponder(
    LensSidePanelPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensSidePanelPageHandler>(message->header()->name)) {
    case messages::LensSidePanelPageHandler::kPopAndLoadQueryFromHistory: {
      break;
    }
    case messages::LensSidePanelPageHandler::kGetIsContextualSearchbox: {
      internal::LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data* params =
          reinterpret_cast<
              internal::LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LensSidePanelPageHandler.1
      bool success = true;
      LensSidePanelPageHandler_GetIsContextualSearchbox_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          LensSidePanelPageHandler_GetIsContextualSearchbox_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsContextualSearchbox(std::move(callback));
      return true;
    }
    case messages::LensSidePanelPageHandler::kOnScrollToMessage: {
      break;
    }
    case messages::LensSidePanelPageHandler::kRequestSendFeedback: {
      break;
    }
    case messages::LensSidePanelPageHandler::kOnAimMessage: {
      break;
    }
    case messages::LensSidePanelPageHandler::kOnImageQueryWithEmptyText: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensSidePanelPageHandlerValidationInfo[] = {
    { &internal::LensSidePanelPageHandler_PopAndLoadQueryFromHistory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPageHandler_GetIsContextualSearchbox_Params_Data::Validate,
     &internal::LensSidePanelPageHandler_GetIsContextualSearchbox_ResponseParams_Data::Validate},
    { &internal::LensSidePanelPageHandler_OnScrollToMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPageHandler_RequestSendFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPageHandler_OnAimMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPageHandler_OnImageQueryWithEmptyText_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensSidePanelPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensSidePanelPageHandler::Name_,
    kLensSidePanelPageHandlerValidationInfo);
}

bool LensSidePanelPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::lens::mojom::LensSidePanelPageHandler::Name_,
    kLensSidePanelPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

LensSidePanelPage::IPCStableHashFunction LensSidePanelPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensSidePanelPage>(message.name())) {
    case messages::LensSidePanelPage::kLoadResultsInFrame: {
      return &LensSidePanelPage::LoadResultsInFrame_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSetIsLoadingResults: {
      return &LensSidePanelPage::SetIsLoadingResults_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSetPageContentUploadProgress: {
      return &LensSidePanelPage::SetPageContentUploadProgress_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSetBackArrowVisible: {
      return &LensSidePanelPage::SetBackArrowVisible_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSetShowErrorPage: {
      return &LensSidePanelPage::SetShowErrorPage_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSuppressGhostLoader: {
      return &LensSidePanelPage::SuppressGhostLoader_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kPageContentTypeChanged: {
      return &LensSidePanelPage::PageContentTypeChanged_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kShowToast: {
      return &LensSidePanelPage::ShowToast_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSendClientMessageToAim: {
      return &LensSidePanelPage::SendClientMessageToAim_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kAimHandshakeReceived: {
      return &LensSidePanelPage::AimHandshakeReceived_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kAimResultsChanged: {
      return &LensSidePanelPage::AimResultsChanged_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kFocusResultsFrame: {
      return &LensSidePanelPage::FocusResultsFrame_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kSetIsOverlayShowing: {
      return &LensSidePanelPage::SetIsOverlayShowing_Sym::IPCStableHash;
    }
    case messages::LensSidePanelPage::kFocusSearchbox: {
      return &LensSidePanelPage::FocusSearchbox_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensSidePanelPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensSidePanelPage>(message.name())) {
      case messages::LensSidePanelPage::kLoadResultsInFrame:
            return "Receive lens::mojom::LensSidePanelPage::LoadResultsInFrame";
      case messages::LensSidePanelPage::kSetIsLoadingResults:
            return "Receive lens::mojom::LensSidePanelPage::SetIsLoadingResults";
      case messages::LensSidePanelPage::kSetPageContentUploadProgress:
            return "Receive lens::mojom::LensSidePanelPage::SetPageContentUploadProgress";
      case messages::LensSidePanelPage::kSetBackArrowVisible:
            return "Receive lens::mojom::LensSidePanelPage::SetBackArrowVisible";
      case messages::LensSidePanelPage::kSetShowErrorPage:
            return "Receive lens::mojom::LensSidePanelPage::SetShowErrorPage";
      case messages::LensSidePanelPage::kSuppressGhostLoader:
            return "Receive lens::mojom::LensSidePanelPage::SuppressGhostLoader";
      case messages::LensSidePanelPage::kPageContentTypeChanged:
            return "Receive lens::mojom::LensSidePanelPage::PageContentTypeChanged";
      case messages::LensSidePanelPage::kShowToast:
            return "Receive lens::mojom::LensSidePanelPage::ShowToast";
      case messages::LensSidePanelPage::kSendClientMessageToAim:
            return "Receive lens::mojom::LensSidePanelPage::SendClientMessageToAim";
      case messages::LensSidePanelPage::kAimHandshakeReceived:
            return "Receive lens::mojom::LensSidePanelPage::AimHandshakeReceived";
      case messages::LensSidePanelPage::kAimResultsChanged:
            return "Receive lens::mojom::LensSidePanelPage::AimResultsChanged";
      case messages::LensSidePanelPage::kFocusResultsFrame:
            return "Receive lens::mojom::LensSidePanelPage::FocusResultsFrame";
      case messages::LensSidePanelPage::kSetIsOverlayShowing:
            return "Receive lens::mojom::LensSidePanelPage::SetIsOverlayShowing";
      case messages::LensSidePanelPage::kFocusSearchbox:
            return "Receive lens::mojom::LensSidePanelPage::FocusSearchbox";
    }
  } else {
    switch (static_cast<messages::LensSidePanelPage>(message.name())) {
      case messages::LensSidePanelPage::kLoadResultsInFrame:
            return "Receive reply lens::mojom::LensSidePanelPage::LoadResultsInFrame";
      case messages::LensSidePanelPage::kSetIsLoadingResults:
            return "Receive reply lens::mojom::LensSidePanelPage::SetIsLoadingResults";
      case messages::LensSidePanelPage::kSetPageContentUploadProgress:
            return "Receive reply lens::mojom::LensSidePanelPage::SetPageContentUploadProgress";
      case messages::LensSidePanelPage::kSetBackArrowVisible:
            return "Receive reply lens::mojom::LensSidePanelPage::SetBackArrowVisible";
      case messages::LensSidePanelPage::kSetShowErrorPage:
            return "Receive reply lens::mojom::LensSidePanelPage::SetShowErrorPage";
      case messages::LensSidePanelPage::kSuppressGhostLoader:
            return "Receive reply lens::mojom::LensSidePanelPage::SuppressGhostLoader";
      case messages::LensSidePanelPage::kPageContentTypeChanged:
            return "Receive reply lens::mojom::LensSidePanelPage::PageContentTypeChanged";
      case messages::LensSidePanelPage::kShowToast:
            return "Receive reply lens::mojom::LensSidePanelPage::ShowToast";
      case messages::LensSidePanelPage::kSendClientMessageToAim:
            return "Receive reply lens::mojom::LensSidePanelPage::SendClientMessageToAim";
      case messages::LensSidePanelPage::kAimHandshakeReceived:
            return "Receive reply lens::mojom::LensSidePanelPage::AimHandshakeReceived";
      case messages::LensSidePanelPage::kAimResultsChanged:
            return "Receive reply lens::mojom::LensSidePanelPage::AimResultsChanged";
      case messages::LensSidePanelPage::kFocusResultsFrame:
            return "Receive reply lens::mojom::LensSidePanelPage::FocusResultsFrame";
      case messages::LensSidePanelPage::kSetIsOverlayShowing:
            return "Receive reply lens::mojom::LensSidePanelPage::SetIsOverlayShowing";
      case messages::LensSidePanelPage::kFocusSearchbox:
            return "Receive reply lens::mojom::LensSidePanelPage::FocusSearchbox";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensSidePanelPage::LoadResultsInFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7affb2a;  // IPCStableHash for lens::mojom::LensSidePanelPage::LoadResultsInFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SetIsLoadingResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c110ec6;  // IPCStableHash for lens::mojom::LensSidePanelPage::SetIsLoadingResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SetPageContentUploadProgress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3a36f95;  // IPCStableHash for lens::mojom::LensSidePanelPage::SetPageContentUploadProgress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SetBackArrowVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x882d5d42;  // IPCStableHash for lens::mojom::LensSidePanelPage::SetBackArrowVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SetShowErrorPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37d27398;  // IPCStableHash for lens::mojom::LensSidePanelPage::SetShowErrorPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SuppressGhostLoader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xafceb7cd;  // IPCStableHash for lens::mojom::LensSidePanelPage::SuppressGhostLoader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::PageContentTypeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41577522;  // IPCStableHash for lens::mojom::LensSidePanelPage::PageContentTypeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::ShowToast_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ce66e67;  // IPCStableHash for lens::mojom::LensSidePanelPage::ShowToast
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SendClientMessageToAim_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa0344036;  // IPCStableHash for lens::mojom::LensSidePanelPage::SendClientMessageToAim
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::AimHandshakeReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78c6a6b0;  // IPCStableHash for lens::mojom::LensSidePanelPage::AimHandshakeReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::AimResultsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e5ac4c8;  // IPCStableHash for lens::mojom::LensSidePanelPage::AimResultsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::FocusResultsFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23a0062f;  // IPCStableHash for lens::mojom::LensSidePanelPage::FocusResultsFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::SetIsOverlayShowing_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1037e5f0;  // IPCStableHash for lens::mojom::LensSidePanelPage::SetIsOverlayShowing
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensSidePanelPage::FocusSearchbox_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0aeb36b3;  // IPCStableHash for lens::mojom::LensSidePanelPage::FocusSearchbox
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LensSidePanelPageProxy::LensSidePanelPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensSidePanelPageProxy::LoadResultsInFrame(
    const ::GURL& in_results_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::LoadResultsInFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results_url"), in_results_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kLoadResultsInFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_LoadResultsInFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results_url)::BaseType> results_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_results_url,
    results_url_fragment);

  params->results_url.Set(
      results_url_fragment.is_null() ? nullptr : results_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results_url in LensSidePanelPage.LoadResultsInFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("LoadResultsInFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SetIsLoadingResults(
    bool in_is_loading) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::SetIsLoadingResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSetIsLoadingResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SetIsLoadingResults_Params_Data> params(
          message);
  params.Allocate();

  params->is_loading = in_is_loading;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SetIsLoadingResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SetPageContentUploadProgress(
    float in_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::SetPageContentUploadProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress"), in_progress,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSetPageContentUploadProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SetPageContentUploadProgress_Params_Data> params(
          message);
  params.Allocate();

  params->progress = in_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SetPageContentUploadProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SetBackArrowVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::SetBackArrowVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSetBackArrowVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SetBackArrowVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SetBackArrowVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SetShowErrorPage(
    bool in_should_show_error_page, SidePanelResultStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::SetShowErrorPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_show_error_page"), in_should_show_error_page,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type SidePanelResultStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSetShowErrorPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SetShowErrorPage_Params_Data> params(
          message);
  params.Allocate();

  params->should_show_error_page = in_should_show_error_page;

  
  mojo::internal::Serialize<::lens::mojom::SidePanelResultStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SetShowErrorPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SuppressGhostLoader(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPage::SuppressGhostLoader");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSuppressGhostLoader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SuppressGhostLoader_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SuppressGhostLoader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::PageContentTypeChanged(
    ::lens::mojom::PageContentType in_new_page_content_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::PageContentTypeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_page_content_type"), in_new_page_content_type,
                        "<value of type ::lens::mojom::PageContentType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kPageContentTypeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_PageContentTypeChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::lens::mojom::PageContentType>(
    in_new_page_content_type,
    &params->new_page_content_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("PageContentTypeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::ShowToast(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::ShowToast", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kShowToast), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_ShowToast_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in LensSidePanelPage.ShowToast request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("ShowToast");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SendClientMessageToAim(
    const std::vector<uint8_t>& in_serialized_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::SendClientMessageToAim", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serialized_message"), in_serialized_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSendClientMessageToAim), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SendClientMessageToAim_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->serialized_message)::BaseType>
      serialized_message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& serialized_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_serialized_message,
    serialized_message_fragment,
    &serialized_message_validate_params);

  params->serialized_message.Set(
      serialized_message_fragment.is_null() ? nullptr : serialized_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serialized_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serialized_message in LensSidePanelPage.SendClientMessageToAim request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SendClientMessageToAim");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::AimHandshakeReceived(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPage::AimHandshakeReceived");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kAimHandshakeReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_AimHandshakeReceived_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("AimHandshakeReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::AimResultsChanged(
    bool in_on_aim) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::AimResultsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("on_aim"), in_on_aim,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kAimResultsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_AimResultsChanged_Params_Data> params(
          message);
  params.Allocate();

  params->on_aim = in_on_aim;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("AimResultsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::FocusResultsFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPage::FocusResultsFrame");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kFocusResultsFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_FocusResultsFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("FocusResultsFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::SetIsOverlayShowing(
    bool in_is_showing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensSidePanelPage::SetIsOverlayShowing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_showing"), in_is_showing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kSetIsOverlayShowing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_SetIsOverlayShowing_Params_Data> params(
          message);
  params.Allocate();

  params->is_showing = in_is_showing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("SetIsOverlayShowing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensSidePanelPageProxy::FocusSearchbox(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensSidePanelPage::FocusSearchbox");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensSidePanelPage::kFocusSearchbox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensSidePanelPage_FocusSearchbox_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensSidePanelPage::Name_);
  message.set_method_name("FocusSearchbox");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LensSidePanelPageStubDispatch::Accept(
    LensSidePanelPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensSidePanelPage>(message->header()->name)) {
    case messages::LensSidePanelPage::kLoadResultsInFrame: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_LoadResultsInFrame_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_LoadResultsInFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.0
      bool success = true;
      ::GURL p_results_url{};
      LensSidePanelPage_LoadResultsInFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultsUrl(&p_results_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadResultsInFrame(        
        std::move(p_results_url));
      return true;
    }
    case messages::LensSidePanelPage::kSetIsLoadingResults: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SetIsLoadingResults_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SetIsLoadingResults_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.1
      bool success = true;
      bool p_is_loading{};
      LensSidePanelPage_SetIsLoadingResults_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsLoadingResults(        
        std::move(p_is_loading));
      return true;
    }
    case messages::LensSidePanelPage::kSetPageContentUploadProgress: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SetPageContentUploadProgress_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SetPageContentUploadProgress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.2
      bool success = true;
      float p_progress{};
      LensSidePanelPage_SetPageContentUploadProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_progress = input_data_view.progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageContentUploadProgress(        
        std::move(p_progress));
      return true;
    }
    case messages::LensSidePanelPage::kSetBackArrowVisible: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SetBackArrowVisible_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SetBackArrowVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.3
      bool success = true;
      bool p_visible{};
      LensSidePanelPage_SetBackArrowVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackArrowVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::LensSidePanelPage::kSetShowErrorPage: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SetShowErrorPage_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SetShowErrorPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.4
      bool success = true;
      bool p_should_show_error_page{};
      SidePanelResultStatus p_status{};
      LensSidePanelPage_SetShowErrorPage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_should_show_error_page = input_data_view.should_show_error_page();
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetShowErrorPage(        
        std::move(p_should_show_error_page), 
        std::move(p_status));
      return true;
    }
    case messages::LensSidePanelPage::kSuppressGhostLoader: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SuppressGhostLoader_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SuppressGhostLoader_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.5
      bool success = true;
      LensSidePanelPage_SuppressGhostLoader_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuppressGhostLoader(        );
      return true;
    }
    case messages::LensSidePanelPage::kPageContentTypeChanged: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_PageContentTypeChanged_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_PageContentTypeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.6
      bool success = true;
      ::lens::mojom::PageContentType p_new_page_content_type{};
      LensSidePanelPage_PageContentTypeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewPageContentType(&p_new_page_content_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PageContentTypeChanged(        
        std::move(p_new_page_content_type));
      return true;
    }
    case messages::LensSidePanelPage::kShowToast: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_ShowToast_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_ShowToast_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.7
      bool success = true;
      std::string p_message{};
      LensSidePanelPage_ShowToast_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowToast(        
        std::move(p_message));
      return true;
    }
    case messages::LensSidePanelPage::kSendClientMessageToAim: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SendClientMessageToAim_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SendClientMessageToAim_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.8
      bool success = true;
      std::vector<uint8_t> p_serialized_message{};
      LensSidePanelPage_SendClientMessageToAim_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSerializedMessage(&p_serialized_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendClientMessageToAim(        
        std::move(p_serialized_message));
      return true;
    }
    case messages::LensSidePanelPage::kAimHandshakeReceived: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_AimHandshakeReceived_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_AimHandshakeReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.9
      bool success = true;
      LensSidePanelPage_AimHandshakeReceived_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AimHandshakeReceived(        );
      return true;
    }
    case messages::LensSidePanelPage::kAimResultsChanged: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_AimResultsChanged_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_AimResultsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.10
      bool success = true;
      bool p_on_aim{};
      LensSidePanelPage_AimResultsChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_on_aim = input_data_view.on_aim();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AimResultsChanged(        
        std::move(p_on_aim));
      return true;
    }
    case messages::LensSidePanelPage::kFocusResultsFrame: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_FocusResultsFrame_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_FocusResultsFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.11
      bool success = true;
      LensSidePanelPage_FocusResultsFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusResultsFrame(        );
      return true;
    }
    case messages::LensSidePanelPage::kSetIsOverlayShowing: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_SetIsOverlayShowing_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_SetIsOverlayShowing_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.12
      bool success = true;
      bool p_is_showing{};
      LensSidePanelPage_SetIsOverlayShowing_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_showing = input_data_view.is_showing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsOverlayShowing(        
        std::move(p_is_showing));
      return true;
    }
    case messages::LensSidePanelPage::kFocusSearchbox: {
      DCHECK(message->is_serialized());
      internal::LensSidePanelPage_FocusSearchbox_Params_Data* params =
          reinterpret_cast<internal::LensSidePanelPage_FocusSearchbox_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensSidePanelPage.13
      bool success = true;
      LensSidePanelPage_FocusSearchbox_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensSidePanelPage::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusSearchbox(        );
      return true;
    }
  }
  return false;
}

// static
bool LensSidePanelPageStubDispatch::AcceptWithResponder(
    LensSidePanelPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensSidePanelPage>(message->header()->name)) {
    case messages::LensSidePanelPage::kLoadResultsInFrame: {
      break;
    }
    case messages::LensSidePanelPage::kSetIsLoadingResults: {
      break;
    }
    case messages::LensSidePanelPage::kSetPageContentUploadProgress: {
      break;
    }
    case messages::LensSidePanelPage::kSetBackArrowVisible: {
      break;
    }
    case messages::LensSidePanelPage::kSetShowErrorPage: {
      break;
    }
    case messages::LensSidePanelPage::kSuppressGhostLoader: {
      break;
    }
    case messages::LensSidePanelPage::kPageContentTypeChanged: {
      break;
    }
    case messages::LensSidePanelPage::kShowToast: {
      break;
    }
    case messages::LensSidePanelPage::kSendClientMessageToAim: {
      break;
    }
    case messages::LensSidePanelPage::kAimHandshakeReceived: {
      break;
    }
    case messages::LensSidePanelPage::kAimResultsChanged: {
      break;
    }
    case messages::LensSidePanelPage::kFocusResultsFrame: {
      break;
    }
    case messages::LensSidePanelPage::kSetIsOverlayShowing: {
      break;
    }
    case messages::LensSidePanelPage::kFocusSearchbox: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensSidePanelPageValidationInfo[] = {
    { &internal::LensSidePanelPage_LoadResultsInFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SetIsLoadingResults_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SetPageContentUploadProgress_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SetBackArrowVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SetShowErrorPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SuppressGhostLoader_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_PageContentTypeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_ShowToast_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SendClientMessageToAim_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_AimHandshakeReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_AimResultsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_FocusResultsFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_SetIsOverlayShowing_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensSidePanelPage_FocusSearchbox_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensSidePanelPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensSidePanelPage::Name_,
    kLensSidePanelPageValidationInfo);
}



}  // lens::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace lens::mojom {


void LensSidePanelPageHandlerFactoryInterceptorForTesting::CreateSidePanelPageHandler(::mojo::PendingReceiver<LensSidePanelPageHandler> handler, ::mojo::PendingRemote<LensSidePanelPage> page) {
  GetForwardingInterface()->CreateSidePanelPageHandler(
    std::move(handler)
    , 
    std::move(page)
    );
}
LensSidePanelPageHandlerFactoryAsyncWaiter::LensSidePanelPageHandlerFactoryAsyncWaiter(
    LensSidePanelPageHandlerFactory* proxy) : proxy_(proxy) {}

LensSidePanelPageHandlerFactoryAsyncWaiter::~LensSidePanelPageHandlerFactoryAsyncWaiter() = default;





void LensSidePanelPageHandlerInterceptorForTesting::PopAndLoadQueryFromHistory() {
  GetForwardingInterface()->PopAndLoadQueryFromHistory();
}
void LensSidePanelPageHandlerInterceptorForTesting::GetIsContextualSearchbox(GetIsContextualSearchboxCallback callback) {
  GetForwardingInterface()->GetIsContextualSearchbox(std::move(callback));
}
void LensSidePanelPageHandlerInterceptorForTesting::OnScrollToMessage(const std::vector<std::string>& text_fragments, uint32_t pdf_page_number) {
  GetForwardingInterface()->OnScrollToMessage(
    std::move(text_fragments)
    , 
    std::move(pdf_page_number)
    );
}
void LensSidePanelPageHandlerInterceptorForTesting::RequestSendFeedback() {
  GetForwardingInterface()->RequestSendFeedback();
}
void LensSidePanelPageHandlerInterceptorForTesting::OnAimMessage(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnAimMessage(
    std::move(message)
    );
}
void LensSidePanelPageHandlerInterceptorForTesting::OnImageQueryWithEmptyText() {
  GetForwardingInterface()->OnImageQueryWithEmptyText();
}
LensSidePanelPageHandlerAsyncWaiter::LensSidePanelPageHandlerAsyncWaiter(
    LensSidePanelPageHandler* proxy) : proxy_(proxy) {}

LensSidePanelPageHandlerAsyncWaiter::~LensSidePanelPageHandlerAsyncWaiter() = default;


void LensSidePanelPageHandlerAsyncWaiter::GetIsContextualSearchbox(
    bool* out_is_contextual_searchbox) {
  base::RunLoop loop;
  proxy_->GetIsContextualSearchbox(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_contextual_searchbox
,
             bool is_contextual_searchbox) {*out_is_contextual_searchbox = std::move(is_contextual_searchbox);
            loop->Quit();
          },
          &loop,
          out_is_contextual_searchbox));
  loop.Run();
}

bool LensSidePanelPageHandlerAsyncWaiter::GetIsContextualSearchbox(
    ) {
  bool async_wait_result;
  GetIsContextualSearchbox(&async_wait_result);
  return async_wait_result;
}




void LensSidePanelPageInterceptorForTesting::LoadResultsInFrame(const ::GURL& results_url) {
  GetForwardingInterface()->LoadResultsInFrame(
    std::move(results_url)
    );
}
void LensSidePanelPageInterceptorForTesting::SetIsLoadingResults(bool is_loading) {
  GetForwardingInterface()->SetIsLoadingResults(
    std::move(is_loading)
    );
}
void LensSidePanelPageInterceptorForTesting::SetPageContentUploadProgress(float progress) {
  GetForwardingInterface()->SetPageContentUploadProgress(
    std::move(progress)
    );
}
void LensSidePanelPageInterceptorForTesting::SetBackArrowVisible(bool visible) {
  GetForwardingInterface()->SetBackArrowVisible(
    std::move(visible)
    );
}
void LensSidePanelPageInterceptorForTesting::SetShowErrorPage(bool should_show_error_page, SidePanelResultStatus status) {
  GetForwardingInterface()->SetShowErrorPage(
    std::move(should_show_error_page)
    , 
    std::move(status)
    );
}
void LensSidePanelPageInterceptorForTesting::SuppressGhostLoader() {
  GetForwardingInterface()->SuppressGhostLoader();
}
void LensSidePanelPageInterceptorForTesting::PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) {
  GetForwardingInterface()->PageContentTypeChanged(
    std::move(new_page_content_type)
    );
}
void LensSidePanelPageInterceptorForTesting::ShowToast(const std::string& message) {
  GetForwardingInterface()->ShowToast(
    std::move(message)
    );
}
void LensSidePanelPageInterceptorForTesting::SendClientMessageToAim(const std::vector<uint8_t>& serialized_message) {
  GetForwardingInterface()->SendClientMessageToAim(
    std::move(serialized_message)
    );
}
void LensSidePanelPageInterceptorForTesting::AimHandshakeReceived() {
  GetForwardingInterface()->AimHandshakeReceived();
}
void LensSidePanelPageInterceptorForTesting::AimResultsChanged(bool on_aim) {
  GetForwardingInterface()->AimResultsChanged(
    std::move(on_aim)
    );
}
void LensSidePanelPageInterceptorForTesting::FocusResultsFrame() {
  GetForwardingInterface()->FocusResultsFrame();
}
void LensSidePanelPageInterceptorForTesting::SetIsOverlayShowing(bool is_showing) {
  GetForwardingInterface()->SetIsOverlayShowing(
    std::move(is_showing)
    );
}
void LensSidePanelPageInterceptorForTesting::FocusSearchbox() {
  GetForwardingInterface()->FocusSearchbox();
}
LensSidePanelPageAsyncWaiter::LensSidePanelPageAsyncWaiter(
    LensSidePanelPage* proxy) : proxy_(proxy) {}

LensSidePanelPageAsyncWaiter::~LensSidePanelPageAsyncWaiter() = default;







}  // lens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif