// chrome/browser/lens/core/mojom/lens.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/lens/core/mojom/lens.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/lens.mojom-params-data.h"
#include "chrome/browser/lens/core/mojom/lens.mojom-shared-message-ids.h"

#include "chrome/browser/lens/core/mojom/lens.mojom-import-headers.h"
#include "chrome/browser/lens/core/mojom/lens.mojom-test-utils.h"


namespace lens::mojom {
OverlayTheme::OverlayTheme()
    : primary(),
      shader_layer_1(),
      shader_layer_2(),
      shader_layer_3(),
      shader_layer_4(),
      shader_layer_5(),
      scrim(),
      surface_container_highest_light(),
      surface_container_highest_dark(),
      selection_element() {}

OverlayTheme::OverlayTheme(
    ::SkColor primary_in,
    ::SkColor shader_layer_1_in,
    ::SkColor shader_layer_2_in,
    ::SkColor shader_layer_3_in,
    ::SkColor shader_layer_4_in,
    ::SkColor shader_layer_5_in,
    ::SkColor scrim_in,
    ::SkColor surface_container_highest_light_in,
    ::SkColor surface_container_highest_dark_in,
    ::SkColor selection_element_in)
    : primary(std::move(primary_in)),
      shader_layer_1(std::move(shader_layer_1_in)),
      shader_layer_2(std::move(shader_layer_2_in)),
      shader_layer_3(std::move(shader_layer_3_in)),
      shader_layer_4(std::move(shader_layer_4_in)),
      shader_layer_5(std::move(shader_layer_5_in)),
      scrim(std::move(scrim_in)),
      surface_container_highest_light(std::move(surface_container_highest_light_in)),
      surface_container_highest_dark(std::move(surface_container_highest_dark_in)),
      selection_element(std::move(selection_element_in)) {}

OverlayTheme::~OverlayTheme() = default;

void OverlayTheme::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary"), this->primary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shader_layer_1"), this->shader_layer_1,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shader_layer_2"), this->shader_layer_2,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shader_layer_3"), this->shader_layer_3,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shader_layer_4"), this->shader_layer_4,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shader_layer_5"), this->shader_layer_5,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrim"), this->scrim,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_container_highest_light"), this->surface_container_highest_light,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_container_highest_dark"), this->surface_container_highest_dark,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_element"), this->selection_element,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OverlayTheme::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LensPageHandlerFactory::IPCStableHashFunction LensPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensPageHandlerFactory>(message.name())) {
    case messages::LensPageHandlerFactory::kCreatePageHandler: {
      return &LensPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensPageHandlerFactory>(message.name())) {
      case messages::LensPageHandlerFactory::kCreatePageHandler:
            return "Receive lens::mojom::LensPageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::LensPageHandlerFactory>(message.name())) {
      case messages::LensPageHandlerFactory::kCreatePageHandler:
            return "Receive reply lens::mojom::LensPageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04b24923;  // IPCStableHash for lens::mojom::LensPageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LensPageHandlerFactoryProxy::LensPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensPageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingReceiver<LensPageHandler> in_handler, ::mojo::PendingRemote<LensPage> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<LensPageHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<LensPage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::lens::mojom::LensPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in LensPageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::lens::mojom::LensPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in LensPageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LensPageHandlerFactoryStubDispatch::Accept(
    LensPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensPageHandlerFactory>(message->header()->name)) {
    case messages::LensPageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::LensPageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::LensPageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<LensPageHandler> p_handler{};
      ::mojo::PendingRemote<LensPage> p_page{};
      LensPageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_handler), 
        std::move(p_page));
      return true;
    }
  }
  return false;
}

// static
bool LensPageHandlerFactoryStubDispatch::AcceptWithResponder(
    LensPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensPageHandlerFactory>(message->header()->name)) {
    case messages::LensPageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensPageHandlerFactoryValidationInfo[] = {
    { &internal::LensPageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensPageHandlerFactory::Name_,
    kLensPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

LensPageHandler::IPCStableHashFunction LensPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensPageHandler>(message.name())) {
    case messages::LensPageHandler::kActivityRequestedByOverlay: {
      return &LensPageHandler::ActivityRequestedByOverlay_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kCloseRequestedByOverlayCloseButton: {
      return &LensPageHandler::CloseRequestedByOverlayCloseButton_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kCloseRequestedByOverlayBackgroundClick: {
      return &LensPageHandler::CloseRequestedByOverlayBackgroundClick_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kNotifyOverlayInitialized: {
      return &LensPageHandler::NotifyOverlayInitialized_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kAddBackgroundBlur: {
      return &LensPageHandler::AddBackgroundBlur_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kSetLiveBlur: {
      return &LensPageHandler::SetLiveBlur_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kFeedbackRequestedByOverlay: {
      return &LensPageHandler::FeedbackRequestedByOverlay_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kGetOverlayInvocationSource: {
      return &LensPageHandler::GetOverlayInvocationSource_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kInfoRequestedByOverlay: {
      return &LensPageHandler::InfoRequestedByOverlay_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueLensRegionRequest: {
      return &LensPageHandler::IssueLensRegionRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueLensObjectRequest: {
      return &LensPageHandler::IssueLensObjectRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueTextSelectionRequest: {
      return &LensPageHandler::IssueTextSelectionRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueTranslateSelectionRequest: {
      return &LensPageHandler::IssueTranslateSelectionRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueMathSelectionRequest: {
      return &LensPageHandler::IssueMathSelectionRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueTranslateFullPageRequest: {
      return &LensPageHandler::IssueTranslateFullPageRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kIssueEndTranslateModeRequest: {
      return &LensPageHandler::IssueEndTranslateModeRequest_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kCopyText: {
      return &LensPageHandler::CopyText_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kCopyImage: {
      return &LensPageHandler::CopyImage_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kSaveAsImage: {
      return &LensPageHandler::SaveAsImage_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kClosePreselectionBubble: {
      return &LensPageHandler::ClosePreselectionBubble_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kRecordUkmAndTaskCompletionForLensOverlayInteraction: {
      return &LensPageHandler::RecordUkmAndTaskCompletionForLensOverlayInteraction_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kRecordLensOverlaySemanticEvent: {
      return &LensPageHandler::RecordLensOverlaySemanticEvent_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kMaybeShowTranslateFeaturePromo: {
      return &LensPageHandler::MaybeShowTranslateFeaturePromo_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kMaybeCloseTranslateFeaturePromo: {
      return &LensPageHandler::MaybeCloseTranslateFeaturePromo_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kFetchSupportedLanguages: {
      return &LensPageHandler::FetchSupportedLanguages_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kFinishReshowOverlay: {
      return &LensPageHandler::FinishReshowOverlay_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kAcceptPrivacyNotice: {
      return &LensPageHandler::AcceptPrivacyNotice_Sym::IPCStableHash;
    }
    case messages::LensPageHandler::kDismissPrivacyNotice: {
      return &LensPageHandler::DismissPrivacyNotice_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensPageHandler>(message.name())) {
      case messages::LensPageHandler::kActivityRequestedByOverlay:
            return "Receive lens::mojom::LensPageHandler::ActivityRequestedByOverlay";
      case messages::LensPageHandler::kCloseRequestedByOverlayCloseButton:
            return "Receive lens::mojom::LensPageHandler::CloseRequestedByOverlayCloseButton";
      case messages::LensPageHandler::kCloseRequestedByOverlayBackgroundClick:
            return "Receive lens::mojom::LensPageHandler::CloseRequestedByOverlayBackgroundClick";
      case messages::LensPageHandler::kNotifyOverlayInitialized:
            return "Receive lens::mojom::LensPageHandler::NotifyOverlayInitialized";
      case messages::LensPageHandler::kAddBackgroundBlur:
            return "Receive lens::mojom::LensPageHandler::AddBackgroundBlur";
      case messages::LensPageHandler::kSetLiveBlur:
            return "Receive lens::mojom::LensPageHandler::SetLiveBlur";
      case messages::LensPageHandler::kFeedbackRequestedByOverlay:
            return "Receive lens::mojom::LensPageHandler::FeedbackRequestedByOverlay";
      case messages::LensPageHandler::kGetOverlayInvocationSource:
            return "Receive lens::mojom::LensPageHandler::GetOverlayInvocationSource";
      case messages::LensPageHandler::kInfoRequestedByOverlay:
            return "Receive lens::mojom::LensPageHandler::InfoRequestedByOverlay";
      case messages::LensPageHandler::kIssueLensRegionRequest:
            return "Receive lens::mojom::LensPageHandler::IssueLensRegionRequest";
      case messages::LensPageHandler::kIssueLensObjectRequest:
            return "Receive lens::mojom::LensPageHandler::IssueLensObjectRequest";
      case messages::LensPageHandler::kIssueTextSelectionRequest:
            return "Receive lens::mojom::LensPageHandler::IssueTextSelectionRequest";
      case messages::LensPageHandler::kIssueTranslateSelectionRequest:
            return "Receive lens::mojom::LensPageHandler::IssueTranslateSelectionRequest";
      case messages::LensPageHandler::kIssueMathSelectionRequest:
            return "Receive lens::mojom::LensPageHandler::IssueMathSelectionRequest";
      case messages::LensPageHandler::kIssueTranslateFullPageRequest:
            return "Receive lens::mojom::LensPageHandler::IssueTranslateFullPageRequest";
      case messages::LensPageHandler::kIssueEndTranslateModeRequest:
            return "Receive lens::mojom::LensPageHandler::IssueEndTranslateModeRequest";
      case messages::LensPageHandler::kCopyText:
            return "Receive lens::mojom::LensPageHandler::CopyText";
      case messages::LensPageHandler::kCopyImage:
            return "Receive lens::mojom::LensPageHandler::CopyImage";
      case messages::LensPageHandler::kSaveAsImage:
            return "Receive lens::mojom::LensPageHandler::SaveAsImage";
      case messages::LensPageHandler::kClosePreselectionBubble:
            return "Receive lens::mojom::LensPageHandler::ClosePreselectionBubble";
      case messages::LensPageHandler::kRecordUkmAndTaskCompletionForLensOverlayInteraction:
            return "Receive lens::mojom::LensPageHandler::RecordUkmAndTaskCompletionForLensOverlayInteraction";
      case messages::LensPageHandler::kRecordLensOverlaySemanticEvent:
            return "Receive lens::mojom::LensPageHandler::RecordLensOverlaySemanticEvent";
      case messages::LensPageHandler::kMaybeShowTranslateFeaturePromo:
            return "Receive lens::mojom::LensPageHandler::MaybeShowTranslateFeaturePromo";
      case messages::LensPageHandler::kMaybeCloseTranslateFeaturePromo:
            return "Receive lens::mojom::LensPageHandler::MaybeCloseTranslateFeaturePromo";
      case messages::LensPageHandler::kFetchSupportedLanguages:
            return "Receive lens::mojom::LensPageHandler::FetchSupportedLanguages";
      case messages::LensPageHandler::kFinishReshowOverlay:
            return "Receive lens::mojom::LensPageHandler::FinishReshowOverlay";
      case messages::LensPageHandler::kAcceptPrivacyNotice:
            return "Receive lens::mojom::LensPageHandler::AcceptPrivacyNotice";
      case messages::LensPageHandler::kDismissPrivacyNotice:
            return "Receive lens::mojom::LensPageHandler::DismissPrivacyNotice";
    }
  } else {
    switch (static_cast<messages::LensPageHandler>(message.name())) {
      case messages::LensPageHandler::kActivityRequestedByOverlay:
            return "Receive reply lens::mojom::LensPageHandler::ActivityRequestedByOverlay";
      case messages::LensPageHandler::kCloseRequestedByOverlayCloseButton:
            return "Receive reply lens::mojom::LensPageHandler::CloseRequestedByOverlayCloseButton";
      case messages::LensPageHandler::kCloseRequestedByOverlayBackgroundClick:
            return "Receive reply lens::mojom::LensPageHandler::CloseRequestedByOverlayBackgroundClick";
      case messages::LensPageHandler::kNotifyOverlayInitialized:
            return "Receive reply lens::mojom::LensPageHandler::NotifyOverlayInitialized";
      case messages::LensPageHandler::kAddBackgroundBlur:
            return "Receive reply lens::mojom::LensPageHandler::AddBackgroundBlur";
      case messages::LensPageHandler::kSetLiveBlur:
            return "Receive reply lens::mojom::LensPageHandler::SetLiveBlur";
      case messages::LensPageHandler::kFeedbackRequestedByOverlay:
            return "Receive reply lens::mojom::LensPageHandler::FeedbackRequestedByOverlay";
      case messages::LensPageHandler::kGetOverlayInvocationSource:
            return "Receive reply lens::mojom::LensPageHandler::GetOverlayInvocationSource";
      case messages::LensPageHandler::kInfoRequestedByOverlay:
            return "Receive reply lens::mojom::LensPageHandler::InfoRequestedByOverlay";
      case messages::LensPageHandler::kIssueLensRegionRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueLensRegionRequest";
      case messages::LensPageHandler::kIssueLensObjectRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueLensObjectRequest";
      case messages::LensPageHandler::kIssueTextSelectionRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueTextSelectionRequest";
      case messages::LensPageHandler::kIssueTranslateSelectionRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueTranslateSelectionRequest";
      case messages::LensPageHandler::kIssueMathSelectionRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueMathSelectionRequest";
      case messages::LensPageHandler::kIssueTranslateFullPageRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueTranslateFullPageRequest";
      case messages::LensPageHandler::kIssueEndTranslateModeRequest:
            return "Receive reply lens::mojom::LensPageHandler::IssueEndTranslateModeRequest";
      case messages::LensPageHandler::kCopyText:
            return "Receive reply lens::mojom::LensPageHandler::CopyText";
      case messages::LensPageHandler::kCopyImage:
            return "Receive reply lens::mojom::LensPageHandler::CopyImage";
      case messages::LensPageHandler::kSaveAsImage:
            return "Receive reply lens::mojom::LensPageHandler::SaveAsImage";
      case messages::LensPageHandler::kClosePreselectionBubble:
            return "Receive reply lens::mojom::LensPageHandler::ClosePreselectionBubble";
      case messages::LensPageHandler::kRecordUkmAndTaskCompletionForLensOverlayInteraction:
            return "Receive reply lens::mojom::LensPageHandler::RecordUkmAndTaskCompletionForLensOverlayInteraction";
      case messages::LensPageHandler::kRecordLensOverlaySemanticEvent:
            return "Receive reply lens::mojom::LensPageHandler::RecordLensOverlaySemanticEvent";
      case messages::LensPageHandler::kMaybeShowTranslateFeaturePromo:
            return "Receive reply lens::mojom::LensPageHandler::MaybeShowTranslateFeaturePromo";
      case messages::LensPageHandler::kMaybeCloseTranslateFeaturePromo:
            return "Receive reply lens::mojom::LensPageHandler::MaybeCloseTranslateFeaturePromo";
      case messages::LensPageHandler::kFetchSupportedLanguages:
            return "Receive reply lens::mojom::LensPageHandler::FetchSupportedLanguages";
      case messages::LensPageHandler::kFinishReshowOverlay:
            return "Receive reply lens::mojom::LensPageHandler::FinishReshowOverlay";
      case messages::LensPageHandler::kAcceptPrivacyNotice:
            return "Receive reply lens::mojom::LensPageHandler::AcceptPrivacyNotice";
      case messages::LensPageHandler::kDismissPrivacyNotice:
            return "Receive reply lens::mojom::LensPageHandler::DismissPrivacyNotice";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensPageHandler::ActivityRequestedByOverlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb4e4141;  // IPCStableHash for lens::mojom::LensPageHandler::ActivityRequestedByOverlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::CloseRequestedByOverlayCloseButton_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb641e0e;  // IPCStableHash for lens::mojom::LensPageHandler::CloseRequestedByOverlayCloseButton
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::CloseRequestedByOverlayBackgroundClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57e288a0;  // IPCStableHash for lens::mojom::LensPageHandler::CloseRequestedByOverlayBackgroundClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::NotifyOverlayInitialized_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x333a0ca2;  // IPCStableHash for lens::mojom::LensPageHandler::NotifyOverlayInitialized
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::AddBackgroundBlur_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21551f9e;  // IPCStableHash for lens::mojom::LensPageHandler::AddBackgroundBlur
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::SetLiveBlur_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00cdcb9b;  // IPCStableHash for lens::mojom::LensPageHandler::SetLiveBlur
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::FeedbackRequestedByOverlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e93746f;  // IPCStableHash for lens::mojom::LensPageHandler::FeedbackRequestedByOverlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::GetOverlayInvocationSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde8a86f0;  // IPCStableHash for lens::mojom::LensPageHandler::GetOverlayInvocationSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::InfoRequestedByOverlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1df585f7;  // IPCStableHash for lens::mojom::LensPageHandler::InfoRequestedByOverlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueLensRegionRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c60eab9;  // IPCStableHash for lens::mojom::LensPageHandler::IssueLensRegionRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueLensObjectRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c3666d2;  // IPCStableHash for lens::mojom::LensPageHandler::IssueLensObjectRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueTextSelectionRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2cf76db;  // IPCStableHash for lens::mojom::LensPageHandler::IssueTextSelectionRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueTranslateSelectionRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9cdf5672;  // IPCStableHash for lens::mojom::LensPageHandler::IssueTranslateSelectionRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueMathSelectionRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f68f854;  // IPCStableHash for lens::mojom::LensPageHandler::IssueMathSelectionRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueTranslateFullPageRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf42c1847;  // IPCStableHash for lens::mojom::LensPageHandler::IssueTranslateFullPageRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::IssueEndTranslateModeRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f67b12e;  // IPCStableHash for lens::mojom::LensPageHandler::IssueEndTranslateModeRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::CopyText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a58ee0f;  // IPCStableHash for lens::mojom::LensPageHandler::CopyText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::CopyImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49f7a1e8;  // IPCStableHash for lens::mojom::LensPageHandler::CopyImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::SaveAsImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbcf6fd6c;  // IPCStableHash for lens::mojom::LensPageHandler::SaveAsImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::ClosePreselectionBubble_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7f8c61c;  // IPCStableHash for lens::mojom::LensPageHandler::ClosePreselectionBubble
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::RecordUkmAndTaskCompletionForLensOverlayInteraction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51ec13a0;  // IPCStableHash for lens::mojom::LensPageHandler::RecordUkmAndTaskCompletionForLensOverlayInteraction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::RecordLensOverlaySemanticEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3490733;  // IPCStableHash for lens::mojom::LensPageHandler::RecordLensOverlaySemanticEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::MaybeShowTranslateFeaturePromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd6c6c12;  // IPCStableHash for lens::mojom::LensPageHandler::MaybeShowTranslateFeaturePromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::MaybeCloseTranslateFeaturePromo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10c5cb36;  // IPCStableHash for lens::mojom::LensPageHandler::MaybeCloseTranslateFeaturePromo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::FetchSupportedLanguages_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8676e438;  // IPCStableHash for lens::mojom::LensPageHandler::FetchSupportedLanguages
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::FinishReshowOverlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3869d781;  // IPCStableHash for lens::mojom::LensPageHandler::FinishReshowOverlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::AcceptPrivacyNotice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x293fc4e1;  // IPCStableHash for lens::mojom::LensPageHandler::AcceptPrivacyNotice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPageHandler::DismissPrivacyNotice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd8638ba7;  // IPCStableHash for lens::mojom::LensPageHandler::DismissPrivacyNotice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LensPageHandler_GetOverlayInvocationSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LensPageHandler_GetOverlayInvocationSource_ForwardToCallback(
      LensPageHandler::GetOverlayInvocationSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  LensPageHandler_GetOverlayInvocationSource_ForwardToCallback(const LensPageHandler_GetOverlayInvocationSource_ForwardToCallback&) = delete;
  LensPageHandler_GetOverlayInvocationSource_ForwardToCallback& operator=(const LensPageHandler_GetOverlayInvocationSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LensPageHandler::GetOverlayInvocationSourceCallback callback_;
};

class LensPageHandler_FetchSupportedLanguages_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LensPageHandler_FetchSupportedLanguages_ForwardToCallback(
      LensPageHandler::FetchSupportedLanguagesCallback callback
      ) : callback_(std::move(callback)) {
  }

  LensPageHandler_FetchSupportedLanguages_ForwardToCallback(const LensPageHandler_FetchSupportedLanguages_ForwardToCallback&) = delete;
  LensPageHandler_FetchSupportedLanguages_ForwardToCallback& operator=(const LensPageHandler_FetchSupportedLanguages_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LensPageHandler::FetchSupportedLanguagesCallback callback_;
};

LensPageHandlerProxy::LensPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensPageHandlerProxy::ActivityRequestedByOverlay(
    ::ui::mojom::ClickModifiersPtr in_click_modifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::ActivityRequestedByOverlay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_modifiers"), in_click_modifiers,
                        "<value of type ::ui::mojom::ClickModifiersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kActivityRequestedByOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_ActivityRequestedByOverlay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->click_modifiers)::BaseType> click_modifiers_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::ClickModifiersDataView>(
    in_click_modifiers,
    click_modifiers_fragment);

  params->click_modifiers.Set(
      click_modifiers_fragment.is_null() ? nullptr : click_modifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->click_modifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null click_modifiers in LensPageHandler.ActivityRequestedByOverlay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("ActivityRequestedByOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::CloseRequestedByOverlayCloseButton(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::CloseRequestedByOverlayCloseButton");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kCloseRequestedByOverlayCloseButton), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("CloseRequestedByOverlayCloseButton");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::CloseRequestedByOverlayBackgroundClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::CloseRequestedByOverlayBackgroundClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kCloseRequestedByOverlayBackgroundClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("CloseRequestedByOverlayBackgroundClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::NotifyOverlayInitialized(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::NotifyOverlayInitialized");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kNotifyOverlayInitialized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_NotifyOverlayInitialized_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("NotifyOverlayInitialized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::AddBackgroundBlur(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::AddBackgroundBlur");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kAddBackgroundBlur), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_AddBackgroundBlur_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("AddBackgroundBlur");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::SetLiveBlur(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::SetLiveBlur", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kSetLiveBlur), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_SetLiveBlur_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("SetLiveBlur");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::FeedbackRequestedByOverlay(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::FeedbackRequestedByOverlay");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kFeedbackRequestedByOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_FeedbackRequestedByOverlay_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("FeedbackRequestedByOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::GetOverlayInvocationSource(
    GetOverlayInvocationSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::GetOverlayInvocationSource");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kGetOverlayInvocationSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_GetOverlayInvocationSource_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("GetOverlayInvocationSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LensPageHandler_GetOverlayInvocationSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LensPageHandlerProxy::InfoRequestedByOverlay(
    ::ui::mojom::ClickModifiersPtr in_click_modifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::InfoRequestedByOverlay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_modifiers"), in_click_modifiers,
                        "<value of type ::ui::mojom::ClickModifiersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kInfoRequestedByOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_InfoRequestedByOverlay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->click_modifiers)::BaseType> click_modifiers_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::ClickModifiersDataView>(
    in_click_modifiers,
    click_modifiers_fragment);

  params->click_modifiers.Set(
      click_modifiers_fragment.is_null() ? nullptr : click_modifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->click_modifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null click_modifiers in LensPageHandler.InfoRequestedByOverlay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("InfoRequestedByOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueLensRegionRequest(
    ::lens::mojom::CenterRotatedBoxPtr in_region, bool in_is_click) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::IssueLensRegionRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::lens::mojom::CenterRotatedBoxPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_click"), in_is_click,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueLensRegionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueLensRegionRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in LensPageHandler.IssueLensRegionRequest request");

  params->is_click = in_is_click;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueLensRegionRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueLensObjectRequest(
    ::lens::mojom::CenterRotatedBoxPtr in_region, bool in_is_mask_click) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::IssueLensObjectRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::lens::mojom::CenterRotatedBoxPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_mask_click"), in_is_mask_click,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueLensObjectRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueLensObjectRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in LensPageHandler.IssueLensObjectRequest request");

  params->is_mask_click = in_is_mask_click;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueLensObjectRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueTextSelectionRequest(
    const std::string& in_query, int32_t in_selection_start_index, int32_t in_selection_end_index, bool in_is_translate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::IssueTextSelectionRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_start_index"), in_selection_start_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_end_index"), in_selection_end_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_translate"), in_is_translate,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueTextSelectionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueTextSelectionRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in LensPageHandler.IssueTextSelectionRequest request");

  params->selection_start_index = in_selection_start_index;

  params->selection_end_index = in_selection_end_index;

  params->is_translate = in_is_translate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueTextSelectionRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueTranslateSelectionRequest(
    const std::string& in_query, const std::string& in_content_language, int32_t in_selection_start_index, int32_t in_selection_end_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::IssueTranslateSelectionRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_language"), in_content_language,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_start_index"), in_selection_start_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_end_index"), in_selection_end_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueTranslateSelectionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueTranslateSelectionRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in LensPageHandler.IssueTranslateSelectionRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_language)::BaseType> content_language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_content_language,
    content_language_fragment);

  params->content_language.Set(
      content_language_fragment.is_null() ? nullptr : content_language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_language in LensPageHandler.IssueTranslateSelectionRequest request");

  params->selection_start_index = in_selection_start_index;

  params->selection_end_index = in_selection_end_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueTranslateSelectionRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueMathSelectionRequest(
    const std::string& in_query, const std::string& in_formula, int32_t in_selection_start_index, int32_t in_selection_end_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::IssueMathSelectionRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("query"), in_query,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formula"), in_formula,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_start_index"), in_selection_start_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_end_index"), in_selection_end_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueMathSelectionRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueMathSelectionRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->query)::BaseType> query_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_query,
    query_fragment);

  params->query.Set(
      query_fragment.is_null() ? nullptr : query_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->query.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null query in LensPageHandler.IssueMathSelectionRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->formula)::BaseType> formula_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_formula,
    formula_fragment);

  params->formula.Set(
      formula_fragment.is_null() ? nullptr : formula_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->formula.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null formula in LensPageHandler.IssueMathSelectionRequest request");

  params->selection_start_index = in_selection_start_index;

  params->selection_end_index = in_selection_end_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueMathSelectionRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueTranslateFullPageRequest(
    const std::string& in_source_language, const std::string& in_target_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::IssueTranslateFullPageRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_language"), in_source_language,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_language"), in_target_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueTranslateFullPageRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueTranslateFullPageRequest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_language)::BaseType> source_language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_language,
    source_language_fragment);

  params->source_language.Set(
      source_language_fragment.is_null() ? nullptr : source_language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_language in LensPageHandler.IssueTranslateFullPageRequest request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_language)::BaseType> target_language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_target_language,
    target_language_fragment);

  params->target_language.Set(
      target_language_fragment.is_null() ? nullptr : target_language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_language in LensPageHandler.IssueTranslateFullPageRequest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueTranslateFullPageRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::IssueEndTranslateModeRequest(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::IssueEndTranslateModeRequest");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kIssueEndTranslateModeRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_IssueEndTranslateModeRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("IssueEndTranslateModeRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::CopyText(
    const std::string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::CopyText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kCopyText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_CopyText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in LensPageHandler.CopyText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("CopyText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::CopyImage(
    ::lens::mojom::CenterRotatedBoxPtr in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::CopyImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::lens::mojom::CenterRotatedBoxPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kCopyImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_CopyImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in LensPageHandler.CopyImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("CopyImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::SaveAsImage(
    ::lens::mojom::CenterRotatedBoxPtr in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::SaveAsImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::lens::mojom::CenterRotatedBoxPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kSaveAsImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_SaveAsImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in LensPageHandler.SaveAsImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("SaveAsImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::ClosePreselectionBubble(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::ClosePreselectionBubble");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kClosePreselectionBubble), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_ClosePreselectionBubble_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("ClosePreselectionBubble");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::RecordUkmAndTaskCompletionForLensOverlayInteraction(
    UserAction in_user_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::RecordUkmAndTaskCompletionForLensOverlayInteraction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_action"), in_user_action,
                        "<value of type UserAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kRecordUkmAndTaskCompletionForLensOverlayInteraction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::lens::mojom::UserAction>(
    in_user_action,
    &params->user_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("RecordUkmAndTaskCompletionForLensOverlayInteraction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::RecordLensOverlaySemanticEvent(
    SemanticEvent in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::RecordLensOverlaySemanticEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type SemanticEvent>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kRecordLensOverlaySemanticEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::lens::mojom::SemanticEvent>(
    in_event,
    &params->event);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("RecordLensOverlaySemanticEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::MaybeShowTranslateFeaturePromo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::MaybeShowTranslateFeaturePromo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kMaybeShowTranslateFeaturePromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("MaybeShowTranslateFeaturePromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::MaybeCloseTranslateFeaturePromo(
    bool in_feature_engaged) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPageHandler::MaybeCloseTranslateFeaturePromo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature_engaged"), in_feature_engaged,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kMaybeCloseTranslateFeaturePromo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data> params(
          message);
  params.Allocate();

  params->feature_engaged = in_feature_engaged;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("MaybeCloseTranslateFeaturePromo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::FetchSupportedLanguages(
    FetchSupportedLanguagesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::FetchSupportedLanguages");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kFetchSupportedLanguages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_FetchSupportedLanguages_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("FetchSupportedLanguages");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LensPageHandler_FetchSupportedLanguages_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LensPageHandlerProxy::FinishReshowOverlay(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::FinishReshowOverlay");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kFinishReshowOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_FinishReshowOverlay_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("FinishReshowOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::AcceptPrivacyNotice(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::AcceptPrivacyNotice");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kAcceptPrivacyNotice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_AcceptPrivacyNotice_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("AcceptPrivacyNotice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageHandlerProxy::DismissPrivacyNotice(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPageHandler::DismissPrivacyNotice");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kDismissPrivacyNotice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_DismissPrivacyNotice_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("DismissPrivacyNotice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class LensPageHandler_GetOverlayInvocationSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LensPageHandler::GetOverlayInvocationSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LensPageHandler_GetOverlayInvocationSource_ProxyToResponder> proxy(
        new LensPageHandler_GetOverlayInvocationSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LensPageHandler_GetOverlayInvocationSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LensPageHandler_GetOverlayInvocationSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LensPageHandler_GetOverlayInvocationSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LensPageHandler::GetOverlayInvocationSourceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_invocation_source);
};

bool LensPageHandler_GetOverlayInvocationSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LensPageHandler.7
  bool success = true;
  std::string p_invocation_source{};
  LensPageHandler_GetOverlayInvocationSource_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInvocationSource(&p_invocation_source))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LensPageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_invocation_source));
  }
  return true;
}

void LensPageHandler_GetOverlayInvocationSource_ProxyToResponder::Run(
    const std::string& in_invocation_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply lens::mojom::LensPageHandler::GetOverlayInvocationSource", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("invocation_source"), in_invocation_source,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kGetOverlayInvocationSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->invocation_source)::BaseType> invocation_source_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_invocation_source,
    invocation_source_fragment);

  params->invocation_source.Set(
      invocation_source_fragment.is_null() ? nullptr : invocation_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->invocation_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null invocation_source in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("GetOverlayInvocationSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LensPageHandler_FetchSupportedLanguages_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LensPageHandler::FetchSupportedLanguagesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LensPageHandler_FetchSupportedLanguages_ProxyToResponder> proxy(
        new LensPageHandler_FetchSupportedLanguages_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LensPageHandler_FetchSupportedLanguages_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LensPageHandler_FetchSupportedLanguages_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LensPageHandler_FetchSupportedLanguages_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LensPageHandler::FetchSupportedLanguagesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_browser_locale, std::vector<::lens::mojom::LanguagePtr> in_source_languages, std::vector<::lens::mojom::LanguagePtr> in_target_languages);
};

bool LensPageHandler_FetchSupportedLanguages_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LensPageHandler_FetchSupportedLanguages_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LensPageHandler_FetchSupportedLanguages_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LensPageHandler.24
  bool success = true;
  std::string p_browser_locale{};
  std::vector<::lens::mojom::LanguagePtr> p_source_languages{};
  std::vector<::lens::mojom::LanguagePtr> p_target_languages{};
  LensPageHandler_FetchSupportedLanguages_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBrowserLocale(&p_browser_locale))
    success = false;
  if (success && !input_data_view.ReadSourceLanguages(&p_source_languages))
    success = false;
  if (success && !input_data_view.ReadTargetLanguages(&p_target_languages))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LensPageHandler::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_browser_locale), 
std::move(p_source_languages), 
std::move(p_target_languages));
  }
  return true;
}

void LensPageHandler_FetchSupportedLanguages_ProxyToResponder::Run(
    const std::string& in_browser_locale, std::vector<::lens::mojom::LanguagePtr> in_source_languages, std::vector<::lens::mojom::LanguagePtr> in_target_languages) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply lens::mojom::LensPageHandler::FetchSupportedLanguages", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("browser_locale"), in_browser_locale,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_languages"), in_source_languages,
                        "<value of type std::vector<::lens::mojom::LanguagePtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_languages"), in_target_languages,
                        "<value of type std::vector<::lens::mojom::LanguagePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPageHandler::kFetchSupportedLanguages), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPageHandler_FetchSupportedLanguages_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->browser_locale)::BaseType> browser_locale_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_browser_locale,
    browser_locale_fragment);

  params->browser_locale.Set(
      browser_locale_fragment.is_null() ? nullptr : browser_locale_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->browser_locale.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null browser_locale in ");
  mojo::internal::MessageFragment<
      typename decltype(params->source_languages)::BaseType>
      source_languages_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& source_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::LanguageDataView>>(
    in_source_languages,
    source_languages_fragment,
    &source_languages_validate_params);

  params->source_languages.Set(
      source_languages_fragment.is_null() ? nullptr : source_languages_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_languages.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_languages in ");
  mojo::internal::MessageFragment<
      typename decltype(params->target_languages)::BaseType>
      target_languages_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& target_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::LanguageDataView>>(
    in_target_languages,
    target_languages_fragment,
    &target_languages_validate_params);

  params->target_languages.Set(
      target_languages_fragment.is_null() ? nullptr : target_languages_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_languages.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_languages in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPageHandler::Name_);
  message.set_method_name("FetchSupportedLanguages");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LensPageHandlerStubDispatch::Accept(
    LensPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensPageHandler>(message->header()->name)) {
    case messages::LensPageHandler::kActivityRequestedByOverlay: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_ActivityRequestedByOverlay_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_ActivityRequestedByOverlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.0
      bool success = true;
      ::ui::mojom::ClickModifiersPtr p_click_modifiers{};
      LensPageHandler_ActivityRequestedByOverlay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClickModifiers(&p_click_modifiers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivityRequestedByOverlay(        
        std::move(p_click_modifiers));
      return true;
    }
    case messages::LensPageHandler::kCloseRequestedByOverlayCloseButton: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.1
      bool success = true;
      LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseRequestedByOverlayCloseButton(        );
      return true;
    }
    case messages::LensPageHandler::kCloseRequestedByOverlayBackgroundClick: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.2
      bool success = true;
      LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseRequestedByOverlayBackgroundClick(        );
      return true;
    }
    case messages::LensPageHandler::kNotifyOverlayInitialized: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_NotifyOverlayInitialized_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_NotifyOverlayInitialized_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.3
      bool success = true;
      LensPageHandler_NotifyOverlayInitialized_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOverlayInitialized(        );
      return true;
    }
    case messages::LensPageHandler::kAddBackgroundBlur: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_AddBackgroundBlur_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_AddBackgroundBlur_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.4
      bool success = true;
      LensPageHandler_AddBackgroundBlur_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddBackgroundBlur(        );
      return true;
    }
    case messages::LensPageHandler::kSetLiveBlur: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_SetLiveBlur_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_SetLiveBlur_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.5
      bool success = true;
      bool p_enabled{};
      LensPageHandler_SetLiveBlur_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLiveBlur(        
        std::move(p_enabled));
      return true;
    }
    case messages::LensPageHandler::kFeedbackRequestedByOverlay: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_FeedbackRequestedByOverlay_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_FeedbackRequestedByOverlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.6
      bool success = true;
      LensPageHandler_FeedbackRequestedByOverlay_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FeedbackRequestedByOverlay(        );
      return true;
    }
    case messages::LensPageHandler::kGetOverlayInvocationSource: {
      break;
    }
    case messages::LensPageHandler::kInfoRequestedByOverlay: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_InfoRequestedByOverlay_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_InfoRequestedByOverlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.8
      bool success = true;
      ::ui::mojom::ClickModifiersPtr p_click_modifiers{};
      LensPageHandler_InfoRequestedByOverlay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClickModifiers(&p_click_modifiers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InfoRequestedByOverlay(        
        std::move(p_click_modifiers));
      return true;
    }
    case messages::LensPageHandler::kIssueLensRegionRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueLensRegionRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueLensRegionRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.9
      bool success = true;
      ::lens::mojom::CenterRotatedBoxPtr p_region{};
      bool p_is_click{};
      LensPageHandler_IssueLensRegionRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success)
        p_is_click = input_data_view.is_click();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueLensRegionRequest(        
        std::move(p_region), 
        std::move(p_is_click));
      return true;
    }
    case messages::LensPageHandler::kIssueLensObjectRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueLensObjectRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueLensObjectRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.10
      bool success = true;
      ::lens::mojom::CenterRotatedBoxPtr p_region{};
      bool p_is_mask_click{};
      LensPageHandler_IssueLensObjectRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success)
        p_is_mask_click = input_data_view.is_mask_click();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueLensObjectRequest(        
        std::move(p_region), 
        std::move(p_is_mask_click));
      return true;
    }
    case messages::LensPageHandler::kIssueTextSelectionRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueTextSelectionRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueTextSelectionRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.11
      bool success = true;
      std::string p_query{};
      int32_t p_selection_start_index{};
      int32_t p_selection_end_index{};
      bool p_is_translate{};
      LensPageHandler_IssueTextSelectionRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success)
        p_selection_start_index = input_data_view.selection_start_index();
      if (success)
        p_selection_end_index = input_data_view.selection_end_index();
      if (success)
        p_is_translate = input_data_view.is_translate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueTextSelectionRequest(        
        std::move(p_query), 
        std::move(p_selection_start_index), 
        std::move(p_selection_end_index), 
        std::move(p_is_translate));
      return true;
    }
    case messages::LensPageHandler::kIssueTranslateSelectionRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueTranslateSelectionRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueTranslateSelectionRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.12
      bool success = true;
      std::string p_query{};
      std::string p_content_language{};
      int32_t p_selection_start_index{};
      int32_t p_selection_end_index{};
      LensPageHandler_IssueTranslateSelectionRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success && !input_data_view.ReadContentLanguage(&p_content_language))
        success = false;
      if (success)
        p_selection_start_index = input_data_view.selection_start_index();
      if (success)
        p_selection_end_index = input_data_view.selection_end_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueTranslateSelectionRequest(        
        std::move(p_query), 
        std::move(p_content_language), 
        std::move(p_selection_start_index), 
        std::move(p_selection_end_index));
      return true;
    }
    case messages::LensPageHandler::kIssueMathSelectionRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueMathSelectionRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueMathSelectionRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.13
      bool success = true;
      std::string p_query{};
      std::string p_formula{};
      int32_t p_selection_start_index{};
      int32_t p_selection_end_index{};
      LensPageHandler_IssueMathSelectionRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadQuery(&p_query))
        success = false;
      if (success && !input_data_view.ReadFormula(&p_formula))
        success = false;
      if (success)
        p_selection_start_index = input_data_view.selection_start_index();
      if (success)
        p_selection_end_index = input_data_view.selection_end_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueMathSelectionRequest(        
        std::move(p_query), 
        std::move(p_formula), 
        std::move(p_selection_start_index), 
        std::move(p_selection_end_index));
      return true;
    }
    case messages::LensPageHandler::kIssueTranslateFullPageRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueTranslateFullPageRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueTranslateFullPageRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.14
      bool success = true;
      std::string p_source_language{};
      std::string p_target_language{};
      LensPageHandler_IssueTranslateFullPageRequest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceLanguage(&p_source_language))
        success = false;
      if (success && !input_data_view.ReadTargetLanguage(&p_target_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueTranslateFullPageRequest(        
        std::move(p_source_language), 
        std::move(p_target_language));
      return true;
    }
    case messages::LensPageHandler::kIssueEndTranslateModeRequest: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_IssueEndTranslateModeRequest_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_IssueEndTranslateModeRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.15
      bool success = true;
      LensPageHandler_IssueEndTranslateModeRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueEndTranslateModeRequest(        );
      return true;
    }
    case messages::LensPageHandler::kCopyText: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_CopyText_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_CopyText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.16
      bool success = true;
      std::string p_text{};
      LensPageHandler_CopyText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyText(        
        std::move(p_text));
      return true;
    }
    case messages::LensPageHandler::kCopyImage: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_CopyImage_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_CopyImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.17
      bool success = true;
      ::lens::mojom::CenterRotatedBoxPtr p_region{};
      LensPageHandler_CopyImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyImage(        
        std::move(p_region));
      return true;
    }
    case messages::LensPageHandler::kSaveAsImage: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_SaveAsImage_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_SaveAsImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.18
      bool success = true;
      ::lens::mojom::CenterRotatedBoxPtr p_region{};
      LensPageHandler_SaveAsImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveAsImage(        
        std::move(p_region));
      return true;
    }
    case messages::LensPageHandler::kClosePreselectionBubble: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_ClosePreselectionBubble_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_ClosePreselectionBubble_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.19
      bool success = true;
      LensPageHandler_ClosePreselectionBubble_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClosePreselectionBubble(        );
      return true;
    }
    case messages::LensPageHandler::kRecordUkmAndTaskCompletionForLensOverlayInteraction: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.20
      bool success = true;
      UserAction p_user_action{};
      LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserAction(&p_user_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordUkmAndTaskCompletionForLensOverlayInteraction(        
        std::move(p_user_action));
      return true;
    }
    case messages::LensPageHandler::kRecordLensOverlaySemanticEvent: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.21
      bool success = true;
      SemanticEvent p_event{};
      LensPageHandler_RecordLensOverlaySemanticEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordLensOverlaySemanticEvent(        
        std::move(p_event));
      return true;
    }
    case messages::LensPageHandler::kMaybeShowTranslateFeaturePromo: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.22
      bool success = true;
      LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeShowTranslateFeaturePromo(        );
      return true;
    }
    case messages::LensPageHandler::kMaybeCloseTranslateFeaturePromo: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.23
      bool success = true;
      bool p_feature_engaged{};
      LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_feature_engaged = input_data_view.feature_engaged();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeCloseTranslateFeaturePromo(        
        std::move(p_feature_engaged));
      return true;
    }
    case messages::LensPageHandler::kFetchSupportedLanguages: {
      break;
    }
    case messages::LensPageHandler::kFinishReshowOverlay: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_FinishReshowOverlay_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_FinishReshowOverlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.25
      bool success = true;
      LensPageHandler_FinishReshowOverlay_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinishReshowOverlay(        );
      return true;
    }
    case messages::LensPageHandler::kAcceptPrivacyNotice: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_AcceptPrivacyNotice_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_AcceptPrivacyNotice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.26
      bool success = true;
      LensPageHandler_AcceptPrivacyNotice_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptPrivacyNotice(        );
      return true;
    }
    case messages::LensPageHandler::kDismissPrivacyNotice: {
      DCHECK(message->is_serialized());
      internal::LensPageHandler_DismissPrivacyNotice_Params_Data* params =
          reinterpret_cast<internal::LensPageHandler_DismissPrivacyNotice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPageHandler.27
      bool success = true;
      LensPageHandler_DismissPrivacyNotice_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DismissPrivacyNotice(        );
      return true;
    }
  }
  return false;
}

// static
bool LensPageHandlerStubDispatch::AcceptWithResponder(
    LensPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensPageHandler>(message->header()->name)) {
    case messages::LensPageHandler::kActivityRequestedByOverlay: {
      break;
    }
    case messages::LensPageHandler::kCloseRequestedByOverlayCloseButton: {
      break;
    }
    case messages::LensPageHandler::kCloseRequestedByOverlayBackgroundClick: {
      break;
    }
    case messages::LensPageHandler::kNotifyOverlayInitialized: {
      break;
    }
    case messages::LensPageHandler::kAddBackgroundBlur: {
      break;
    }
    case messages::LensPageHandler::kSetLiveBlur: {
      break;
    }
    case messages::LensPageHandler::kFeedbackRequestedByOverlay: {
      break;
    }
    case messages::LensPageHandler::kGetOverlayInvocationSource: {
      internal::LensPageHandler_GetOverlayInvocationSource_Params_Data* params =
          reinterpret_cast<
              internal::LensPageHandler_GetOverlayInvocationSource_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LensPageHandler.7
      bool success = true;
      LensPageHandler_GetOverlayInvocationSource_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          LensPageHandler_GetOverlayInvocationSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOverlayInvocationSource(std::move(callback));
      return true;
    }
    case messages::LensPageHandler::kInfoRequestedByOverlay: {
      break;
    }
    case messages::LensPageHandler::kIssueLensRegionRequest: {
      break;
    }
    case messages::LensPageHandler::kIssueLensObjectRequest: {
      break;
    }
    case messages::LensPageHandler::kIssueTextSelectionRequest: {
      break;
    }
    case messages::LensPageHandler::kIssueTranslateSelectionRequest: {
      break;
    }
    case messages::LensPageHandler::kIssueMathSelectionRequest: {
      break;
    }
    case messages::LensPageHandler::kIssueTranslateFullPageRequest: {
      break;
    }
    case messages::LensPageHandler::kIssueEndTranslateModeRequest: {
      break;
    }
    case messages::LensPageHandler::kCopyText: {
      break;
    }
    case messages::LensPageHandler::kCopyImage: {
      break;
    }
    case messages::LensPageHandler::kSaveAsImage: {
      break;
    }
    case messages::LensPageHandler::kClosePreselectionBubble: {
      break;
    }
    case messages::LensPageHandler::kRecordUkmAndTaskCompletionForLensOverlayInteraction: {
      break;
    }
    case messages::LensPageHandler::kRecordLensOverlaySemanticEvent: {
      break;
    }
    case messages::LensPageHandler::kMaybeShowTranslateFeaturePromo: {
      break;
    }
    case messages::LensPageHandler::kMaybeCloseTranslateFeaturePromo: {
      break;
    }
    case messages::LensPageHandler::kFetchSupportedLanguages: {
      internal::LensPageHandler_FetchSupportedLanguages_Params_Data* params =
          reinterpret_cast<
              internal::LensPageHandler_FetchSupportedLanguages_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LensPageHandler.24
      bool success = true;
      LensPageHandler_FetchSupportedLanguages_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPageHandler::Name_, 24, false);
        return false;
      }
      auto callback =
          LensPageHandler_FetchSupportedLanguages_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchSupportedLanguages(std::move(callback));
      return true;
    }
    case messages::LensPageHandler::kFinishReshowOverlay: {
      break;
    }
    case messages::LensPageHandler::kAcceptPrivacyNotice: {
      break;
    }
    case messages::LensPageHandler::kDismissPrivacyNotice: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensPageHandlerValidationInfo[] = {
    { &internal::LensPageHandler_ActivityRequestedByOverlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_NotifyOverlayInitialized_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_AddBackgroundBlur_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_SetLiveBlur_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_FeedbackRequestedByOverlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_GetOverlayInvocationSource_Params_Data::Validate,
     &internal::LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data::Validate},
    { &internal::LensPageHandler_InfoRequestedByOverlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueLensRegionRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueLensObjectRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueTextSelectionRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueTranslateSelectionRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueMathSelectionRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueTranslateFullPageRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_IssueEndTranslateModeRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_CopyText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_CopyImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_SaveAsImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_ClosePreselectionBubble_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_FetchSupportedLanguages_Params_Data::Validate,
     &internal::LensPageHandler_FetchSupportedLanguages_ResponseParams_Data::Validate},
    { &internal::LensPageHandler_FinishReshowOverlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_AcceptPrivacyNotice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPageHandler_DismissPrivacyNotice_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensPageHandler::Name_,
    kLensPageHandlerValidationInfo);
}

bool LensPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::lens::mojom::LensPageHandler::Name_,
    kLensPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

LensPage::IPCStableHashFunction LensPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LensPage>(message.name())) {
    case messages::LensPage::kScreenshotDataReceived: {
      return &LensPage::ScreenshotDataReceived_Sym::IPCStableHash;
    }
    case messages::LensPage::kNotifyHandshakeComplete: {
      return &LensPage::NotifyHandshakeComplete_Sym::IPCStableHash;
    }
    case messages::LensPage::kNotifyResultsPanelOpened: {
      return &LensPage::NotifyResultsPanelOpened_Sym::IPCStableHash;
    }
    case messages::LensPage::kNotifyOverlayClosing: {
      return &LensPage::NotifyOverlayClosing_Sym::IPCStableHash;
    }
    case messages::LensPage::kObjectsReceived: {
      return &LensPage::ObjectsReceived_Sym::IPCStableHash;
    }
    case messages::LensPage::kTextReceived: {
      return &LensPage::TextReceived_Sym::IPCStableHash;
    }
    case messages::LensPage::kRegionTextReceived: {
      return &LensPage::RegionTextReceived_Sym::IPCStableHash;
    }
    case messages::LensPage::kThemeReceived: {
      return &LensPage::ThemeReceived_Sym::IPCStableHash;
    }
    case messages::LensPage::kShouldShowContextualSearchBox: {
      return &LensPage::ShouldShowContextualSearchBox_Sym::IPCStableHash;
    }
    case messages::LensPage::kPageContentTypeChanged: {
      return &LensPage::PageContentTypeChanged_Sym::IPCStableHash;
    }
    case messages::LensPage::kSetPostRegionSelection: {
      return &LensPage::SetPostRegionSelection_Sym::IPCStableHash;
    }
    case messages::LensPage::kSetTextSelection: {
      return &LensPage::SetTextSelection_Sym::IPCStableHash;
    }
    case messages::LensPage::kSetTranslateMode: {
      return &LensPage::SetTranslateMode_Sym::IPCStableHash;
    }
    case messages::LensPage::kClearRegionSelection: {
      return &LensPage::ClearRegionSelection_Sym::IPCStableHash;
    }
    case messages::LensPage::kClearTextSelection: {
      return &LensPage::ClearTextSelection_Sym::IPCStableHash;
    }
    case messages::LensPage::kClearAllSelections: {
      return &LensPage::ClearAllSelections_Sym::IPCStableHash;
    }
    case messages::LensPage::kOnCopyCommand: {
      return &LensPage::OnCopyCommand_Sym::IPCStableHash;
    }
    case messages::LensPage::kSuppressGhostLoader: {
      return &LensPage::SuppressGhostLoader_Sym::IPCStableHash;
    }
    case messages::LensPage::kOnOverlayReshown: {
      return &LensPage::OnOverlayReshown_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LensPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LensPage>(message.name())) {
      case messages::LensPage::kScreenshotDataReceived:
            return "Receive lens::mojom::LensPage::ScreenshotDataReceived";
      case messages::LensPage::kNotifyHandshakeComplete:
            return "Receive lens::mojom::LensPage::NotifyHandshakeComplete";
      case messages::LensPage::kNotifyResultsPanelOpened:
            return "Receive lens::mojom::LensPage::NotifyResultsPanelOpened";
      case messages::LensPage::kNotifyOverlayClosing:
            return "Receive lens::mojom::LensPage::NotifyOverlayClosing";
      case messages::LensPage::kObjectsReceived:
            return "Receive lens::mojom::LensPage::ObjectsReceived";
      case messages::LensPage::kTextReceived:
            return "Receive lens::mojom::LensPage::TextReceived";
      case messages::LensPage::kRegionTextReceived:
            return "Receive lens::mojom::LensPage::RegionTextReceived";
      case messages::LensPage::kThemeReceived:
            return "Receive lens::mojom::LensPage::ThemeReceived";
      case messages::LensPage::kShouldShowContextualSearchBox:
            return "Receive lens::mojom::LensPage::ShouldShowContextualSearchBox";
      case messages::LensPage::kPageContentTypeChanged:
            return "Receive lens::mojom::LensPage::PageContentTypeChanged";
      case messages::LensPage::kSetPostRegionSelection:
            return "Receive lens::mojom::LensPage::SetPostRegionSelection";
      case messages::LensPage::kSetTextSelection:
            return "Receive lens::mojom::LensPage::SetTextSelection";
      case messages::LensPage::kSetTranslateMode:
            return "Receive lens::mojom::LensPage::SetTranslateMode";
      case messages::LensPage::kClearRegionSelection:
            return "Receive lens::mojom::LensPage::ClearRegionSelection";
      case messages::LensPage::kClearTextSelection:
            return "Receive lens::mojom::LensPage::ClearTextSelection";
      case messages::LensPage::kClearAllSelections:
            return "Receive lens::mojom::LensPage::ClearAllSelections";
      case messages::LensPage::kOnCopyCommand:
            return "Receive lens::mojom::LensPage::OnCopyCommand";
      case messages::LensPage::kSuppressGhostLoader:
            return "Receive lens::mojom::LensPage::SuppressGhostLoader";
      case messages::LensPage::kOnOverlayReshown:
            return "Receive lens::mojom::LensPage::OnOverlayReshown";
    }
  } else {
    switch (static_cast<messages::LensPage>(message.name())) {
      case messages::LensPage::kScreenshotDataReceived:
            return "Receive reply lens::mojom::LensPage::ScreenshotDataReceived";
      case messages::LensPage::kNotifyHandshakeComplete:
            return "Receive reply lens::mojom::LensPage::NotifyHandshakeComplete";
      case messages::LensPage::kNotifyResultsPanelOpened:
            return "Receive reply lens::mojom::LensPage::NotifyResultsPanelOpened";
      case messages::LensPage::kNotifyOverlayClosing:
            return "Receive reply lens::mojom::LensPage::NotifyOverlayClosing";
      case messages::LensPage::kObjectsReceived:
            return "Receive reply lens::mojom::LensPage::ObjectsReceived";
      case messages::LensPage::kTextReceived:
            return "Receive reply lens::mojom::LensPage::TextReceived";
      case messages::LensPage::kRegionTextReceived:
            return "Receive reply lens::mojom::LensPage::RegionTextReceived";
      case messages::LensPage::kThemeReceived:
            return "Receive reply lens::mojom::LensPage::ThemeReceived";
      case messages::LensPage::kShouldShowContextualSearchBox:
            return "Receive reply lens::mojom::LensPage::ShouldShowContextualSearchBox";
      case messages::LensPage::kPageContentTypeChanged:
            return "Receive reply lens::mojom::LensPage::PageContentTypeChanged";
      case messages::LensPage::kSetPostRegionSelection:
            return "Receive reply lens::mojom::LensPage::SetPostRegionSelection";
      case messages::LensPage::kSetTextSelection:
            return "Receive reply lens::mojom::LensPage::SetTextSelection";
      case messages::LensPage::kSetTranslateMode:
            return "Receive reply lens::mojom::LensPage::SetTranslateMode";
      case messages::LensPage::kClearRegionSelection:
            return "Receive reply lens::mojom::LensPage::ClearRegionSelection";
      case messages::LensPage::kClearTextSelection:
            return "Receive reply lens::mojom::LensPage::ClearTextSelection";
      case messages::LensPage::kClearAllSelections:
            return "Receive reply lens::mojom::LensPage::ClearAllSelections";
      case messages::LensPage::kOnCopyCommand:
            return "Receive reply lens::mojom::LensPage::OnCopyCommand";
      case messages::LensPage::kSuppressGhostLoader:
            return "Receive reply lens::mojom::LensPage::SuppressGhostLoader";
      case messages::LensPage::kOnOverlayReshown:
            return "Receive reply lens::mojom::LensPage::OnOverlayReshown";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LensPage::ScreenshotDataReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8b5084b;  // IPCStableHash for lens::mojom::LensPage::ScreenshotDataReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::NotifyHandshakeComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fae41d9;  // IPCStableHash for lens::mojom::LensPage::NotifyHandshakeComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::NotifyResultsPanelOpened_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe214c285;  // IPCStableHash for lens::mojom::LensPage::NotifyResultsPanelOpened
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::NotifyOverlayClosing_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad241701;  // IPCStableHash for lens::mojom::LensPage::NotifyOverlayClosing
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::ObjectsReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67de7b8d;  // IPCStableHash for lens::mojom::LensPage::ObjectsReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::TextReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0526ec0;  // IPCStableHash for lens::mojom::LensPage::TextReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::RegionTextReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x882df29e;  // IPCStableHash for lens::mojom::LensPage::RegionTextReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::ThemeReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd822bebd;  // IPCStableHash for lens::mojom::LensPage::ThemeReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::ShouldShowContextualSearchBox_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48739272;  // IPCStableHash for lens::mojom::LensPage::ShouldShowContextualSearchBox
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::PageContentTypeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5bef9f5;  // IPCStableHash for lens::mojom::LensPage::PageContentTypeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::SetPostRegionSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3af4d8d;  // IPCStableHash for lens::mojom::LensPage::SetPostRegionSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::SetTextSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa61b8fd5;  // IPCStableHash for lens::mojom::LensPage::SetTextSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::SetTranslateMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcfeacf9b;  // IPCStableHash for lens::mojom::LensPage::SetTranslateMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::ClearRegionSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85e239c5;  // IPCStableHash for lens::mojom::LensPage::ClearRegionSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::ClearTextSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb44ae344;  // IPCStableHash for lens::mojom::LensPage::ClearTextSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::ClearAllSelections_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b672fd3;  // IPCStableHash for lens::mojom::LensPage::ClearAllSelections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::OnCopyCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a66cb96;  // IPCStableHash for lens::mojom::LensPage::OnCopyCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::SuppressGhostLoader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96da9dc7;  // IPCStableHash for lens::mojom::LensPage::SuppressGhostLoader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LensPage::OnOverlayReshown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x529c5a25;  // IPCStableHash for lens::mojom::LensPage::OnOverlayReshown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LensPageProxy::LensPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LensPageProxy::ScreenshotDataReceived(
    const ::SkBitmap& in_screenshot_data, bool in_is_side_panel_open) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::ScreenshotDataReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screenshot_data"), in_screenshot_data,
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_side_panel_open"), in_is_side_panel_open,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kScreenshotDataReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ScreenshotDataReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->screenshot_data)::BaseType> screenshot_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapMappedFromTrustedProcessDataView>(
    in_screenshot_data,
    screenshot_data_fragment);

  params->screenshot_data.Set(
      screenshot_data_fragment.is_null() ? nullptr : screenshot_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screenshot_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screenshot_data in LensPage.ScreenshotDataReceived request");

  params->is_side_panel_open = in_is_side_panel_open;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ScreenshotDataReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::NotifyHandshakeComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::NotifyHandshakeComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kNotifyHandshakeComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_NotifyHandshakeComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("NotifyHandshakeComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::NotifyResultsPanelOpened(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::NotifyResultsPanelOpened");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kNotifyResultsPanelOpened), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_NotifyResultsPanelOpened_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("NotifyResultsPanelOpened");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::NotifyOverlayClosing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::NotifyOverlayClosing");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kNotifyOverlayClosing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_NotifyOverlayClosing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("NotifyOverlayClosing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::ObjectsReceived(
    std::vector<::lens::mojom::OverlayObjectPtr> in_objects) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::ObjectsReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("objects"), in_objects,
                        "<value of type std::vector<::lens::mojom::OverlayObjectPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kObjectsReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ObjectsReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->objects)::BaseType>
      objects_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& objects_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::OverlayObjectDataView>>(
    in_objects,
    objects_fragment,
    &objects_validate_params);

  params->objects.Set(
      objects_fragment.is_null() ? nullptr : objects_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->objects.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null objects in LensPage.ObjectsReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ObjectsReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::TextReceived(
    ::lens::mojom::TextPtr in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::TextReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type ::lens::mojom::TextPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kTextReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_TextReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::TextDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in LensPage.TextReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("TextReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::RegionTextReceived(
    ::lens::mojom::TextPtr in_text, bool in_is_injected_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::RegionTextReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type ::lens::mojom::TextPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_injected_image"), in_is_injected_image,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kRegionTextReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_RegionTextReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::TextDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in LensPage.RegionTextReceived request");

  params->is_injected_image = in_is_injected_image;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("RegionTextReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::ThemeReceived(
    OverlayThemePtr in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::ThemeReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type OverlayThemePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kThemeReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ThemeReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme)::BaseType> theme_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::OverlayThemeDataView>(
    in_theme,
    theme_fragment);

  params->theme.Set(
      theme_fragment.is_null() ? nullptr : theme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme in LensPage.ThemeReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ThemeReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::ShouldShowContextualSearchBox(
    bool in_should_show) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::ShouldShowContextualSearchBox", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_show"), in_should_show,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kShouldShowContextualSearchBox), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ShouldShowContextualSearchBox_Params_Data> params(
          message);
  params.Allocate();

  params->should_show = in_should_show;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ShouldShowContextualSearchBox");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::PageContentTypeChanged(
    ::lens::mojom::PageContentType in_new_page_content_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::PageContentTypeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_page_content_type"), in_new_page_content_type,
                        "<value of type ::lens::mojom::PageContentType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kPageContentTypeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_PageContentTypeChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::lens::mojom::PageContentType>(
    in_new_page_content_type,
    &params->new_page_content_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("PageContentTypeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::SetPostRegionSelection(
    ::lens::mojom::CenterRotatedBoxPtr in_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::SetPostRegionSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::lens::mojom::CenterRotatedBoxPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kSetPostRegionSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_SetPostRegionSelection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in LensPage.SetPostRegionSelection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("SetPostRegionSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::SetTextSelection(
    int32_t in_selection_start_index, int32_t in_selection_end_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::SetTextSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_start_index"), in_selection_start_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_end_index"), in_selection_end_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kSetTextSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_SetTextSelection_Params_Data> params(
          message);
  params.Allocate();

  params->selection_start_index = in_selection_start_index;

  params->selection_end_index = in_selection_end_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("SetTextSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::SetTranslateMode(
    const std::string& in_source_language, const std::string& in_target_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::SetTranslateMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_language"), in_source_language,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_language"), in_target_language,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kSetTranslateMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_SetTranslateMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_language)::BaseType> source_language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_language,
    source_language_fragment);

  params->source_language.Set(
      source_language_fragment.is_null() ? nullptr : source_language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_language in LensPage.SetTranslateMode request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_language)::BaseType> target_language_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_target_language,
    target_language_fragment);

  params->target_language.Set(
      target_language_fragment.is_null() ? nullptr : target_language_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_language.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_language in LensPage.SetTranslateMode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("SetTranslateMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::ClearRegionSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::ClearRegionSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kClearRegionSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ClearRegionSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ClearRegionSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::ClearTextSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::ClearTextSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kClearTextSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ClearTextSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ClearTextSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::ClearAllSelections(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::ClearAllSelections");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kClearAllSelections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_ClearAllSelections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("ClearAllSelections");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::OnCopyCommand(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::OnCopyCommand");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kOnCopyCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_OnCopyCommand_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("OnCopyCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::SuppressGhostLoader(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send lens::mojom::LensPage::SuppressGhostLoader");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kSuppressGhostLoader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_SuppressGhostLoader_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("SuppressGhostLoader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LensPageProxy::OnOverlayReshown(
    const ::SkBitmap& in_screenshot_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send lens::mojom::LensPage::OnOverlayReshown", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("screenshot_data"), in_screenshot_data,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LensPage::kOnOverlayReshown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::lens::mojom::internal::LensPage_OnOverlayReshown_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->screenshot_data)::BaseType> screenshot_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapMappedFromTrustedProcessDataView>(
    in_screenshot_data,
    screenshot_data_fragment);

  params->screenshot_data.Set(
      screenshot_data_fragment.is_null() ? nullptr : screenshot_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->screenshot_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null screenshot_data in LensPage.OnOverlayReshown request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LensPage::Name_);
  message.set_method_name("OnOverlayReshown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LensPageStubDispatch::Accept(
    LensPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LensPage>(message->header()->name)) {
    case messages::LensPage::kScreenshotDataReceived: {
      DCHECK(message->is_serialized());
      internal::LensPage_ScreenshotDataReceived_Params_Data* params =
          reinterpret_cast<internal::LensPage_ScreenshotDataReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.0
      bool success = true;
      ::SkBitmap p_screenshot_data{};
      bool p_is_side_panel_open{};
      LensPage_ScreenshotDataReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScreenshotData(&p_screenshot_data))
        success = false;
      if (success)
        p_is_side_panel_open = input_data_view.is_side_panel_open();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScreenshotDataReceived(        
        std::move(p_screenshot_data), 
        std::move(p_is_side_panel_open));
      return true;
    }
    case messages::LensPage::kNotifyHandshakeComplete: {
      DCHECK(message->is_serialized());
      internal::LensPage_NotifyHandshakeComplete_Params_Data* params =
          reinterpret_cast<internal::LensPage_NotifyHandshakeComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.1
      bool success = true;
      LensPage_NotifyHandshakeComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyHandshakeComplete(        );
      return true;
    }
    case messages::LensPage::kNotifyResultsPanelOpened: {
      DCHECK(message->is_serialized());
      internal::LensPage_NotifyResultsPanelOpened_Params_Data* params =
          reinterpret_cast<internal::LensPage_NotifyResultsPanelOpened_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.2
      bool success = true;
      LensPage_NotifyResultsPanelOpened_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResultsPanelOpened(        );
      return true;
    }
    case messages::LensPage::kNotifyOverlayClosing: {
      DCHECK(message->is_serialized());
      internal::LensPage_NotifyOverlayClosing_Params_Data* params =
          reinterpret_cast<internal::LensPage_NotifyOverlayClosing_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.3
      bool success = true;
      LensPage_NotifyOverlayClosing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOverlayClosing(        );
      return true;
    }
    case messages::LensPage::kObjectsReceived: {
      DCHECK(message->is_serialized());
      internal::LensPage_ObjectsReceived_Params_Data* params =
          reinterpret_cast<internal::LensPage_ObjectsReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.4
      bool success = true;
      std::vector<::lens::mojom::OverlayObjectPtr> p_objects{};
      LensPage_ObjectsReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadObjects(&p_objects))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ObjectsReceived(        
        std::move(p_objects));
      return true;
    }
    case messages::LensPage::kTextReceived: {
      DCHECK(message->is_serialized());
      internal::LensPage_TextReceived_Params_Data* params =
          reinterpret_cast<internal::LensPage_TextReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.5
      bool success = true;
      ::lens::mojom::TextPtr p_text{};
      LensPage_TextReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextReceived(        
        std::move(p_text));
      return true;
    }
    case messages::LensPage::kRegionTextReceived: {
      DCHECK(message->is_serialized());
      internal::LensPage_RegionTextReceived_Params_Data* params =
          reinterpret_cast<internal::LensPage_RegionTextReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.6
      bool success = true;
      ::lens::mojom::TextPtr p_text{};
      bool p_is_injected_image{};
      LensPage_RegionTextReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_is_injected_image = input_data_view.is_injected_image();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegionTextReceived(        
        std::move(p_text), 
        std::move(p_is_injected_image));
      return true;
    }
    case messages::LensPage::kThemeReceived: {
      DCHECK(message->is_serialized());
      internal::LensPage_ThemeReceived_Params_Data* params =
          reinterpret_cast<internal::LensPage_ThemeReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.7
      bool success = true;
      OverlayThemePtr p_theme{};
      LensPage_ThemeReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ThemeReceived(        
        std::move(p_theme));
      return true;
    }
    case messages::LensPage::kShouldShowContextualSearchBox: {
      DCHECK(message->is_serialized());
      internal::LensPage_ShouldShowContextualSearchBox_Params_Data* params =
          reinterpret_cast<internal::LensPage_ShouldShowContextualSearchBox_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.8
      bool success = true;
      bool p_should_show{};
      LensPage_ShouldShowContextualSearchBox_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_should_show = input_data_view.should_show();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldShowContextualSearchBox(        
        std::move(p_should_show));
      return true;
    }
    case messages::LensPage::kPageContentTypeChanged: {
      DCHECK(message->is_serialized());
      internal::LensPage_PageContentTypeChanged_Params_Data* params =
          reinterpret_cast<internal::LensPage_PageContentTypeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.9
      bool success = true;
      ::lens::mojom::PageContentType p_new_page_content_type{};
      LensPage_PageContentTypeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewPageContentType(&p_new_page_content_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PageContentTypeChanged(        
        std::move(p_new_page_content_type));
      return true;
    }
    case messages::LensPage::kSetPostRegionSelection: {
      DCHECK(message->is_serialized());
      internal::LensPage_SetPostRegionSelection_Params_Data* params =
          reinterpret_cast<internal::LensPage_SetPostRegionSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.10
      bool success = true;
      ::lens::mojom::CenterRotatedBoxPtr p_region{};
      LensPage_SetPostRegionSelection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPostRegionSelection(        
        std::move(p_region));
      return true;
    }
    case messages::LensPage::kSetTextSelection: {
      DCHECK(message->is_serialized());
      internal::LensPage_SetTextSelection_Params_Data* params =
          reinterpret_cast<internal::LensPage_SetTextSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.11
      bool success = true;
      int32_t p_selection_start_index{};
      int32_t p_selection_end_index{};
      LensPage_SetTextSelection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_selection_start_index = input_data_view.selection_start_index();
      if (success)
        p_selection_end_index = input_data_view.selection_end_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextSelection(        
        std::move(p_selection_start_index), 
        std::move(p_selection_end_index));
      return true;
    }
    case messages::LensPage::kSetTranslateMode: {
      DCHECK(message->is_serialized());
      internal::LensPage_SetTranslateMode_Params_Data* params =
          reinterpret_cast<internal::LensPage_SetTranslateMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.12
      bool success = true;
      std::string p_source_language{};
      std::string p_target_language{};
      LensPage_SetTranslateMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceLanguage(&p_source_language))
        success = false;
      if (success && !input_data_view.ReadTargetLanguage(&p_target_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTranslateMode(        
        std::move(p_source_language), 
        std::move(p_target_language));
      return true;
    }
    case messages::LensPage::kClearRegionSelection: {
      DCHECK(message->is_serialized());
      internal::LensPage_ClearRegionSelection_Params_Data* params =
          reinterpret_cast<internal::LensPage_ClearRegionSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.13
      bool success = true;
      LensPage_ClearRegionSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearRegionSelection(        );
      return true;
    }
    case messages::LensPage::kClearTextSelection: {
      DCHECK(message->is_serialized());
      internal::LensPage_ClearTextSelection_Params_Data* params =
          reinterpret_cast<internal::LensPage_ClearTextSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.14
      bool success = true;
      LensPage_ClearTextSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTextSelection(        );
      return true;
    }
    case messages::LensPage::kClearAllSelections: {
      DCHECK(message->is_serialized());
      internal::LensPage_ClearAllSelections_Params_Data* params =
          reinterpret_cast<internal::LensPage_ClearAllSelections_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.15
      bool success = true;
      LensPage_ClearAllSelections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearAllSelections(        );
      return true;
    }
    case messages::LensPage::kOnCopyCommand: {
      DCHECK(message->is_serialized());
      internal::LensPage_OnCopyCommand_Params_Data* params =
          reinterpret_cast<internal::LensPage_OnCopyCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.16
      bool success = true;
      LensPage_OnCopyCommand_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCopyCommand(        );
      return true;
    }
    case messages::LensPage::kSuppressGhostLoader: {
      DCHECK(message->is_serialized());
      internal::LensPage_SuppressGhostLoader_Params_Data* params =
          reinterpret_cast<internal::LensPage_SuppressGhostLoader_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.17
      bool success = true;
      LensPage_SuppressGhostLoader_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuppressGhostLoader(        );
      return true;
    }
    case messages::LensPage::kOnOverlayReshown: {
      DCHECK(message->is_serialized());
      internal::LensPage_OnOverlayReshown_Params_Data* params =
          reinterpret_cast<internal::LensPage_OnOverlayReshown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LensPage.18
      bool success = true;
      ::SkBitmap p_screenshot_data{};
      LensPage_OnOverlayReshown_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScreenshotData(&p_screenshot_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LensPage::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOverlayReshown(        
        std::move(p_screenshot_data));
      return true;
    }
  }
  return false;
}

// static
bool LensPageStubDispatch::AcceptWithResponder(
    LensPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LensPage>(message->header()->name)) {
    case messages::LensPage::kScreenshotDataReceived: {
      break;
    }
    case messages::LensPage::kNotifyHandshakeComplete: {
      break;
    }
    case messages::LensPage::kNotifyResultsPanelOpened: {
      break;
    }
    case messages::LensPage::kNotifyOverlayClosing: {
      break;
    }
    case messages::LensPage::kObjectsReceived: {
      break;
    }
    case messages::LensPage::kTextReceived: {
      break;
    }
    case messages::LensPage::kRegionTextReceived: {
      break;
    }
    case messages::LensPage::kThemeReceived: {
      break;
    }
    case messages::LensPage::kShouldShowContextualSearchBox: {
      break;
    }
    case messages::LensPage::kPageContentTypeChanged: {
      break;
    }
    case messages::LensPage::kSetPostRegionSelection: {
      break;
    }
    case messages::LensPage::kSetTextSelection: {
      break;
    }
    case messages::LensPage::kSetTranslateMode: {
      break;
    }
    case messages::LensPage::kClearRegionSelection: {
      break;
    }
    case messages::LensPage::kClearTextSelection: {
      break;
    }
    case messages::LensPage::kClearAllSelections: {
      break;
    }
    case messages::LensPage::kOnCopyCommand: {
      break;
    }
    case messages::LensPage::kSuppressGhostLoader: {
      break;
    }
    case messages::LensPage::kOnOverlayReshown: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLensPageValidationInfo[] = {
    { &internal::LensPage_ScreenshotDataReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_NotifyHandshakeComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_NotifyResultsPanelOpened_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_NotifyOverlayClosing_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_ObjectsReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_TextReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_RegionTextReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_ThemeReceived_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_ShouldShowContextualSearchBox_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_PageContentTypeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_SetPostRegionSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_SetTextSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_SetTranslateMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_ClearRegionSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_ClearTextSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_ClearAllSelections_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_OnCopyCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_SuppressGhostLoader_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LensPage_OnOverlayReshown_Params_Data::Validate,
     nullptr /* no response */},
};

bool LensPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::lens::mojom::LensPage::Name_,
    kLensPageValidationInfo);
}



}  // lens::mojom


namespace mojo {


// static
bool StructTraits<::lens::mojom::OverlayTheme::DataView, ::lens::mojom::OverlayThemePtr>::Read(
    ::lens::mojom::OverlayTheme::DataView input,
    ::lens::mojom::OverlayThemePtr* output) {
  bool success = true;
  ::lens::mojom::OverlayThemePtr result(::lens::mojom::OverlayTheme::New());
  
      if (success && !input.ReadPrimary(&result->primary))
        success = false;
      if (success && !input.ReadShaderLayer1(&result->shader_layer_1))
        success = false;
      if (success && !input.ReadShaderLayer2(&result->shader_layer_2))
        success = false;
      if (success && !input.ReadShaderLayer3(&result->shader_layer_3))
        success = false;
      if (success && !input.ReadShaderLayer4(&result->shader_layer_4))
        success = false;
      if (success && !input.ReadShaderLayer5(&result->shader_layer_5))
        success = false;
      if (success && !input.ReadScrim(&result->scrim))
        success = false;
      if (success && !input.ReadSurfaceContainerHighestLight(&result->surface_container_highest_light))
        success = false;
      if (success && !input.ReadSurfaceContainerHighestDark(&result->surface_container_highest_dark))
        success = false;
      if (success && !input.ReadSelectionElement(&result->selection_element))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace lens::mojom {


void LensPageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingReceiver<LensPageHandler> handler, ::mojo::PendingRemote<LensPage> page) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(handler)
    , 
    std::move(page)
    );
}
LensPageHandlerFactoryAsyncWaiter::LensPageHandlerFactoryAsyncWaiter(
    LensPageHandlerFactory* proxy) : proxy_(proxy) {}

LensPageHandlerFactoryAsyncWaiter::~LensPageHandlerFactoryAsyncWaiter() = default;





void LensPageHandlerInterceptorForTesting::ActivityRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) {
  GetForwardingInterface()->ActivityRequestedByOverlay(
    std::move(click_modifiers)
    );
}
void LensPageHandlerInterceptorForTesting::CloseRequestedByOverlayCloseButton() {
  GetForwardingInterface()->CloseRequestedByOverlayCloseButton();
}
void LensPageHandlerInterceptorForTesting::CloseRequestedByOverlayBackgroundClick() {
  GetForwardingInterface()->CloseRequestedByOverlayBackgroundClick();
}
void LensPageHandlerInterceptorForTesting::NotifyOverlayInitialized() {
  GetForwardingInterface()->NotifyOverlayInitialized();
}
void LensPageHandlerInterceptorForTesting::AddBackgroundBlur() {
  GetForwardingInterface()->AddBackgroundBlur();
}
void LensPageHandlerInterceptorForTesting::SetLiveBlur(bool enabled) {
  GetForwardingInterface()->SetLiveBlur(
    std::move(enabled)
    );
}
void LensPageHandlerInterceptorForTesting::FeedbackRequestedByOverlay() {
  GetForwardingInterface()->FeedbackRequestedByOverlay();
}
void LensPageHandlerInterceptorForTesting::GetOverlayInvocationSource(GetOverlayInvocationSourceCallback callback) {
  GetForwardingInterface()->GetOverlayInvocationSource(std::move(callback));
}
void LensPageHandlerInterceptorForTesting::InfoRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) {
  GetForwardingInterface()->InfoRequestedByOverlay(
    std::move(click_modifiers)
    );
}
void LensPageHandlerInterceptorForTesting::IssueLensRegionRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_click) {
  GetForwardingInterface()->IssueLensRegionRequest(
    std::move(region)
    , 
    std::move(is_click)
    );
}
void LensPageHandlerInterceptorForTesting::IssueLensObjectRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_mask_click) {
  GetForwardingInterface()->IssueLensObjectRequest(
    std::move(region)
    , 
    std::move(is_mask_click)
    );
}
void LensPageHandlerInterceptorForTesting::IssueTextSelectionRequest(const std::string& query, int32_t selection_start_index, int32_t selection_end_index, bool is_translate) {
  GetForwardingInterface()->IssueTextSelectionRequest(
    std::move(query)
    , 
    std::move(selection_start_index)
    , 
    std::move(selection_end_index)
    , 
    std::move(is_translate)
    );
}
void LensPageHandlerInterceptorForTesting::IssueTranslateSelectionRequest(const std::string& query, const std::string& content_language, int32_t selection_start_index, int32_t selection_end_index) {
  GetForwardingInterface()->IssueTranslateSelectionRequest(
    std::move(query)
    , 
    std::move(content_language)
    , 
    std::move(selection_start_index)
    , 
    std::move(selection_end_index)
    );
}
void LensPageHandlerInterceptorForTesting::IssueMathSelectionRequest(const std::string& query, const std::string& formula, int32_t selection_start_index, int32_t selection_end_index) {
  GetForwardingInterface()->IssueMathSelectionRequest(
    std::move(query)
    , 
    std::move(formula)
    , 
    std::move(selection_start_index)
    , 
    std::move(selection_end_index)
    );
}
void LensPageHandlerInterceptorForTesting::IssueTranslateFullPageRequest(const std::string& source_language, const std::string& target_language) {
  GetForwardingInterface()->IssueTranslateFullPageRequest(
    std::move(source_language)
    , 
    std::move(target_language)
    );
}
void LensPageHandlerInterceptorForTesting::IssueEndTranslateModeRequest() {
  GetForwardingInterface()->IssueEndTranslateModeRequest();
}
void LensPageHandlerInterceptorForTesting::CopyText(const std::string& text) {
  GetForwardingInterface()->CopyText(
    std::move(text)
    );
}
void LensPageHandlerInterceptorForTesting::CopyImage(::lens::mojom::CenterRotatedBoxPtr region) {
  GetForwardingInterface()->CopyImage(
    std::move(region)
    );
}
void LensPageHandlerInterceptorForTesting::SaveAsImage(::lens::mojom::CenterRotatedBoxPtr region) {
  GetForwardingInterface()->SaveAsImage(
    std::move(region)
    );
}
void LensPageHandlerInterceptorForTesting::ClosePreselectionBubble() {
  GetForwardingInterface()->ClosePreselectionBubble();
}
void LensPageHandlerInterceptorForTesting::RecordUkmAndTaskCompletionForLensOverlayInteraction(UserAction user_action) {
  GetForwardingInterface()->RecordUkmAndTaskCompletionForLensOverlayInteraction(
    std::move(user_action)
    );
}
void LensPageHandlerInterceptorForTesting::RecordLensOverlaySemanticEvent(SemanticEvent event) {
  GetForwardingInterface()->RecordLensOverlaySemanticEvent(
    std::move(event)
    );
}
void LensPageHandlerInterceptorForTesting::MaybeShowTranslateFeaturePromo() {
  GetForwardingInterface()->MaybeShowTranslateFeaturePromo();
}
void LensPageHandlerInterceptorForTesting::MaybeCloseTranslateFeaturePromo(bool feature_engaged) {
  GetForwardingInterface()->MaybeCloseTranslateFeaturePromo(
    std::move(feature_engaged)
    );
}
void LensPageHandlerInterceptorForTesting::FetchSupportedLanguages(FetchSupportedLanguagesCallback callback) {
  GetForwardingInterface()->FetchSupportedLanguages(std::move(callback));
}
void LensPageHandlerInterceptorForTesting::FinishReshowOverlay() {
  GetForwardingInterface()->FinishReshowOverlay();
}
void LensPageHandlerInterceptorForTesting::AcceptPrivacyNotice() {
  GetForwardingInterface()->AcceptPrivacyNotice();
}
void LensPageHandlerInterceptorForTesting::DismissPrivacyNotice() {
  GetForwardingInterface()->DismissPrivacyNotice();
}
LensPageHandlerAsyncWaiter::LensPageHandlerAsyncWaiter(
    LensPageHandler* proxy) : proxy_(proxy) {}

LensPageHandlerAsyncWaiter::~LensPageHandlerAsyncWaiter() = default;


void LensPageHandlerAsyncWaiter::GetOverlayInvocationSource(
    std::string* out_invocation_source) {
  base::RunLoop loop;
  proxy_->GetOverlayInvocationSource(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_invocation_source
,
             const std::string& invocation_source) {*out_invocation_source = std::move(invocation_source);
            loop->Quit();
          },
          &loop,
          out_invocation_source));
  loop.Run();
}

std::string LensPageHandlerAsyncWaiter::GetOverlayInvocationSource(
    ) {
  std::string async_wait_result;
  GetOverlayInvocationSource(&async_wait_result);
  return async_wait_result;
}

void LensPageHandlerAsyncWaiter::FetchSupportedLanguages(
    std::string* out_browser_locale, std::vector<::lens::mojom::LanguagePtr>* out_source_languages, std::vector<::lens::mojom::LanguagePtr>* out_target_languages) {
  base::RunLoop loop;
  proxy_->FetchSupportedLanguages(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_browser_locale
,
             std::vector<::lens::mojom::LanguagePtr>* out_source_languages
,
             std::vector<::lens::mojom::LanguagePtr>* out_target_languages
,
             const std::string& browser_locale,
             std::vector<::lens::mojom::LanguagePtr> source_languages,
             std::vector<::lens::mojom::LanguagePtr> target_languages) {*out_browser_locale = std::move(browser_locale);*out_source_languages = std::move(source_languages);*out_target_languages = std::move(target_languages);
            loop->Quit();
          },
          &loop,
          out_browser_locale,
          out_source_languages,
          out_target_languages));
  loop.Run();
}






void LensPageInterceptorForTesting::ScreenshotDataReceived(const ::SkBitmap& screenshot_data, bool is_side_panel_open) {
  GetForwardingInterface()->ScreenshotDataReceived(
    std::move(screenshot_data)
    , 
    std::move(is_side_panel_open)
    );
}
void LensPageInterceptorForTesting::NotifyHandshakeComplete() {
  GetForwardingInterface()->NotifyHandshakeComplete();
}
void LensPageInterceptorForTesting::NotifyResultsPanelOpened() {
  GetForwardingInterface()->NotifyResultsPanelOpened();
}
void LensPageInterceptorForTesting::NotifyOverlayClosing() {
  GetForwardingInterface()->NotifyOverlayClosing();
}
void LensPageInterceptorForTesting::ObjectsReceived(std::vector<::lens::mojom::OverlayObjectPtr> objects) {
  GetForwardingInterface()->ObjectsReceived(
    std::move(objects)
    );
}
void LensPageInterceptorForTesting::TextReceived(::lens::mojom::TextPtr text) {
  GetForwardingInterface()->TextReceived(
    std::move(text)
    );
}
void LensPageInterceptorForTesting::RegionTextReceived(::lens::mojom::TextPtr text, bool is_injected_image) {
  GetForwardingInterface()->RegionTextReceived(
    std::move(text)
    , 
    std::move(is_injected_image)
    );
}
void LensPageInterceptorForTesting::ThemeReceived(OverlayThemePtr theme) {
  GetForwardingInterface()->ThemeReceived(
    std::move(theme)
    );
}
void LensPageInterceptorForTesting::ShouldShowContextualSearchBox(bool should_show) {
  GetForwardingInterface()->ShouldShowContextualSearchBox(
    std::move(should_show)
    );
}
void LensPageInterceptorForTesting::PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) {
  GetForwardingInterface()->PageContentTypeChanged(
    std::move(new_page_content_type)
    );
}
void LensPageInterceptorForTesting::SetPostRegionSelection(::lens::mojom::CenterRotatedBoxPtr region) {
  GetForwardingInterface()->SetPostRegionSelection(
    std::move(region)
    );
}
void LensPageInterceptorForTesting::SetTextSelection(int32_t selection_start_index, int32_t selection_end_index) {
  GetForwardingInterface()->SetTextSelection(
    std::move(selection_start_index)
    , 
    std::move(selection_end_index)
    );
}
void LensPageInterceptorForTesting::SetTranslateMode(const std::string& source_language, const std::string& target_language) {
  GetForwardingInterface()->SetTranslateMode(
    std::move(source_language)
    , 
    std::move(target_language)
    );
}
void LensPageInterceptorForTesting::ClearRegionSelection() {
  GetForwardingInterface()->ClearRegionSelection();
}
void LensPageInterceptorForTesting::ClearTextSelection() {
  GetForwardingInterface()->ClearTextSelection();
}
void LensPageInterceptorForTesting::ClearAllSelections() {
  GetForwardingInterface()->ClearAllSelections();
}
void LensPageInterceptorForTesting::OnCopyCommand() {
  GetForwardingInterface()->OnCopyCommand();
}
void LensPageInterceptorForTesting::SuppressGhostLoader() {
  GetForwardingInterface()->SuppressGhostLoader();
}
void LensPageInterceptorForTesting::OnOverlayReshown(const ::SkBitmap& screenshot_data) {
  GetForwardingInterface()->OnOverlayReshown(
    std::move(screenshot_data)
    );
}
LensPageAsyncWaiter::LensPageAsyncWaiter(
    LensPage* proxy) : proxy_(proxy) {}

LensPageAsyncWaiter::~LensPageAsyncWaiter() = default;







}  // lens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif