// chrome/browser/lens/core/mojom/lens.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  CenterRotatedBoxSpec as lens_mojom_CenterRotatedBoxSpec,
  CenterRotatedBox as lens_mojom_CenterRotatedBox
} from './geometry.mojom-webui.js';
import {
  OverlayObjectSpec as lens_mojom_OverlayObjectSpec,
  OverlayObject as lens_mojom_OverlayObject
} from './overlay_object.mojom-webui.js';
import {
  PageContentTypeSpec as lens_mojom_PageContentTypeSpec,
  PageContentType as lens_mojom_PageContentType
} from './page_content_type.mojom-webui.js';
import {
  TextSpec as lens_mojom_TextSpec,
  Text as lens_mojom_Text
} from './text.mojom-webui.js';
import {
  LanguageSpec as lens_mojom_LanguageSpec,
  Language as lens_mojom_Language
} from './translate.mojom-webui.js';
import {
  BitmapMappedFromTrustedProcessSpec as skia_mojom_BitmapMappedFromTrustedProcessSpec,
  BitmapMappedFromTrustedProcess as skia_mojom_BitmapMappedFromTrustedProcess
} from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  ClickModifiersSpec as ui_mojom_ClickModifiersSpec,
  ClickModifiers as ui_mojom_ClickModifiers
} from '//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js';





export const UserActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserAction {

  MIN_VALUE = 0,
  MAX_VALUE = 18,
  kRegionSelection = 0,
  kRegionSelectionChange = 1,
  kTextSelection = 2,
  kObjectClick = 3,
  kTranslateText = 4,
  kCopyText = 5,
  kMyActivity = 6,
  kLearnMore = 7,
  kSendFeedback = 8,
  kTapRegionSelection = 9,
  kTranslateButtonEnableAction = 10,
  kTranslateButtonDisableAction = 11,
  kTranslateSourceLanguageChanged = 12,
  kTranslateTargetLanguageChanged = 13,
  kTranslateTextSelection = 14,
  kCopyAsImage = 15,
  kSaveAsImage = 16,
  kMathSelection = 17,
  kFullScreenshotRegionSelection = 18,
}

export const SemanticEventSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SemanticEvent {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kTextGleamsViewStart = 0,
  kTextGleamsViewEnd = 1,
}



export type LensPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LensPageHandlerFactoryPendingReceiver>;

export class LensPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LensPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<LensPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|LensPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'lens.mojom.LensPageHandlerFactory',
        scope);
  }
}

export interface LensPageHandlerFactoryInterface {
  createPageHandler(handler: LensPageHandlerPendingReceiver, page: LensPageRemote): void;
}

export class LensPageHandlerFactoryRemote implements LensPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LensPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LensPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LensPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LensPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      handler: LensPageHandlerPendingReceiver,
      page: LensPageRemote): void {
    this.proxy.sendMessage(
        0,
        LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          handler,
          page
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LensPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LensPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensPageHandlerFactoryRemote, LensPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensPageHandlerFactoryRemote, LensPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LensPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LensPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LensPageHandlerFactory {
  static get $interfaceName(): string {
    return "lens.mojom.LensPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LensPageHandlerFactoryRemote {
    let remote = new LensPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LensPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LensPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensPageHandlerFactoryRemote, LensPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensPageHandlerFactoryRemote, LensPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LensPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type LensPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LensPageHandlerPendingReceiver>;

export class LensPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LensPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<LensPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|LensPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'lens.mojom.LensPageHandler',
        scope);
  }
}

export interface LensPageHandlerInterface {
  activityRequestedByOverlay(clickModifiers: ui_mojom_ClickModifiers): void;
  closeRequestedByOverlayCloseButton(): void;
  closeRequestedByOverlayBackgroundClick(): void;
  notifyOverlayInitialized(): void;
  addBackgroundBlur(): void;
  setLiveBlur(enabled: boolean): void;
  feedbackRequestedByOverlay(): void;
  getOverlayInvocationSource(): Promise<{
        invocationSource: string, }>;
  infoRequestedByOverlay(clickModifiers: ui_mojom_ClickModifiers): void;
  issueLensRegionRequest(region: lens_mojom_CenterRotatedBox, isClick: boolean): void;
  issueLensObjectRequest(region: lens_mojom_CenterRotatedBox, isMaskClick: boolean): void;
  issueTextSelectionRequest(query: string, selectionStartIndex: number, selectionEndIndex: number, isTranslate: boolean): void;
  issueTranslateSelectionRequest(query: string, contentLanguage: string, selectionStartIndex: number, selectionEndIndex: number): void;
  issueMathSelectionRequest(query: string, formula: string, selectionStartIndex: number, selectionEndIndex: number): void;
  issueTranslateFullPageRequest(sourceLanguage: string, targetLanguage: string): void;
  issueEndTranslateModeRequest(): void;
  copyText(text: string): void;
  copyImage(region: lens_mojom_CenterRotatedBox): void;
  saveAsImage(region: lens_mojom_CenterRotatedBox): void;
  closePreselectionBubble(): void;
  recordUkmAndTaskCompletionForLensOverlayInteraction(userAction: UserAction): void;
  recordLensOverlaySemanticEvent(event: SemanticEvent): void;
  maybeShowTranslateFeaturePromo(): void;
  maybeCloseTranslateFeaturePromo(featureEngaged: boolean): void;
  fetchSupportedLanguages(): Promise<{
        browserLocale: string,
        sourceLanguages: lens_mojom_Language[],
        targetLanguages: lens_mojom_Language[], }>;
  finishReshowOverlay(): void;
  acceptPrivacyNotice(): void;
  dismissPrivacyNotice(): void;
}

export class LensPageHandlerRemote implements LensPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LensPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LensPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LensPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LensPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  activityRequestedByOverlay(
      clickModifiers: ui_mojom_ClickModifiers): void {
    this.proxy.sendMessage(
        0,
        LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,
        null,
        [
          clickModifiers
        ],
        false);
  }

  closeRequestedByOverlayCloseButton(): void {
    this.proxy.sendMessage(
        1,
        LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  closeRequestedByOverlayBackgroundClick(): void {
    this.proxy.sendMessage(
        2,
        LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  notifyOverlayInitialized(): void {
    this.proxy.sendMessage(
        3,
        LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  addBackgroundBlur(): void {
    this.proxy.sendMessage(
        4,
        LensPageHandler_AddBackgroundBlur_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setLiveBlur(
      enabled: boolean): void {
    this.proxy.sendMessage(
        5,
        LensPageHandler_SetLiveBlur_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }

  feedbackRequestedByOverlay(): void {
    this.proxy.sendMessage(
        6,
        LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getOverlayInvocationSource(): Promise<{
        invocationSource: string, }> {
    return this.proxy.sendMessage(
        7,
        LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,
        LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  infoRequestedByOverlay(
      clickModifiers: ui_mojom_ClickModifiers): void {
    this.proxy.sendMessage(
        8,
        LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,
        null,
        [
          clickModifiers
        ],
        false);
  }

  issueLensRegionRequest(
      region: lens_mojom_CenterRotatedBox,
      isClick: boolean): void {
    this.proxy.sendMessage(
        9,
        LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,
        null,
        [
          region,
          isClick
        ],
        false);
  }

  issueLensObjectRequest(
      region: lens_mojom_CenterRotatedBox,
      isMaskClick: boolean): void {
    this.proxy.sendMessage(
        10,
        LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,
        null,
        [
          region,
          isMaskClick
        ],
        false);
  }

  issueTextSelectionRequest(
      query: string,
      selectionStartIndex: number,
      selectionEndIndex: number,
      isTranslate: boolean): void {
    this.proxy.sendMessage(
        11,
        LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,
        null,
        [
          query,
          selectionStartIndex,
          selectionEndIndex,
          isTranslate
        ],
        false);
  }

  issueTranslateSelectionRequest(
      query: string,
      contentLanguage: string,
      selectionStartIndex: number,
      selectionEndIndex: number): void {
    this.proxy.sendMessage(
        12,
        LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,
        null,
        [
          query,
          contentLanguage,
          selectionStartIndex,
          selectionEndIndex
        ],
        false);
  }

  issueMathSelectionRequest(
      query: string,
      formula: string,
      selectionStartIndex: number,
      selectionEndIndex: number): void {
    this.proxy.sendMessage(
        13,
        LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,
        null,
        [
          query,
          formula,
          selectionStartIndex,
          selectionEndIndex
        ],
        false);
  }

  issueTranslateFullPageRequest(
      sourceLanguage: string,
      targetLanguage: string): void {
    this.proxy.sendMessage(
        14,
        LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,
        null,
        [
          sourceLanguage,
          targetLanguage
        ],
        false);
  }

  issueEndTranslateModeRequest(): void {
    this.proxy.sendMessage(
        15,
        LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  copyText(
      text: string): void {
    this.proxy.sendMessage(
        16,
        LensPageHandler_CopyText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  copyImage(
      region: lens_mojom_CenterRotatedBox): void {
    this.proxy.sendMessage(
        17,
        LensPageHandler_CopyImage_ParamsSpec.$,
        null,
        [
          region
        ],
        false);
  }

  saveAsImage(
      region: lens_mojom_CenterRotatedBox): void {
    this.proxy.sendMessage(
        18,
        LensPageHandler_SaveAsImage_ParamsSpec.$,
        null,
        [
          region
        ],
        false);
  }

  closePreselectionBubble(): void {
    this.proxy.sendMessage(
        19,
        LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  recordUkmAndTaskCompletionForLensOverlayInteraction(
      userAction: UserAction): void {
    this.proxy.sendMessage(
        20,
        LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,
        null,
        [
          userAction
        ],
        false);
  }

  recordLensOverlaySemanticEvent(
      event: SemanticEvent): void {
    this.proxy.sendMessage(
        21,
        LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }

  maybeShowTranslateFeaturePromo(): void {
    this.proxy.sendMessage(
        22,
        LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  maybeCloseTranslateFeaturePromo(
      featureEngaged: boolean): void {
    this.proxy.sendMessage(
        23,
        LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,
        null,
        [
          featureEngaged
        ],
        false);
  }

  fetchSupportedLanguages(): Promise<{
        browserLocale: string,
        sourceLanguages: lens_mojom_Language[],
        targetLanguages: lens_mojom_Language[], }> {
    return this.proxy.sendMessage(
        24,
        LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,
        LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  finishReshowOverlay(): void {
    this.proxy.sendMessage(
        25,
        LensPageHandler_FinishReshowOverlay_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  acceptPrivacyNotice(): void {
    this.proxy.sendMessage(
        26,
        LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  dismissPrivacyNotice(): void {
    this.proxy.sendMessage(
        27,
        LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LensPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LensPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensPageHandlerRemote, LensPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensPageHandlerRemote, LensPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LensPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LensPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,
        null,
        impl.activityRequestedByOverlay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,
        null,
        impl.closeRequestedByOverlayCloseButton.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,
        null,
        impl.closeRequestedByOverlayBackgroundClick.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,
        null,
        impl.notifyOverlayInitialized.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LensPageHandler_AddBackgroundBlur_ParamsSpec.$,
        null,
        impl.addBackgroundBlur.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LensPageHandler_SetLiveBlur_ParamsSpec.$,
        null,
        impl.setLiveBlur.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,
        null,
        impl.feedbackRequestedByOverlay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,
        LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,
        impl.getOverlayInvocationSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,
        null,
        impl.infoRequestedByOverlay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,
        null,
        impl.issueLensRegionRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,
        null,
        impl.issueLensObjectRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,
        null,
        impl.issueTextSelectionRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,
        null,
        impl.issueTranslateSelectionRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,
        null,
        impl.issueMathSelectionRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,
        null,
        impl.issueTranslateFullPageRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,
        null,
        impl.issueEndTranslateModeRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        LensPageHandler_CopyText_ParamsSpec.$,
        null,
        impl.copyText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        LensPageHandler_CopyImage_ParamsSpec.$,
        null,
        impl.copyImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        LensPageHandler_SaveAsImage_ParamsSpec.$,
        null,
        impl.saveAsImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,
        null,
        impl.closePreselectionBubble.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,
        null,
        impl.recordUkmAndTaskCompletionForLensOverlayInteraction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,
        null,
        impl.recordLensOverlaySemanticEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,
        null,
        impl.maybeShowTranslateFeaturePromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,
        null,
        impl.maybeCloseTranslateFeaturePromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,
        LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,
        impl.fetchSupportedLanguages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        LensPageHandler_FinishReshowOverlay_ParamsSpec.$,
        null,
        impl.finishReshowOverlay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,
        null,
        impl.acceptPrivacyNotice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,
        null,
        impl.dismissPrivacyNotice.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LensPageHandler {
  static get $interfaceName(): string {
    return "lens.mojom.LensPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LensPageHandlerRemote {
    let remote = new LensPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LensPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LensPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensPageHandlerRemote, LensPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensPageHandlerRemote, LensPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  activityRequestedByOverlay: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeRequestedByOverlayCloseButton: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeRequestedByOverlayBackgroundClick: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyOverlayInitialized: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addBackgroundBlur: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setLiveBlur: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  feedbackRequestedByOverlay: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getOverlayInvocationSource: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  infoRequestedByOverlay: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueLensRegionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueLensObjectRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueTextSelectionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueTranslateSelectionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueMathSelectionRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueTranslateFullPageRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  issueEndTranslateModeRequest: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  copyText: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  copyImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  saveAsImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closePreselectionBubble: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordUkmAndTaskCompletionForLensOverlayInteraction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordLensOverlaySemanticEvent: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maybeShowTranslateFeaturePromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maybeCloseTranslateFeaturePromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  fetchSupportedLanguages: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  finishReshowOverlay: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  acceptPrivacyNotice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  dismissPrivacyNotice: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LensPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.activityRequestedByOverlay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,
        null,
        this.activityRequestedByOverlay.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeRequestedByOverlayCloseButton =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,
        null,
        this.closeRequestedByOverlayCloseButton.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeRequestedByOverlayBackgroundClick =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,
        null,
        this.closeRequestedByOverlayBackgroundClick.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyOverlayInitialized =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,
        null,
        this.notifyOverlayInitialized.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addBackgroundBlur =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LensPageHandler_AddBackgroundBlur_ParamsSpec.$,
        null,
        this.addBackgroundBlur.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setLiveBlur =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LensPageHandler_SetLiveBlur_ParamsSpec.$,
        null,
        this.setLiveBlur.createReceiverHandler(false /* expectsResponse */),
        false);
    this.feedbackRequestedByOverlay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,
        null,
        this.feedbackRequestedByOverlay.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getOverlayInvocationSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,
        LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,
        this.getOverlayInvocationSource.createReceiverHandler(true /* expectsResponse */),
        false);
    this.infoRequestedByOverlay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,
        null,
        this.infoRequestedByOverlay.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueLensRegionRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,
        null,
        this.issueLensRegionRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueLensObjectRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,
        null,
        this.issueLensObjectRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueTextSelectionRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,
        null,
        this.issueTextSelectionRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueTranslateSelectionRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,
        null,
        this.issueTranslateSelectionRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueMathSelectionRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,
        null,
        this.issueMathSelectionRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueTranslateFullPageRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,
        null,
        this.issueTranslateFullPageRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.issueEndTranslateModeRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,
        null,
        this.issueEndTranslateModeRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    this.copyText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        LensPageHandler_CopyText_ParamsSpec.$,
        null,
        this.copyText.createReceiverHandler(false /* expectsResponse */),
        false);
    this.copyImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        LensPageHandler_CopyImage_ParamsSpec.$,
        null,
        this.copyImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.saveAsImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        LensPageHandler_SaveAsImage_ParamsSpec.$,
        null,
        this.saveAsImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closePreselectionBubble =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,
        null,
        this.closePreselectionBubble.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordUkmAndTaskCompletionForLensOverlayInteraction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,
        null,
        this.recordUkmAndTaskCompletionForLensOverlayInteraction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordLensOverlaySemanticEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,
        null,
        this.recordLensOverlaySemanticEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    this.maybeShowTranslateFeaturePromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,
        null,
        this.maybeShowTranslateFeaturePromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.maybeCloseTranslateFeaturePromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,
        null,
        this.maybeCloseTranslateFeaturePromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.fetchSupportedLanguages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,
        LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,
        this.fetchSupportedLanguages.createReceiverHandler(true /* expectsResponse */),
        false);
    this.finishReshowOverlay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        LensPageHandler_FinishReshowOverlay_ParamsSpec.$,
        null,
        this.finishReshowOverlay.createReceiverHandler(false /* expectsResponse */),
        false);
    this.acceptPrivacyNotice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,
        null,
        this.acceptPrivacyNotice.createReceiverHandler(false /* expectsResponse */),
        false);
    this.dismissPrivacyNotice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,
        null,
        this.dismissPrivacyNotice.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type LensPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<LensPagePendingReceiver>;

export class LensPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<LensPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<LensPagePendingReceiver>;
  constructor(handle: MojoHandle|LensPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'lens.mojom.LensPage',
        scope);
  }
}

export interface LensPageInterface {
  screenshotDataReceived(screenshotData: skia_mojom_BitmapMappedFromTrustedProcess, isSidePanelOpen: boolean): void;
  notifyHandshakeComplete(): void;
  notifyResultsPanelOpened(): void;
  notifyOverlayClosing(): void;
  objectsReceived(objects: lens_mojom_OverlayObject[]): void;
  textReceived(text: lens_mojom_Text): void;
  regionTextReceived(text: lens_mojom_Text, isInjectedImage: boolean): void;
  themeReceived(theme: OverlayTheme): void;
  shouldShowContextualSearchBox(shouldShow: boolean): void;
  pageContentTypeChanged(newPageContentType: lens_mojom_PageContentType): void;
  setPostRegionSelection(region: lens_mojom_CenterRotatedBox): void;
  setTextSelection(selectionStartIndex: number, selectionEndIndex: number): void;
  setTranslateMode(sourceLanguage: string, targetLanguage: string): void;
  clearRegionSelection(): void;
  clearTextSelection(): void;
  clearAllSelections(): void;
  onCopyCommand(): void;
  suppressGhostLoader(): void;
  onOverlayReshown(screenshotData: skia_mojom_BitmapMappedFromTrustedProcess): void;
}

export class LensPageRemote implements LensPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<LensPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<LensPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|LensPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LensPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  screenshotDataReceived(
      screenshotData: skia_mojom_BitmapMappedFromTrustedProcess,
      isSidePanelOpen: boolean): void {
    this.proxy.sendMessage(
        0,
        LensPage_ScreenshotDataReceived_ParamsSpec.$,
        null,
        [
          screenshotData,
          isSidePanelOpen
        ],
        false);
  }

  notifyHandshakeComplete(): void {
    this.proxy.sendMessage(
        1,
        LensPage_NotifyHandshakeComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  notifyResultsPanelOpened(): void {
    this.proxy.sendMessage(
        2,
        LensPage_NotifyResultsPanelOpened_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  notifyOverlayClosing(): void {
    this.proxy.sendMessage(
        3,
        LensPage_NotifyOverlayClosing_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  objectsReceived(
      objects: lens_mojom_OverlayObject[]): void {
    this.proxy.sendMessage(
        4,
        LensPage_ObjectsReceived_ParamsSpec.$,
        null,
        [
          objects
        ],
        false);
  }

  textReceived(
      text: lens_mojom_Text): void {
    this.proxy.sendMessage(
        5,
        LensPage_TextReceived_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  regionTextReceived(
      text: lens_mojom_Text,
      isInjectedImage: boolean): void {
    this.proxy.sendMessage(
        6,
        LensPage_RegionTextReceived_ParamsSpec.$,
        null,
        [
          text,
          isInjectedImage
        ],
        false);
  }

  themeReceived(
      theme: OverlayTheme): void {
    this.proxy.sendMessage(
        7,
        LensPage_ThemeReceived_ParamsSpec.$,
        null,
        [
          theme
        ],
        false);
  }

  shouldShowContextualSearchBox(
      shouldShow: boolean): void {
    this.proxy.sendMessage(
        8,
        LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,
        null,
        [
          shouldShow
        ],
        false);
  }

  pageContentTypeChanged(
      newPageContentType: lens_mojom_PageContentType): void {
    this.proxy.sendMessage(
        9,
        LensPage_PageContentTypeChanged_ParamsSpec.$,
        null,
        [
          newPageContentType
        ],
        false);
  }

  setPostRegionSelection(
      region: lens_mojom_CenterRotatedBox): void {
    this.proxy.sendMessage(
        10,
        LensPage_SetPostRegionSelection_ParamsSpec.$,
        null,
        [
          region
        ],
        false);
  }

  setTextSelection(
      selectionStartIndex: number,
      selectionEndIndex: number): void {
    this.proxy.sendMessage(
        11,
        LensPage_SetTextSelection_ParamsSpec.$,
        null,
        [
          selectionStartIndex,
          selectionEndIndex
        ],
        false);
  }

  setTranslateMode(
      sourceLanguage: string,
      targetLanguage: string): void {
    this.proxy.sendMessage(
        12,
        LensPage_SetTranslateMode_ParamsSpec.$,
        null,
        [
          sourceLanguage,
          targetLanguage
        ],
        false);
  }

  clearRegionSelection(): void {
    this.proxy.sendMessage(
        13,
        LensPage_ClearRegionSelection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  clearTextSelection(): void {
    this.proxy.sendMessage(
        14,
        LensPage_ClearTextSelection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  clearAllSelections(): void {
    this.proxy.sendMessage(
        15,
        LensPage_ClearAllSelections_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onCopyCommand(): void {
    this.proxy.sendMessage(
        16,
        LensPage_OnCopyCommand_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  suppressGhostLoader(): void {
    this.proxy.sendMessage(
        17,
        LensPage_SuppressGhostLoader_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onOverlayReshown(
      screenshotData: skia_mojom_BitmapMappedFromTrustedProcess): void {
    this.proxy.sendMessage(
        18,
        LensPage_OnOverlayReshown_ParamsSpec.$,
        null,
        [
          screenshotData
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LensPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LensPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensPageRemote, LensPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensPageRemote, LensPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: LensPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LensPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LensPage_ScreenshotDataReceived_ParamsSpec.$,
        null,
        impl.screenshotDataReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LensPage_NotifyHandshakeComplete_ParamsSpec.$,
        null,
        impl.notifyHandshakeComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LensPage_NotifyResultsPanelOpened_ParamsSpec.$,
        null,
        impl.notifyResultsPanelOpened.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LensPage_NotifyOverlayClosing_ParamsSpec.$,
        null,
        impl.notifyOverlayClosing.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LensPage_ObjectsReceived_ParamsSpec.$,
        null,
        impl.objectsReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        LensPage_TextReceived_ParamsSpec.$,
        null,
        impl.textReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        LensPage_RegionTextReceived_ParamsSpec.$,
        null,
        impl.regionTextReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        LensPage_ThemeReceived_ParamsSpec.$,
        null,
        impl.themeReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,
        null,
        impl.shouldShowContextualSearchBox.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        LensPage_PageContentTypeChanged_ParamsSpec.$,
        null,
        impl.pageContentTypeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        LensPage_SetPostRegionSelection_ParamsSpec.$,
        null,
        impl.setPostRegionSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        LensPage_SetTextSelection_ParamsSpec.$,
        null,
        impl.setTextSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        LensPage_SetTranslateMode_ParamsSpec.$,
        null,
        impl.setTranslateMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        LensPage_ClearRegionSelection_ParamsSpec.$,
        null,
        impl.clearRegionSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        LensPage_ClearTextSelection_ParamsSpec.$,
        null,
        impl.clearTextSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        LensPage_ClearAllSelections_ParamsSpec.$,
        null,
        impl.clearAllSelections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        LensPage_OnCopyCommand_ParamsSpec.$,
        null,
        impl.onCopyCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        LensPage_SuppressGhostLoader_ParamsSpec.$,
        null,
        impl.suppressGhostLoader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        LensPage_OnOverlayReshown_ParamsSpec.$,
        null,
        impl.onOverlayReshown.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LensPage {
  static get $interfaceName(): string {
    return "lens.mojom.LensPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): LensPageRemote {
    let remote = new LensPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the LensPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LensPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    LensPageRemote, LensPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    LensPageRemote, LensPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  screenshotDataReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyHandshakeComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyResultsPanelOpened: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  notifyOverlayClosing: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  objectsReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  textReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  regionTextReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  themeReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  shouldShowContextualSearchBox: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pageContentTypeChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPostRegionSelection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTextSelection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTranslateMode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearRegionSelection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearTextSelection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearAllSelections: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onCopyCommand: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  suppressGhostLoader: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onOverlayReshown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LensPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.screenshotDataReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LensPage_ScreenshotDataReceived_ParamsSpec.$,
        null,
        this.screenshotDataReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyHandshakeComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LensPage_NotifyHandshakeComplete_ParamsSpec.$,
        null,
        this.notifyHandshakeComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyResultsPanelOpened =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LensPage_NotifyResultsPanelOpened_ParamsSpec.$,
        null,
        this.notifyResultsPanelOpened.createReceiverHandler(false /* expectsResponse */),
        false);
    this.notifyOverlayClosing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LensPage_NotifyOverlayClosing_ParamsSpec.$,
        null,
        this.notifyOverlayClosing.createReceiverHandler(false /* expectsResponse */),
        false);
    this.objectsReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LensPage_ObjectsReceived_ParamsSpec.$,
        null,
        this.objectsReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.textReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        LensPage_TextReceived_ParamsSpec.$,
        null,
        this.textReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.regionTextReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        LensPage_RegionTextReceived_ParamsSpec.$,
        null,
        this.regionTextReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.themeReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        LensPage_ThemeReceived_ParamsSpec.$,
        null,
        this.themeReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.shouldShowContextualSearchBox =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,
        null,
        this.shouldShowContextualSearchBox.createReceiverHandler(false /* expectsResponse */),
        false);
    this.pageContentTypeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        LensPage_PageContentTypeChanged_ParamsSpec.$,
        null,
        this.pageContentTypeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPostRegionSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        LensPage_SetPostRegionSelection_ParamsSpec.$,
        null,
        this.setPostRegionSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setTextSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        LensPage_SetTextSelection_ParamsSpec.$,
        null,
        this.setTextSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setTranslateMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        LensPage_SetTranslateMode_ParamsSpec.$,
        null,
        this.setTranslateMode.createReceiverHandler(false /* expectsResponse */),
        false);
    this.clearRegionSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        LensPage_ClearRegionSelection_ParamsSpec.$,
        null,
        this.clearRegionSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.clearTextSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        LensPage_ClearTextSelection_ParamsSpec.$,
        null,
        this.clearTextSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.clearAllSelections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        LensPage_ClearAllSelections_ParamsSpec.$,
        null,
        this.clearAllSelections.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onCopyCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        LensPage_OnCopyCommand_ParamsSpec.$,
        null,
        this.onCopyCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    this.suppressGhostLoader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        LensPage_SuppressGhostLoader_ParamsSpec.$,
        null,
        this.suppressGhostLoader.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onOverlayReshown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        LensPage_OnOverlayReshown_ParamsSpec.$,
        null,
        this.onOverlayReshown.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const OverlayThemeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_ActivityRequestedByOverlay_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_NotifyOverlayInitialized_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_AddBackgroundBlur_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_SetLiveBlur_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_GetOverlayInvocationSource_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_InfoRequestedByOverlay_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueLensRegionRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueLensObjectRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueTextSelectionRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueMathSelectionRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_CopyText_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_CopyImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_SaveAsImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_ClosePreselectionBubble_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_FetchSupportedLanguages_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_FinishReshowOverlay_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_AcceptPrivacyNotice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPageHandler_DismissPrivacyNotice_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ScreenshotDataReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_NotifyHandshakeComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_NotifyResultsPanelOpened_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_NotifyOverlayClosing_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ObjectsReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_TextReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_RegionTextReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ThemeReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ShouldShowContextualSearchBox_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_PageContentTypeChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_SetPostRegionSelection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_SetTextSelection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_SetTranslateMode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ClearRegionSelection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ClearTextSelection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_ClearAllSelections_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_OnCopyCommand_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_SuppressGhostLoader_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const LensPage_OnOverlayReshown_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface OverlayThemeMojoType {
  primary: skia_mojom_SkColor;
  shaderLayer1: skia_mojom_SkColor;
  shaderLayer2: skia_mojom_SkColor;
  shaderLayer3: skia_mojom_SkColor;
  shaderLayer4: skia_mojom_SkColor;
  shaderLayer5: skia_mojom_SkColor;
  scrim: skia_mojom_SkColor;
  surfaceContainerHighestLight: skia_mojom_SkColor;
  surfaceContainerHighestDark: skia_mojom_SkColor;
  selectionElement: skia_mojom_SkColor;
}


export type OverlayTheme = OverlayThemeMojoType;
mojo.internal.Struct<OverlayThemeMojoType>(
    OverlayThemeSpec.$,
    'OverlayTheme',
    [
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'primary', 0,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'shaderLayer1', 8,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'shaderLayer2', 16,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'shaderLayer3', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'shaderLayer4', 32,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'shaderLayer5', 40,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'scrim', 48,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'surfaceContainerHighestLight', 56,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'surfaceContainerHighestDark', 64,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OverlayThemeMojoType, skia_mojom_SkColor>(
        'selectionElement', 72,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 88],]);





export interface LensPageHandlerFactory_CreatePageHandler_ParamsMojoType {
  handler: LensPageHandlerPendingReceiver;
  page: LensPageRemote;
}


export type LensPageHandlerFactory_CreatePageHandler_Params = LensPageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<LensPageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    LensPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'LensPageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<LensPageHandlerFactory_CreatePageHandler_ParamsMojoType, LensPageHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(LensPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandlerFactory_CreatePageHandler_ParamsMojoType, LensPageRemote>(
        'page', 4,
        0,
        mojo.internal.InterfaceProxy(LensPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPageHandler_ActivityRequestedByOverlay_ParamsMojoType {
  clickModifiers: ui_mojom_ClickModifiers;
}


export type LensPageHandler_ActivityRequestedByOverlay_Params = LensPageHandler_ActivityRequestedByOverlay_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_ActivityRequestedByOverlay_ParamsMojoType>(
    LensPageHandler_ActivityRequestedByOverlay_ParamsSpec.$,
    'LensPageHandler_ActivityRequestedByOverlay_Params',
    [
      mojo.internal.StructField<LensPageHandler_ActivityRequestedByOverlay_ParamsMojoType, ui_mojom_ClickModifiers>(
        'clickModifiers', 0,
        0,
        ui_mojom_ClickModifiersSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsMojoType {
}


export type LensPageHandler_CloseRequestedByOverlayCloseButton_Params = LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsMojoType>(
    LensPageHandler_CloseRequestedByOverlayCloseButton_ParamsSpec.$,
    'LensPageHandler_CloseRequestedByOverlayCloseButton_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsMojoType {
}


export type LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params = LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsMojoType>(
    LensPageHandler_CloseRequestedByOverlayBackgroundClick_ParamsSpec.$,
    'LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_NotifyOverlayInitialized_ParamsMojoType {
}


export type LensPageHandler_NotifyOverlayInitialized_Params = LensPageHandler_NotifyOverlayInitialized_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_NotifyOverlayInitialized_ParamsMojoType>(
    LensPageHandler_NotifyOverlayInitialized_ParamsSpec.$,
    'LensPageHandler_NotifyOverlayInitialized_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_AddBackgroundBlur_ParamsMojoType {
}


export type LensPageHandler_AddBackgroundBlur_Params = LensPageHandler_AddBackgroundBlur_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_AddBackgroundBlur_ParamsMojoType>(
    LensPageHandler_AddBackgroundBlur_ParamsSpec.$,
    'LensPageHandler_AddBackgroundBlur_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_SetLiveBlur_ParamsMojoType {
  enabled: boolean;
}


export type LensPageHandler_SetLiveBlur_Params = LensPageHandler_SetLiveBlur_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_SetLiveBlur_ParamsMojoType>(
    LensPageHandler_SetLiveBlur_ParamsSpec.$,
    'LensPageHandler_SetLiveBlur_Params',
    [
      mojo.internal.StructField<LensPageHandler_SetLiveBlur_ParamsMojoType, boolean>(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_FeedbackRequestedByOverlay_ParamsMojoType {
}


export type LensPageHandler_FeedbackRequestedByOverlay_Params = LensPageHandler_FeedbackRequestedByOverlay_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_FeedbackRequestedByOverlay_ParamsMojoType>(
    LensPageHandler_FeedbackRequestedByOverlay_ParamsSpec.$,
    'LensPageHandler_FeedbackRequestedByOverlay_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_GetOverlayInvocationSource_ParamsMojoType {
}


export type LensPageHandler_GetOverlayInvocationSource_Params = LensPageHandler_GetOverlayInvocationSource_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_GetOverlayInvocationSource_ParamsMojoType>(
    LensPageHandler_GetOverlayInvocationSource_ParamsSpec.$,
    'LensPageHandler_GetOverlayInvocationSource_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_GetOverlayInvocationSource_ResponseParamsMojoType {
  invocationSource: string;
}


export type LensPageHandler_GetOverlayInvocationSource_ResponseParams = LensPageHandler_GetOverlayInvocationSource_ResponseParamsMojoType;
mojo.internal.Struct<LensPageHandler_GetOverlayInvocationSource_ResponseParamsMojoType>(
    LensPageHandler_GetOverlayInvocationSource_ResponseParamsSpec.$,
    'LensPageHandler_GetOverlayInvocationSource_ResponseParams',
    [
      mojo.internal.StructField<LensPageHandler_GetOverlayInvocationSource_ResponseParamsMojoType, string>(
        'invocationSource', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_InfoRequestedByOverlay_ParamsMojoType {
  clickModifiers: ui_mojom_ClickModifiers;
}


export type LensPageHandler_InfoRequestedByOverlay_Params = LensPageHandler_InfoRequestedByOverlay_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_InfoRequestedByOverlay_ParamsMojoType>(
    LensPageHandler_InfoRequestedByOverlay_ParamsSpec.$,
    'LensPageHandler_InfoRequestedByOverlay_Params',
    [
      mojo.internal.StructField<LensPageHandler_InfoRequestedByOverlay_ParamsMojoType, ui_mojom_ClickModifiers>(
        'clickModifiers', 0,
        0,
        ui_mojom_ClickModifiersSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_IssueLensRegionRequest_ParamsMojoType {
  region: lens_mojom_CenterRotatedBox;
  isClick: boolean;
}


export type LensPageHandler_IssueLensRegionRequest_Params = LensPageHandler_IssueLensRegionRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueLensRegionRequest_ParamsMojoType>(
    LensPageHandler_IssueLensRegionRequest_ParamsSpec.$,
    'LensPageHandler_IssueLensRegionRequest_Params',
    [
      mojo.internal.StructField<LensPageHandler_IssueLensRegionRequest_ParamsMojoType, lens_mojom_CenterRotatedBox>(
        'region', 0,
        0,
        lens_mojom_CenterRotatedBoxSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueLensRegionRequest_ParamsMojoType, boolean>(
        'isClick', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPageHandler_IssueLensObjectRequest_ParamsMojoType {
  region: lens_mojom_CenterRotatedBox;
  isMaskClick: boolean;
}


export type LensPageHandler_IssueLensObjectRequest_Params = LensPageHandler_IssueLensObjectRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueLensObjectRequest_ParamsMojoType>(
    LensPageHandler_IssueLensObjectRequest_ParamsSpec.$,
    'LensPageHandler_IssueLensObjectRequest_Params',
    [
      mojo.internal.StructField<LensPageHandler_IssueLensObjectRequest_ParamsMojoType, lens_mojom_CenterRotatedBox>(
        'region', 0,
        0,
        lens_mojom_CenterRotatedBoxSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueLensObjectRequest_ParamsMojoType, boolean>(
        'isMaskClick', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPageHandler_IssueTextSelectionRequest_ParamsMojoType {
  query: string;
  selectionStartIndex: number;
  selectionEndIndex: number;
  isTranslate: boolean;
}


export type LensPageHandler_IssueTextSelectionRequest_Params = LensPageHandler_IssueTextSelectionRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueTextSelectionRequest_ParamsMojoType>(
    LensPageHandler_IssueTextSelectionRequest_ParamsSpec.$,
    'LensPageHandler_IssueTextSelectionRequest_Params',
    [
      mojo.internal.StructField<LensPageHandler_IssueTextSelectionRequest_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTextSelectionRequest_ParamsMojoType, number>(
        'selectionStartIndex', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTextSelectionRequest_ParamsMojoType, number>(
        'selectionEndIndex', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTextSelectionRequest_ParamsMojoType, boolean>(
        'isTranslate', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType {
  query: string;
  contentLanguage: string;
  selectionStartIndex: number;
  selectionEndIndex: number;
}


export type LensPageHandler_IssueTranslateSelectionRequest_Params = LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType>(
    LensPageHandler_IssueTranslateSelectionRequest_ParamsSpec.$,
    'LensPageHandler_IssueTranslateSelectionRequest_Params',
    [
      mojo.internal.StructField<LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType, string>(
        'contentLanguage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType, number>(
        'selectionStartIndex', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTranslateSelectionRequest_ParamsMojoType, number>(
        'selectionEndIndex', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface LensPageHandler_IssueMathSelectionRequest_ParamsMojoType {
  query: string;
  formula: string;
  selectionStartIndex: number;
  selectionEndIndex: number;
}


export type LensPageHandler_IssueMathSelectionRequest_Params = LensPageHandler_IssueMathSelectionRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueMathSelectionRequest_ParamsMojoType>(
    LensPageHandler_IssueMathSelectionRequest_ParamsSpec.$,
    'LensPageHandler_IssueMathSelectionRequest_Params',
    [
      mojo.internal.StructField<LensPageHandler_IssueMathSelectionRequest_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueMathSelectionRequest_ParamsMojoType, string>(
        'formula', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueMathSelectionRequest_ParamsMojoType, number>(
        'selectionStartIndex', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueMathSelectionRequest_ParamsMojoType, number>(
        'selectionEndIndex', 20,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface LensPageHandler_IssueTranslateFullPageRequest_ParamsMojoType {
  sourceLanguage: string;
  targetLanguage: string;
}


export type LensPageHandler_IssueTranslateFullPageRequest_Params = LensPageHandler_IssueTranslateFullPageRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueTranslateFullPageRequest_ParamsMojoType>(
    LensPageHandler_IssueTranslateFullPageRequest_ParamsSpec.$,
    'LensPageHandler_IssueTranslateFullPageRequest_Params',
    [
      mojo.internal.StructField<LensPageHandler_IssueTranslateFullPageRequest_ParamsMojoType, string>(
        'sourceLanguage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_IssueTranslateFullPageRequest_ParamsMojoType, string>(
        'targetLanguage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPageHandler_IssueEndTranslateModeRequest_ParamsMojoType {
}


export type LensPageHandler_IssueEndTranslateModeRequest_Params = LensPageHandler_IssueEndTranslateModeRequest_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_IssueEndTranslateModeRequest_ParamsMojoType>(
    LensPageHandler_IssueEndTranslateModeRequest_ParamsSpec.$,
    'LensPageHandler_IssueEndTranslateModeRequest_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_CopyText_ParamsMojoType {
  text: string;
}


export type LensPageHandler_CopyText_Params = LensPageHandler_CopyText_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_CopyText_ParamsMojoType>(
    LensPageHandler_CopyText_ParamsSpec.$,
    'LensPageHandler_CopyText_Params',
    [
      mojo.internal.StructField<LensPageHandler_CopyText_ParamsMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_CopyImage_ParamsMojoType {
  region: lens_mojom_CenterRotatedBox;
}


export type LensPageHandler_CopyImage_Params = LensPageHandler_CopyImage_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_CopyImage_ParamsMojoType>(
    LensPageHandler_CopyImage_ParamsSpec.$,
    'LensPageHandler_CopyImage_Params',
    [
      mojo.internal.StructField<LensPageHandler_CopyImage_ParamsMojoType, lens_mojom_CenterRotatedBox>(
        'region', 0,
        0,
        lens_mojom_CenterRotatedBoxSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_SaveAsImage_ParamsMojoType {
  region: lens_mojom_CenterRotatedBox;
}


export type LensPageHandler_SaveAsImage_Params = LensPageHandler_SaveAsImage_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_SaveAsImage_ParamsMojoType>(
    LensPageHandler_SaveAsImage_ParamsSpec.$,
    'LensPageHandler_SaveAsImage_Params',
    [
      mojo.internal.StructField<LensPageHandler_SaveAsImage_ParamsMojoType, lens_mojom_CenterRotatedBox>(
        'region', 0,
        0,
        lens_mojom_CenterRotatedBoxSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_ClosePreselectionBubble_ParamsMojoType {
}


export type LensPageHandler_ClosePreselectionBubble_Params = LensPageHandler_ClosePreselectionBubble_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_ClosePreselectionBubble_ParamsMojoType>(
    LensPageHandler_ClosePreselectionBubble_ParamsSpec.$,
    'LensPageHandler_ClosePreselectionBubble_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsMojoType {
  userAction: UserAction;
}


export type LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params = LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsMojoType>(
    LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsSpec.$,
    'LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params',
    [
      mojo.internal.StructField<LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_ParamsMojoType, UserAction>(
        'userAction', 0,
        0,
        UserActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_RecordLensOverlaySemanticEvent_ParamsMojoType {
  event: SemanticEvent;
}


export type LensPageHandler_RecordLensOverlaySemanticEvent_Params = LensPageHandler_RecordLensOverlaySemanticEvent_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_RecordLensOverlaySemanticEvent_ParamsMojoType>(
    LensPageHandler_RecordLensOverlaySemanticEvent_ParamsSpec.$,
    'LensPageHandler_RecordLensOverlaySemanticEvent_Params',
    [
      mojo.internal.StructField<LensPageHandler_RecordLensOverlaySemanticEvent_ParamsMojoType, SemanticEvent>(
        'event', 0,
        0,
        SemanticEventSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsMojoType {
}


export type LensPageHandler_MaybeShowTranslateFeaturePromo_Params = LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsMojoType>(
    LensPageHandler_MaybeShowTranslateFeaturePromo_ParamsSpec.$,
    'LensPageHandler_MaybeShowTranslateFeaturePromo_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsMojoType {
  featureEngaged: boolean;
}


export type LensPageHandler_MaybeCloseTranslateFeaturePromo_Params = LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsMojoType>(
    LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsSpec.$,
    'LensPageHandler_MaybeCloseTranslateFeaturePromo_Params',
    [
      mojo.internal.StructField<LensPageHandler_MaybeCloseTranslateFeaturePromo_ParamsMojoType, boolean>(
        'featureEngaged', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPageHandler_FetchSupportedLanguages_ParamsMojoType {
}


export type LensPageHandler_FetchSupportedLanguages_Params = LensPageHandler_FetchSupportedLanguages_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_FetchSupportedLanguages_ParamsMojoType>(
    LensPageHandler_FetchSupportedLanguages_ParamsSpec.$,
    'LensPageHandler_FetchSupportedLanguages_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_FetchSupportedLanguages_ResponseParamsMojoType {
  browserLocale: string;
  sourceLanguages: lens_mojom_Language[];
  targetLanguages: lens_mojom_Language[];
}


export type LensPageHandler_FetchSupportedLanguages_ResponseParams = LensPageHandler_FetchSupportedLanguages_ResponseParamsMojoType;
mojo.internal.Struct<LensPageHandler_FetchSupportedLanguages_ResponseParamsMojoType>(
    LensPageHandler_FetchSupportedLanguages_ResponseParamsSpec.$,
    'LensPageHandler_FetchSupportedLanguages_ResponseParams',
    [
      mojo.internal.StructField<LensPageHandler_FetchSupportedLanguages_ResponseParamsMojoType, string>(
        'browserLocale', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_FetchSupportedLanguages_ResponseParamsMojoType, lens_mojom_Language[]>(
        'sourceLanguages', 8,
        0,
        mojo.internal.Array(lens_mojom_LanguageSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPageHandler_FetchSupportedLanguages_ResponseParamsMojoType, lens_mojom_Language[]>(
        'targetLanguages', 16,
        0,
        mojo.internal.Array(lens_mojom_LanguageSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface LensPageHandler_FinishReshowOverlay_ParamsMojoType {
}


export type LensPageHandler_FinishReshowOverlay_Params = LensPageHandler_FinishReshowOverlay_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_FinishReshowOverlay_ParamsMojoType>(
    LensPageHandler_FinishReshowOverlay_ParamsSpec.$,
    'LensPageHandler_FinishReshowOverlay_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_AcceptPrivacyNotice_ParamsMojoType {
}


export type LensPageHandler_AcceptPrivacyNotice_Params = LensPageHandler_AcceptPrivacyNotice_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_AcceptPrivacyNotice_ParamsMojoType>(
    LensPageHandler_AcceptPrivacyNotice_ParamsSpec.$,
    'LensPageHandler_AcceptPrivacyNotice_Params',
    [
    ],
    [[0, 8],]);





export interface LensPageHandler_DismissPrivacyNotice_ParamsMojoType {
}


export type LensPageHandler_DismissPrivacyNotice_Params = LensPageHandler_DismissPrivacyNotice_ParamsMojoType;
mojo.internal.Struct<LensPageHandler_DismissPrivacyNotice_ParamsMojoType>(
    LensPageHandler_DismissPrivacyNotice_ParamsSpec.$,
    'LensPageHandler_DismissPrivacyNotice_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_ScreenshotDataReceived_ParamsMojoType {
  screenshotData: skia_mojom_BitmapMappedFromTrustedProcess;
  isSidePanelOpen: boolean;
}


export type LensPage_ScreenshotDataReceived_Params = LensPage_ScreenshotDataReceived_ParamsMojoType;
mojo.internal.Struct<LensPage_ScreenshotDataReceived_ParamsMojoType>(
    LensPage_ScreenshotDataReceived_ParamsSpec.$,
    'LensPage_ScreenshotDataReceived_Params',
    [
      mojo.internal.StructField<LensPage_ScreenshotDataReceived_ParamsMojoType, skia_mojom_BitmapMappedFromTrustedProcess>(
        'screenshotData', 0,
        0,
        skia_mojom_BitmapMappedFromTrustedProcessSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPage_ScreenshotDataReceived_ParamsMojoType, boolean>(
        'isSidePanelOpen', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPage_NotifyHandshakeComplete_ParamsMojoType {
}


export type LensPage_NotifyHandshakeComplete_Params = LensPage_NotifyHandshakeComplete_ParamsMojoType;
mojo.internal.Struct<LensPage_NotifyHandshakeComplete_ParamsMojoType>(
    LensPage_NotifyHandshakeComplete_ParamsSpec.$,
    'LensPage_NotifyHandshakeComplete_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_NotifyResultsPanelOpened_ParamsMojoType {
}


export type LensPage_NotifyResultsPanelOpened_Params = LensPage_NotifyResultsPanelOpened_ParamsMojoType;
mojo.internal.Struct<LensPage_NotifyResultsPanelOpened_ParamsMojoType>(
    LensPage_NotifyResultsPanelOpened_ParamsSpec.$,
    'LensPage_NotifyResultsPanelOpened_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_NotifyOverlayClosing_ParamsMojoType {
}


export type LensPage_NotifyOverlayClosing_Params = LensPage_NotifyOverlayClosing_ParamsMojoType;
mojo.internal.Struct<LensPage_NotifyOverlayClosing_ParamsMojoType>(
    LensPage_NotifyOverlayClosing_ParamsSpec.$,
    'LensPage_NotifyOverlayClosing_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_ObjectsReceived_ParamsMojoType {
  objects: lens_mojom_OverlayObject[];
}


export type LensPage_ObjectsReceived_Params = LensPage_ObjectsReceived_ParamsMojoType;
mojo.internal.Struct<LensPage_ObjectsReceived_ParamsMojoType>(
    LensPage_ObjectsReceived_ParamsSpec.$,
    'LensPage_ObjectsReceived_Params',
    [
      mojo.internal.StructField<LensPage_ObjectsReceived_ParamsMojoType, lens_mojom_OverlayObject[]>(
        'objects', 0,
        0,
        mojo.internal.Array(lens_mojom_OverlayObjectSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_TextReceived_ParamsMojoType {
  text: lens_mojom_Text;
}


export type LensPage_TextReceived_Params = LensPage_TextReceived_ParamsMojoType;
mojo.internal.Struct<LensPage_TextReceived_ParamsMojoType>(
    LensPage_TextReceived_ParamsSpec.$,
    'LensPage_TextReceived_Params',
    [
      mojo.internal.StructField<LensPage_TextReceived_ParamsMojoType, lens_mojom_Text>(
        'text', 0,
        0,
        lens_mojom_TextSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_RegionTextReceived_ParamsMojoType {
  text: lens_mojom_Text;
  isInjectedImage: boolean;
}


export type LensPage_RegionTextReceived_Params = LensPage_RegionTextReceived_ParamsMojoType;
mojo.internal.Struct<LensPage_RegionTextReceived_ParamsMojoType>(
    LensPage_RegionTextReceived_ParamsSpec.$,
    'LensPage_RegionTextReceived_Params',
    [
      mojo.internal.StructField<LensPage_RegionTextReceived_ParamsMojoType, lens_mojom_Text>(
        'text', 0,
        0,
        lens_mojom_TextSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPage_RegionTextReceived_ParamsMojoType, boolean>(
        'isInjectedImage', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPage_ThemeReceived_ParamsMojoType {
  theme: OverlayTheme;
}


export type LensPage_ThemeReceived_Params = LensPage_ThemeReceived_ParamsMojoType;
mojo.internal.Struct<LensPage_ThemeReceived_ParamsMojoType>(
    LensPage_ThemeReceived_ParamsSpec.$,
    'LensPage_ThemeReceived_Params',
    [
      mojo.internal.StructField<LensPage_ThemeReceived_ParamsMojoType, OverlayTheme>(
        'theme', 0,
        0,
        OverlayThemeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_ShouldShowContextualSearchBox_ParamsMojoType {
  shouldShow: boolean;
}


export type LensPage_ShouldShowContextualSearchBox_Params = LensPage_ShouldShowContextualSearchBox_ParamsMojoType;
mojo.internal.Struct<LensPage_ShouldShowContextualSearchBox_ParamsMojoType>(
    LensPage_ShouldShowContextualSearchBox_ParamsSpec.$,
    'LensPage_ShouldShowContextualSearchBox_Params',
    [
      mojo.internal.StructField<LensPage_ShouldShowContextualSearchBox_ParamsMojoType, boolean>(
        'shouldShow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_PageContentTypeChanged_ParamsMojoType {
  newPageContentType: lens_mojom_PageContentType;
}


export type LensPage_PageContentTypeChanged_Params = LensPage_PageContentTypeChanged_ParamsMojoType;
mojo.internal.Struct<LensPage_PageContentTypeChanged_ParamsMojoType>(
    LensPage_PageContentTypeChanged_ParamsSpec.$,
    'LensPage_PageContentTypeChanged_Params',
    [
      mojo.internal.StructField<LensPage_PageContentTypeChanged_ParamsMojoType, lens_mojom_PageContentType>(
        'newPageContentType', 0,
        0,
        lens_mojom_PageContentTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_SetPostRegionSelection_ParamsMojoType {
  region: lens_mojom_CenterRotatedBox;
}


export type LensPage_SetPostRegionSelection_Params = LensPage_SetPostRegionSelection_ParamsMojoType;
mojo.internal.Struct<LensPage_SetPostRegionSelection_ParamsMojoType>(
    LensPage_SetPostRegionSelection_ParamsSpec.$,
    'LensPage_SetPostRegionSelection_Params',
    [
      mojo.internal.StructField<LensPage_SetPostRegionSelection_ParamsMojoType, lens_mojom_CenterRotatedBox>(
        'region', 0,
        0,
        lens_mojom_CenterRotatedBoxSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_SetTextSelection_ParamsMojoType {
  selectionStartIndex: number;
  selectionEndIndex: number;
}


export type LensPage_SetTextSelection_Params = LensPage_SetTextSelection_ParamsMojoType;
mojo.internal.Struct<LensPage_SetTextSelection_ParamsMojoType>(
    LensPage_SetTextSelection_ParamsSpec.$,
    'LensPage_SetTextSelection_Params',
    [
      mojo.internal.StructField<LensPage_SetTextSelection_ParamsMojoType, number>(
        'selectionStartIndex', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPage_SetTextSelection_ParamsMojoType, number>(
        'selectionEndIndex', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface LensPage_SetTranslateMode_ParamsMojoType {
  sourceLanguage: string;
  targetLanguage: string;
}


export type LensPage_SetTranslateMode_Params = LensPage_SetTranslateMode_ParamsMojoType;
mojo.internal.Struct<LensPage_SetTranslateMode_ParamsMojoType>(
    LensPage_SetTranslateMode_ParamsSpec.$,
    'LensPage_SetTranslateMode_Params',
    [
      mojo.internal.StructField<LensPage_SetTranslateMode_ParamsMojoType, string>(
        'sourceLanguage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<LensPage_SetTranslateMode_ParamsMojoType, string>(
        'targetLanguage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface LensPage_ClearRegionSelection_ParamsMojoType {
}


export type LensPage_ClearRegionSelection_Params = LensPage_ClearRegionSelection_ParamsMojoType;
mojo.internal.Struct<LensPage_ClearRegionSelection_ParamsMojoType>(
    LensPage_ClearRegionSelection_ParamsSpec.$,
    'LensPage_ClearRegionSelection_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_ClearTextSelection_ParamsMojoType {
}


export type LensPage_ClearTextSelection_Params = LensPage_ClearTextSelection_ParamsMojoType;
mojo.internal.Struct<LensPage_ClearTextSelection_ParamsMojoType>(
    LensPage_ClearTextSelection_ParamsSpec.$,
    'LensPage_ClearTextSelection_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_ClearAllSelections_ParamsMojoType {
}


export type LensPage_ClearAllSelections_Params = LensPage_ClearAllSelections_ParamsMojoType;
mojo.internal.Struct<LensPage_ClearAllSelections_ParamsMojoType>(
    LensPage_ClearAllSelections_ParamsSpec.$,
    'LensPage_ClearAllSelections_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_OnCopyCommand_ParamsMojoType {
}


export type LensPage_OnCopyCommand_Params = LensPage_OnCopyCommand_ParamsMojoType;
mojo.internal.Struct<LensPage_OnCopyCommand_ParamsMojoType>(
    LensPage_OnCopyCommand_ParamsSpec.$,
    'LensPage_OnCopyCommand_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_SuppressGhostLoader_ParamsMojoType {
}


export type LensPage_SuppressGhostLoader_Params = LensPage_SuppressGhostLoader_ParamsMojoType;
mojo.internal.Struct<LensPage_SuppressGhostLoader_ParamsMojoType>(
    LensPage_SuppressGhostLoader_ParamsSpec.$,
    'LensPage_SuppressGhostLoader_Params',
    [
    ],
    [[0, 8],]);





export interface LensPage_OnOverlayReshown_ParamsMojoType {
  screenshotData: skia_mojom_BitmapMappedFromTrustedProcess;
}


export type LensPage_OnOverlayReshown_Params = LensPage_OnOverlayReshown_ParamsMojoType;
mojo.internal.Struct<LensPage_OnOverlayReshown_ParamsMojoType>(
    LensPage_OnOverlayReshown_ParamsSpec.$,
    'LensPage_OnOverlayReshown_Params',
    [
      mojo.internal.StructField<LensPage_OnOverlayReshown_ParamsMojoType, skia_mojom_BitmapMappedFromTrustedProcess>(
        'screenshotData', 0,
        0,
        skia_mojom_BitmapMappedFromTrustedProcessSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



