// chrome/browser/lens/core/mojom/lens.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_TEST_UTILS_H_

#include "chrome/browser/lens/core/mojom/lens.mojom.h"


namespace lens::mojom {


class  LensPageHandlerFactoryInterceptorForTesting : public LensPageHandlerFactory {
  virtual LensPageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingReceiver<LensPageHandler> handler, ::mojo::PendingRemote<LensPage> page) override;
};
class  LensPageHandlerFactoryAsyncWaiter {
 public:
  explicit LensPageHandlerFactoryAsyncWaiter(LensPageHandlerFactory* proxy);

  LensPageHandlerFactoryAsyncWaiter(const LensPageHandlerFactoryAsyncWaiter&) = delete;
  LensPageHandlerFactoryAsyncWaiter& operator=(const LensPageHandlerFactoryAsyncWaiter&) = delete;

  ~LensPageHandlerFactoryAsyncWaiter();

 private:
  LensPageHandlerFactory* const proxy_;
};


class  LensPageHandlerInterceptorForTesting : public LensPageHandler {
  virtual LensPageHandler* GetForwardingInterface() = 0;
  void ActivityRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) override;
  void CloseRequestedByOverlayCloseButton() override;
  void CloseRequestedByOverlayBackgroundClick() override;
  void NotifyOverlayInitialized() override;
  void AddBackgroundBlur() override;
  void SetLiveBlur(bool enabled) override;
  void FeedbackRequestedByOverlay() override;
  void GetOverlayInvocationSource(GetOverlayInvocationSourceCallback callback) override;
  void InfoRequestedByOverlay(::ui::mojom::ClickModifiersPtr click_modifiers) override;
  void IssueLensRegionRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_click) override;
  void IssueLensObjectRequest(::lens::mojom::CenterRotatedBoxPtr region, bool is_mask_click) override;
  void IssueTextSelectionRequest(const std::string& query, int32_t selection_start_index, int32_t selection_end_index, bool is_translate) override;
  void IssueTranslateSelectionRequest(const std::string& query, const std::string& content_language, int32_t selection_start_index, int32_t selection_end_index) override;
  void IssueMathSelectionRequest(const std::string& query, const std::string& formula, int32_t selection_start_index, int32_t selection_end_index) override;
  void IssueTranslateFullPageRequest(const std::string& source_language, const std::string& target_language) override;
  void IssueEndTranslateModeRequest() override;
  void CopyText(const std::string& text) override;
  void CopyImage(::lens::mojom::CenterRotatedBoxPtr region) override;
  void SaveAsImage(::lens::mojom::CenterRotatedBoxPtr region) override;
  void ClosePreselectionBubble() override;
  void RecordUkmAndTaskCompletionForLensOverlayInteraction(UserAction user_action) override;
  void RecordLensOverlaySemanticEvent(SemanticEvent event) override;
  void MaybeShowTranslateFeaturePromo() override;
  void MaybeCloseTranslateFeaturePromo(bool feature_engaged) override;
  void FetchSupportedLanguages(FetchSupportedLanguagesCallback callback) override;
  void FinishReshowOverlay() override;
  void AcceptPrivacyNotice() override;
  void DismissPrivacyNotice() override;
};
class  LensPageHandlerAsyncWaiter {
 public:
  explicit LensPageHandlerAsyncWaiter(LensPageHandler* proxy);

  LensPageHandlerAsyncWaiter(const LensPageHandlerAsyncWaiter&) = delete;
  LensPageHandlerAsyncWaiter& operator=(const LensPageHandlerAsyncWaiter&) = delete;

  ~LensPageHandlerAsyncWaiter();
  void GetOverlayInvocationSource(
      std::string* out_invocation_source);
  std::string GetOverlayInvocationSource();
  void FetchSupportedLanguages(
      std::string* out_browser_locale, std::vector<::lens::mojom::LanguagePtr>* out_source_languages, std::vector<::lens::mojom::LanguagePtr>* out_target_languages);
  

 private:
  LensPageHandler* const proxy_;
};


class  LensPageInterceptorForTesting : public LensPage {
  virtual LensPage* GetForwardingInterface() = 0;
  void ScreenshotDataReceived(const ::SkBitmap& screenshot_data, bool is_side_panel_open) override;
  void NotifyHandshakeComplete() override;
  void NotifyResultsPanelOpened() override;
  void NotifyOverlayClosing() override;
  void ObjectsReceived(std::vector<::lens::mojom::OverlayObjectPtr> objects) override;
  void TextReceived(::lens::mojom::TextPtr text) override;
  void RegionTextReceived(::lens::mojom::TextPtr text, bool is_injected_image) override;
  void ThemeReceived(OverlayThemePtr theme) override;
  void ShouldShowContextualSearchBox(bool should_show) override;
  void PageContentTypeChanged(::lens::mojom::PageContentType new_page_content_type) override;
  void SetPostRegionSelection(::lens::mojom::CenterRotatedBoxPtr region) override;
  void SetTextSelection(int32_t selection_start_index, int32_t selection_end_index) override;
  void SetTranslateMode(const std::string& source_language, const std::string& target_language) override;
  void ClearRegionSelection() override;
  void ClearTextSelection() override;
  void ClearAllSelections() override;
  void OnCopyCommand() override;
  void SuppressGhostLoader() override;
  void OnOverlayReshown(const ::SkBitmap& screenshot_data) override;
};
class  LensPageAsyncWaiter {
 public:
  explicit LensPageAsyncWaiter(LensPage* proxy);

  LensPageAsyncWaiter(const LensPageAsyncWaiter&) = delete;
  LensPageAsyncWaiter& operator=(const LensPageAsyncWaiter&) = delete;

  ~LensPageAsyncWaiter();

 private:
  LensPage* const proxy_;
};




}  // lens::mojom

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_TEST_UTILS_H_