// chrome/browser/lens/core/mojom/lens.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_SHARED_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/lens.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/overlay_object.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/page_content_type.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/text.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/translate.mojom-shared.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/lens/core/mojom/lens.mojom-data-view.h"




namespace std {

template <>
struct hash<::lens::mojom::UserAction>
    : public mojo::internal::EnumHashImpl<::lens::mojom::UserAction> {};

template <>
struct hash<::lens::mojom::SemanticEvent>
    : public mojo::internal::EnumHashImpl<::lens::mojom::SemanticEvent> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::UserAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::UserAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::UserAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::SemanticEvent, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::SemanticEvent, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::SemanticEvent>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::OverlayThemeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::OverlayThemeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::OverlayTheme_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::primary(input)) in_primary = Traits::primary(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary)::BaseType> primary_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_primary,
      primary_fragment);

    fragment->primary.Set(
        primary_fragment.is_null() ? nullptr : primary_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary in OverlayTheme struct");

    decltype(Traits::shader_layer_1(input)) in_shader_layer_1 = Traits::shader_layer_1(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shader_layer_1)::BaseType> shader_layer_1_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_shader_layer_1,
      shader_layer_1_fragment);

    fragment->shader_layer_1.Set(
        shader_layer_1_fragment.is_null() ? nullptr : shader_layer_1_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shader_layer_1.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shader_layer_1 in OverlayTheme struct");

    decltype(Traits::shader_layer_2(input)) in_shader_layer_2 = Traits::shader_layer_2(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shader_layer_2)::BaseType> shader_layer_2_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_shader_layer_2,
      shader_layer_2_fragment);

    fragment->shader_layer_2.Set(
        shader_layer_2_fragment.is_null() ? nullptr : shader_layer_2_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shader_layer_2.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shader_layer_2 in OverlayTheme struct");

    decltype(Traits::shader_layer_3(input)) in_shader_layer_3 = Traits::shader_layer_3(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shader_layer_3)::BaseType> shader_layer_3_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_shader_layer_3,
      shader_layer_3_fragment);

    fragment->shader_layer_3.Set(
        shader_layer_3_fragment.is_null() ? nullptr : shader_layer_3_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shader_layer_3.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shader_layer_3 in OverlayTheme struct");

    decltype(Traits::shader_layer_4(input)) in_shader_layer_4 = Traits::shader_layer_4(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shader_layer_4)::BaseType> shader_layer_4_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_shader_layer_4,
      shader_layer_4_fragment);

    fragment->shader_layer_4.Set(
        shader_layer_4_fragment.is_null() ? nullptr : shader_layer_4_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shader_layer_4.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shader_layer_4 in OverlayTheme struct");

    decltype(Traits::shader_layer_5(input)) in_shader_layer_5 = Traits::shader_layer_5(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shader_layer_5)::BaseType> shader_layer_5_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_shader_layer_5,
      shader_layer_5_fragment);

    fragment->shader_layer_5.Set(
        shader_layer_5_fragment.is_null() ? nullptr : shader_layer_5_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shader_layer_5.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shader_layer_5 in OverlayTheme struct");

    decltype(Traits::scrim(input)) in_scrim = Traits::scrim(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scrim)::BaseType> scrim_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_scrim,
      scrim_fragment);

    fragment->scrim.Set(
        scrim_fragment.is_null() ? nullptr : scrim_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scrim.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scrim in OverlayTheme struct");

    decltype(Traits::surface_container_highest_light(input)) in_surface_container_highest_light = Traits::surface_container_highest_light(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->surface_container_highest_light)::BaseType> surface_container_highest_light_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_surface_container_highest_light,
      surface_container_highest_light_fragment);

    fragment->surface_container_highest_light.Set(
        surface_container_highest_light_fragment.is_null() ? nullptr : surface_container_highest_light_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->surface_container_highest_light.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_container_highest_light in OverlayTheme struct");

    decltype(Traits::surface_container_highest_dark(input)) in_surface_container_highest_dark = Traits::surface_container_highest_dark(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->surface_container_highest_dark)::BaseType> surface_container_highest_dark_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_surface_container_highest_dark,
      surface_container_highest_dark_fragment);

    fragment->surface_container_highest_dark.Set(
        surface_container_highest_dark_fragment.is_null() ? nullptr : surface_container_highest_dark_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->surface_container_highest_dark.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_container_highest_dark in OverlayTheme struct");

    decltype(Traits::selection_element(input)) in_selection_element = Traits::selection_element(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selection_element)::BaseType> selection_element_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_selection_element,
      selection_element_fragment);

    fragment->selection_element.Set(
        selection_element_fragment.is_null() ? nullptr : selection_element_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selection_element.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selection_element in OverlayTheme struct");
  }

  static bool Deserialize(::lens::mojom::internal::OverlayTheme_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::OverlayThemeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace lens::mojom {

inline void OverlayThemeDataView::GetPrimaryDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->primary.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetShaderLayer1DataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->shader_layer_1.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetShaderLayer2DataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->shader_layer_2.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetShaderLayer3DataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->shader_layer_3.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetShaderLayer4DataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->shader_layer_4.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetShaderLayer5DataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->shader_layer_5.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetScrimDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->scrim.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetSurfaceContainerHighestLightDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->surface_container_highest_light.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetSurfaceContainerHighestDarkDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->surface_container_highest_dark.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void OverlayThemeDataView::GetSelectionElementDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->selection_element.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}



}  // lens::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::UserAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::UserAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::SemanticEvent> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::SemanticEvent value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_SHARED_H_