// chrome/browser/lens/core/mojom/lens.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/lens/core/mojom/lens.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/lens.mojom-params-data.h"
namespace lens {
namespace mojom {

NOINLINE static const char* UserActionToStringHelper(UserAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserAction::kRegionSelection:
      return "kRegionSelection";
    case UserAction::kRegionSelectionChange:
      return "kRegionSelectionChange";
    case UserAction::kTextSelection:
      return "kTextSelection";
    case UserAction::kObjectClick:
      return "kObjectClick";
    case UserAction::kTranslateText:
      return "kTranslateText";
    case UserAction::kCopyText:
      return "kCopyText";
    case UserAction::kMyActivity:
      return "kMyActivity";
    case UserAction::kLearnMore:
      return "kLearnMore";
    case UserAction::kSendFeedback:
      return "kSendFeedback";
    case UserAction::kTapRegionSelection:
      return "kTapRegionSelection";
    case UserAction::kTranslateButtonEnableAction:
      return "kTranslateButtonEnableAction";
    case UserAction::kTranslateButtonDisableAction:
      return "kTranslateButtonDisableAction";
    case UserAction::kTranslateSourceLanguageChanged:
      return "kTranslateSourceLanguageChanged";
    case UserAction::kTranslateTargetLanguageChanged:
      return "kTranslateTargetLanguageChanged";
    case UserAction::kTranslateTextSelection:
      return "kTranslateTextSelection";
    case UserAction::kCopyAsImage:
      return "kCopyAsImage";
    case UserAction::kSaveAsImage:
      return "kSaveAsImage";
    case UserAction::kMathSelection:
      return "kMathSelection";
    case UserAction::kFullScreenshotRegionSelection:
      return "kFullScreenshotRegionSelection";
    default:
      return nullptr;
  }
}

std::string UserActionToString(UserAction value) {
  const char *str = UserActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserAction value) {
  return os << UserActionToString(value);
}

NOINLINE static const char* SemanticEventToStringHelper(SemanticEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SemanticEvent::kTextGleamsViewStart:
      return "kTextGleamsViewStart";
    case SemanticEvent::kTextGleamsViewEnd:
      return "kTextGleamsViewEnd";
    default:
      return nullptr;
  }
}

std::string SemanticEventToString(SemanticEvent value) {
  const char *str = SemanticEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SemanticEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SemanticEvent value) {
  return os << SemanticEventToString(value);
}

namespace internal {


// static
bool OverlayTheme_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OverlayTheme_Data* object =
      static_cast<const OverlayTheme_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->primary, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shader_layer_1, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shader_layer_1, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shader_layer_2, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shader_layer_2, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shader_layer_3, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shader_layer_3, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shader_layer_4, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shader_layer_4, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shader_layer_5, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shader_layer_5, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scrim, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scrim, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_container_highest_light, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_container_highest_light, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_container_highest_dark, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_container_highest_dark, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection_element, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection_element, validation_context))
    return false;

  return true;
}

OverlayTheme_Data::OverlayTheme_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const LensPageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

LensPageHandlerFactory_CreatePageHandler_Params_Data::LensPageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_ActivityRequestedByOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_ActivityRequestedByOverlay_Params_Data* object =
      static_cast<const LensPageHandler_ActivityRequestedByOverlay_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_modifiers, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_modifiers, validation_context))
    return false;

  return true;
}

LensPageHandler_ActivityRequestedByOverlay_Params_Data::LensPageHandler_ActivityRequestedByOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data* object =
      static_cast<const LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data*>(data);

  return true;
}

LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data::LensPageHandler_CloseRequestedByOverlayCloseButton_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data* object =
      static_cast<const LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data*>(data);

  return true;
}

LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data::LensPageHandler_CloseRequestedByOverlayBackgroundClick_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_NotifyOverlayInitialized_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_NotifyOverlayInitialized_Params_Data* object =
      static_cast<const LensPageHandler_NotifyOverlayInitialized_Params_Data*>(data);

  return true;
}

LensPageHandler_NotifyOverlayInitialized_Params_Data::LensPageHandler_NotifyOverlayInitialized_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_AddBackgroundBlur_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_AddBackgroundBlur_Params_Data* object =
      static_cast<const LensPageHandler_AddBackgroundBlur_Params_Data*>(data);

  return true;
}

LensPageHandler_AddBackgroundBlur_Params_Data::LensPageHandler_AddBackgroundBlur_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_SetLiveBlur_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_SetLiveBlur_Params_Data* object =
      static_cast<const LensPageHandler_SetLiveBlur_Params_Data*>(data);

  return true;
}

LensPageHandler_SetLiveBlur_Params_Data::LensPageHandler_SetLiveBlur_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_FeedbackRequestedByOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_FeedbackRequestedByOverlay_Params_Data* object =
      static_cast<const LensPageHandler_FeedbackRequestedByOverlay_Params_Data*>(data);

  return true;
}

LensPageHandler_FeedbackRequestedByOverlay_Params_Data::LensPageHandler_FeedbackRequestedByOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_GetOverlayInvocationSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_GetOverlayInvocationSource_Params_Data* object =
      static_cast<const LensPageHandler_GetOverlayInvocationSource_Params_Data*>(data);

  return true;
}

LensPageHandler_GetOverlayInvocationSource_Params_Data::LensPageHandler_GetOverlayInvocationSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data* object =
      static_cast<const LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->invocation_source, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& invocation_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->invocation_source, validation_context,
                                         &invocation_source_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data::LensPageHandler_GetOverlayInvocationSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_InfoRequestedByOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_InfoRequestedByOverlay_Params_Data* object =
      static_cast<const LensPageHandler_InfoRequestedByOverlay_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_modifiers, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_modifiers, validation_context))
    return false;

  return true;
}

LensPageHandler_InfoRequestedByOverlay_Params_Data::LensPageHandler_InfoRequestedByOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueLensRegionRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueLensRegionRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueLensRegionRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  return true;
}

LensPageHandler_IssueLensRegionRequest_Params_Data::LensPageHandler_IssueLensRegionRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueLensObjectRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueLensObjectRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueLensObjectRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  return true;
}

LensPageHandler_IssueLensObjectRequest_Params_Data::LensPageHandler_IssueLensObjectRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueTextSelectionRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueTextSelectionRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueTextSelectionRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_IssueTextSelectionRequest_Params_Data::LensPageHandler_IssueTextSelectionRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueTranslateSelectionRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueTranslateSelectionRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueTranslateSelectionRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_language, validation_context,
                                         &content_language_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_IssueTranslateSelectionRequest_Params_Data::LensPageHandler_IssueTranslateSelectionRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueMathSelectionRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueMathSelectionRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueMathSelectionRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->formula, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& formula_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->formula, validation_context,
                                         &formula_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_IssueMathSelectionRequest_Params_Data::LensPageHandler_IssueMathSelectionRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueTranslateFullPageRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueTranslateFullPageRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueTranslateFullPageRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_language, validation_context,
                                         &source_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_language, validation_context,
                                         &target_language_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_IssueTranslateFullPageRequest_Params_Data::LensPageHandler_IssueTranslateFullPageRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_IssueEndTranslateModeRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_IssueEndTranslateModeRequest_Params_Data* object =
      static_cast<const LensPageHandler_IssueEndTranslateModeRequest_Params_Data*>(data);

  return true;
}

LensPageHandler_IssueEndTranslateModeRequest_Params_Data::LensPageHandler_IssueEndTranslateModeRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_CopyText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_CopyText_Params_Data* object =
      static_cast<const LensPageHandler_CopyText_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_CopyText_Params_Data::LensPageHandler_CopyText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_CopyImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_CopyImage_Params_Data* object =
      static_cast<const LensPageHandler_CopyImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  return true;
}

LensPageHandler_CopyImage_Params_Data::LensPageHandler_CopyImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_SaveAsImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_SaveAsImage_Params_Data* object =
      static_cast<const LensPageHandler_SaveAsImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  return true;
}

LensPageHandler_SaveAsImage_Params_Data::LensPageHandler_SaveAsImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_ClosePreselectionBubble_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_ClosePreselectionBubble_Params_Data* object =
      static_cast<const LensPageHandler_ClosePreselectionBubble_Params_Data*>(data);

  return true;
}

LensPageHandler_ClosePreselectionBubble_Params_Data::LensPageHandler_ClosePreselectionBubble_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data* object =
      static_cast<const LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data*>(data);


  if (!::lens::mojom::internal::UserAction_Data
        ::Validate(object->user_action, validation_context))
    return false;

  return true;
}

LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data::LensPageHandler_RecordUkmAndTaskCompletionForLensOverlayInteraction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data* object =
      static_cast<const LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data*>(data);


  if (!::lens::mojom::internal::SemanticEvent_Data
        ::Validate(object->event, validation_context))
    return false;

  return true;
}

LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data::LensPageHandler_RecordLensOverlaySemanticEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data* object =
      static_cast<const LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data*>(data);

  return true;
}

LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data::LensPageHandler_MaybeShowTranslateFeaturePromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data* object =
      static_cast<const LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data*>(data);

  return true;
}

LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data::LensPageHandler_MaybeCloseTranslateFeaturePromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_FetchSupportedLanguages_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_FetchSupportedLanguages_Params_Data* object =
      static_cast<const LensPageHandler_FetchSupportedLanguages_Params_Data*>(data);

  return true;
}

LensPageHandler_FetchSupportedLanguages_Params_Data::LensPageHandler_FetchSupportedLanguages_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_FetchSupportedLanguages_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_FetchSupportedLanguages_ResponseParams_Data* object =
      static_cast<const LensPageHandler_FetchSupportedLanguages_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_locale, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& browser_locale_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->browser_locale, validation_context,
                                         &browser_locale_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_languages, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_languages, validation_context,
                                         &source_languages_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_languages, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_languages, validation_context,
                                         &target_languages_validate_params)) {
    return false;
  }

  return true;
}

LensPageHandler_FetchSupportedLanguages_ResponseParams_Data::LensPageHandler_FetchSupportedLanguages_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_FinishReshowOverlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_FinishReshowOverlay_Params_Data* object =
      static_cast<const LensPageHandler_FinishReshowOverlay_Params_Data*>(data);

  return true;
}

LensPageHandler_FinishReshowOverlay_Params_Data::LensPageHandler_FinishReshowOverlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_AcceptPrivacyNotice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_AcceptPrivacyNotice_Params_Data* object =
      static_cast<const LensPageHandler_AcceptPrivacyNotice_Params_Data*>(data);

  return true;
}

LensPageHandler_AcceptPrivacyNotice_Params_Data::LensPageHandler_AcceptPrivacyNotice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPageHandler_DismissPrivacyNotice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPageHandler_DismissPrivacyNotice_Params_Data* object =
      static_cast<const LensPageHandler_DismissPrivacyNotice_Params_Data*>(data);

  return true;
}

LensPageHandler_DismissPrivacyNotice_Params_Data::LensPageHandler_DismissPrivacyNotice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ScreenshotDataReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ScreenshotDataReceived_Params_Data* object =
      static_cast<const LensPage_ScreenshotDataReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screenshot_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screenshot_data, validation_context))
    return false;

  return true;
}

LensPage_ScreenshotDataReceived_Params_Data::LensPage_ScreenshotDataReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_NotifyHandshakeComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_NotifyHandshakeComplete_Params_Data* object =
      static_cast<const LensPage_NotifyHandshakeComplete_Params_Data*>(data);

  return true;
}

LensPage_NotifyHandshakeComplete_Params_Data::LensPage_NotifyHandshakeComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_NotifyResultsPanelOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_NotifyResultsPanelOpened_Params_Data* object =
      static_cast<const LensPage_NotifyResultsPanelOpened_Params_Data*>(data);

  return true;
}

LensPage_NotifyResultsPanelOpened_Params_Data::LensPage_NotifyResultsPanelOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_NotifyOverlayClosing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_NotifyOverlayClosing_Params_Data* object =
      static_cast<const LensPage_NotifyOverlayClosing_Params_Data*>(data);

  return true;
}

LensPage_NotifyOverlayClosing_Params_Data::LensPage_NotifyOverlayClosing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ObjectsReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ObjectsReceived_Params_Data* object =
      static_cast<const LensPage_ObjectsReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->objects, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& objects_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->objects, validation_context,
                                         &objects_validate_params)) {
    return false;
  }

  return true;
}

LensPage_ObjectsReceived_Params_Data::LensPage_ObjectsReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_TextReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_TextReceived_Params_Data* object =
      static_cast<const LensPage_TextReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

LensPage_TextReceived_Params_Data::LensPage_TextReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_RegionTextReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_RegionTextReceived_Params_Data* object =
      static_cast<const LensPage_RegionTextReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

LensPage_RegionTextReceived_Params_Data::LensPage_RegionTextReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ThemeReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ThemeReceived_Params_Data* object =
      static_cast<const LensPage_ThemeReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->theme, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->theme, validation_context))
    return false;

  return true;
}

LensPage_ThemeReceived_Params_Data::LensPage_ThemeReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ShouldShowContextualSearchBox_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ShouldShowContextualSearchBox_Params_Data* object =
      static_cast<const LensPage_ShouldShowContextualSearchBox_Params_Data*>(data);

  return true;
}

LensPage_ShouldShowContextualSearchBox_Params_Data::LensPage_ShouldShowContextualSearchBox_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_PageContentTypeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_PageContentTypeChanged_Params_Data* object =
      static_cast<const LensPage_PageContentTypeChanged_Params_Data*>(data);


  if (!::lens::mojom::internal::PageContentType_Data
        ::Validate(object->new_page_content_type, validation_context))
    return false;

  return true;
}

LensPage_PageContentTypeChanged_Params_Data::LensPage_PageContentTypeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_SetPostRegionSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_SetPostRegionSelection_Params_Data* object =
      static_cast<const LensPage_SetPostRegionSelection_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->region, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->region, validation_context))
    return false;

  return true;
}

LensPage_SetPostRegionSelection_Params_Data::LensPage_SetPostRegionSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_SetTextSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_SetTextSelection_Params_Data* object =
      static_cast<const LensPage_SetTextSelection_Params_Data*>(data);

  return true;
}

LensPage_SetTextSelection_Params_Data::LensPage_SetTextSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_SetTranslateMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_SetTranslateMode_Params_Data* object =
      static_cast<const LensPage_SetTranslateMode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_language, validation_context,
                                         &source_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_language, validation_context,
                                         &target_language_validate_params)) {
    return false;
  }

  return true;
}

LensPage_SetTranslateMode_Params_Data::LensPage_SetTranslateMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ClearRegionSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ClearRegionSelection_Params_Data* object =
      static_cast<const LensPage_ClearRegionSelection_Params_Data*>(data);

  return true;
}

LensPage_ClearRegionSelection_Params_Data::LensPage_ClearRegionSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ClearTextSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ClearTextSelection_Params_Data* object =
      static_cast<const LensPage_ClearTextSelection_Params_Data*>(data);

  return true;
}

LensPage_ClearTextSelection_Params_Data::LensPage_ClearTextSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_ClearAllSelections_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_ClearAllSelections_Params_Data* object =
      static_cast<const LensPage_ClearAllSelections_Params_Data*>(data);

  return true;
}

LensPage_ClearAllSelections_Params_Data::LensPage_ClearAllSelections_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_OnCopyCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_OnCopyCommand_Params_Data* object =
      static_cast<const LensPage_OnCopyCommand_Params_Data*>(data);

  return true;
}

LensPage_OnCopyCommand_Params_Data::LensPage_OnCopyCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_SuppressGhostLoader_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_SuppressGhostLoader_Params_Data* object =
      static_cast<const LensPage_SuppressGhostLoader_Params_Data*>(data);

  return true;
}

LensPage_SuppressGhostLoader_Params_Data::LensPage_SuppressGhostLoader_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LensPage_OnOverlayReshown_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LensPage_OnOverlayReshown_Params_Data* object =
      static_cast<const LensPage_OnOverlayReshown_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screenshot_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screenshot_data, validation_context))
    return false;

  return true;
}

LensPage_OnOverlayReshown_Params_Data::LensPage_OnOverlayReshown_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace lens

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::UserAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::UserAction value) {
  return std::move(context).WriteString(::lens::mojom::UserActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::SemanticEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::SemanticEvent value) {
  return std::move(context).WriteString(::lens::mojom::SemanticEventToString(value));
}

} // namespace perfetto