// chrome/browser/lens/core/mojom/lens.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/lens/core/mojom/lens.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/overlay_object.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/page_content_type.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/text.mojom-shared.h"
#include "chrome/browser/lens/core/mojom/translate.mojom-shared.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace lens::mojom {
class OverlayThemeDataView;



}  // lens::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::lens::mojom::OverlayThemeDataView> {
  using Data = ::lens::mojom::internal::OverlayTheme_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace lens::mojom {


enum class UserAction : int32_t {
  
  kRegionSelection = 0,
  
  kRegionSelectionChange = 1,
  
  kTextSelection = 2,
  
  kObjectClick = 3,
  
  kTranslateText = 4,
  
  kCopyText = 5,
  
  kMyActivity = 6,
  
  kLearnMore = 7,
  
  kSendFeedback = 8,
  
  kTapRegionSelection = 9,
  
  kTranslateButtonEnableAction = 10,
  
  kTranslateButtonDisableAction = 11,
  
  kTranslateSourceLanguageChanged = 12,
  
  kTranslateTargetLanguageChanged = 13,
  
  kTranslateTextSelection = 14,
  
  kCopyAsImage = 15,
  
  kSaveAsImage = 16,
  
  kMathSelection = 17,
  
  kFullScreenshotRegionSelection = 18,
  kMinValue = 0,
  kMaxValue = 18,
};

 std::ostream& operator<<(std::ostream& os, UserAction value);
inline bool IsKnownEnumValue(UserAction value) {
  return internal::UserAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SemanticEvent : int32_t {
  
  kTextGleamsViewStart = 0,
  
  kTextGleamsViewEnd = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SemanticEvent value);
inline bool IsKnownEnumValue(SemanticEvent value) {
  return internal::SemanticEvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class LensPageHandlerFactoryInterfaceBase {};

using LensPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<LensPageHandlerFactoryInterfaceBase>;
using LensPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<LensPageHandlerFactoryInterfaceBase>;
using LensPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LensPageHandlerFactoryInterfaceBase>;
using LensPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LensPageHandlerFactoryInterfaceBase>;
class LensPageHandlerInterfaceBase {};

using LensPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<LensPageHandlerInterfaceBase>;
using LensPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<LensPageHandlerInterfaceBase>;
using LensPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LensPageHandlerInterfaceBase>;
using LensPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LensPageHandlerInterfaceBase>;
class LensPageInterfaceBase {};

using LensPagePtrDataView =
    mojo::InterfacePtrDataView<LensPageInterfaceBase>;
using LensPageRequestDataView =
    mojo::InterfaceRequestDataView<LensPageInterfaceBase>;
using LensPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LensPageInterfaceBase>;
using LensPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LensPageInterfaceBase>;


class OverlayThemeDataView {
 public:
  OverlayThemeDataView() = default;

  OverlayThemeDataView(
      internal::OverlayTheme_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrimaryDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrimary(UserType* output) {
    
    auto* pointer = data_->primary.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetShaderLayer1DataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShaderLayer1(UserType* output) {
    
    auto* pointer = data_->shader_layer_1.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetShaderLayer2DataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShaderLayer2(UserType* output) {
    
    auto* pointer = data_->shader_layer_2.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetShaderLayer3DataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShaderLayer3(UserType* output) {
    
    auto* pointer = data_->shader_layer_3.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetShaderLayer4DataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShaderLayer4(UserType* output) {
    
    auto* pointer = data_->shader_layer_4.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetShaderLayer5DataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShaderLayer5(UserType* output) {
    
    auto* pointer = data_->shader_layer_5.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetScrimDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrim(UserType* output) {
    
    auto* pointer = data_->scrim.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetSurfaceContainerHighestLightDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceContainerHighestLight(UserType* output) {
    
    auto* pointer = data_->surface_container_highest_light.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetSurfaceContainerHighestDarkDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceContainerHighestDark(UserType* output) {
    
    auto* pointer = data_->surface_container_highest_dark.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetSelectionElementDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectionElement(UserType* output) {
    
    auto* pointer = data_->selection_element.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
 private:
  internal::OverlayTheme_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // lens::mojom

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_LENS_MOJOM_DATA_VIEW_H_