// chrome/browser/lens/core/mojom/geometry.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_SHARED_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/geometry.mojom-shared-internal.h"
#include "chrome/browser/lens/core/mojom/polygon.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "chrome/browser/lens/core/mojom/geometry.mojom-data-view.h"




namespace std {

template <>
struct hash<::lens::mojom::CenterRotatedBox_CoordinateType>
    : public mojo::internal::EnumHashImpl<::lens::mojom::CenterRotatedBox_CoordinateType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::CenterRotatedBox_CoordinateType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::lens::mojom::CenterRotatedBox_CoordinateType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::lens::mojom::CenterRotatedBox_CoordinateType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::CenterRotatedBoxDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::CenterRotatedBoxDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::CenterRotatedBox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::box(input)) in_box = Traits::box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->box)::BaseType> box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_box,
      box_fragment);

    fragment->box.Set(
        box_fragment.is_null() ? nullptr : box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null box in CenterRotatedBox struct");

    fragment->rotation = Traits::rotation(input);

    
    mojo::internal::Serialize<::lens::mojom::CenterRotatedBox_CoordinateType>(
      Traits::coordinate_type(input),
      &fragment->coordinate_type);
  }

  static bool Deserialize(::lens::mojom::internal::CenterRotatedBox_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::CenterRotatedBoxDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::lens::mojom::GeometryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::lens::mojom::GeometryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::lens::mojom::internal::Geometry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::lens::mojom::CenterRotatedBoxDataView>(
      in_bounding_box,
      bounding_box_fragment);

    fragment->bounding_box.Set(
        bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounding_box.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounding_box in Geometry struct");

    decltype(Traits::segmentation_polygon(input)) in_segmentation_polygon = Traits::segmentation_polygon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segmentation_polygon)::BaseType>
        segmentation_polygon_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& segmentation_polygon_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::lens::mojom::PolygonDataView>>(
      in_segmentation_polygon,
      segmentation_polygon_fragment,
      &segmentation_polygon_validate_params);

    fragment->segmentation_polygon.Set(
        segmentation_polygon_fragment.is_null() ? nullptr : segmentation_polygon_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segmentation_polygon.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segmentation_polygon in Geometry struct");
  }

  static bool Deserialize(::lens::mojom::internal::Geometry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::lens::mojom::GeometryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace lens::mojom {

inline void CenterRotatedBoxDataView::GetBoxDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->box.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}


inline void GeometryDataView::GetBoundingBoxDataView(
    CenterRotatedBoxDataView* output) {
  auto pointer = data_->bounding_box.Get();
  *output = CenterRotatedBoxDataView(pointer, message_);
}
inline void GeometryDataView::GetSegmentationPolygonDataView(
    mojo::ArrayDataView<::lens::mojom::PolygonDataView>* output) {
  auto pointer = data_->segmentation_polygon.Get();
  *output = mojo::ArrayDataView<::lens::mojom::PolygonDataView>(pointer, message_);
}



}  // lens::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::lens::mojom::CenterRotatedBox_CoordinateType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::lens::mojom::CenterRotatedBox_CoordinateType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_SHARED_H_