// chrome/browser/glic/host/glic.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_H_
#define CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/glic/host/glic.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/glic/host/glic.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/glic/host/glic.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/glic/host/glic_features.mojom-forward.h"
#include "chrome/common/actor_webui.mojom-forward.h"
#include "components/content_settings/core/common/content_settings_types.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom.h"
#include "mojo/public/mojom/base/string16.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/version.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"




namespace glic::mojom {

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kIntentToShowMinVersion = 0,
    kSetProfileReadyStateMinVersion = 0,
    kUpdatePageStateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct IntentToShow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetProfileReadyState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePageState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void IntentToShow() = 0;

  virtual void SetProfileReadyState(ProfileReadyState ready_state) = 0;

  virtual void UpdatePageState(PanelStateKind panelStateKind) = 0;
};

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingReceiver<PageHandler> receiver, ::mojo::PendingRemote<Page> page) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWebClientMinVersion = 0,
    kPrepareForClientMinVersion = 0,
    kWebviewCommittedMinVersion = 0,
    kClosePanelMinVersion = 0,
    kOpenProfilePickerAndClosePanelMinVersion = 0,
    kOpenDisabledByAdminLinkAndClosePanelMinVersion = 0,
    kSignInAndClosePanelMinVersion = 0,
    kResizeWidgetMinVersion = 0,
    kEnableDragResizeMinVersion = 0,
    kWebUiStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWebClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrepareForClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WebviewCommitted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClosePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenProfilePickerAndClosePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDisabledByAdminLinkAndClosePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SignInAndClosePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResizeWidget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableDragResize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WebUiStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void CreateWebClient(::mojo::PendingReceiver<WebClientHandler> web_client_receiver) = 0;

  using PrepareForClientCallback = base::OnceCallback<void(PrepareForClientResult)>;
  using PrepareForClientMojoCallback = base::OnceCallback<void(PrepareForClientResult)>;

  virtual void PrepareForClient(PrepareForClientCallback callback) = 0;

  virtual void WebviewCommitted(const ::GURL& url) = 0;

  using ClosePanelCallback = base::OnceCallback<void()>;
  using ClosePanelMojoCallback = base::OnceCallback<void()>;

  virtual void ClosePanel(ClosePanelCallback callback) = 0;

  virtual void OpenProfilePickerAndClosePanel() = 0;

  virtual void OpenDisabledByAdminLinkAndClosePanel() = 0;

  virtual void SignInAndClosePanel() = 0;

  using ResizeWidgetCallback = base::OnceCallback<void()>;
  using ResizeWidgetMojoCallback = base::OnceCallback<void()>;

  virtual void ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) = 0;

  virtual void EnableDragResize(bool enabled) = 0;

  virtual void WebUiStateChanged(WebUiState new_state) = 0;
};

class PinCandidatesObserverProxy;

template <typename ImplRefTraits>
class PinCandidatesObserverStub;

class PinCandidatesObserverRequestValidator;


class PinCandidatesObserver
    : public PinCandidatesObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.PinCandidatesObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PinCandidatesObserverInterfaceBase;
  using Proxy_ = PinCandidatesObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PinCandidatesObserverStub<ImplRefTraits>;

  using RequestValidator_ = PinCandidatesObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPinCandidatesChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPinCandidatesChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PinCandidatesObserver() = default;

  virtual void OnPinCandidatesChanged(std::vector<PinCandidatePtr> candidates) = 0;
};

class WebClientHandlerProxy;

template <typename ImplRefTraits>
class WebClientHandlerStub;

class WebClientHandlerRequestValidator;
class WebClientHandlerResponseValidator;


class WebClientHandler
    : public WebClientHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.WebClientHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebClientHandlerInterfaceBase;
  using Proxy_ = WebClientHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebClientHandlerStub<ImplRefTraits>;

  using RequestValidator_ = WebClientHandlerRequestValidator;
  using ResponseValidator_ = WebClientHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWebClientCreatedMinVersion = 0,
    kWebClientInitializedMinVersion = 0,
    kWebClientInitializeFailedMinVersion = 0,
    kCreateTabMinVersion = 0,
    kOpenLinkInPopupMinVersion = 0,
    kOpenGlicSettingsPageMinVersion = 0,
    kOpenPasswordManagerSettingsPageMinVersion = 0,
    kClosePanelMinVersion = 0,
    kClosePanelAndShutdownMinVersion = 0,
    kAttachPanelMinVersion = 0,
    kDetachPanelMinVersion = 0,
    kOnModeChangeMinVersion = 0,
    kShowProfilePickerMinVersion = 0,
    kGetModelQualityClientIdMinVersion = 0,
    kGetContextFromFocusedTabMinVersion = 0,
    kGetContextFromTabMinVersion = 0,
    kGetContextForActorFromTabMinVersion = 0,
    kSetMaximumNumberOfPinnedTabsMinVersion = 0,
    kPinTabsMinVersion = 0,
    kUnpinTabsMinVersion = 0,
    kUnpinAllTabsMinVersion = 0,
    kSubscribeToPinCandidatesMinVersion = 0,
    kCreateTaskMinVersion = 0,
    kPerformActionsMinVersion = 0,
    kStopActorTaskMinVersion = 0,
    kPauseActorTaskMinVersion = 0,
    kResumeActorTaskMinVersion = 0,
    kInterruptActorTaskMinVersion = 0,
    kUninterruptActorTaskMinVersion = 0,
    kCreateActorTabMinVersion = 0,
    kActivateTabMinVersion = 0,
    kResizeWidgetMinVersion = 0,
    kCaptureScreenshotMinVersion = 0,
    kCaptureRegionMinVersion = 0,
    kSetAudioDuckingMinVersion = 0,
    kSetPanelDraggableAreasMinVersion = 0,
    kSetMinimumPanelSizeMinVersion = 0,
    kSetMicrophonePermissionStateMinVersion = 0,
    kSetLocationPermissionStateMinVersion = 0,
    kSetTabContextPermissionStateMinVersion = 0,
    kSetClosedCaptioningSettingMinVersion = 0,
    kSetActuationOnWebSettingMinVersion = 0,
    kShouldAllowMediaPermissionRequestMinVersion = 0,
    kShouldAllowGeolocationPermissionRequestMinVersion = 0,
    kSetContextAccessIndicatorMinVersion = 0,
    kGetUserProfileInfoMinVersion = 0,
    kSyncCookiesMinVersion = 0,
    kLogBeginAsyncEventMinVersion = 0,
    kLogEndAsyncEventMinVersion = 0,
    kLogInstantEventMinVersion = 0,
    kJournalClearMinVersion = 0,
    kJournalSnapshotMinVersion = 0,
    kJournalStartMinVersion = 0,
    kJournalStopMinVersion = 0,
    kJournalRecordFeedbackMinVersion = 0,
    kOnUserInputSubmittedMinVersion = 0,
    kOnContextUploadStartedMinVersion = 0,
    kOnContextUploadCompletedMinVersion = 0,
    kOnReactionMinVersion = 0,
    kOnResponseStartedMinVersion = 0,
    kOnResponseStoppedMinVersion = 0,
    kOnSessionTerminatedMinVersion = 0,
    kOnTurnCompletedMinVersion = 0,
    kOnModelChangedMinVersion = 0,
    kOnRecordUseCounterMinVersion = 0,
    kOnResponseRatedMinVersion = 0,
    kOnClosedCaptionsShownMinVersion = 0,
    kScrollToMinVersion = 0,
    kDropScrollToHighlightMinVersion = 0,
    kSetSyntheticExperimentStateMinVersion = 0,
    kOpenOsPermissionSettingsMenuMinVersion = 0,
    kGetOsMicrophonePermissionStatusMinVersion = 0,
    kGetZeroStateSuggestionsAndSubscribeMinVersion = 0,
    kGetZeroStateSuggestionsForFocusedTabMinVersion = 0,
    kMaybeRefreshUserStatusMinVersion = 0,
    kIsDebuggerAttachedMinVersion = 0,
    kOnViewChangedMinVersion = 0,
    kSubscribeToPageMetadataMinVersion = 0,
    kSwitchConversationMinVersion = 0,
    kRegisterConversationMinVersion = 0,
    kSetOnboardingCompletedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct WebClientCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WebClientInitialized_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WebClientInitializeFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenLinkInPopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenGlicSettingsPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenPasswordManagerSettingsPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClosePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClosePanelAndShutdown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AttachPanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetachPanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnModeChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowProfilePicker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetModelQualityClientId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetContextFromFocusedTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetContextFromTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetContextForActorFromTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMaximumNumberOfPinnedTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PinTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnpinTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnpinAllTabs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubscribeToPinCandidates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformActions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopActorTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PauseActorTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResumeActorTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InterruptActorTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UninterruptActorTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateActorTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivateTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResizeWidget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CaptureScreenshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CaptureRegion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAudioDucking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPanelDraggableAreas_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMinimumPanelSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMicrophonePermissionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLocationPermissionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTabContextPermissionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetClosedCaptioningSetting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetActuationOnWebSetting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldAllowMediaPermissionRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldAllowGeolocationPermissionRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetContextAccessIndicator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserProfileInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SyncCookies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogBeginAsyncEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogEndAsyncEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogInstantEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JournalClear_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JournalSnapshot_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JournalStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JournalStop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JournalRecordFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUserInputSubmitted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnContextUploadStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnContextUploadCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReaction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResponseStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResponseStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSessionTerminated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTurnCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnModelChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRecordUseCounter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnResponseRated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClosedCaptionsShown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrollTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DropScrollToHighlight_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSyntheticExperimentState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenOsPermissionSettingsMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOsMicrophonePermissionStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetZeroStateSuggestionsAndSubscribe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetZeroStateSuggestionsForFocusedTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeRefreshUserStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsDebuggerAttached_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnViewChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubscribeToPageMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwitchConversation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterConversation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOnboardingCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebClientHandler() = default;

  using WebClientCreatedCallback = base::OnceCallback<void(WebClientInitialStatePtr)>;
  using WebClientCreatedMojoCallback = base::OnceCallback<void(WebClientInitialStatePtr)>;

  virtual void WebClientCreated(::mojo::PendingRemote<WebClient> web_client, WebClientCreatedCallback callback) = 0;

  virtual void WebClientInitialized() = 0;

  virtual void WebClientInitializeFailed() = 0;

  using CreateTabCallback = base::OnceCallback<void(TabDataPtr)>;
  using CreateTabMojoCallback = base::OnceCallback<void(TabDataPtr)>;

  virtual void CreateTab(const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id, CreateTabCallback callback) = 0;

  virtual void OpenLinkInPopup(const ::GURL& url, int32_t popup_width, int32_t popup_height) = 0;

  virtual void OpenGlicSettingsPage(OpenSettingsOptionsPtr options) = 0;

  virtual void OpenPasswordManagerSettingsPage() = 0;

  virtual void ClosePanel() = 0;

  virtual void ClosePanelAndShutdown() = 0;

  virtual void AttachPanel() = 0;

  virtual void DetachPanel() = 0;

  virtual void OnModeChange(WebClientMode new_mode) = 0;

  virtual void ShowProfilePicker() = 0;

  using GetModelQualityClientIdCallback = base::OnceCallback<void(const std::string&)>;
  using GetModelQualityClientIdMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetModelQualityClientId(GetModelQualityClientIdCallback callback) = 0;

  using GetContextFromFocusedTabCallback = base::OnceCallback<void(GetContextResultPtr)>;
  using GetContextFromFocusedTabMojoCallback = base::OnceCallback<void(GetContextResultPtr)>;

  virtual void GetContextFromFocusedTab(GetTabContextOptionsPtr options, GetContextFromFocusedTabCallback callback) = 0;

  using GetContextFromTabCallback = base::OnceCallback<void(GetContextResultPtr)>;
  using GetContextFromTabMojoCallback = base::OnceCallback<void(GetContextResultPtr)>;

  virtual void GetContextFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextFromTabCallback callback) = 0;

  using GetContextForActorFromTabCallback = base::OnceCallback<void(GetContextResultPtr)>;
  using GetContextForActorFromTabMojoCallback = base::OnceCallback<void(GetContextResultPtr)>;

  virtual void GetContextForActorFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextForActorFromTabCallback callback) = 0;

  using SetMaximumNumberOfPinnedTabsCallback = base::OnceCallback<void(uint32_t)>;
  using SetMaximumNumberOfPinnedTabsMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void SetMaximumNumberOfPinnedTabs(uint32_t requested_max, SetMaximumNumberOfPinnedTabsCallback callback) = 0;

  using PinTabsCallback = base::OnceCallback<void(bool)>;
  using PinTabsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void PinTabs(const std::vector<int32_t>& tab_ids, PinTabsCallback callback) = 0;

  using UnpinTabsCallback = base::OnceCallback<void(bool)>;
  using UnpinTabsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void UnpinTabs(const std::vector<int32_t>& tab_ids, UnpinTabsCallback callback) = 0;

  virtual void UnpinAllTabs() = 0;

  virtual void SubscribeToPinCandidates(GetPinCandidatesOptionsPtr options, ::mojo::PendingRemote<PinCandidatesObserver> observer) = 0;

  using CreateTaskCallback = base::OnceCallback<void(base::expected<
  int32_t,
  CreateTaskErrorReason>)>;
  using CreateTaskResult = base::expected<
  int32_t,
  CreateTaskErrorReason>;
  using CreateTaskMojoCallback = base::OnceCallback<void(WebClientHandler_CreateTask_ResponseParam_ResultPtr)>;

  virtual void CreateTask(::actor::webui::mojom::TaskOptionsPtr task_options, CreateTaskCallback callback) = 0;

  using PerformActionsCallback = base::OnceCallback<void(base::expected<
  ::mojo_base::ProtoWrapper,
  PerformActionsErrorReason>)>;
  using PerformActionsResult = base::expected<
  ::mojo_base::ProtoWrapper,
  PerformActionsErrorReason>;
  using PerformActionsMojoCallback = base::OnceCallback<void(WebClientHandler_PerformActions_ResponseParam_ResultPtr)>;

  virtual void PerformActions(const std::vector<uint8_t>& actions_proto, PerformActionsCallback callback) = 0;

  virtual void StopActorTask(int32_t task_id, ActorTaskStopReason stop_reason) = 0;

  virtual void PauseActorTask(int32_t task_id, ActorTaskPauseReason pause_reason, std::optional<int32_t> tab_id) = 0;

  using ResumeActorTaskCallback = base::OnceCallback<void(GetContextResultWithActionResultCodePtr)>;
  using ResumeActorTaskMojoCallback = base::OnceCallback<void(GetContextResultWithActionResultCodePtr)>;

  virtual void ResumeActorTask(int32_t task_id, GetTabContextOptionsPtr context_options, ResumeActorTaskCallback callback) = 0;

  virtual void InterruptActorTask(int32_t task_id) = 0;

  virtual void UninterruptActorTask(int32_t task_id) = 0;

  using CreateActorTabCallback = base::OnceCallback<void(TabDataPtr)>;
  using CreateActorTabMojoCallback = base::OnceCallback<void(TabDataPtr)>;

  virtual void CreateActorTab(int32_t task_id, bool open_in_background, std::optional<int32_t> initiator_tab_id, std::optional<int32_t> initiator_window_id, CreateActorTabCallback callback) = 0;

  virtual void ActivateTab(int32_t task_id) = 0;

  using ResizeWidgetCallback = base::OnceCallback<void()>;
  using ResizeWidgetMojoCallback = base::OnceCallback<void()>;

  virtual void ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) = 0;

  using CaptureScreenshotCallback = base::OnceCallback<void(CaptureScreenshotResultPtr)>;
  using CaptureScreenshotMojoCallback = base::OnceCallback<void(CaptureScreenshotResultPtr)>;

  virtual void CaptureScreenshot(CaptureScreenshotCallback callback) = 0;

  virtual void CaptureRegion(::mojo::PendingRemote<CaptureRegionObserver> observer) = 0;

  using SetAudioDuckingCallback = base::OnceCallback<void(bool)>;
  using SetAudioDuckingMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetAudioDucking(bool enable, SetAudioDuckingCallback callback) = 0;

  using SetPanelDraggableAreasCallback = base::OnceCallback<void()>;
  using SetPanelDraggableAreasMojoCallback = base::OnceCallback<void()>;

  virtual void SetPanelDraggableAreas(const std::vector<::gfx::Rect>& draggable_areas, SetPanelDraggableAreasCallback callback) = 0;

  virtual void SetMinimumPanelSize(const ::gfx::Size& size) = 0;

  using SetMicrophonePermissionStateCallback = base::OnceCallback<void()>;
  using SetMicrophonePermissionStateMojoCallback = base::OnceCallback<void()>;

  virtual void SetMicrophonePermissionState(bool enabled, SetMicrophonePermissionStateCallback callback) = 0;

  using SetLocationPermissionStateCallback = base::OnceCallback<void()>;
  using SetLocationPermissionStateMojoCallback = base::OnceCallback<void()>;

  virtual void SetLocationPermissionState(bool enabled, SetLocationPermissionStateCallback callback) = 0;

  using SetTabContextPermissionStateCallback = base::OnceCallback<void()>;
  using SetTabContextPermissionStateMojoCallback = base::OnceCallback<void()>;

  virtual void SetTabContextPermissionState(bool enabled, SetTabContextPermissionStateCallback callback) = 0;

  using SetClosedCaptioningSettingCallback = base::OnceCallback<void()>;
  using SetClosedCaptioningSettingMojoCallback = base::OnceCallback<void()>;

  virtual void SetClosedCaptioningSetting(bool enabled, SetClosedCaptioningSettingCallback callback) = 0;

  using SetActuationOnWebSettingCallback = base::OnceCallback<void()>;
  using SetActuationOnWebSettingMojoCallback = base::OnceCallback<void()>;

  virtual void SetActuationOnWebSetting(bool enabled, SetActuationOnWebSettingCallback callback) = 0;

  using ShouldAllowMediaPermissionRequestCallback = base::OnceCallback<void(bool)>;
  using ShouldAllowMediaPermissionRequestMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ShouldAllowMediaPermissionRequest(ShouldAllowMediaPermissionRequestCallback callback) = 0;

  using ShouldAllowGeolocationPermissionRequestCallback = base::OnceCallback<void(bool)>;
  using ShouldAllowGeolocationPermissionRequestMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ShouldAllowGeolocationPermissionRequest(ShouldAllowGeolocationPermissionRequestCallback callback) = 0;

  virtual void SetContextAccessIndicator(bool enabled) = 0;

  using GetUserProfileInfoCallback = base::OnceCallback<void(UserProfileInfoPtr)>;
  using GetUserProfileInfoMojoCallback = base::OnceCallback<void(UserProfileInfoPtr)>;

  virtual void GetUserProfileInfo(GetUserProfileInfoCallback callback) = 0;

  using SyncCookiesCallback = base::OnceCallback<void(bool)>;
  using SyncCookiesMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SyncCookies(SyncCookiesCallback callback) = 0;

  virtual void LogBeginAsyncEvent(uint64_t event_async_id, int32_t task_id, const std::string& event, const std::string& details) = 0;

  virtual void LogEndAsyncEvent(uint64_t event_async_id, const std::string& details) = 0;

  virtual void LogInstantEvent(int32_t task_id, const std::string& event, const std::string& details) = 0;

  virtual void JournalClear() = 0;

  using JournalSnapshotCallback = base::OnceCallback<void(JournalPtr)>;
  using JournalSnapshotMojoCallback = base::OnceCallback<void(JournalPtr)>;

  virtual void JournalSnapshot(bool clear_journal, JournalSnapshotCallback callback) = 0;

  virtual void JournalStart(uint64_t max_bytes, bool capture_screenshots) = 0;

  virtual void JournalStop() = 0;

  virtual void JournalRecordFeedback(bool positive, const std::string& reason) = 0;

  virtual void OnUserInputSubmitted(WebClientMode mode) = 0;

  virtual void OnContextUploadStarted() = 0;

  virtual void OnContextUploadCompleted() = 0;

  virtual void OnReaction(MetricUserInputReactionType reactionType) = 0;

  virtual void OnResponseStarted() = 0;

  virtual void OnResponseStopped(OnResponseStoppedDetailsPtr details) = 0;

  virtual void OnSessionTerminated() = 0;

  virtual void OnTurnCompleted(WebClientModel model, ::base::TimeDelta duration) = 0;

  virtual void OnModelChanged(WebClientModel model) = 0;

  virtual void OnRecordUseCounter(uint16_t counter) = 0;

  virtual void OnResponseRated(bool positive) = 0;

  virtual void OnClosedCaptionsShown() = 0;

  using ScrollToCallback = base::OnceCallback<void(std::optional<ScrollToErrorReason>)>;
  using ScrollToMojoCallback = base::OnceCallback<void(std::optional<ScrollToErrorReason>)>;

  virtual void ScrollTo(ScrollToParamsPtr params, ScrollToCallback callback) = 0;

  virtual void DropScrollToHighlight() = 0;

  virtual void SetSyntheticExperimentState(const std::string& trial_name, const std::string& group_name) = 0;

  virtual void OpenOsPermissionSettingsMenu(::content_settings::mojom::ContentSettingsType type) = 0;

  using GetOsMicrophonePermissionStatusCallback = base::OnceCallback<void(bool)>;
  using GetOsMicrophonePermissionStatusMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetOsMicrophonePermissionStatus(GetOsMicrophonePermissionStatusCallback callback) = 0;

  using GetZeroStateSuggestionsAndSubscribeCallback = base::OnceCallback<void(ZeroStateSuggestionsV2Ptr)>;
  using GetZeroStateSuggestionsAndSubscribeMojoCallback = base::OnceCallback<void(ZeroStateSuggestionsV2Ptr)>;

  virtual void GetZeroStateSuggestionsAndSubscribe(bool is_live, ZeroStateSuggestionsOptionsPtr options, GetZeroStateSuggestionsAndSubscribeCallback callback) = 0;

  using GetZeroStateSuggestionsForFocusedTabCallback = base::OnceCallback<void(ZeroStateSuggestionsPtr)>;
  using GetZeroStateSuggestionsForFocusedTabMojoCallback = base::OnceCallback<void(ZeroStateSuggestionsPtr)>;

  virtual void GetZeroStateSuggestionsForFocusedTab(std::optional<bool> is_first_run, GetZeroStateSuggestionsForFocusedTabCallback callback) = 0;

  virtual void MaybeRefreshUserStatus() = 0;

  using IsDebuggerAttachedCallback = base::OnceCallback<void(bool)>;
  using IsDebuggerAttachedMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsDebuggerAttached(IsDebuggerAttachedCallback callback) = 0;

  virtual void OnViewChanged(ViewChangedNotificationPtr notification) = 0;

  using SubscribeToPageMetadataCallback = base::OnceCallback<void(bool)>;
  using SubscribeToPageMetadataMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SubscribeToPageMetadata(int32_t tab_id, const std::vector<std::string>& names, SubscribeToPageMetadataCallback callback) = 0;

  using SwitchConversationCallback = base::OnceCallback<void(std::optional<SwitchConversationErrorReason>)>;
  using SwitchConversationMojoCallback = base::OnceCallback<void(std::optional<SwitchConversationErrorReason>)>;

  virtual void SwitchConversation(ConversationInfoPtr info, SwitchConversationCallback callback) = 0;

  using RegisterConversationCallback = base::OnceCallback<void(std::optional<RegisterConversationErrorReason>)>;
  using RegisterConversationMojoCallback = base::OnceCallback<void(std::optional<RegisterConversationErrorReason>)>;

  virtual void RegisterConversation(ConversationInfoPtr info, RegisterConversationCallback callback) = 0;

  virtual void SetOnboardingCompleted() = 0;
};

class WebClientProxy;

template <typename ImplRefTraits>
class WebClientStub;

class WebClientRequestValidator;
class WebClientResponseValidator;


class WebClient
    : public WebClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.WebClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebClientInterfaceBase;
  using Proxy_ = WebClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebClientStub<ImplRefTraits>;

  using RequestValidator_ = WebClientRequestValidator;
  using ResponseValidator_ = WebClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNotifyPanelWillOpenMinVersion = 0,
    kNotifyPanelWasClosedMinVersion = 0,
    kNotifyPanelStateChangeMinVersion = 0,
    kNotifyPanelActiveChangeMinVersion = 0,
    kNotifyPanelCanAttachChangeMinVersion = 0,
    kNotifyMicrophonePermissionStateChangedMinVersion = 0,
    kNotifyLocationPermissionStateChangedMinVersion = 0,
    kNotifyTabContextPermissionStateChangedMinVersion = 0,
    kNotifyOsLocationPermissionStateChangedMinVersion = 0,
    kNotifyFocusedTabChangedMinVersion = 0,
    kNotifyManualResizeChangedMinVersion = 0,
    kNotifyOsHotkeyStateChangedMinVersion = 0,
    kNotifyBrowserIsOpenChangedMinVersion = 0,
    kNotifyInstanceActivationChangedMinVersion = 0,
    kNotifyClosedCaptioningSettingChangedMinVersion = 0,
    kNotifyPinnedTabsChangedMinVersion = 0,
    kNotifyPinnedTabDataChangedMinVersion = 0,
    kNotifyZeroStateSuggestionsChangedMinVersion = 0,
    kNotifyActorTaskStateChangedMinVersion = 0,
    kNotifyTabDataChangedMinVersion = 0,
    kRequestViewChangeMinVersion = 0,
    kNotifyPageMetadataChangedMinVersion = 0,
    kNotifyDefaultTabContextPermissionStateChangedMinVersion = 0,
    kRequestToShowCredentialSelectionDialogMinVersion = 0,
    kRequestToShowAutofillSuggestionsDialogMinVersion = 0,
    kRequestToShowUserConfirmationDialogMinVersion = 0,
    kRequestToConfirmNavigationMinVersion = 0,
    kNotifyAdditionalContextMinVersion = 0,
    kNotifyActuationOnWebSettingChangedMinVersion = 0,
    kNotifyActOnWebCapabilityChangedMinVersion = 0,
    kNotifyOnboardingCompletedChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyPanelWillOpen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPanelWasClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPanelStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPanelActiveChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPanelCanAttachChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyMicrophonePermissionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyLocationPermissionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyTabContextPermissionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOsLocationPermissionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyFocusedTabChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyManualResizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOsHotkeyStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyBrowserIsOpenChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyInstanceActivationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyClosedCaptioningSettingChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPinnedTabsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPinnedTabDataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyZeroStateSuggestionsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyActorTaskStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyTabDataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestViewChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyPageMetadataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyDefaultTabContextPermissionStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestToShowCredentialSelectionDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestToShowAutofillSuggestionsDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestToShowUserConfirmationDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestToConfirmNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyAdditionalContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyActuationOnWebSettingChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyActOnWebCapabilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyOnboardingCompletedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebClient() = default;

  using NotifyPanelWillOpenCallback = base::OnceCallback<void(OpenPanelInfoPtr)>;
  using NotifyPanelWillOpenMojoCallback = base::OnceCallback<void(OpenPanelInfoPtr)>;

  virtual void NotifyPanelWillOpen(PanelOpeningDataPtr panel_opening_data, NotifyPanelWillOpenCallback callback) = 0;

  using NotifyPanelWasClosedCallback = base::OnceCallback<void()>;
  using NotifyPanelWasClosedMojoCallback = base::OnceCallback<void()>;

  virtual void NotifyPanelWasClosed(NotifyPanelWasClosedCallback callback) = 0;

  virtual void NotifyPanelStateChange(PanelStatePtr panel_state) = 0;

  virtual void NotifyPanelActiveChange(bool panel_active) = 0;

  virtual void NotifyPanelCanAttachChange(bool can_attach) = 0;

  virtual void NotifyMicrophonePermissionStateChanged(bool enabled) = 0;

  virtual void NotifyLocationPermissionStateChanged(bool enabled) = 0;

  virtual void NotifyTabContextPermissionStateChanged(bool enabled) = 0;

  virtual void NotifyOsLocationPermissionStateChanged(bool enabled) = 0;

  virtual void NotifyFocusedTabChanged(FocusedTabDataPtr focused_tab_data) = 0;

  virtual void NotifyManualResizeChanged(bool resizing) = 0;

  virtual void NotifyOsHotkeyStateChanged(const std::string& hotkey) = 0;

  virtual void NotifyBrowserIsOpenChanged(bool browser_is_open) = 0;

  virtual void NotifyInstanceActivationChanged(bool instance_active) = 0;

  virtual void NotifyClosedCaptioningSettingChanged(bool enabled) = 0;

  virtual void NotifyPinnedTabsChanged(std::vector<TabDataPtr> tab_data) = 0;

  virtual void NotifyPinnedTabDataChanged(TabDataPtr tab_data) = 0;

  virtual void NotifyZeroStateSuggestionsChanged(ZeroStateSuggestionsV2Ptr suggestions, ZeroStateSuggestionsOptionsPtr options) = 0;

  virtual void NotifyActorTaskStateChanged(int32_t task_id, ActorTaskState state) = 0;

  virtual void NotifyTabDataChanged(TabDataPtr tab_data) = 0;

  virtual void RequestViewChange(ViewChangeRequestPtr request) = 0;

  virtual void NotifyPageMetadataChanged(int32_t tab_id, ::blink::mojom::PageMetadataPtr metadata) = 0;

  virtual void NotifyDefaultTabContextPermissionStateChanged(bool enabled) = 0;

  using RequestToShowCredentialSelectionDialogCallback = base::OnceCallback<void(::actor::webui::mojom::SelectCredentialDialogResponsePtr)>;
  using RequestToShowCredentialSelectionDialogMojoCallback = base::OnceCallback<void(::actor::webui::mojom::SelectCredentialDialogResponsePtr)>;

  virtual void RequestToShowCredentialSelectionDialog(::actor::webui::mojom::SelectCredentialDialogRequestPtr request, RequestToShowCredentialSelectionDialogCallback callback) = 0;

  using RequestToShowAutofillSuggestionsDialogCallback = base::OnceCallback<void(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr)>;
  using RequestToShowAutofillSuggestionsDialogMojoCallback = base::OnceCallback<void(::actor::webui::mojom::SelectAutofillSuggestionsDialogResponsePtr)>;

  virtual void RequestToShowAutofillSuggestionsDialog(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr request, RequestToShowAutofillSuggestionsDialogCallback callback) = 0;

  using RequestToShowUserConfirmationDialogCallback = base::OnceCallback<void(::actor::webui::mojom::UserConfirmationDialogResponsePtr)>;
  using RequestToShowUserConfirmationDialogMojoCallback = base::OnceCallback<void(::actor::webui::mojom::UserConfirmationDialogResponsePtr)>;

  virtual void RequestToShowUserConfirmationDialog(::actor::webui::mojom::UserConfirmationDialogRequestPtr request, RequestToShowUserConfirmationDialogCallback callback) = 0;

  using RequestToConfirmNavigationCallback = base::OnceCallback<void(::actor::webui::mojom::NavigationConfirmationResponsePtr)>;
  using RequestToConfirmNavigationMojoCallback = base::OnceCallback<void(::actor::webui::mojom::NavigationConfirmationResponsePtr)>;

  virtual void RequestToConfirmNavigation(::actor::webui::mojom::NavigationConfirmationRequestPtr request, RequestToConfirmNavigationCallback callback) = 0;

  virtual void NotifyAdditionalContext(AdditionalContextPtr context) = 0;

  virtual void NotifyActuationOnWebSettingChanged(bool enabled) = 0;

  virtual void NotifyActOnWebCapabilityChanged(bool can_act_on_web) = 0;

  virtual void NotifyOnboardingCompletedChanged(bool completed) = 0;
};

class CaptureRegionObserverProxy;

template <typename ImplRefTraits>
class CaptureRegionObserverStub;

class CaptureRegionObserverRequestValidator;


class CaptureRegionObserver
    : public CaptureRegionObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.CaptureRegionObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CaptureRegionObserverInterfaceBase;
  using Proxy_ = CaptureRegionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = CaptureRegionObserverStub<ImplRefTraits>;

  using RequestValidator_ = CaptureRegionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CaptureRegionObserver() = default;

  virtual void OnUpdate(CaptureRegionResultPtr result, std::optional<CaptureRegionErrorReason> reason) = 0;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void IntentToShow() final;
  
  void SetProfileReadyState(ProfileReadyState ready_state) final;
  
  void UpdatePageState(PanelStateKind panelStateKind) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingReceiver<PageHandler> receiver, ::mojo::PendingRemote<Page> page) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWebClient(::mojo::PendingReceiver<WebClientHandler> web_client_receiver) final;
  
  void PrepareForClient(PrepareForClientCallback callback) final;
  
  void WebviewCommitted(const ::GURL& url) final;
  
  void ClosePanel(ClosePanelCallback callback) final;
  
  void OpenProfilePickerAndClosePanel() final;
  
  void OpenDisabledByAdminLinkAndClosePanel() final;
  
  void SignInAndClosePanel() final;
  
  void ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) final;
  
  void EnableDragResize(bool enabled) final;
  
  void WebUiStateChanged(WebUiState new_state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PinCandidatesObserverProxy
    : public PinCandidatesObserver {
 public:
  using InterfaceType = PinCandidatesObserver;

  explicit PinCandidatesObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPinCandidatesChanged(std::vector<PinCandidatePtr> candidates) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebClientHandlerProxy
    : public WebClientHandler {
 public:
  using InterfaceType = WebClientHandler;

  explicit WebClientHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WebClientCreated(::mojo::PendingRemote<WebClient> web_client, WebClientCreatedCallback callback) final;
  
  void WebClientInitialized() final;
  
  void WebClientInitializeFailed() final;
  
  void CreateTab(const ::GURL& url, bool open_in_background, std::optional<int32_t> window_id, CreateTabCallback callback) final;
  
  void OpenLinkInPopup(const ::GURL& url, int32_t popup_width, int32_t popup_height) final;
  
  void OpenGlicSettingsPage(OpenSettingsOptionsPtr options) final;
  
  void OpenPasswordManagerSettingsPage() final;
  
  void ClosePanel() final;
  
  void ClosePanelAndShutdown() final;
  
  void AttachPanel() final;
  
  void DetachPanel() final;
  
  void OnModeChange(WebClientMode new_mode) final;
  
  void ShowProfilePicker() final;
  
  void GetModelQualityClientId(GetModelQualityClientIdCallback callback) final;
  
  void GetContextFromFocusedTab(GetTabContextOptionsPtr options, GetContextFromFocusedTabCallback callback) final;
  
  void GetContextFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextFromTabCallback callback) final;
  
  void GetContextForActorFromTab(int32_t tab_id, GetTabContextOptionsPtr options, GetContextForActorFromTabCallback callback) final;
  
  void SetMaximumNumberOfPinnedTabs(uint32_t requested_max, SetMaximumNumberOfPinnedTabsCallback callback) final;
  
  void PinTabs(const std::vector<int32_t>& tab_ids, PinTabsCallback callback) final;
  
  void UnpinTabs(const std::vector<int32_t>& tab_ids, UnpinTabsCallback callback) final;
  
  void UnpinAllTabs() final;
  
  void SubscribeToPinCandidates(GetPinCandidatesOptionsPtr options, ::mojo::PendingRemote<PinCandidatesObserver> observer) final;
  
  void CreateTask(::actor::webui::mojom::TaskOptionsPtr task_options, CreateTaskCallback callback) final;
  
  void PerformActions(const std::vector<uint8_t>& actions_proto, PerformActionsCallback callback) final;
  
  void StopActorTask(int32_t task_id, ActorTaskStopReason stop_reason) final;
  
  void PauseActorTask(int32_t task_id, ActorTaskPauseReason pause_reason, std::optional<int32_t> tab_id) final;
  
  void ResumeActorTask(int32_t task_id, GetTabContextOptionsPtr context_options, ResumeActorTaskCallback callback) final;
  
  void InterruptActorTask(int32_t task_id) final;
  
  void UninterruptActorTask(int32_t task_id) final;
  
  void CreateActorTab(int32_t task_id, bool open_in_background, std::optional<int32_t> initiator_tab_id, std::optional<int32_t> initiator_window_id, CreateActorTabCallback callback) final;
  
  void ActivateTab(int32_t task_id) final;
  
  void ResizeWidget(const ::gfx::Size& size, ::base::TimeDelta duration, ResizeWidgetCallback callback) final;
  
  void CaptureScreenshot(CaptureScreenshotCallback callback) final;
  
  void CaptureRegion(::mojo::PendingRemote<CaptureRegionObserver> observer) final;
  
  void SetAudioDucking(bool enable, SetAudioDuckingCallback callback) final;
  
  void SetPanelDraggableAreas(const std::vector<::gfx::Rect>& draggable_areas, SetPanelDraggableAreasCallback callback) final;
  
  void SetMinimumPanelSize(const ::gfx::Size& size) final;
  
  void SetMicrophonePermissionState(bool enabled, SetMicrophonePermissionStateCallback callback) final;
  
  void SetLocationPermissionState(bool enabled, SetLocationPermissionStateCallback callback) final;
  
  void SetTabContextPermissionState(bool enabled, SetTabContextPermissionStateCallback callback) final;
  
  void SetClosedCaptioningSetting(bool enabled, SetClosedCaptioningSettingCallback callback) final;
  
  void SetActuationOnWebSetting(bool enabled, SetActuationOnWebSettingCallback callback) final;
  
  void ShouldAllowMediaPermissionRequest(ShouldAllowMediaPermissionRequestCallback callback) final;
  
  void ShouldAllowGeolocationPermissionRequest(ShouldAllowGeolocationPermissionRequestCallback callback) final;
  
  void SetContextAccessIndicator(bool enabled) final;
  
  void GetUserProfileInfo(GetUserProfileInfoCallback callback) final;
  
  void SyncCookies(SyncCookiesCallback callback) final;
  
  void LogBeginAsyncEvent(uint64_t event_async_id, int32_t task_id, const std::string& event, const std::string& details) final;
  
  void LogEndAsyncEvent(uint64_t event_async_id, const std::string& details) final;
  
  void LogInstantEvent(int32_t task_id, const std::string& event, const std::string& details) final;
  
  void JournalClear() final;
  
  void JournalSnapshot(bool clear_journal, JournalSnapshotCallback callback) final;
  
  void JournalStart(uint64_t max_bytes, bool capture_screenshots) final;
  
  void JournalStop() final;
  
  void JournalRecordFeedback(bool positive, const std::string& reason) final;
  
  void OnUserInputSubmitted(WebClientMode mode) final;
  
  void OnContextUploadStarted() final;
  
  void OnContextUploadCompleted() final;
  
  void OnReaction(MetricUserInputReactionType reactionType) final;
  
  void OnResponseStarted() final;
  
  void OnResponseStopped(OnResponseStoppedDetailsPtr details) final;
  
  void OnSessionTerminated() final;
  
  void OnTurnCompleted(WebClientModel model, ::base::TimeDelta duration) final;
  
  void OnModelChanged(WebClientModel model) final;
  
  void OnRecordUseCounter(uint16_t counter) final;
  
  void OnResponseRated(bool positive) final;
  
  void OnClosedCaptionsShown() final;
  
  void ScrollTo(ScrollToParamsPtr params, ScrollToCallback callback) final;
  
  void DropScrollToHighlight() final;
  
  void SetSyntheticExperimentState(const std::string& trial_name, const std::string& group_name) final;
  
  void OpenOsPermissionSettingsMenu(::content_settings::mojom::ContentSettingsType type) final;
  
  void GetOsMicrophonePermissionStatus(GetOsMicrophonePermissionStatusCallback callback) final;
  
  void GetZeroStateSuggestionsAndSubscribe(bool is_live, ZeroStateSuggestionsOptionsPtr options, GetZeroStateSuggestionsAndSubscribeCallback callback) final;
  
  void GetZeroStateSuggestionsForFocusedTab(std::optional<bool> is_first_run, GetZeroStateSuggestionsForFocusedTabCallback callback) final;
  
  void MaybeRefreshUserStatus() final;
  
  void IsDebuggerAttached(IsDebuggerAttachedCallback callback) final;
  
  void OnViewChanged(ViewChangedNotificationPtr notification) final;
  
  void SubscribeToPageMetadata(int32_t tab_id, const std::vector<std::string>& names, SubscribeToPageMetadataCallback callback) final;
  
  void SwitchConversation(ConversationInfoPtr info, SwitchConversationCallback callback) final;
  
  void RegisterConversation(ConversationInfoPtr info, RegisterConversationCallback callback) final;
  
  void SetOnboardingCompleted() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebClientProxy
    : public WebClient {
 public:
  using InterfaceType = WebClient;

  explicit WebClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyPanelWillOpen(PanelOpeningDataPtr panel_opening_data, NotifyPanelWillOpenCallback callback) final;
  
  void NotifyPanelWasClosed(NotifyPanelWasClosedCallback callback) final;
  
  void NotifyPanelStateChange(PanelStatePtr panel_state) final;
  
  void NotifyPanelActiveChange(bool panel_active) final;
  
  void NotifyPanelCanAttachChange(bool can_attach) final;
  
  void NotifyMicrophonePermissionStateChanged(bool enabled) final;
  
  void NotifyLocationPermissionStateChanged(bool enabled) final;
  
  void NotifyTabContextPermissionStateChanged(bool enabled) final;
  
  void NotifyOsLocationPermissionStateChanged(bool enabled) final;
  
  void NotifyFocusedTabChanged(FocusedTabDataPtr focused_tab_data) final;
  
  void NotifyManualResizeChanged(bool resizing) final;
  
  void NotifyOsHotkeyStateChanged(const std::string& hotkey) final;
  
  void NotifyBrowserIsOpenChanged(bool browser_is_open) final;
  
  void NotifyInstanceActivationChanged(bool instance_active) final;
  
  void NotifyClosedCaptioningSettingChanged(bool enabled) final;
  
  void NotifyPinnedTabsChanged(std::vector<TabDataPtr> tab_data) final;
  
  void NotifyPinnedTabDataChanged(TabDataPtr tab_data) final;
  
  void NotifyZeroStateSuggestionsChanged(ZeroStateSuggestionsV2Ptr suggestions, ZeroStateSuggestionsOptionsPtr options) final;
  
  void NotifyActorTaskStateChanged(int32_t task_id, ActorTaskState state) final;
  
  void NotifyTabDataChanged(TabDataPtr tab_data) final;
  
  void RequestViewChange(ViewChangeRequestPtr request) final;
  
  void NotifyPageMetadataChanged(int32_t tab_id, ::blink::mojom::PageMetadataPtr metadata) final;
  
  void NotifyDefaultTabContextPermissionStateChanged(bool enabled) final;
  
  void RequestToShowCredentialSelectionDialog(::actor::webui::mojom::SelectCredentialDialogRequestPtr request, RequestToShowCredentialSelectionDialogCallback callback) final;
  
  void RequestToShowAutofillSuggestionsDialog(::actor::webui::mojom::SelectAutofillSuggestionsDialogRequestPtr request, RequestToShowAutofillSuggestionsDialogCallback callback) final;
  
  void RequestToShowUserConfirmationDialog(::actor::webui::mojom::UserConfirmationDialogRequestPtr request, RequestToShowUserConfirmationDialogCallback callback) final;
  
  void RequestToConfirmNavigation(::actor::webui::mojom::NavigationConfirmationRequestPtr request, RequestToConfirmNavigationCallback callback) final;
  
  void NotifyAdditionalContext(AdditionalContextPtr context) final;
  
  void NotifyActuationOnWebSettingChanged(bool enabled) final;
  
  void NotifyActOnWebCapabilityChanged(bool can_act_on_web) final;
  
  void NotifyOnboardingCompletedChanged(bool completed) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CaptureRegionObserverProxy
    : public CaptureRegionObserver {
 public:
  using InterfaceType = CaptureRegionObserver;

  explicit CaptureRegionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnUpdate(CaptureRegionResultPtr result, std::optional<CaptureRegionErrorReason> reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PinCandidatesObserverStubDispatch {
 public:
  static bool Accept(PinCandidatesObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PinCandidatesObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PinCandidatesObserver>>
class PinCandidatesObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PinCandidatesObserverStub() = default;
  ~PinCandidatesObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PinCandidatesObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PinCandidatesObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebClientHandlerStubDispatch {
 public:
  static bool Accept(WebClientHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebClientHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebClientHandler>>
class WebClientHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebClientHandlerStub() = default;
  ~WebClientHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebClientHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebClientHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebClientStubDispatch {
 public:
  static bool Accept(WebClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebClient>>
class WebClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebClientStub() = default;
  ~WebClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CaptureRegionObserverStubDispatch {
 public:
  static bool Accept(CaptureRegionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CaptureRegionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CaptureRegionObserver>>
class CaptureRegionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CaptureRegionObserverStub() = default;
  ~CaptureRegionObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CaptureRegionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CaptureRegionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PinCandidatesObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebClientHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CaptureRegionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebClientHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  GetPinCandidatesOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetPinCandidatesOptions, T>::value>;
  using DataView = GetPinCandidatesOptionsDataView;
  using Data_ = internal::GetPinCandidatesOptions_Data;

  template <typename... Args>
  static GetPinCandidatesOptionsPtr New(Args&&... args) {
    return GetPinCandidatesOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetPinCandidatesOptionsPtr From(const U& u) {
    return mojo::TypeConverter<GetPinCandidatesOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetPinCandidatesOptions>::Convert(*this);
  }


  GetPinCandidatesOptions();

  GetPinCandidatesOptions(
      uint32_t max_candidates,
      const std::optional<std::string>& query);


  ~GetPinCandidatesOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetPinCandidatesOptionsPtr>
  GetPinCandidatesOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetPinCandidatesOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetPinCandidatesOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetPinCandidatesOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetPinCandidatesOptions_UnserializedMessageContext<
            UserType, GetPinCandidatesOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetPinCandidatesOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetPinCandidatesOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetPinCandidatesOptions_UnserializedMessageContext<
            UserType, GetPinCandidatesOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetPinCandidatesOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t max_candidates;
  
  std::optional<std::string> query;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetPinCandidatesOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ScrollToTextSelector {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollToTextSelector, T>::value>;
  using DataView = ScrollToTextSelectorDataView;
  using Data_ = internal::ScrollToTextSelector_Data;

  template <typename... Args>
  static ScrollToTextSelectorPtr New(Args&&... args) {
    return ScrollToTextSelectorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollToTextSelectorPtr From(const U& u) {
    return mojo::TypeConverter<ScrollToTextSelectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollToTextSelector>::Convert(*this);
  }


  ScrollToTextSelector();

  ScrollToTextSelector(
      const std::string& text,
      std::optional<int32_t> search_range_start_node_id);


  ~ScrollToTextSelector();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollToTextSelectorPtr>
  ScrollToTextSelectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToTextSelector::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToTextSelector::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollToTextSelector::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollToTextSelector_UnserializedMessageContext<
            UserType, ScrollToTextSelector::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollToTextSelector::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollToTextSelector::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollToTextSelector_UnserializedMessageContext<
            UserType, ScrollToTextSelector::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollToTextSelector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;
  
  std::optional<int32_t> search_range_start_node_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollToTextSelector::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScrollToTextFragmentSelector {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollToTextFragmentSelector, T>::value>;
  using DataView = ScrollToTextFragmentSelectorDataView;
  using Data_ = internal::ScrollToTextFragmentSelector_Data;

  template <typename... Args>
  static ScrollToTextFragmentSelectorPtr New(Args&&... args) {
    return ScrollToTextFragmentSelectorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollToTextFragmentSelectorPtr From(const U& u) {
    return mojo::TypeConverter<ScrollToTextFragmentSelectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollToTextFragmentSelector>::Convert(*this);
  }


  ScrollToTextFragmentSelector();

  ScrollToTextFragmentSelector(
      const std::string& text_start,
      const std::string& text_end,
      std::optional<int32_t> search_range_start_node_id);


  ~ScrollToTextFragmentSelector();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollToTextFragmentSelectorPtr>
  ScrollToTextFragmentSelectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToTextFragmentSelector::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToTextFragmentSelector::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollToTextFragmentSelector::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollToTextFragmentSelector_UnserializedMessageContext<
            UserType, ScrollToTextFragmentSelector::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollToTextFragmentSelector::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollToTextFragmentSelector::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollToTextFragmentSelector_UnserializedMessageContext<
            UserType, ScrollToTextFragmentSelector::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollToTextFragmentSelector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text_start;
  
  std::string text_end;
  
  std::optional<int32_t> search_range_start_node_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScrollToNodeSelector {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollToNodeSelector, T>::value>;
  using DataView = ScrollToNodeSelectorDataView;
  using Data_ = internal::ScrollToNodeSelector_Data;

  template <typename... Args>
  static ScrollToNodeSelectorPtr New(Args&&... args) {
    return ScrollToNodeSelectorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollToNodeSelectorPtr From(const U& u) {
    return mojo::TypeConverter<ScrollToNodeSelectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollToNodeSelector>::Convert(*this);
  }


  ScrollToNodeSelector();

  explicit ScrollToNodeSelector(
      int32_t node_id);


  ~ScrollToNodeSelector();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollToNodeSelectorPtr>
  ScrollToNodeSelectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToNodeSelector::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToNodeSelector::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollToNodeSelector::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollToNodeSelector_UnserializedMessageContext<
            UserType, ScrollToNodeSelector::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollToNodeSelector::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollToNodeSelector::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollToNodeSelector_UnserializedMessageContext<
            UserType, ScrollToNodeSelector::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollToNodeSelector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t node_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollToNodeSelector::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SuggestionContent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SuggestionContent, T>::value>;
  using DataView = SuggestionContentDataView;
  using Data_ = internal::SuggestionContent_Data;

  template <typename... Args>
  static SuggestionContentPtr New(Args&&... args) {
    return SuggestionContentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SuggestionContentPtr From(const U& u) {
    return mojo::TypeConverter<SuggestionContentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SuggestionContent>::Convert(*this);
  }


  SuggestionContent();

  explicit SuggestionContent(
      const std::string& suggestion);


  ~SuggestionContent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SuggestionContentPtr>
  SuggestionContentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuggestionContent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SuggestionContent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SuggestionContent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SuggestionContent_UnserializedMessageContext<
            UserType, SuggestionContent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SuggestionContent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SuggestionContent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SuggestionContent_UnserializedMessageContext<
            UserType, SuggestionContent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SuggestionContent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string suggestion;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SuggestionContent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  ConversationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConversationInfo, T>::value>;
  using DataView = ConversationInfoDataView;
  using Data_ = internal::ConversationInfo_Data;

  template <typename... Args>
  static ConversationInfoPtr New(Args&&... args) {
    return ConversationInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConversationInfoPtr From(const U& u) {
    return mojo::TypeConverter<ConversationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConversationInfo>::Convert(*this);
  }


  ConversationInfo();

  ConversationInfo(
      const std::string& conversation_id,
      const std::string& conversation_title);


  ~ConversationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConversationInfoPtr>
  ConversationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConversationInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConversationInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConversationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConversationInfo_UnserializedMessageContext<
            UserType, ConversationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConversationInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConversationInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConversationInfo_UnserializedMessageContext<
            UserType, ConversationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConversationInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string conversation_id;
  
  std::string conversation_title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConversationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PanelState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PanelState, T>::value>;
  using DataView = PanelStateDataView;
  using Data_ = internal::PanelState_Data;

  template <typename... Args>
  static PanelStatePtr New(Args&&... args) {
    return PanelStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PanelStatePtr From(const U& u) {
    return mojo::TypeConverter<PanelStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PanelState>::Convert(*this);
  }


  PanelState();

  PanelState(
      PanelStateKind kind,
      std::optional<int32_t> window_id);


  ~PanelState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PanelStatePtr>
  PanelStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PanelState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PanelState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PanelState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PanelState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PanelState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PanelState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PanelState_UnserializedMessageContext<
            UserType, PanelState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PanelState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PanelState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PanelState_UnserializedMessageContext<
            UserType, PanelState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PanelState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PanelStateKind kind;
  
  std::optional<int32_t> window_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PanelState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PanelState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PanelState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PanelState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OnResponseStoppedDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnResponseStoppedDetails, T>::value>;
  using DataView = OnResponseStoppedDetailsDataView;
  using Data_ = internal::OnResponseStoppedDetails_Data;

  template <typename... Args>
  static OnResponseStoppedDetailsPtr New(Args&&... args) {
    return OnResponseStoppedDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnResponseStoppedDetailsPtr From(const U& u) {
    return mojo::TypeConverter<OnResponseStoppedDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnResponseStoppedDetails>::Convert(*this);
  }


  OnResponseStoppedDetails();

  explicit OnResponseStoppedDetails(
      ResponseStopCause cause);


  ~OnResponseStoppedDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnResponseStoppedDetailsPtr>
  OnResponseStoppedDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnResponseStoppedDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnResponseStoppedDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnResponseStoppedDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnResponseStoppedDetails_UnserializedMessageContext<
            UserType, OnResponseStoppedDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnResponseStoppedDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnResponseStoppedDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnResponseStoppedDetails_UnserializedMessageContext<
            UserType, OnResponseStoppedDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnResponseStoppedDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ResponseStopCause cause;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnResponseStoppedDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class  ImageOriginAnnotations {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageOriginAnnotations, T>::value>;
  using DataView = ImageOriginAnnotationsDataView;
  using Data_ = internal::ImageOriginAnnotations_Data;

  template <typename... Args>
  static ImageOriginAnnotationsPtr New(Args&&... args) {
    return ImageOriginAnnotationsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageOriginAnnotationsPtr From(const U& u) {
    return mojo::TypeConverter<ImageOriginAnnotationsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageOriginAnnotations>::Convert(*this);
  }


  ImageOriginAnnotations();


  ~ImageOriginAnnotations();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageOriginAnnotationsPtr>
  ImageOriginAnnotationsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageOriginAnnotations::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageOriginAnnotations::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageOriginAnnotations::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageOriginAnnotations_UnserializedMessageContext<
            UserType, ImageOriginAnnotations::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageOriginAnnotations::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageOriginAnnotations::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageOriginAnnotations_UnserializedMessageContext<
            UserType, ImageOriginAnnotations::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageOriginAnnotations::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageOriginAnnotations::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  OpenSettingsOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenSettingsOptions, T>::value>;
  using DataView = OpenSettingsOptionsDataView;
  using Data_ = internal::OpenSettingsOptions_Data;

  template <typename... Args>
  static OpenSettingsOptionsPtr New(Args&&... args) {
    return OpenSettingsOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenSettingsOptionsPtr From(const U& u) {
    return mojo::TypeConverter<OpenSettingsOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenSettingsOptions>::Convert(*this);
  }


  OpenSettingsOptions();

  explicit OpenSettingsOptions(
      SettingsPageField highlightField);


  ~OpenSettingsOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenSettingsOptionsPtr>
  OpenSettingsOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenSettingsOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenSettingsOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenSettingsOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenSettingsOptions_UnserializedMessageContext<
            UserType, OpenSettingsOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpenSettingsOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpenSettingsOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenSettingsOptions_UnserializedMessageContext<
            UserType, OpenSettingsOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenSettingsOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SettingsPageField highlightField;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenSettingsOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ViewChangeRequestActuation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewChangeRequestActuation, T>::value>;
  using DataView = ViewChangeRequestActuationDataView;
  using Data_ = internal::ViewChangeRequestActuation_Data;

  template <typename... Args>
  static ViewChangeRequestActuationPtr New(Args&&... args) {
    return ViewChangeRequestActuationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewChangeRequestActuationPtr From(const U& u) {
    return mojo::TypeConverter<ViewChangeRequestActuationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewChangeRequestActuation>::Convert(*this);
  }


  ViewChangeRequestActuation();


  ~ViewChangeRequestActuation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewChangeRequestActuationPtr>
  ViewChangeRequestActuationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangeRequestActuation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangeRequestActuation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewChangeRequestActuation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewChangeRequestActuation_UnserializedMessageContext<
            UserType, ViewChangeRequestActuation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewChangeRequestActuation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewChangeRequestActuation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewChangeRequestActuation_UnserializedMessageContext<
            UserType, ViewChangeRequestActuation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewChangeRequestActuation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewChangeRequestActuation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ViewChangeRequestConversation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewChangeRequestConversation, T>::value>;
  using DataView = ViewChangeRequestConversationDataView;
  using Data_ = internal::ViewChangeRequestConversation_Data;

  template <typename... Args>
  static ViewChangeRequestConversationPtr New(Args&&... args) {
    return ViewChangeRequestConversationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewChangeRequestConversationPtr From(const U& u) {
    return mojo::TypeConverter<ViewChangeRequestConversationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewChangeRequestConversation>::Convert(*this);
  }


  ViewChangeRequestConversation();


  ~ViewChangeRequestConversation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewChangeRequestConversationPtr>
  ViewChangeRequestConversationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangeRequestConversation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangeRequestConversation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewChangeRequestConversation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewChangeRequestConversation_UnserializedMessageContext<
            UserType, ViewChangeRequestConversation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewChangeRequestConversation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewChangeRequestConversation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewChangeRequestConversation_UnserializedMessageContext<
            UserType, ViewChangeRequestConversation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewChangeRequestConversation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewChangeRequestConversation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ViewChangedNotification {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewChangedNotification, T>::value>;
  using DataView = ViewChangedNotificationDataView;
  using Data_ = internal::ViewChangedNotification_Data;

  template <typename... Args>
  static ViewChangedNotificationPtr New(Args&&... args) {
    return ViewChangedNotificationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewChangedNotificationPtr From(const U& u) {
    return mojo::TypeConverter<ViewChangedNotificationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewChangedNotification>::Convert(*this);
  }


  ViewChangedNotification();

  explicit ViewChangedNotification(
      CurrentView current_view);


  ~ViewChangedNotification();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewChangedNotificationPtr>
  ViewChangedNotificationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangedNotification::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangedNotification::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewChangedNotification::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewChangedNotification_UnserializedMessageContext<
            UserType, ViewChangedNotification::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewChangedNotification::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewChangedNotification::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewChangedNotification_UnserializedMessageContext<
            UserType, ViewChangedNotification::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewChangedNotification::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CurrentView current_view;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewChangedNotification::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GetContextResult {
 public:
  using DataView = GetContextResultDataView;
  using Data_ = internal::GetContextResult_Data;
  using Tag = Data_::GetContextResult_Tag;

  template <typename... Args>
  static GetContextResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_reason|.
  static GetContextResultPtr NewErrorReason(
      const std::string& value);
  // Construct an instance holding |tab_context|.
  static GetContextResultPtr NewTabContext(
      TabContextPtr value);

  template <typename U>
  static GetContextResultPtr From(const U& u) {
    return mojo::TypeConverter<GetContextResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetContextResult>::Convert(*this);
  }
  ~GetContextResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetContextResult(const GetContextResult& other) = delete;
  GetContextResult& operator=(const GetContextResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetContextResultPtr>
  GetContextResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetContextResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetContextResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_reason() const { return tag_ == Tag::kErrorReason; }
  const std::string& get_error_reason() const {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  std::string& get_error_reason() {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  void set_error_reason(const std::string& error_reason);

  bool is_tab_context() const { return tag_ == Tag::kTabContext; }
  const TabContextPtr& get_tab_context() const {
    CHECK(tag_ == Tag::kTabContext);
    return data_.tab_context;
  }
  TabContextPtr& get_tab_context() {
    CHECK(tag_ == Tag::kTabContext);
    return data_.tab_context;
  }
  void set_tab_context(TabContextPtr tab_context);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetContextResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetContextResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabContext)>,
        TabContextPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string error_reason;
    TabContextPtr tab_context;
  };

  GetContextResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
      const std::string& value);
  GetContextResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabContext)>,
      TabContextPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  CaptureScreenshotResult {
 public:
  using DataView = CaptureScreenshotResultDataView;
  using Data_ = internal::CaptureScreenshotResult_Data;
  using Tag = Data_::CaptureScreenshotResult_Tag;

  template <typename... Args>
  static CaptureScreenshotResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_reason|.
  static CaptureScreenshotResultPtr NewErrorReason(
      CaptureScreenshotErrorReason value);
  // Construct an instance holding |screenshot|.
  static CaptureScreenshotResultPtr NewScreenshot(
      ScreenshotPtr value);

  template <typename U>
  static CaptureScreenshotResultPtr From(const U& u) {
    return mojo::TypeConverter<CaptureScreenshotResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CaptureScreenshotResult>::Convert(*this);
  }
  ~CaptureScreenshotResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CaptureScreenshotResult(const CaptureScreenshotResult& other) = delete;
  CaptureScreenshotResult& operator=(const CaptureScreenshotResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CaptureScreenshotResultPtr>
  CaptureScreenshotResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CaptureScreenshotResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CaptureScreenshotResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_reason() const { return tag_ == Tag::kErrorReason; }
  CaptureScreenshotErrorReason get_error_reason() const {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  void set_error_reason(CaptureScreenshotErrorReason error_reason);

  bool is_screenshot() const { return tag_ == Tag::kScreenshot; }
  const ScreenshotPtr& get_screenshot() const {
    CHECK(tag_ == Tag::kScreenshot);
    return data_.screenshot;
  }
  ScreenshotPtr& get_screenshot() {
    CHECK(tag_ == Tag::kScreenshot);
    return data_.screenshot;
  }
  void set_screenshot(ScreenshotPtr screenshot);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CaptureScreenshotResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CaptureScreenshotResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
        CaptureScreenshotErrorReason value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
        ScreenshotPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CaptureScreenshotErrorReason error_reason;
    ScreenshotPtr screenshot;
  };

  CaptureScreenshotResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
      CaptureScreenshotErrorReason value);
  CaptureScreenshotResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
      ScreenshotPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ScrollToSelector {
 public:
  using DataView = ScrollToSelectorDataView;
  using Data_ = internal::ScrollToSelector_Data;
  using Tag = Data_::ScrollToSelector_Tag;

  template <typename... Args>
  static ScrollToSelectorPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |exact_text_selector|.
  static ScrollToSelectorPtr NewExactTextSelector(
      ScrollToTextSelectorPtr value);
  // Construct an instance holding |text_fragment_selector|.
  static ScrollToSelectorPtr NewTextFragmentSelector(
      ScrollToTextFragmentSelectorPtr value);
  // Construct an instance holding |node_selector|.
  static ScrollToSelectorPtr NewNodeSelector(
      ScrollToNodeSelectorPtr value);

  template <typename U>
  static ScrollToSelectorPtr From(const U& u) {
    return mojo::TypeConverter<ScrollToSelectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollToSelector>::Convert(*this);
  }
  ~ScrollToSelector();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ScrollToSelector(const ScrollToSelector& other) = delete;
  ScrollToSelector& operator=(const ScrollToSelector& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ScrollToSelectorPtr>
  ScrollToSelectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ScrollToSelector>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ScrollToSelector>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_exact_text_selector() const { return tag_ == Tag::kExactTextSelector; }
  const ScrollToTextSelectorPtr& get_exact_text_selector() const {
    CHECK(tag_ == Tag::kExactTextSelector);
    return data_.exact_text_selector;
  }
  ScrollToTextSelectorPtr& get_exact_text_selector() {
    CHECK(tag_ == Tag::kExactTextSelector);
    return data_.exact_text_selector;
  }
  void set_exact_text_selector(ScrollToTextSelectorPtr exact_text_selector);

  bool is_text_fragment_selector() const { return tag_ == Tag::kTextFragmentSelector; }
  const ScrollToTextFragmentSelectorPtr& get_text_fragment_selector() const {
    CHECK(tag_ == Tag::kTextFragmentSelector);
    return data_.text_fragment_selector;
  }
  ScrollToTextFragmentSelectorPtr& get_text_fragment_selector() {
    CHECK(tag_ == Tag::kTextFragmentSelector);
    return data_.text_fragment_selector;
  }
  void set_text_fragment_selector(ScrollToTextFragmentSelectorPtr text_fragment_selector);

  bool is_node_selector() const { return tag_ == Tag::kNodeSelector; }
  const ScrollToNodeSelectorPtr& get_node_selector() const {
    CHECK(tag_ == Tag::kNodeSelector);
    return data_.node_selector;
  }
  ScrollToNodeSelectorPtr& get_node_selector() {
    CHECK(tag_ == Tag::kNodeSelector);
    return data_.node_selector;
  }
  void set_node_selector(ScrollToNodeSelectorPtr node_selector);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollToSelector::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ScrollToSelector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kExactTextSelector)>,
        ScrollToTextSelectorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTextFragmentSelector)>,
        ScrollToTextFragmentSelectorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNodeSelector)>,
        ScrollToNodeSelectorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ScrollToTextSelectorPtr exact_text_selector;
    ScrollToTextFragmentSelectorPtr text_fragment_selector;
    ScrollToNodeSelectorPtr node_selector;
  };

  ScrollToSelector(
      std::in_place_index_t<static_cast<size_t>(Tag::kExactTextSelector)>,
      ScrollToTextSelectorPtr value);
  ScrollToSelector(
      std::in_place_index_t<static_cast<size_t>(Tag::kTextFragmentSelector)>,
      ScrollToTextFragmentSelectorPtr value);
  ScrollToSelector(
      std::in_place_index_t<static_cast<size_t>(Tag::kNodeSelector)>,
      ScrollToNodeSelectorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  AdditionalContextPart {
 public:
  using DataView = AdditionalContextPartDataView;
  using Data_ = internal::AdditionalContextPart_Data;
  using Tag = Data_::AdditionalContextPart_Tag;

  template <typename... Args>
  static AdditionalContextPartPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |data|.
  static AdditionalContextPartPtr NewData(
      ContextDataPtr value);
  // Construct an instance holding |screenshot|.
  static AdditionalContextPartPtr NewScreenshot(
      ScreenshotPtr value);
  // Construct an instance holding |web_page_data|.
  static AdditionalContextPartPtr NewWebPageData(
      WebPageDataPtr value);
  // Construct an instance holding |annotated_page_data|.
  static AdditionalContextPartPtr NewAnnotatedPageData(
      AnnotatedPageDataPtr value);
  // Construct an instance holding |pdf_document_data|.
  static AdditionalContextPartPtr NewPdfDocumentData(
      PdfDocumentDataPtr value);
  // Construct an instance holding |tab_context|.
  static AdditionalContextPartPtr NewTabContext(
      TabContextPtr value);

  template <typename U>
  static AdditionalContextPartPtr From(const U& u) {
    return mojo::TypeConverter<AdditionalContextPartPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdditionalContextPart>::Convert(*this);
  }
  ~AdditionalContextPart();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AdditionalContextPart(const AdditionalContextPart& other) = delete;
  AdditionalContextPart& operator=(const AdditionalContextPart& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AdditionalContextPartPtr>
  AdditionalContextPartPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AdditionalContextPart>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AdditionalContextPart>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_data() const { return tag_ == Tag::kData; }
  const ContextDataPtr& get_data() const {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  ContextDataPtr& get_data() {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  void set_data(ContextDataPtr data);

  bool is_screenshot() const { return tag_ == Tag::kScreenshot; }
  const ScreenshotPtr& get_screenshot() const {
    CHECK(tag_ == Tag::kScreenshot);
    return data_.screenshot;
  }
  ScreenshotPtr& get_screenshot() {
    CHECK(tag_ == Tag::kScreenshot);
    return data_.screenshot;
  }
  void set_screenshot(ScreenshotPtr screenshot);

  bool is_web_page_data() const { return tag_ == Tag::kWebPageData; }
  const WebPageDataPtr& get_web_page_data() const {
    CHECK(tag_ == Tag::kWebPageData);
    return data_.web_page_data;
  }
  WebPageDataPtr& get_web_page_data() {
    CHECK(tag_ == Tag::kWebPageData);
    return data_.web_page_data;
  }
  void set_web_page_data(WebPageDataPtr web_page_data);

  bool is_annotated_page_data() const { return tag_ == Tag::kAnnotatedPageData; }
  const AnnotatedPageDataPtr& get_annotated_page_data() const {
    CHECK(tag_ == Tag::kAnnotatedPageData);
    return data_.annotated_page_data;
  }
  AnnotatedPageDataPtr& get_annotated_page_data() {
    CHECK(tag_ == Tag::kAnnotatedPageData);
    return data_.annotated_page_data;
  }
  void set_annotated_page_data(AnnotatedPageDataPtr annotated_page_data);

  bool is_pdf_document_data() const { return tag_ == Tag::kPdfDocumentData; }
  const PdfDocumentDataPtr& get_pdf_document_data() const {
    CHECK(tag_ == Tag::kPdfDocumentData);
    return data_.pdf_document_data;
  }
  PdfDocumentDataPtr& get_pdf_document_data() {
    CHECK(tag_ == Tag::kPdfDocumentData);
    return data_.pdf_document_data;
  }
  void set_pdf_document_data(PdfDocumentDataPtr pdf_document_data);

  bool is_tab_context() const { return tag_ == Tag::kTabContext; }
  const TabContextPtr& get_tab_context() const {
    CHECK(tag_ == Tag::kTabContext);
    return data_.tab_context;
  }
  TabContextPtr& get_tab_context() {
    CHECK(tag_ == Tag::kTabContext);
    return data_.tab_context;
  }
  void set_tab_context(TabContextPtr tab_context);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdditionalContextPart::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AdditionalContextPart::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
        ContextDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
        ScreenshotPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kWebPageData)>,
        WebPageDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAnnotatedPageData)>,
        AnnotatedPageDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPdfDocumentData)>,
        PdfDocumentDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTabContext)>,
        TabContextPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ContextDataPtr data;
    ScreenshotPtr screenshot;
    WebPageDataPtr web_page_data;
    AnnotatedPageDataPtr annotated_page_data;
    PdfDocumentDataPtr pdf_document_data;
    TabContextPtr tab_context;
  };

  AdditionalContextPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
      ContextDataPtr value);
  AdditionalContextPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kScreenshot)>,
      ScreenshotPtr value);
  AdditionalContextPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kWebPageData)>,
      WebPageDataPtr value);
  AdditionalContextPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kAnnotatedPageData)>,
      AnnotatedPageDataPtr value);
  AdditionalContextPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kPdfDocumentData)>,
      PdfDocumentDataPtr value);
  AdditionalContextPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kTabContext)>,
      TabContextPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  FocusedTabData {
 public:
  using DataView = FocusedTabDataDataView;
  using Data_ = internal::FocusedTabData_Data;
  using Tag = Data_::FocusedTabData_Tag;

  template <typename... Args>
  static FocusedTabDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |focused_tab|.
  static FocusedTabDataPtr NewFocusedTab(
      TabDataPtr value);
  // Construct an instance holding |no_focused_tab_data|.
  static FocusedTabDataPtr NewNoFocusedTabData(
      NoFocusedTabDataPtr value);

  template <typename U>
  static FocusedTabDataPtr From(const U& u) {
    return mojo::TypeConverter<FocusedTabDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FocusedTabData>::Convert(*this);
  }
  ~FocusedTabData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FocusedTabData(const FocusedTabData& other) = delete;
  FocusedTabData& operator=(const FocusedTabData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FocusedTabDataPtr>
  FocusedTabDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FocusedTabData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FocusedTabData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_focused_tab() const { return tag_ == Tag::kFocusedTab; }
  const TabDataPtr& get_focused_tab() const {
    CHECK(tag_ == Tag::kFocusedTab);
    return data_.focused_tab;
  }
  TabDataPtr& get_focused_tab() {
    CHECK(tag_ == Tag::kFocusedTab);
    return data_.focused_tab;
  }
  void set_focused_tab(TabDataPtr focused_tab);

  bool is_no_focused_tab_data() const { return tag_ == Tag::kNoFocusedTabData; }
  const NoFocusedTabDataPtr& get_no_focused_tab_data() const {
    CHECK(tag_ == Tag::kNoFocusedTabData);
    return data_.no_focused_tab_data;
  }
  NoFocusedTabDataPtr& get_no_focused_tab_data() {
    CHECK(tag_ == Tag::kNoFocusedTabData);
    return data_.no_focused_tab_data;
  }
  void set_no_focused_tab_data(NoFocusedTabDataPtr no_focused_tab_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FocusedTabData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FocusedTabData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFocusedTab)>,
        TabDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNoFocusedTabData)>,
        NoFocusedTabDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    TabDataPtr focused_tab;
    NoFocusedTabDataPtr no_focused_tab_data;
  };

  FocusedTabData(
      std::in_place_index_t<static_cast<size_t>(Tag::kFocusedTab)>,
      TabDataPtr value);
  FocusedTabData(
      std::in_place_index_t<static_cast<size_t>(Tag::kNoFocusedTabData)>,
      NoFocusedTabDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  CapturedRegion {
 public:
  using DataView = CapturedRegionDataView;
  using Data_ = internal::CapturedRegion_Data;
  using Tag = Data_::CapturedRegion_Tag;

  template <typename... Args>
  static CapturedRegionPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |rect|.
  static CapturedRegionPtr NewRect(
      const ::gfx::Rect& value);

  template <typename U>
  static CapturedRegionPtr From(const U& u) {
    return mojo::TypeConverter<CapturedRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CapturedRegion>::Convert(*this);
  }
  ~CapturedRegion();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CapturedRegion(const CapturedRegion& other) = delete;
  CapturedRegion& operator=(const CapturedRegion& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CapturedRegionPtr>
  CapturedRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CapturedRegion>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CapturedRegion>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_rect() const { return tag_ == Tag::kRect; }
  const ::gfx::Rect& get_rect() const {
    CHECK(tag_ == Tag::kRect);
    return data_.rect;
  }
  ::gfx::Rect& get_rect() {
    CHECK(tag_ == Tag::kRect);
    return data_.rect;
  }
  void set_rect(const ::gfx::Rect& rect);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CapturedRegion::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CapturedRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRect)>,
        const ::gfx::Rect& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::gfx::Rect rect;
  };

  CapturedRegion(
      std::in_place_index_t<static_cast<size_t>(Tag::kRect)>,
      const ::gfx::Rect& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  ViewChangeRequestDetails {
 public:
  using DataView = ViewChangeRequestDetailsDataView;
  using Data_ = internal::ViewChangeRequestDetails_Data;
  using Tag = Data_::ViewChangeRequestDetails_Tag;

  template <typename... Args>
  static ViewChangeRequestDetailsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |actuation|.
  static ViewChangeRequestDetailsPtr NewActuation(
      ViewChangeRequestActuationPtr value);
  // Construct an instance holding |conversation|.
  static ViewChangeRequestDetailsPtr NewConversation(
      ViewChangeRequestConversationPtr value);

  template <typename U>
  static ViewChangeRequestDetailsPtr From(const U& u) {
    return mojo::TypeConverter<ViewChangeRequestDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewChangeRequestDetails>::Convert(*this);
  }
  ~ViewChangeRequestDetails();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ViewChangeRequestDetails(const ViewChangeRequestDetails& other) = delete;
  ViewChangeRequestDetails& operator=(const ViewChangeRequestDetails& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ViewChangeRequestDetailsPtr>
  ViewChangeRequestDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ViewChangeRequestDetails>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ViewChangeRequestDetails>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_actuation() const { return tag_ == Tag::kActuation; }
  const ViewChangeRequestActuationPtr& get_actuation() const {
    CHECK(tag_ == Tag::kActuation);
    return data_.actuation;
  }
  ViewChangeRequestActuationPtr& get_actuation() {
    CHECK(tag_ == Tag::kActuation);
    return data_.actuation;
  }
  void set_actuation(ViewChangeRequestActuationPtr actuation);

  bool is_conversation() const { return tag_ == Tag::kConversation; }
  const ViewChangeRequestConversationPtr& get_conversation() const {
    CHECK(tag_ == Tag::kConversation);
    return data_.conversation;
  }
  ViewChangeRequestConversationPtr& get_conversation() {
    CHECK(tag_ == Tag::kConversation);
    return data_.conversation;
  }
  void set_conversation(ViewChangeRequestConversationPtr conversation);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewChangeRequestDetails::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ViewChangeRequestDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kActuation)>,
        ViewChangeRequestActuationPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kConversation)>,
        ViewChangeRequestConversationPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ViewChangeRequestActuationPtr actuation;
    ViewChangeRequestConversationPtr conversation;
  };

  ViewChangeRequestDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kActuation)>,
      ViewChangeRequestActuationPtr value);
  ViewChangeRequestDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kConversation)>,
      ViewChangeRequestConversationPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  WebClientHandler_CreateTask_ResponseParam_Result {
 public:
  using DataView = WebClientHandler_CreateTask_ResponseParam_ResultDataView;
  using Data_ = internal::WebClientHandler_CreateTask_ResponseParam_Result_Data;
  using Tag = Data_::WebClientHandler_CreateTask_ResponseParam_Result_Tag;

  template <typename... Args>
  static WebClientHandler_CreateTask_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static WebClientHandler_CreateTask_ResponseParam_ResultPtr NewSuccess(
      int32_t value);
  // Construct an instance holding |failure|.
  static WebClientHandler_CreateTask_ResponseParam_ResultPtr NewFailure(
      CreateTaskErrorReason value);

  template <typename U>
  static WebClientHandler_CreateTask_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<WebClientHandler_CreateTask_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebClientHandler_CreateTask_ResponseParam_Result>::Convert(*this);
  }
  ~WebClientHandler_CreateTask_ResponseParam_Result();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebClientHandler_CreateTask_ResponseParam_ResultPtr>
  WebClientHandler_CreateTask_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebClientHandler_CreateTask_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebClientHandler_CreateTask_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  int32_t get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(int32_t success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  CreateTaskErrorReason get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(CreateTaskErrorReason failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebClientHandler_CreateTask_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebClientHandler_CreateTask_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        int32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        CreateTaskErrorReason value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    int32_t success;
    CreateTaskErrorReason failure;
  };

  WebClientHandler_CreateTask_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      int32_t value);
  WebClientHandler_CreateTask_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      CreateTaskErrorReason value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  WebClientHandler_PerformActions_ResponseParam_Result {
 public:
  using DataView = WebClientHandler_PerformActions_ResponseParam_ResultDataView;
  using Data_ = internal::WebClientHandler_PerformActions_ResponseParam_Result_Data;
  using Tag = Data_::WebClientHandler_PerformActions_ResponseParam_Result_Tag;

  template <typename... Args>
  static WebClientHandler_PerformActions_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static WebClientHandler_PerformActions_ResponseParam_ResultPtr NewSuccess(
      ::mojo_base::ProtoWrapper value);
  // Construct an instance holding |failure|.
  static WebClientHandler_PerformActions_ResponseParam_ResultPtr NewFailure(
      PerformActionsErrorReason value);

  template <typename U>
  static WebClientHandler_PerformActions_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<WebClientHandler_PerformActions_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebClientHandler_PerformActions_ResponseParam_Result>::Convert(*this);
  }
  ~WebClientHandler_PerformActions_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  WebClientHandler_PerformActions_ResponseParam_Result(const WebClientHandler_PerformActions_ResponseParam_Result& other) = delete;
  WebClientHandler_PerformActions_ResponseParam_Result& operator=(const WebClientHandler_PerformActions_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = WebClientHandler_PerformActions_ResponseParam_ResultPtr>
  WebClientHandler_PerformActions_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebClientHandler_PerformActions_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, WebClientHandler_PerformActions_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::mojo_base::ProtoWrapper& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::mojo_base::ProtoWrapper& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(::mojo_base::ProtoWrapper success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  PerformActionsErrorReason get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(PerformActionsErrorReason failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebClientHandler_PerformActions_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<WebClientHandler_PerformActions_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        ::mojo_base::ProtoWrapper value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        PerformActionsErrorReason value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo_base::ProtoWrapper success;
    PerformActionsErrorReason failure;
  };

  WebClientHandler_PerformActions_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      ::mojo_base::ProtoWrapper value);
  WebClientHandler_PerformActions_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      PerformActionsErrorReason value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  GetContextResultWithActionResultCode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetContextResultWithActionResultCode, T>::value>;
  using DataView = GetContextResultWithActionResultCodeDataView;
  using Data_ = internal::GetContextResultWithActionResultCode_Data;

  template <typename... Args>
  static GetContextResultWithActionResultCodePtr New(Args&&... args) {
    return GetContextResultWithActionResultCodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetContextResultWithActionResultCodePtr From(const U& u) {
    return mojo::TypeConverter<GetContextResultWithActionResultCodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetContextResultWithActionResultCode>::Convert(*this);
  }


  GetContextResultWithActionResultCode();

  GetContextResultWithActionResultCode(
      GetContextResultPtr get_context_result,
      std::optional<int32_t> action_result);

GetContextResultWithActionResultCode(const GetContextResultWithActionResultCode&) = delete;
GetContextResultWithActionResultCode& operator=(const GetContextResultWithActionResultCode&) = delete;

  ~GetContextResultWithActionResultCode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetContextResultWithActionResultCodePtr>
  GetContextResultWithActionResultCodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetContextResultWithActionResultCode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetContextResultWithActionResultCode_UnserializedMessageContext<
            UserType, GetContextResultWithActionResultCode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetContextResultWithActionResultCode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetContextResultWithActionResultCode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetContextResultWithActionResultCode_UnserializedMessageContext<
            UserType, GetContextResultWithActionResultCode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetContextResultWithActionResultCode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GetContextResultPtr get_context_result;
  
  std::optional<int32_t> action_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserProfileInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserProfileInfo, T>::value>;
  using DataView = UserProfileInfoDataView;
  using Data_ = internal::UserProfileInfo_Data;

  template <typename... Args>
  static UserProfileInfoPtr New(Args&&... args) {
    return UserProfileInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserProfileInfoPtr From(const U& u) {
    return mojo::TypeConverter<UserProfileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserProfileInfo>::Convert(*this);
  }


  UserProfileInfo();

  UserProfileInfo(
      const ::SkBitmap& avatar_icon,
      const std::string& display_name,
      const std::string& local_profile_name,
      const std::string& email,
      const std::string& given_name,
      bool is_managed);


  ~UserProfileInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserProfileInfoPtr>
  UserProfileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserProfileInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserProfileInfo_UnserializedMessageContext<
            UserType, UserProfileInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserProfileInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserProfileInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserProfileInfo_UnserializedMessageContext<
            UserType, UserProfileInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserProfileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkBitmap avatar_icon;
  
  std::string display_name;
  
  std::string local_profile_name;
  
  std::string email;
  
  std::string given_name;
  
  bool is_managed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserProfileInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebClientInitialState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebClientInitialState, T>::value>;
  using DataView = WebClientInitialStateDataView;
  using Data_ = internal::WebClientInitialState_Data;

  template <typename... Args>
  static WebClientInitialStatePtr New(Args&&... args) {
    return WebClientInitialStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebClientInitialStatePtr From(const U& u) {
    return mojo::TypeConverter<WebClientInitialStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebClientInitialState>::Convert(*this);
  }


  WebClientInitialState();

  WebClientInitialState(
      PanelStatePtr panel_state,
      FocusedTabDataPtr focused_tab_data,
      bool microphone_permission_enabled,
      bool location_permission_enabled,
      bool tab_context_permission_enabled,
      bool os_location_permission_enabled,
      const std::string& hotkey,
      const ::base::Version& chrome_version,
      Platform platform,
      bool can_attach,
      bool panel_is_active,
      bool browser_is_open,
      bool instance_is_active,
      bool always_detached_mode,
      bool enable_zero_state_suggestions,
      bool enable_act_in_focused_tab,
      bool enable_scroll_to,
      bool enable_default_tab_context_setting_feature,
      bool default_tab_context_setting_enabled,
      bool enable_closed_captioning_feature,
      bool closed_captioning_setting_enabled,
      bool enable_maybe_refresh_user_status,
      bool enable_multi_tab,
      bool enable_get_context_actor,
      std::vector<HostCapability> host_capabilities,
      bool enable_get_page_metadata,
      bool enable_api_activation_gating,
      bool enable_capture_region,
      bool enable_web_actuation_setting_feature,
      bool actuation_on_web_setting_enabled,
      bool can_act_on_web,
      bool enable_activate_tab,
      bool enable_get_tab_by_id,
      bool enable_open_password_manager_settings_page,
      bool enable_load_and_extract_content,
      bool enable_trust_first_onboarding,
      bool onboarding_completed);

WebClientInitialState(const WebClientInitialState&) = delete;
WebClientInitialState& operator=(const WebClientInitialState&) = delete;

  ~WebClientInitialState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebClientInitialStatePtr>
  WebClientInitialStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebClientInitialState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebClientInitialState_UnserializedMessageContext<
            UserType, WebClientInitialState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebClientInitialState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebClientInitialState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebClientInitialState_UnserializedMessageContext<
            UserType, WebClientInitialState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebClientInitialState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PanelStatePtr panel_state;
  
  FocusedTabDataPtr focused_tab_data;
  
  bool microphone_permission_enabled;
  
  bool location_permission_enabled;
  
  bool tab_context_permission_enabled;
  
  bool os_location_permission_enabled;
  
  std::string hotkey;
  
  ::base::Version chrome_version;
  
  Platform platform;
  
  bool can_attach;
  
  bool panel_is_active;
  
  bool browser_is_open;
  
  bool instance_is_active;
  
  bool always_detached_mode;
  
  bool enable_zero_state_suggestions;
  
  bool enable_act_in_focused_tab;
  
  bool enable_scroll_to;
  
  bool enable_default_tab_context_setting_feature;
  
  bool default_tab_context_setting_enabled;
  
  bool enable_closed_captioning_feature;
  
  bool closed_captioning_setting_enabled;
  
  bool enable_maybe_refresh_user_status;
  
  bool enable_multi_tab;
  
  bool enable_get_context_actor;
  
  std::vector<HostCapability> host_capabilities;
  
  bool enable_get_page_metadata;
  
  bool enable_api_activation_gating;
  
  bool enable_capture_region;
  
  bool enable_web_actuation_setting_feature;
  
  bool actuation_on_web_setting_enabled;
  
  bool can_act_on_web;
  
  bool enable_activate_tab;
  
  bool enable_get_tab_by_id;
  
  bool enable_open_password_manager_settings_page;
  
  bool enable_load_and_extract_content;
  
  bool enable_trust_first_onboarding;
  
  bool onboarding_completed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebClientInitialState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GetTabContextOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetTabContextOptions, T>::value>;
  using DataView = GetTabContextOptionsDataView;
  using Data_ = internal::GetTabContextOptions_Data;

  template <typename... Args>
  static GetTabContextOptionsPtr New(Args&&... args) {
    return GetTabContextOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetTabContextOptionsPtr From(const U& u) {
    return mojo::TypeConverter<GetTabContextOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetTabContextOptions>::Convert(*this);
  }


  GetTabContextOptions();

  GetTabContextOptions(
      bool include_inner_text,
      uint32_t inner_text_bytes_limit,
      bool include_viewport_screenshot,
      bool include_annotated_page_content,
      uint32_t max_meta_tags,
      bool include_pdf,
      uint32_t pdf_size_limit,
      uint32_t annotated_page_content_mode);


  ~GetTabContextOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetTabContextOptionsPtr>
  GetTabContextOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetTabContextOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetTabContextOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetTabContextOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetTabContextOptions_UnserializedMessageContext<
            UserType, GetTabContextOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetTabContextOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetTabContextOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetTabContextOptions_UnserializedMessageContext<
            UserType, GetTabContextOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetTabContextOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_inner_text;
  
  uint32_t inner_text_bytes_limit;
  
  bool include_viewport_screenshot;
  
  bool include_annotated_page_content;
  
  uint32_t max_meta_tags;
  
  bool include_pdf;
  
  uint32_t pdf_size_limit;
  
  uint32_t annotated_page_content_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetTabContextOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ScrollToParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScrollToParams, T>::value>;
  using DataView = ScrollToParamsDataView;
  using Data_ = internal::ScrollToParams_Data;

  template <typename... Args>
  static ScrollToParamsPtr New(Args&&... args) {
    return ScrollToParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScrollToParamsPtr From(const U& u) {
    return mojo::TypeConverter<ScrollToParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScrollToParams>::Convert(*this);
  }


  ScrollToParams();

  ScrollToParams(
      ScrollToSelectorPtr selector,
      bool highlight,
      const std::optional<::base::UnguessableToken>& document_id,
      const std::optional<::GURL>& url);

ScrollToParams(const ScrollToParams&) = delete;
ScrollToParams& operator=(const ScrollToParams&) = delete;

  ~ScrollToParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScrollToParamsPtr>
  ScrollToParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScrollToParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScrollToParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScrollToParams_UnserializedMessageContext<
            UserType, ScrollToParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScrollToParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScrollToParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScrollToParams_UnserializedMessageContext<
            UserType, ScrollToParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScrollToParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ScrollToSelectorPtr selector;
  
  bool highlight;
  
  std::optional<::base::UnguessableToken> document_id;
  
  std::optional<::GURL> url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScrollToParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  ZeroStateSuggestions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ZeroStateSuggestions, T>::value>;
  using DataView = ZeroStateSuggestionsDataView;
  using Data_ = internal::ZeroStateSuggestions_Data;

  template <typename... Args>
  static ZeroStateSuggestionsPtr New(Args&&... args) {
    return ZeroStateSuggestionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ZeroStateSuggestionsPtr From(const U& u) {
    return mojo::TypeConverter<ZeroStateSuggestionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ZeroStateSuggestions>::Convert(*this);
  }


  ZeroStateSuggestions();

  ZeroStateSuggestions(
      std::vector<SuggestionContentPtr> suggestions,
      int32_t tab_id,
      const ::GURL& tab_url);

ZeroStateSuggestions(const ZeroStateSuggestions&) = delete;
ZeroStateSuggestions& operator=(const ZeroStateSuggestions&) = delete;

  ~ZeroStateSuggestions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ZeroStateSuggestionsPtr>
  ZeroStateSuggestionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ZeroStateSuggestions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ZeroStateSuggestions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ZeroStateSuggestions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ZeroStateSuggestions_UnserializedMessageContext<
            UserType, ZeroStateSuggestions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ZeroStateSuggestions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ZeroStateSuggestions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ZeroStateSuggestions_UnserializedMessageContext<
            UserType, ZeroStateSuggestions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ZeroStateSuggestions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SuggestionContentPtr> suggestions;
  
  int32_t tab_id;
  
  ::GURL tab_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ZeroStateSuggestions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ZeroStateSuggestionsV2 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ZeroStateSuggestionsV2, T>::value>;
  using DataView = ZeroStateSuggestionsV2DataView;
  using Data_ = internal::ZeroStateSuggestionsV2_Data;

  template <typename... Args>
  static ZeroStateSuggestionsV2Ptr New(Args&&... args) {
    return ZeroStateSuggestionsV2Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ZeroStateSuggestionsV2Ptr From(const U& u) {
    return mojo::TypeConverter<ZeroStateSuggestionsV2Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ZeroStateSuggestionsV2>::Convert(*this);
  }


  ZeroStateSuggestionsV2();

  ZeroStateSuggestionsV2(
      std::vector<SuggestionContentPtr> suggestions,
      bool is_pending);

ZeroStateSuggestionsV2(const ZeroStateSuggestionsV2&) = delete;
ZeroStateSuggestionsV2& operator=(const ZeroStateSuggestionsV2&) = delete;

  ~ZeroStateSuggestionsV2();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ZeroStateSuggestionsV2Ptr>
  ZeroStateSuggestionsV2Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ZeroStateSuggestionsV2::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ZeroStateSuggestionsV2::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ZeroStateSuggestionsV2::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ZeroStateSuggestionsV2_UnserializedMessageContext<
            UserType, ZeroStateSuggestionsV2::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ZeroStateSuggestionsV2::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ZeroStateSuggestionsV2::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ZeroStateSuggestionsV2_UnserializedMessageContext<
            UserType, ZeroStateSuggestionsV2::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ZeroStateSuggestionsV2::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SuggestionContentPtr> suggestions;
  
  bool is_pending;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ZeroStateSuggestionsOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ZeroStateSuggestionsOptions, T>::value>;
  using DataView = ZeroStateSuggestionsOptionsDataView;
  using Data_ = internal::ZeroStateSuggestionsOptions_Data;

  template <typename... Args>
  static ZeroStateSuggestionsOptionsPtr New(Args&&... args) {
    return ZeroStateSuggestionsOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ZeroStateSuggestionsOptionsPtr From(const U& u) {
    return mojo::TypeConverter<ZeroStateSuggestionsOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ZeroStateSuggestionsOptions>::Convert(*this);
  }


  ZeroStateSuggestionsOptions();

  ZeroStateSuggestionsOptions(
      bool is_first_run,
      std::vector<std::string> supported_tools);


  ~ZeroStateSuggestionsOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ZeroStateSuggestionsOptionsPtr>
  ZeroStateSuggestionsOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ZeroStateSuggestionsOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ZeroStateSuggestionsOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ZeroStateSuggestionsOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ZeroStateSuggestionsOptions_UnserializedMessageContext<
            UserType, ZeroStateSuggestionsOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ZeroStateSuggestionsOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ZeroStateSuggestionsOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ZeroStateSuggestionsOptions_UnserializedMessageContext<
            UserType, ZeroStateSuggestionsOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ZeroStateSuggestionsOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_first_run;
  
  std::vector<std::string> supported_tools;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PinCandidate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PinCandidate, T>::value>;
  using DataView = PinCandidateDataView;
  using Data_ = internal::PinCandidate_Data;

  template <typename... Args>
  static PinCandidatePtr New(Args&&... args) {
    return PinCandidatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PinCandidatePtr From(const U& u) {
    return mojo::TypeConverter<PinCandidatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PinCandidate>::Convert(*this);
  }


  PinCandidate();

  explicit PinCandidate(
      TabDataPtr tab_data);

PinCandidate(const PinCandidate&) = delete;
PinCandidate& operator=(const PinCandidate&) = delete;

  ~PinCandidate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PinCandidatePtr>
  PinCandidatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PinCandidate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PinCandidate_UnserializedMessageContext<
            UserType, PinCandidate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PinCandidate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PinCandidate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PinCandidate_UnserializedMessageContext<
            UserType, PinCandidate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PinCandidate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TabDataPtr tab_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PinCandidate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PanelOpeningData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PanelOpeningData, T>::value>;
  using DataView = PanelOpeningDataDataView;
  using Data_ = internal::PanelOpeningData_Data;

  template <typename... Args>
  static PanelOpeningDataPtr New(Args&&... args) {
    return PanelOpeningDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PanelOpeningDataPtr From(const U& u) {
    return mojo::TypeConverter<PanelOpeningDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PanelOpeningData>::Convert(*this);
  }


  PanelOpeningData();

  PanelOpeningData(
      PanelStatePtr panel_state,
      InvocationSource invocation_source,
      const std::optional<std::string>& conversation_id,
      const std::optional<std::string>& prompt_suggestion,
      std::optional<std::vector<ConversationInfoPtr>> recently_active_conversations);

PanelOpeningData(const PanelOpeningData&) = delete;
PanelOpeningData& operator=(const PanelOpeningData&) = delete;

  ~PanelOpeningData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PanelOpeningDataPtr>
  PanelOpeningDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PanelOpeningData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PanelOpeningData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PanelOpeningData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PanelOpeningData_UnserializedMessageContext<
            UserType, PanelOpeningData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PanelOpeningData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PanelOpeningData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PanelOpeningData_UnserializedMessageContext<
            UserType, PanelOpeningData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PanelOpeningData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PanelStatePtr panel_state;
  
  InvocationSource invocation_source;
  
  std::optional<std::string> conversation_id;
  
  std::optional<std::string> prompt_suggestion;
  
  std::optional<std::vector<ConversationInfoPtr>> recently_active_conversations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PanelOpeningData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  OpenPanelInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenPanelInfo, T>::value>;
  using DataView = OpenPanelInfoDataView;
  using Data_ = internal::OpenPanelInfo_Data;

  template <typename... Args>
  static OpenPanelInfoPtr New(Args&&... args) {
    return OpenPanelInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenPanelInfoPtr From(const U& u) {
    return mojo::TypeConverter<OpenPanelInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenPanelInfo>::Convert(*this);
  }


  OpenPanelInfo();

  OpenPanelInfo(
      WebClientMode web_client_mode,
      const std::optional<::gfx::Size>& panelSize,
      ::base::TimeDelta resizeDuration,
      bool can_user_resize);


  ~OpenPanelInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenPanelInfoPtr>
  OpenPanelInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenPanelInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenPanelInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenPanelInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenPanelInfo_UnserializedMessageContext<
            UserType, OpenPanelInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OpenPanelInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OpenPanelInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenPanelInfo_UnserializedMessageContext<
            UserType, OpenPanelInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenPanelInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WebClientMode web_client_mode;
  
  std::optional<::gfx::Size> panelSize;
  
  ::base::TimeDelta resizeDuration;
  
  bool can_user_resize;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenPanelInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ContextData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContextData, T>::value>;
  using DataView = ContextDataDataView;
  using Data_ = internal::ContextData_Data;

  template <typename... Args>
  static ContextDataPtr New(Args&&... args) {
    return ContextDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContextDataPtr From(const U& u) {
    return mojo::TypeConverter<ContextDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContextData>::Convert(*this);
  }


  ContextData();

  ContextData(
      const std::string& mime_type,
      ::mojo_base::BigBuffer data);

ContextData(const ContextData&) = delete;
ContextData& operator=(const ContextData&) = delete;

  ~ContextData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContextDataPtr>
  ContextDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContextData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContextData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContextData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContextData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContextData_UnserializedMessageContext<
            UserType, ContextData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContextData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContextData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContextData_UnserializedMessageContext<
            UserType, ContextData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContextData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mime_type;
  
  ::mojo_base::BigBuffer data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContextData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContextData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContextData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContextData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AdditionalContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdditionalContext, T>::value>;
  using DataView = AdditionalContextDataView;
  using Data_ = internal::AdditionalContext_Data;

  template <typename... Args>
  static AdditionalContextPtr New(Args&&... args) {
    return AdditionalContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdditionalContextPtr From(const U& u) {
    return mojo::TypeConverter<AdditionalContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdditionalContext>::Convert(*this);
  }


  AdditionalContext();

  AdditionalContext(
      const std::optional<std::string>& name,
      std::optional<int32_t> tab_id,
      const std::optional<::url::Origin>& origin,
      const std::optional<::GURL>& frameUrl,
      std::vector<AdditionalContextPartPtr> parts);

AdditionalContext(const AdditionalContext&) = delete;
AdditionalContext& operator=(const AdditionalContext&) = delete;

  ~AdditionalContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdditionalContextPtr>
  AdditionalContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdditionalContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdditionalContext_UnserializedMessageContext<
            UserType, AdditionalContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdditionalContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdditionalContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdditionalContext_UnserializedMessageContext<
            UserType, AdditionalContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdditionalContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> name;
  
  std::optional<int32_t> tab_id;
  
  std::optional<::url::Origin> origin;
  
  std::optional<::GURL> frameUrl;
  
  std::vector<AdditionalContextPartPtr> parts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdditionalContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabContext, T>::value>;
  using DataView = TabContextDataView;
  using Data_ = internal::TabContext_Data;

  template <typename... Args>
  static TabContextPtr New(Args&&... args) {
    return TabContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabContextPtr From(const U& u) {
    return mojo::TypeConverter<TabContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabContext>::Convert(*this);
  }


  TabContext();

  TabContext(
      TabDataPtr tab_data,
      WebPageDataPtr web_page_data,
      ScreenshotPtr viewport_screenshot,
      PdfDocumentDataPtr pdf_document_data,
      AnnotatedPageDataPtr annotated_page_data);

TabContext(const TabContext&) = delete;
TabContext& operator=(const TabContext&) = delete;

  ~TabContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabContextPtr>
  TabContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabContext_UnserializedMessageContext<
            UserType, TabContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabContext_UnserializedMessageContext<
            UserType, TabContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TabDataPtr tab_data;
  
  WebPageDataPtr web_page_data;
  
  ScreenshotPtr viewport_screenshot;
  
  PdfDocumentDataPtr pdf_document_data;
  
  AnnotatedPageDataPtr annotated_page_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebPageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebPageData, T>::value>;
  using DataView = WebPageDataDataView;
  using Data_ = internal::WebPageData_Data;

  template <typename... Args>
  static WebPageDataPtr New(Args&&... args) {
    return WebPageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebPageDataPtr From(const U& u) {
    return mojo::TypeConverter<WebPageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebPageData>::Convert(*this);
  }


  WebPageData();

  explicit WebPageData(
      DocumentDataPtr main_document);

WebPageData(const WebPageData&) = delete;
WebPageData& operator=(const WebPageData&) = delete;

  ~WebPageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebPageDataPtr>
  WebPageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPageData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebPageData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebPageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebPageData_UnserializedMessageContext<
            UserType, WebPageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebPageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebPageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebPageData_UnserializedMessageContext<
            UserType, WebPageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebPageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DocumentDataPtr main_document;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebPageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DocumentData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DocumentData, T>::value>;
  using DataView = DocumentDataDataView;
  using Data_ = internal::DocumentData_Data;

  template <typename... Args>
  static DocumentDataPtr New(Args&&... args) {
    return DocumentDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DocumentDataPtr From(const U& u) {
    return mojo::TypeConverter<DocumentDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DocumentData>::Convert(*this);
  }


  DocumentData();

  DocumentData(
      const ::url::Origin& origin,
      const std::string& inner_text,
      bool inner_text_truncated);


  ~DocumentData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DocumentDataPtr>
  DocumentDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DocumentData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DocumentData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DocumentData_UnserializedMessageContext<
            UserType, DocumentData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DocumentData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DocumentData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DocumentData_UnserializedMessageContext<
            UserType, DocumentData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DocumentData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::string inner_text;
  
  bool inner_text_truncated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DocumentData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PdfDocumentData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PdfDocumentData, T>::value>;
  using DataView = PdfDocumentDataDataView;
  using Data_ = internal::PdfDocumentData_Data;

  template <typename... Args>
  static PdfDocumentDataPtr New(Args&&... args) {
    return PdfDocumentDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PdfDocumentDataPtr From(const U& u) {
    return mojo::TypeConverter<PdfDocumentDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PdfDocumentData>::Convert(*this);
  }


  PdfDocumentData();

  PdfDocumentData(
      const ::url::Origin& origin,
      std::optional<std::vector<uint8_t>> pdf_data,
      bool size_limit_exceeded);


  ~PdfDocumentData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PdfDocumentDataPtr>
  PdfDocumentDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PdfDocumentData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PdfDocumentData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PdfDocumentData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PdfDocumentData_UnserializedMessageContext<
            UserType, PdfDocumentData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PdfDocumentData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PdfDocumentData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PdfDocumentData_UnserializedMessageContext<
            UserType, PdfDocumentData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PdfDocumentData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::optional<std::vector<uint8_t>> pdf_data;
  
  bool size_limit_exceeded;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PdfDocumentData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TabData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabData, T>::value>;
  using DataView = TabDataDataView;
  using Data_ = internal::TabData_Data;

  template <typename... Args>
  static TabDataPtr New(Args&&... args) {
    return TabDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabDataPtr From(const U& u) {
    return mojo::TypeConverter<TabDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabData>::Convert(*this);
  }


  TabData();

  TabData(
      int32_t tab_id,
      int32_t window_id,
      const ::GURL& url,
      const std::optional<std::string>& title,
      const ::SkBitmap& favicon,
      const std::optional<::GURL>& favicon_url,
      const std::string& document_mime_type,
      std::optional<bool> is_observable,
      std::optional<bool> is_media_active,
      std::optional<bool> is_tab_content_captured,
      std::optional<bool> is_active_in_window,
      std::optional<bool> is_window_active);


  ~TabData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabDataPtr>
  TabDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabData_UnserializedMessageContext<
            UserType, TabData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabData_UnserializedMessageContext<
            UserType, TabData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  int32_t window_id;
  
  ::GURL url;
  
  std::optional<std::string> title;
  
  ::SkBitmap favicon;
  
  std::optional<::GURL> favicon_url;
  
  std::string document_mime_type;
  
  std::optional<bool> is_observable;
  
  std::optional<bool> is_media_active;
  
  std::optional<bool> is_tab_content_captured;
  
  std::optional<bool> is_active_in_window;
  
  std::optional<bool> is_window_active;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NoFocusedTabData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NoFocusedTabData, T>::value>;
  using DataView = NoFocusedTabDataDataView;
  using Data_ = internal::NoFocusedTabData_Data;

  template <typename... Args>
  static NoFocusedTabDataPtr New(Args&&... args) {
    return NoFocusedTabDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NoFocusedTabDataPtr From(const U& u) {
    return mojo::TypeConverter<NoFocusedTabDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NoFocusedTabData>::Convert(*this);
  }


  NoFocusedTabData();

  NoFocusedTabData(
      TabDataPtr active_tab_data,
      const std::string& no_focus_reason);

NoFocusedTabData(const NoFocusedTabData&) = delete;
NoFocusedTabData& operator=(const NoFocusedTabData&) = delete;

  ~NoFocusedTabData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NoFocusedTabDataPtr>
  NoFocusedTabDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NoFocusedTabData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NoFocusedTabData_UnserializedMessageContext<
            UserType, NoFocusedTabData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NoFocusedTabData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NoFocusedTabData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NoFocusedTabData_UnserializedMessageContext<
            UserType, NoFocusedTabData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NoFocusedTabData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TabDataPtr active_tab_data;
  
  std::string no_focus_reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NoFocusedTabData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AnnotatedPageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnnotatedPageData, T>::value>;
  using DataView = AnnotatedPageDataDataView;
  using Data_ = internal::AnnotatedPageData_Data;

  template <typename... Args>
  static AnnotatedPageDataPtr New(Args&&... args) {
    return AnnotatedPageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnnotatedPageDataPtr From(const U& u) {
    return mojo::TypeConverter<AnnotatedPageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnnotatedPageData>::Convert(*this);
  }


  AnnotatedPageData();

  AnnotatedPageData(
      std::optional<::mojo_base::ProtoWrapper> annotated_page_content,
      ::blink::mojom::PageMetadataPtr metadata);

AnnotatedPageData(const AnnotatedPageData&) = delete;
AnnotatedPageData& operator=(const AnnotatedPageData&) = delete;

  ~AnnotatedPageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnnotatedPageDataPtr>
  AnnotatedPageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnnotatedPageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnnotatedPageData_UnserializedMessageContext<
            UserType, AnnotatedPageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnnotatedPageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnnotatedPageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnnotatedPageData_UnserializedMessageContext<
            UserType, AnnotatedPageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnnotatedPageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::mojo_base::ProtoWrapper> annotated_page_content;
  
  ::blink::mojom::PageMetadataPtr metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnnotatedPageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Journal {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Journal, T>::value>;
  using DataView = JournalDataView;
  using Data_ = internal::Journal_Data;

  template <typename... Args>
  static JournalPtr New(Args&&... args) {
    return JournalPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JournalPtr From(const U& u) {
    return mojo::TypeConverter<JournalPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Journal>::Convert(*this);
  }


  Journal();

  explicit Journal(
      std::vector<uint8_t> data);


  ~Journal();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JournalPtr>
  JournalPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Journal::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Journal::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Journal::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Journal::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Journal::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Journal::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Journal_UnserializedMessageContext<
            UserType, Journal::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Journal::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Journal::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Journal_UnserializedMessageContext<
            UserType, Journal::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Journal::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Journal::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Journal::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Journal::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Journal::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CaptureRegionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CaptureRegionResult, T>::value>;
  using DataView = CaptureRegionResultDataView;
  using Data_ = internal::CaptureRegionResult_Data;

  template <typename... Args>
  static CaptureRegionResultPtr New(Args&&... args) {
    return CaptureRegionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CaptureRegionResultPtr From(const U& u) {
    return mojo::TypeConverter<CaptureRegionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CaptureRegionResult>::Convert(*this);
  }


  CaptureRegionResult();

  CaptureRegionResult(
      int32_t tab_id,
      CapturedRegionPtr region);

CaptureRegionResult(const CaptureRegionResult&) = delete;
CaptureRegionResult& operator=(const CaptureRegionResult&) = delete;

  ~CaptureRegionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CaptureRegionResultPtr>
  CaptureRegionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CaptureRegionResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CaptureRegionResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CaptureRegionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CaptureRegionResult_UnserializedMessageContext<
            UserType, CaptureRegionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CaptureRegionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CaptureRegionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CaptureRegionResult_UnserializedMessageContext<
            UserType, CaptureRegionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CaptureRegionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  CapturedRegionPtr region;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CaptureRegionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Screenshot {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Screenshot, T>::value>;
  using DataView = ScreenshotDataView;
  using Data_ = internal::Screenshot_Data;

  template <typename... Args>
  static ScreenshotPtr New(Args&&... args) {
    return ScreenshotPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScreenshotPtr From(const U& u) {
    return mojo::TypeConverter<ScreenshotPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Screenshot>::Convert(*this);
  }


  Screenshot();

  Screenshot(
      uint32_t width_pixels,
      uint32_t height_pixels,
      std::vector<uint8_t> data,
      const std::string& mime_type,
      ImageOriginAnnotationsPtr origin_annotations);

Screenshot(const Screenshot&) = delete;
Screenshot& operator=(const Screenshot&) = delete;

  ~Screenshot();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScreenshotPtr>
  ScreenshotPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Screenshot::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Screenshot::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Screenshot::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Screenshot_UnserializedMessageContext<
            UserType, Screenshot::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Screenshot::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Screenshot::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Screenshot_UnserializedMessageContext<
            UserType, Screenshot::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Screenshot::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t width_pixels;
  
  uint32_t height_pixels;
  
  std::vector<uint8_t> data;
  
  std::string mime_type;
  
  ImageOriginAnnotationsPtr origin_annotations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Screenshot::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  ViewChangeRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewChangeRequest, T>::value>;
  using DataView = ViewChangeRequestDataView;
  using Data_ = internal::ViewChangeRequest_Data;

  template <typename... Args>
  static ViewChangeRequestPtr New(Args&&... args) {
    return ViewChangeRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewChangeRequestPtr From(const U& u) {
    return mojo::TypeConverter<ViewChangeRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewChangeRequest>::Convert(*this);
  }


  ViewChangeRequest();

  explicit ViewChangeRequest(
      ViewChangeRequestDetailsPtr details);

ViewChangeRequest(const ViewChangeRequest&) = delete;
ViewChangeRequest& operator=(const ViewChangeRequest&) = delete;

  ~ViewChangeRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewChangeRequestPtr>
  ViewChangeRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangeRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewChangeRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewChangeRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewChangeRequest_UnserializedMessageContext<
            UserType, ViewChangeRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewChangeRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewChangeRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewChangeRequest_UnserializedMessageContext<
            UserType, ViewChangeRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewChangeRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ViewChangeRequestDetailsPtr details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewChangeRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
GetContextResultPtr GetContextResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorReason:
      return NewErrorReason(
          mojo::Clone(data_.error_reason));
    case Tag::kTabContext:
      return NewTabContext(
          mojo::Clone(data_.tab_context));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetContextResult>::value>::type*>
bool GetContextResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorReason:
      return mojo::Equals(data_.error_reason, other.data_.error_reason);
    case Tag::kTabContext:
      return mojo::Equals(data_.tab_context, other.data_.tab_context);
  }

  return false;
}
template <typename UnionPtrType>
CaptureScreenshotResultPtr CaptureScreenshotResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorReason:
      return NewErrorReason(
          mojo::Clone(data_.error_reason));
    case Tag::kScreenshot:
      return NewScreenshot(
          mojo::Clone(data_.screenshot));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CaptureScreenshotResult>::value>::type*>
bool CaptureScreenshotResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorReason:
      return mojo::Equals(data_.error_reason, other.data_.error_reason);
    case Tag::kScreenshot:
      return mojo::Equals(data_.screenshot, other.data_.screenshot);
  }

  return false;
}
template <typename UnionPtrType>
ScrollToSelectorPtr ScrollToSelector::Clone() const {
  switch (tag_) {
    case Tag::kExactTextSelector:
      return NewExactTextSelector(
          mojo::Clone(data_.exact_text_selector));
    case Tag::kTextFragmentSelector:
      return NewTextFragmentSelector(
          mojo::Clone(data_.text_fragment_selector));
    case Tag::kNodeSelector:
      return NewNodeSelector(
          mojo::Clone(data_.node_selector));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ScrollToSelector>::value>::type*>
bool ScrollToSelector::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kExactTextSelector:
      return mojo::Equals(data_.exact_text_selector, other.data_.exact_text_selector);
    case Tag::kTextFragmentSelector:
      return mojo::Equals(data_.text_fragment_selector, other.data_.text_fragment_selector);
    case Tag::kNodeSelector:
      return mojo::Equals(data_.node_selector, other.data_.node_selector);
  }

  return false;
}
template <typename UnionPtrType>
AdditionalContextPartPtr AdditionalContextPart::Clone() const {
  switch (tag_) {
    case Tag::kData:
      return NewData(
          mojo::Clone(data_.data));
    case Tag::kScreenshot:
      return NewScreenshot(
          mojo::Clone(data_.screenshot));
    case Tag::kWebPageData:
      return NewWebPageData(
          mojo::Clone(data_.web_page_data));
    case Tag::kAnnotatedPageData:
      return NewAnnotatedPageData(
          mojo::Clone(data_.annotated_page_data));
    case Tag::kPdfDocumentData:
      return NewPdfDocumentData(
          mojo::Clone(data_.pdf_document_data));
    case Tag::kTabContext:
      return NewTabContext(
          mojo::Clone(data_.tab_context));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AdditionalContextPart>::value>::type*>
bool AdditionalContextPart::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kData:
      return mojo::Equals(data_.data, other.data_.data);
    case Tag::kScreenshot:
      return mojo::Equals(data_.screenshot, other.data_.screenshot);
    case Tag::kWebPageData:
      return mojo::Equals(data_.web_page_data, other.data_.web_page_data);
    case Tag::kAnnotatedPageData:
      return mojo::Equals(data_.annotated_page_data, other.data_.annotated_page_data);
    case Tag::kPdfDocumentData:
      return mojo::Equals(data_.pdf_document_data, other.data_.pdf_document_data);
    case Tag::kTabContext:
      return mojo::Equals(data_.tab_context, other.data_.tab_context);
  }

  return false;
}
template <typename UnionPtrType>
FocusedTabDataPtr FocusedTabData::Clone() const {
  switch (tag_) {
    case Tag::kFocusedTab:
      return NewFocusedTab(
          mojo::Clone(data_.focused_tab));
    case Tag::kNoFocusedTabData:
      return NewNoFocusedTabData(
          mojo::Clone(data_.no_focused_tab_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FocusedTabData>::value>::type*>
bool FocusedTabData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFocusedTab:
      return mojo::Equals(data_.focused_tab, other.data_.focused_tab);
    case Tag::kNoFocusedTabData:
      return mojo::Equals(data_.no_focused_tab_data, other.data_.no_focused_tab_data);
  }

  return false;
}
template <typename UnionPtrType>
CapturedRegionPtr CapturedRegion::Clone() const {
  switch (tag_) {
    case Tag::kRect:
      return NewRect(
          mojo::Clone(data_.rect));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CapturedRegion>::value>::type*>
bool CapturedRegion::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRect:
      return mojo::Equals(data_.rect, other.data_.rect);
  }

  return false;
}
template <typename UnionPtrType>
ViewChangeRequestDetailsPtr ViewChangeRequestDetails::Clone() const {
  switch (tag_) {
    case Tag::kActuation:
      return NewActuation(
          mojo::Clone(data_.actuation));
    case Tag::kConversation:
      return NewConversation(
          mojo::Clone(data_.conversation));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ViewChangeRequestDetails>::value>::type*>
bool ViewChangeRequestDetails::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kActuation:
      return mojo::Equals(data_.actuation, other.data_.actuation);
    case Tag::kConversation:
      return mojo::Equals(data_.conversation, other.data_.conversation);
  }

  return false;
}
template <typename UnionPtrType>
WebClientHandler_CreateTask_ResponseParam_ResultPtr WebClientHandler_CreateTask_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebClientHandler_CreateTask_ResponseParam_Result>::value>::type*>
bool WebClientHandler_CreateTask_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename UnionPtrType>
WebClientHandler_PerformActions_ResponseParam_ResultPtr WebClientHandler_PerformActions_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, WebClientHandler_PerformActions_ResponseParam_Result>::value>::type*>
bool WebClientHandler_PerformActions_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}
template <typename StructPtrType>
GetContextResultWithActionResultCodePtr GetContextResultWithActionResultCode::Clone() const {
  return New(
      mojo::Clone(get_context_result),
      mojo::Clone(action_result)
  );
}

template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>*>
bool GetContextResultWithActionResultCode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->get_context_result, other_struct.get_context_result))
    return false;
  if (!mojo::Equals(this->action_result, other_struct.action_result))
    return false;
  return true;
}

template <typename T, GetContextResultWithActionResultCode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.get_context_result < rhs.get_context_result)
    return true;
  if (rhs.get_context_result < lhs.get_context_result)
    return false;
  if (lhs.action_result < rhs.action_result)
    return true;
  if (rhs.action_result < lhs.action_result)
    return false;
  return false;
}
template <typename StructPtrType>
UserProfileInfoPtr UserProfileInfo::Clone() const {
  return New(
      mojo::Clone(avatar_icon),
      mojo::Clone(display_name),
      mojo::Clone(local_profile_name),
      mojo::Clone(email),
      mojo::Clone(given_name),
      mojo::Clone(is_managed)
  );
}

template <typename T, UserProfileInfo::EnableIfSame<T>*>
bool UserProfileInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->avatar_icon, other_struct.avatar_icon))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->local_profile_name, other_struct.local_profile_name))
    return false;
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  if (!mojo::Equals(this->given_name, other_struct.given_name))
    return false;
  if (!mojo::Equals(this->is_managed, other_struct.is_managed))
    return false;
  return true;
}

template <typename T, UserProfileInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.avatar_icon < rhs.avatar_icon)
    return true;
  if (rhs.avatar_icon < lhs.avatar_icon)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.local_profile_name < rhs.local_profile_name)
    return true;
  if (rhs.local_profile_name < lhs.local_profile_name)
    return false;
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  if (lhs.given_name < rhs.given_name)
    return true;
  if (rhs.given_name < lhs.given_name)
    return false;
  if (lhs.is_managed < rhs.is_managed)
    return true;
  if (rhs.is_managed < lhs.is_managed)
    return false;
  return false;
}
template <typename StructPtrType>
WebClientInitialStatePtr WebClientInitialState::Clone() const {
  return New(
      mojo::Clone(panel_state),
      mojo::Clone(focused_tab_data),
      mojo::Clone(microphone_permission_enabled),
      mojo::Clone(location_permission_enabled),
      mojo::Clone(tab_context_permission_enabled),
      mojo::Clone(os_location_permission_enabled),
      mojo::Clone(hotkey),
      mojo::Clone(chrome_version),
      mojo::Clone(platform),
      mojo::Clone(can_attach),
      mojo::Clone(panel_is_active),
      mojo::Clone(browser_is_open),
      mojo::Clone(instance_is_active),
      mojo::Clone(always_detached_mode),
      mojo::Clone(enable_zero_state_suggestions),
      mojo::Clone(enable_act_in_focused_tab),
      mojo::Clone(enable_scroll_to),
      mojo::Clone(enable_default_tab_context_setting_feature),
      mojo::Clone(default_tab_context_setting_enabled),
      mojo::Clone(enable_closed_captioning_feature),
      mojo::Clone(closed_captioning_setting_enabled),
      mojo::Clone(enable_maybe_refresh_user_status),
      mojo::Clone(enable_multi_tab),
      mojo::Clone(enable_get_context_actor),
      mojo::Clone(host_capabilities),
      mojo::Clone(enable_get_page_metadata),
      mojo::Clone(enable_api_activation_gating),
      mojo::Clone(enable_capture_region),
      mojo::Clone(enable_web_actuation_setting_feature),
      mojo::Clone(actuation_on_web_setting_enabled),
      mojo::Clone(can_act_on_web),
      mojo::Clone(enable_activate_tab),
      mojo::Clone(enable_get_tab_by_id),
      mojo::Clone(enable_open_password_manager_settings_page),
      mojo::Clone(enable_load_and_extract_content),
      mojo::Clone(enable_trust_first_onboarding),
      mojo::Clone(onboarding_completed)
  );
}

template <typename T, WebClientInitialState::EnableIfSame<T>*>
bool WebClientInitialState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->panel_state, other_struct.panel_state))
    return false;
  if (!mojo::Equals(this->focused_tab_data, other_struct.focused_tab_data))
    return false;
  if (!mojo::Equals(this->microphone_permission_enabled, other_struct.microphone_permission_enabled))
    return false;
  if (!mojo::Equals(this->location_permission_enabled, other_struct.location_permission_enabled))
    return false;
  if (!mojo::Equals(this->tab_context_permission_enabled, other_struct.tab_context_permission_enabled))
    return false;
  if (!mojo::Equals(this->os_location_permission_enabled, other_struct.os_location_permission_enabled))
    return false;
  if (!mojo::Equals(this->hotkey, other_struct.hotkey))
    return false;
  if (!mojo::Equals(this->chrome_version, other_struct.chrome_version))
    return false;
  if (!mojo::Equals(this->platform, other_struct.platform))
    return false;
  if (!mojo::Equals(this->can_attach, other_struct.can_attach))
    return false;
  if (!mojo::Equals(this->panel_is_active, other_struct.panel_is_active))
    return false;
  if (!mojo::Equals(this->browser_is_open, other_struct.browser_is_open))
    return false;
  if (!mojo::Equals(this->instance_is_active, other_struct.instance_is_active))
    return false;
  if (!mojo::Equals(this->always_detached_mode, other_struct.always_detached_mode))
    return false;
  if (!mojo::Equals(this->enable_zero_state_suggestions, other_struct.enable_zero_state_suggestions))
    return false;
  if (!mojo::Equals(this->enable_act_in_focused_tab, other_struct.enable_act_in_focused_tab))
    return false;
  if (!mojo::Equals(this->enable_scroll_to, other_struct.enable_scroll_to))
    return false;
  if (!mojo::Equals(this->enable_default_tab_context_setting_feature, other_struct.enable_default_tab_context_setting_feature))
    return false;
  if (!mojo::Equals(this->default_tab_context_setting_enabled, other_struct.default_tab_context_setting_enabled))
    return false;
  if (!mojo::Equals(this->enable_closed_captioning_feature, other_struct.enable_closed_captioning_feature))
    return false;
  if (!mojo::Equals(this->closed_captioning_setting_enabled, other_struct.closed_captioning_setting_enabled))
    return false;
  if (!mojo::Equals(this->enable_maybe_refresh_user_status, other_struct.enable_maybe_refresh_user_status))
    return false;
  if (!mojo::Equals(this->enable_multi_tab, other_struct.enable_multi_tab))
    return false;
  if (!mojo::Equals(this->enable_get_context_actor, other_struct.enable_get_context_actor))
    return false;
  if (!mojo::Equals(this->host_capabilities, other_struct.host_capabilities))
    return false;
  if (!mojo::Equals(this->enable_get_page_metadata, other_struct.enable_get_page_metadata))
    return false;
  if (!mojo::Equals(this->enable_api_activation_gating, other_struct.enable_api_activation_gating))
    return false;
  if (!mojo::Equals(this->enable_capture_region, other_struct.enable_capture_region))
    return false;
  if (!mojo::Equals(this->enable_web_actuation_setting_feature, other_struct.enable_web_actuation_setting_feature))
    return false;
  if (!mojo::Equals(this->actuation_on_web_setting_enabled, other_struct.actuation_on_web_setting_enabled))
    return false;
  if (!mojo::Equals(this->can_act_on_web, other_struct.can_act_on_web))
    return false;
  if (!mojo::Equals(this->enable_activate_tab, other_struct.enable_activate_tab))
    return false;
  if (!mojo::Equals(this->enable_get_tab_by_id, other_struct.enable_get_tab_by_id))
    return false;
  if (!mojo::Equals(this->enable_open_password_manager_settings_page, other_struct.enable_open_password_manager_settings_page))
    return false;
  if (!mojo::Equals(this->enable_load_and_extract_content, other_struct.enable_load_and_extract_content))
    return false;
  if (!mojo::Equals(this->enable_trust_first_onboarding, other_struct.enable_trust_first_onboarding))
    return false;
  if (!mojo::Equals(this->onboarding_completed, other_struct.onboarding_completed))
    return false;
  return true;
}

template <typename T, WebClientInitialState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.panel_state < rhs.panel_state)
    return true;
  if (rhs.panel_state < lhs.panel_state)
    return false;
  if (lhs.focused_tab_data < rhs.focused_tab_data)
    return true;
  if (rhs.focused_tab_data < lhs.focused_tab_data)
    return false;
  if (lhs.microphone_permission_enabled < rhs.microphone_permission_enabled)
    return true;
  if (rhs.microphone_permission_enabled < lhs.microphone_permission_enabled)
    return false;
  if (lhs.location_permission_enabled < rhs.location_permission_enabled)
    return true;
  if (rhs.location_permission_enabled < lhs.location_permission_enabled)
    return false;
  if (lhs.tab_context_permission_enabled < rhs.tab_context_permission_enabled)
    return true;
  if (rhs.tab_context_permission_enabled < lhs.tab_context_permission_enabled)
    return false;
  if (lhs.os_location_permission_enabled < rhs.os_location_permission_enabled)
    return true;
  if (rhs.os_location_permission_enabled < lhs.os_location_permission_enabled)
    return false;
  if (lhs.hotkey < rhs.hotkey)
    return true;
  if (rhs.hotkey < lhs.hotkey)
    return false;
  if (lhs.chrome_version < rhs.chrome_version)
    return true;
  if (rhs.chrome_version < lhs.chrome_version)
    return false;
  if (lhs.platform < rhs.platform)
    return true;
  if (rhs.platform < lhs.platform)
    return false;
  if (lhs.can_attach < rhs.can_attach)
    return true;
  if (rhs.can_attach < lhs.can_attach)
    return false;
  if (lhs.panel_is_active < rhs.panel_is_active)
    return true;
  if (rhs.panel_is_active < lhs.panel_is_active)
    return false;
  if (lhs.browser_is_open < rhs.browser_is_open)
    return true;
  if (rhs.browser_is_open < lhs.browser_is_open)
    return false;
  if (lhs.instance_is_active < rhs.instance_is_active)
    return true;
  if (rhs.instance_is_active < lhs.instance_is_active)
    return false;
  if (lhs.always_detached_mode < rhs.always_detached_mode)
    return true;
  if (rhs.always_detached_mode < lhs.always_detached_mode)
    return false;
  if (lhs.enable_zero_state_suggestions < rhs.enable_zero_state_suggestions)
    return true;
  if (rhs.enable_zero_state_suggestions < lhs.enable_zero_state_suggestions)
    return false;
  if (lhs.enable_act_in_focused_tab < rhs.enable_act_in_focused_tab)
    return true;
  if (rhs.enable_act_in_focused_tab < lhs.enable_act_in_focused_tab)
    return false;
  if (lhs.enable_scroll_to < rhs.enable_scroll_to)
    return true;
  if (rhs.enable_scroll_to < lhs.enable_scroll_to)
    return false;
  if (lhs.enable_default_tab_context_setting_feature < rhs.enable_default_tab_context_setting_feature)
    return true;
  if (rhs.enable_default_tab_context_setting_feature < lhs.enable_default_tab_context_setting_feature)
    return false;
  if (lhs.default_tab_context_setting_enabled < rhs.default_tab_context_setting_enabled)
    return true;
  if (rhs.default_tab_context_setting_enabled < lhs.default_tab_context_setting_enabled)
    return false;
  if (lhs.enable_closed_captioning_feature < rhs.enable_closed_captioning_feature)
    return true;
  if (rhs.enable_closed_captioning_feature < lhs.enable_closed_captioning_feature)
    return false;
  if (lhs.closed_captioning_setting_enabled < rhs.closed_captioning_setting_enabled)
    return true;
  if (rhs.closed_captioning_setting_enabled < lhs.closed_captioning_setting_enabled)
    return false;
  if (lhs.enable_maybe_refresh_user_status < rhs.enable_maybe_refresh_user_status)
    return true;
  if (rhs.enable_maybe_refresh_user_status < lhs.enable_maybe_refresh_user_status)
    return false;
  if (lhs.enable_multi_tab < rhs.enable_multi_tab)
    return true;
  if (rhs.enable_multi_tab < lhs.enable_multi_tab)
    return false;
  if (lhs.enable_get_context_actor < rhs.enable_get_context_actor)
    return true;
  if (rhs.enable_get_context_actor < lhs.enable_get_context_actor)
    return false;
  if (lhs.host_capabilities < rhs.host_capabilities)
    return true;
  if (rhs.host_capabilities < lhs.host_capabilities)
    return false;
  if (lhs.enable_get_page_metadata < rhs.enable_get_page_metadata)
    return true;
  if (rhs.enable_get_page_metadata < lhs.enable_get_page_metadata)
    return false;
  if (lhs.enable_api_activation_gating < rhs.enable_api_activation_gating)
    return true;
  if (rhs.enable_api_activation_gating < lhs.enable_api_activation_gating)
    return false;
  if (lhs.enable_capture_region < rhs.enable_capture_region)
    return true;
  if (rhs.enable_capture_region < lhs.enable_capture_region)
    return false;
  if (lhs.enable_web_actuation_setting_feature < rhs.enable_web_actuation_setting_feature)
    return true;
  if (rhs.enable_web_actuation_setting_feature < lhs.enable_web_actuation_setting_feature)
    return false;
  if (lhs.actuation_on_web_setting_enabled < rhs.actuation_on_web_setting_enabled)
    return true;
  if (rhs.actuation_on_web_setting_enabled < lhs.actuation_on_web_setting_enabled)
    return false;
  if (lhs.can_act_on_web < rhs.can_act_on_web)
    return true;
  if (rhs.can_act_on_web < lhs.can_act_on_web)
    return false;
  if (lhs.enable_activate_tab < rhs.enable_activate_tab)
    return true;
  if (rhs.enable_activate_tab < lhs.enable_activate_tab)
    return false;
  if (lhs.enable_get_tab_by_id < rhs.enable_get_tab_by_id)
    return true;
  if (rhs.enable_get_tab_by_id < lhs.enable_get_tab_by_id)
    return false;
  if (lhs.enable_open_password_manager_settings_page < rhs.enable_open_password_manager_settings_page)
    return true;
  if (rhs.enable_open_password_manager_settings_page < lhs.enable_open_password_manager_settings_page)
    return false;
  if (lhs.enable_load_and_extract_content < rhs.enable_load_and_extract_content)
    return true;
  if (rhs.enable_load_and_extract_content < lhs.enable_load_and_extract_content)
    return false;
  if (lhs.enable_trust_first_onboarding < rhs.enable_trust_first_onboarding)
    return true;
  if (rhs.enable_trust_first_onboarding < lhs.enable_trust_first_onboarding)
    return false;
  if (lhs.onboarding_completed < rhs.onboarding_completed)
    return true;
  if (rhs.onboarding_completed < lhs.onboarding_completed)
    return false;
  return false;
}
template <typename StructPtrType>
GetTabContextOptionsPtr GetTabContextOptions::Clone() const {
  return New(
      mojo::Clone(include_inner_text),
      mojo::Clone(inner_text_bytes_limit),
      mojo::Clone(include_viewport_screenshot),
      mojo::Clone(include_annotated_page_content),
      mojo::Clone(max_meta_tags),
      mojo::Clone(include_pdf),
      mojo::Clone(pdf_size_limit),
      mojo::Clone(annotated_page_content_mode)
  );
}

template <typename T, GetTabContextOptions::EnableIfSame<T>*>
bool GetTabContextOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_inner_text, other_struct.include_inner_text))
    return false;
  if (!mojo::Equals(this->inner_text_bytes_limit, other_struct.inner_text_bytes_limit))
    return false;
  if (!mojo::Equals(this->include_viewport_screenshot, other_struct.include_viewport_screenshot))
    return false;
  if (!mojo::Equals(this->include_annotated_page_content, other_struct.include_annotated_page_content))
    return false;
  if (!mojo::Equals(this->max_meta_tags, other_struct.max_meta_tags))
    return false;
  if (!mojo::Equals(this->include_pdf, other_struct.include_pdf))
    return false;
  if (!mojo::Equals(this->pdf_size_limit, other_struct.pdf_size_limit))
    return false;
  if (!mojo::Equals(this->annotated_page_content_mode, other_struct.annotated_page_content_mode))
    return false;
  return true;
}

template <typename T, GetTabContextOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_inner_text < rhs.include_inner_text)
    return true;
  if (rhs.include_inner_text < lhs.include_inner_text)
    return false;
  if (lhs.inner_text_bytes_limit < rhs.inner_text_bytes_limit)
    return true;
  if (rhs.inner_text_bytes_limit < lhs.inner_text_bytes_limit)
    return false;
  if (lhs.include_viewport_screenshot < rhs.include_viewport_screenshot)
    return true;
  if (rhs.include_viewport_screenshot < lhs.include_viewport_screenshot)
    return false;
  if (lhs.include_annotated_page_content < rhs.include_annotated_page_content)
    return true;
  if (rhs.include_annotated_page_content < lhs.include_annotated_page_content)
    return false;
  if (lhs.max_meta_tags < rhs.max_meta_tags)
    return true;
  if (rhs.max_meta_tags < lhs.max_meta_tags)
    return false;
  if (lhs.include_pdf < rhs.include_pdf)
    return true;
  if (rhs.include_pdf < lhs.include_pdf)
    return false;
  if (lhs.pdf_size_limit < rhs.pdf_size_limit)
    return true;
  if (rhs.pdf_size_limit < lhs.pdf_size_limit)
    return false;
  if (lhs.annotated_page_content_mode < rhs.annotated_page_content_mode)
    return true;
  if (rhs.annotated_page_content_mode < lhs.annotated_page_content_mode)
    return false;
  return false;
}
template <typename StructPtrType>
GetPinCandidatesOptionsPtr GetPinCandidatesOptions::Clone() const {
  return New(
      mojo::Clone(max_candidates),
      mojo::Clone(query)
  );
}

template <typename T, GetPinCandidatesOptions::EnableIfSame<T>*>
bool GetPinCandidatesOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max_candidates, other_struct.max_candidates))
    return false;
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  return true;
}

template <typename T, GetPinCandidatesOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max_candidates < rhs.max_candidates)
    return true;
  if (rhs.max_candidates < lhs.max_candidates)
    return false;
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollToParamsPtr ScrollToParams::Clone() const {
  return New(
      mojo::Clone(selector),
      mojo::Clone(highlight),
      mojo::Clone(document_id),
      mojo::Clone(url)
  );
}

template <typename T, ScrollToParams::EnableIfSame<T>*>
bool ScrollToParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->selector, other_struct.selector))
    return false;
  if (!mojo::Equals(this->highlight, other_struct.highlight))
    return false;
  if (!mojo::Equals(this->document_id, other_struct.document_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, ScrollToParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.selector < rhs.selector)
    return true;
  if (rhs.selector < lhs.selector)
    return false;
  if (lhs.highlight < rhs.highlight)
    return true;
  if (rhs.highlight < lhs.highlight)
    return false;
  if (lhs.document_id < rhs.document_id)
    return true;
  if (rhs.document_id < lhs.document_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollToTextSelectorPtr ScrollToTextSelector::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(search_range_start_node_id)
  );
}

template <typename T, ScrollToTextSelector::EnableIfSame<T>*>
bool ScrollToTextSelector::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->search_range_start_node_id, other_struct.search_range_start_node_id))
    return false;
  return true;
}

template <typename T, ScrollToTextSelector::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.search_range_start_node_id < rhs.search_range_start_node_id)
    return true;
  if (rhs.search_range_start_node_id < lhs.search_range_start_node_id)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollToTextFragmentSelectorPtr ScrollToTextFragmentSelector::Clone() const {
  return New(
      mojo::Clone(text_start),
      mojo::Clone(text_end),
      mojo::Clone(search_range_start_node_id)
  );
}

template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>*>
bool ScrollToTextFragmentSelector::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_start, other_struct.text_start))
    return false;
  if (!mojo::Equals(this->text_end, other_struct.text_end))
    return false;
  if (!mojo::Equals(this->search_range_start_node_id, other_struct.search_range_start_node_id))
    return false;
  return true;
}

template <typename T, ScrollToTextFragmentSelector::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_start < rhs.text_start)
    return true;
  if (rhs.text_start < lhs.text_start)
    return false;
  if (lhs.text_end < rhs.text_end)
    return true;
  if (rhs.text_end < lhs.text_end)
    return false;
  if (lhs.search_range_start_node_id < rhs.search_range_start_node_id)
    return true;
  if (rhs.search_range_start_node_id < lhs.search_range_start_node_id)
    return false;
  return false;
}
template <typename StructPtrType>
ScrollToNodeSelectorPtr ScrollToNodeSelector::Clone() const {
  return New(
      mojo::Clone(node_id)
  );
}

template <typename T, ScrollToNodeSelector::EnableIfSame<T>*>
bool ScrollToNodeSelector::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_id, other_struct.node_id))
    return false;
  return true;
}

template <typename T, ScrollToNodeSelector::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_id < rhs.node_id)
    return true;
  if (rhs.node_id < lhs.node_id)
    return false;
  return false;
}
template <typename StructPtrType>
SuggestionContentPtr SuggestionContent::Clone() const {
  return New(
      mojo::Clone(suggestion)
  );
}

template <typename T, SuggestionContent::EnableIfSame<T>*>
bool SuggestionContent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->suggestion, other_struct.suggestion))
    return false;
  return true;
}

template <typename T, SuggestionContent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.suggestion < rhs.suggestion)
    return true;
  if (rhs.suggestion < lhs.suggestion)
    return false;
  return false;
}
template <typename StructPtrType>
ZeroStateSuggestionsPtr ZeroStateSuggestions::Clone() const {
  return New(
      mojo::Clone(suggestions),
      mojo::Clone(tab_id),
      mojo::Clone(tab_url)
  );
}

template <typename T, ZeroStateSuggestions::EnableIfSame<T>*>
bool ZeroStateSuggestions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->tab_url, other_struct.tab_url))
    return false;
  return true;
}

template <typename T, ZeroStateSuggestions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.suggestions < rhs.suggestions)
    return true;
  if (rhs.suggestions < lhs.suggestions)
    return false;
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.tab_url < rhs.tab_url)
    return true;
  if (rhs.tab_url < lhs.tab_url)
    return false;
  return false;
}
template <typename StructPtrType>
ZeroStateSuggestionsV2Ptr ZeroStateSuggestionsV2::Clone() const {
  return New(
      mojo::Clone(suggestions),
      mojo::Clone(is_pending)
  );
}

template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>*>
bool ZeroStateSuggestionsV2::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->suggestions, other_struct.suggestions))
    return false;
  if (!mojo::Equals(this->is_pending, other_struct.is_pending))
    return false;
  return true;
}

template <typename T, ZeroStateSuggestionsV2::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.suggestions < rhs.suggestions)
    return true;
  if (rhs.suggestions < lhs.suggestions)
    return false;
  if (lhs.is_pending < rhs.is_pending)
    return true;
  if (rhs.is_pending < lhs.is_pending)
    return false;
  return false;
}
template <typename StructPtrType>
ZeroStateSuggestionsOptionsPtr ZeroStateSuggestionsOptions::Clone() const {
  return New(
      mojo::Clone(is_first_run),
      mojo::Clone(supported_tools)
  );
}

template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>*>
bool ZeroStateSuggestionsOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_first_run, other_struct.is_first_run))
    return false;
  if (!mojo::Equals(this->supported_tools, other_struct.supported_tools))
    return false;
  return true;
}

template <typename T, ZeroStateSuggestionsOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_first_run < rhs.is_first_run)
    return true;
  if (rhs.is_first_run < lhs.is_first_run)
    return false;
  if (lhs.supported_tools < rhs.supported_tools)
    return true;
  if (rhs.supported_tools < lhs.supported_tools)
    return false;
  return false;
}
template <typename StructPtrType>
PinCandidatePtr PinCandidate::Clone() const {
  return New(
      mojo::Clone(tab_data)
  );
}

template <typename T, PinCandidate::EnableIfSame<T>*>
bool PinCandidate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_data, other_struct.tab_data))
    return false;
  return true;
}

template <typename T, PinCandidate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_data < rhs.tab_data)
    return true;
  if (rhs.tab_data < lhs.tab_data)
    return false;
  return false;
}
template <typename StructPtrType>
ConversationInfoPtr ConversationInfo::Clone() const {
  return New(
      mojo::Clone(conversation_id),
      mojo::Clone(conversation_title)
  );
}

template <typename T, ConversationInfo::EnableIfSame<T>*>
bool ConversationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->conversation_id, other_struct.conversation_id))
    return false;
  if (!mojo::Equals(this->conversation_title, other_struct.conversation_title))
    return false;
  return true;
}

template <typename T, ConversationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.conversation_id < rhs.conversation_id)
    return true;
  if (rhs.conversation_id < lhs.conversation_id)
    return false;
  if (lhs.conversation_title < rhs.conversation_title)
    return true;
  if (rhs.conversation_title < lhs.conversation_title)
    return false;
  return false;
}
template <typename StructPtrType>
PanelOpeningDataPtr PanelOpeningData::Clone() const {
  return New(
      mojo::Clone(panel_state),
      mojo::Clone(invocation_source),
      mojo::Clone(conversation_id),
      mojo::Clone(prompt_suggestion),
      mojo::Clone(recently_active_conversations)
  );
}

template <typename T, PanelOpeningData::EnableIfSame<T>*>
bool PanelOpeningData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->panel_state, other_struct.panel_state))
    return false;
  if (!mojo::Equals(this->invocation_source, other_struct.invocation_source))
    return false;
  if (!mojo::Equals(this->conversation_id, other_struct.conversation_id))
    return false;
  if (!mojo::Equals(this->prompt_suggestion, other_struct.prompt_suggestion))
    return false;
  if (!mojo::Equals(this->recently_active_conversations, other_struct.recently_active_conversations))
    return false;
  return true;
}

template <typename T, PanelOpeningData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.panel_state < rhs.panel_state)
    return true;
  if (rhs.panel_state < lhs.panel_state)
    return false;
  if (lhs.invocation_source < rhs.invocation_source)
    return true;
  if (rhs.invocation_source < lhs.invocation_source)
    return false;
  if (lhs.conversation_id < rhs.conversation_id)
    return true;
  if (rhs.conversation_id < lhs.conversation_id)
    return false;
  if (lhs.prompt_suggestion < rhs.prompt_suggestion)
    return true;
  if (rhs.prompt_suggestion < lhs.prompt_suggestion)
    return false;
  if (lhs.recently_active_conversations < rhs.recently_active_conversations)
    return true;
  if (rhs.recently_active_conversations < lhs.recently_active_conversations)
    return false;
  return false;
}
template <typename StructPtrType>
PanelStatePtr PanelState::Clone() const {
  return New(
      mojo::Clone(kind),
      mojo::Clone(window_id)
  );
}

template <typename T, PanelState::EnableIfSame<T>*>
bool PanelState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->kind, other_struct.kind))
    return false;
  if (!mojo::Equals(this->window_id, other_struct.window_id))
    return false;
  return true;
}

template <typename T, PanelState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.kind < rhs.kind)
    return true;
  if (rhs.kind < lhs.kind)
    return false;
  if (lhs.window_id < rhs.window_id)
    return true;
  if (rhs.window_id < lhs.window_id)
    return false;
  return false;
}
template <typename StructPtrType>
OnResponseStoppedDetailsPtr OnResponseStoppedDetails::Clone() const {
  return New(
      mojo::Clone(cause)
  );
}

template <typename T, OnResponseStoppedDetails::EnableIfSame<T>*>
bool OnResponseStoppedDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  return true;
}

template <typename T, OnResponseStoppedDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cause < rhs.cause)
    return true;
  if (rhs.cause < lhs.cause)
    return false;
  return false;
}
template <typename StructPtrType>
OpenPanelInfoPtr OpenPanelInfo::Clone() const {
  return New(
      mojo::Clone(web_client_mode),
      mojo::Clone(panelSize),
      mojo::Clone(resizeDuration),
      mojo::Clone(can_user_resize)
  );
}

template <typename T, OpenPanelInfo::EnableIfSame<T>*>
bool OpenPanelInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_client_mode, other_struct.web_client_mode))
    return false;
  if (!mojo::Equals(this->panelSize, other_struct.panelSize))
    return false;
  if (!mojo::Equals(this->resizeDuration, other_struct.resizeDuration))
    return false;
  if (!mojo::Equals(this->can_user_resize, other_struct.can_user_resize))
    return false;
  return true;
}

template <typename T, OpenPanelInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_client_mode < rhs.web_client_mode)
    return true;
  if (rhs.web_client_mode < lhs.web_client_mode)
    return false;
  if (lhs.panelSize < rhs.panelSize)
    return true;
  if (rhs.panelSize < lhs.panelSize)
    return false;
  if (lhs.resizeDuration < rhs.resizeDuration)
    return true;
  if (rhs.resizeDuration < lhs.resizeDuration)
    return false;
  if (lhs.can_user_resize < rhs.can_user_resize)
    return true;
  if (rhs.can_user_resize < lhs.can_user_resize)
    return false;
  return false;
}
template <typename StructPtrType>
ContextDataPtr ContextData::Clone() const {
  return New(
      mojo::Clone(mime_type),
      mojo::Clone(data)
  );
}

template <typename T, ContextData::EnableIfSame<T>*>
bool ContextData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, ContextData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
AdditionalContextPtr AdditionalContext::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(tab_id),
      mojo::Clone(origin),
      mojo::Clone(frameUrl),
      mojo::Clone(parts)
  );
}

template <typename T, AdditionalContext::EnableIfSame<T>*>
bool AdditionalContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->frameUrl, other_struct.frameUrl))
    return false;
  if (!mojo::Equals(this->parts, other_struct.parts))
    return false;
  return true;
}

template <typename T, AdditionalContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.frameUrl < rhs.frameUrl)
    return true;
  if (rhs.frameUrl < lhs.frameUrl)
    return false;
  if (lhs.parts < rhs.parts)
    return true;
  if (rhs.parts < lhs.parts)
    return false;
  return false;
}
template <typename StructPtrType>
TabContextPtr TabContext::Clone() const {
  return New(
      mojo::Clone(tab_data),
      mojo::Clone(web_page_data),
      mojo::Clone(viewport_screenshot),
      mojo::Clone(pdf_document_data),
      mojo::Clone(annotated_page_data)
  );
}

template <typename T, TabContext::EnableIfSame<T>*>
bool TabContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_data, other_struct.tab_data))
    return false;
  if (!mojo::Equals(this->web_page_data, other_struct.web_page_data))
    return false;
  if (!mojo::Equals(this->viewport_screenshot, other_struct.viewport_screenshot))
    return false;
  if (!mojo::Equals(this->pdf_document_data, other_struct.pdf_document_data))
    return false;
  if (!mojo::Equals(this->annotated_page_data, other_struct.annotated_page_data))
    return false;
  return true;
}

template <typename T, TabContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_data < rhs.tab_data)
    return true;
  if (rhs.tab_data < lhs.tab_data)
    return false;
  if (lhs.web_page_data < rhs.web_page_data)
    return true;
  if (rhs.web_page_data < lhs.web_page_data)
    return false;
  if (lhs.viewport_screenshot < rhs.viewport_screenshot)
    return true;
  if (rhs.viewport_screenshot < lhs.viewport_screenshot)
    return false;
  if (lhs.pdf_document_data < rhs.pdf_document_data)
    return true;
  if (rhs.pdf_document_data < lhs.pdf_document_data)
    return false;
  if (lhs.annotated_page_data < rhs.annotated_page_data)
    return true;
  if (rhs.annotated_page_data < lhs.annotated_page_data)
    return false;
  return false;
}
template <typename StructPtrType>
WebPageDataPtr WebPageData::Clone() const {
  return New(
      mojo::Clone(main_document)
  );
}

template <typename T, WebPageData::EnableIfSame<T>*>
bool WebPageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->main_document, other_struct.main_document))
    return false;
  return true;
}

template <typename T, WebPageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.main_document < rhs.main_document)
    return true;
  if (rhs.main_document < lhs.main_document)
    return false;
  return false;
}
template <typename StructPtrType>
DocumentDataPtr DocumentData::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(inner_text),
      mojo::Clone(inner_text_truncated)
  );
}

template <typename T, DocumentData::EnableIfSame<T>*>
bool DocumentData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->inner_text, other_struct.inner_text))
    return false;
  if (!mojo::Equals(this->inner_text_truncated, other_struct.inner_text_truncated))
    return false;
  return true;
}

template <typename T, DocumentData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.inner_text < rhs.inner_text)
    return true;
  if (rhs.inner_text < lhs.inner_text)
    return false;
  if (lhs.inner_text_truncated < rhs.inner_text_truncated)
    return true;
  if (rhs.inner_text_truncated < lhs.inner_text_truncated)
    return false;
  return false;
}
template <typename StructPtrType>
PdfDocumentDataPtr PdfDocumentData::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(pdf_data),
      mojo::Clone(size_limit_exceeded)
  );
}

template <typename T, PdfDocumentData::EnableIfSame<T>*>
bool PdfDocumentData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->pdf_data, other_struct.pdf_data))
    return false;
  if (!mojo::Equals(this->size_limit_exceeded, other_struct.size_limit_exceeded))
    return false;
  return true;
}

template <typename T, PdfDocumentData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.pdf_data < rhs.pdf_data)
    return true;
  if (rhs.pdf_data < lhs.pdf_data)
    return false;
  if (lhs.size_limit_exceeded < rhs.size_limit_exceeded)
    return true;
  if (rhs.size_limit_exceeded < lhs.size_limit_exceeded)
    return false;
  return false;
}
template <typename StructPtrType>
TabDataPtr TabData::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(window_id),
      mojo::Clone(url),
      mojo::Clone(title),
      mojo::Clone(favicon),
      mojo::Clone(favicon_url),
      mojo::Clone(document_mime_type),
      mojo::Clone(is_observable),
      mojo::Clone(is_media_active),
      mojo::Clone(is_tab_content_captured),
      mojo::Clone(is_active_in_window),
      mojo::Clone(is_window_active)
  );
}

template <typename T, TabData::EnableIfSame<T>*>
bool TabData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->window_id, other_struct.window_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->favicon, other_struct.favicon))
    return false;
  if (!mojo::Equals(this->favicon_url, other_struct.favicon_url))
    return false;
  if (!mojo::Equals(this->document_mime_type, other_struct.document_mime_type))
    return false;
  if (!mojo::Equals(this->is_observable, other_struct.is_observable))
    return false;
  if (!mojo::Equals(this->is_media_active, other_struct.is_media_active))
    return false;
  if (!mojo::Equals(this->is_tab_content_captured, other_struct.is_tab_content_captured))
    return false;
  if (!mojo::Equals(this->is_active_in_window, other_struct.is_active_in_window))
    return false;
  if (!mojo::Equals(this->is_window_active, other_struct.is_window_active))
    return false;
  return true;
}

template <typename T, TabData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.window_id < rhs.window_id)
    return true;
  if (rhs.window_id < lhs.window_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.favicon < rhs.favicon)
    return true;
  if (rhs.favicon < lhs.favicon)
    return false;
  if (lhs.favicon_url < rhs.favicon_url)
    return true;
  if (rhs.favicon_url < lhs.favicon_url)
    return false;
  if (lhs.document_mime_type < rhs.document_mime_type)
    return true;
  if (rhs.document_mime_type < lhs.document_mime_type)
    return false;
  if (lhs.is_observable < rhs.is_observable)
    return true;
  if (rhs.is_observable < lhs.is_observable)
    return false;
  if (lhs.is_media_active < rhs.is_media_active)
    return true;
  if (rhs.is_media_active < lhs.is_media_active)
    return false;
  if (lhs.is_tab_content_captured < rhs.is_tab_content_captured)
    return true;
  if (rhs.is_tab_content_captured < lhs.is_tab_content_captured)
    return false;
  if (lhs.is_active_in_window < rhs.is_active_in_window)
    return true;
  if (rhs.is_active_in_window < lhs.is_active_in_window)
    return false;
  if (lhs.is_window_active < rhs.is_window_active)
    return true;
  if (rhs.is_window_active < lhs.is_window_active)
    return false;
  return false;
}
template <typename StructPtrType>
NoFocusedTabDataPtr NoFocusedTabData::Clone() const {
  return New(
      mojo::Clone(active_tab_data),
      mojo::Clone(no_focus_reason)
  );
}

template <typename T, NoFocusedTabData::EnableIfSame<T>*>
bool NoFocusedTabData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->active_tab_data, other_struct.active_tab_data))
    return false;
  if (!mojo::Equals(this->no_focus_reason, other_struct.no_focus_reason))
    return false;
  return true;
}

template <typename T, NoFocusedTabData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.active_tab_data < rhs.active_tab_data)
    return true;
  if (rhs.active_tab_data < lhs.active_tab_data)
    return false;
  if (lhs.no_focus_reason < rhs.no_focus_reason)
    return true;
  if (rhs.no_focus_reason < lhs.no_focus_reason)
    return false;
  return false;
}
template <typename StructPtrType>
AnnotatedPageDataPtr AnnotatedPageData::Clone() const {
  return New(
      mojo::Clone(annotated_page_content),
      mojo::Clone(metadata)
  );
}

template <typename T, AnnotatedPageData::EnableIfSame<T>*>
bool AnnotatedPageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->annotated_page_content, other_struct.annotated_page_content))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  return true;
}

template <typename T, AnnotatedPageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.annotated_page_content < rhs.annotated_page_content)
    return true;
  if (rhs.annotated_page_content < lhs.annotated_page_content)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  return false;
}
template <typename StructPtrType>
ImageOriginAnnotationsPtr ImageOriginAnnotations::Clone() const {
  return New(
  );
}

template <typename T, ImageOriginAnnotations::EnableIfSame<T>*>
bool ImageOriginAnnotations::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ImageOriginAnnotations::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
JournalPtr Journal::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, Journal::EnableIfSame<T>*>
bool Journal::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, Journal::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
CaptureRegionResultPtr CaptureRegionResult::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(region)
  );
}

template <typename T, CaptureRegionResult::EnableIfSame<T>*>
bool CaptureRegionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->region, other_struct.region))
    return false;
  return true;
}

template <typename T, CaptureRegionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.region < rhs.region)
    return true;
  if (rhs.region < lhs.region)
    return false;
  return false;
}
template <typename StructPtrType>
ScreenshotPtr Screenshot::Clone() const {
  return New(
      mojo::Clone(width_pixels),
      mojo::Clone(height_pixels),
      mojo::Clone(data),
      mojo::Clone(mime_type),
      mojo::Clone(origin_annotations)
  );
}

template <typename T, Screenshot::EnableIfSame<T>*>
bool Screenshot::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width_pixels, other_struct.width_pixels))
    return false;
  if (!mojo::Equals(this->height_pixels, other_struct.height_pixels))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->origin_annotations, other_struct.origin_annotations))
    return false;
  return true;
}

template <typename T, Screenshot::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width_pixels < rhs.width_pixels)
    return true;
  if (rhs.width_pixels < lhs.width_pixels)
    return false;
  if (lhs.height_pixels < rhs.height_pixels)
    return true;
  if (rhs.height_pixels < lhs.height_pixels)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.origin_annotations < rhs.origin_annotations)
    return true;
  if (rhs.origin_annotations < lhs.origin_annotations)
    return false;
  return false;
}
template <typename StructPtrType>
OpenSettingsOptionsPtr OpenSettingsOptions::Clone() const {
  return New(
      mojo::Clone(highlightField)
  );
}

template <typename T, OpenSettingsOptions::EnableIfSame<T>*>
bool OpenSettingsOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->highlightField, other_struct.highlightField))
    return false;
  return true;
}

template <typename T, OpenSettingsOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.highlightField < rhs.highlightField)
    return true;
  if (rhs.highlightField < lhs.highlightField)
    return false;
  return false;
}
template <typename StructPtrType>
ViewChangeRequestActuationPtr ViewChangeRequestActuation::Clone() const {
  return New(
  );
}

template <typename T, ViewChangeRequestActuation::EnableIfSame<T>*>
bool ViewChangeRequestActuation::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ViewChangeRequestActuation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ViewChangeRequestConversationPtr ViewChangeRequestConversation::Clone() const {
  return New(
  );
}

template <typename T, ViewChangeRequestConversation::EnableIfSame<T>*>
bool ViewChangeRequestConversation::Equals(const T& other_struct) const {
  return true;
}

template <typename T, ViewChangeRequestConversation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
ViewChangeRequestPtr ViewChangeRequest::Clone() const {
  return New(
      mojo::Clone(details)
  );
}

template <typename T, ViewChangeRequest::EnableIfSame<T>*>
bool ViewChangeRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, ViewChangeRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}
template <typename StructPtrType>
ViewChangedNotificationPtr ViewChangedNotification::Clone() const {
  return New(
      mojo::Clone(current_view)
  );
}

template <typename T, ViewChangedNotification::EnableIfSame<T>*>
bool ViewChangedNotification::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->current_view, other_struct.current_view))
    return false;
  return true;
}

template <typename T, ViewChangedNotification::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.current_view < rhs.current_view)
    return true;
  if (rhs.current_view < lhs.current_view)
    return false;
  return false;
}


}  // glic::mojom

namespace mojo {


template <>
struct  StructTraits<::glic::mojom::GetContextResultWithActionResultCode::DataView,
                                         ::glic::mojom::GetContextResultWithActionResultCodePtr> {
  static bool IsNull(const ::glic::mojom::GetContextResultWithActionResultCodePtr& input) { return !input; }
  static void SetToNull(::glic::mojom::GetContextResultWithActionResultCodePtr* output) { output->reset(); }

  static  decltype(::glic::mojom::GetContextResultWithActionResultCode::get_context_result)& get_context_result(
       ::glic::mojom::GetContextResultWithActionResultCodePtr& input) {
    return input->get_context_result;
  }

  static decltype(::glic::mojom::GetContextResultWithActionResultCode::action_result) action_result(
      const ::glic::mojom::GetContextResultWithActionResultCodePtr& input) {
    return input->action_result;
  }

  static bool Read(::glic::mojom::GetContextResultWithActionResultCode::DataView input, ::glic::mojom::GetContextResultWithActionResultCodePtr* output);
};


template <>
struct  StructTraits<::glic::mojom::UserProfileInfo::DataView,
                                         ::glic::mojom::UserProfileInfoPtr> {
  static bool IsNull(const ::glic::mojom::UserProfileInfoPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::UserProfileInfoPtr* output) { output->reset(); }

  static  decltype(::glic::mojom::UserProfileInfo::avatar_icon)& avatar_icon(
       ::glic::mojom::UserProfileInfoPtr& input) {
    return input->avatar_icon;
  }

  static const decltype(::glic::mojom::UserProfileInfo::display_name)& display_name(
      const ::glic::mojom::UserProfileInfoPtr& input) {
    return input->display_name;
  }

  static const decltype(::glic::mojom::UserProfileInfo::local_profile_name)& local_profile_name(
      const ::glic::mojom::UserProfileInfoPtr& input) {
    return input->local_profile_name;
  }

  static const decltype(::glic::mojom::UserProfileInfo::email)& email(
      const ::glic::mojom::UserProfileInfoPtr& input) {
    return input->email;
  }

  static const decltype(::glic::mojom::UserProfileInfo::given_name)& given_name(
      const ::glic::mojom::UserProfileInfoPtr& input) {
    return input->given_name;
  }

  static decltype(::glic::mojom::UserProfileInfo::is_managed) is_managed(
      const ::glic::mojom::UserProfileInfoPtr& input) {
    return input->is_managed;
  }

  static bool Read(::glic::mojom::UserProfileInfo::DataView input, ::glic::mojom::UserProfileInfoPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::WebClientInitialState::DataView,
                                         ::glic::mojom::WebClientInitialStatePtr> {
  static bool IsNull(const ::glic::mojom::WebClientInitialStatePtr& input) { return !input; }
  static void SetToNull(::glic::mojom::WebClientInitialStatePtr* output) { output->reset(); }

  static const decltype(::glic::mojom::WebClientInitialState::panel_state)& panel_state(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->panel_state;
  }

  static  decltype(::glic::mojom::WebClientInitialState::focused_tab_data)& focused_tab_data(
       ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->focused_tab_data;
  }

  static decltype(::glic::mojom::WebClientInitialState::microphone_permission_enabled) microphone_permission_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->microphone_permission_enabled;
  }

  static decltype(::glic::mojom::WebClientInitialState::location_permission_enabled) location_permission_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->location_permission_enabled;
  }

  static decltype(::glic::mojom::WebClientInitialState::tab_context_permission_enabled) tab_context_permission_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->tab_context_permission_enabled;
  }

  static decltype(::glic::mojom::WebClientInitialState::os_location_permission_enabled) os_location_permission_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->os_location_permission_enabled;
  }

  static const decltype(::glic::mojom::WebClientInitialState::hotkey)& hotkey(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->hotkey;
  }

  static const decltype(::glic::mojom::WebClientInitialState::chrome_version)& chrome_version(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->chrome_version;
  }

  static decltype(::glic::mojom::WebClientInitialState::platform) platform(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->platform;
  }

  static decltype(::glic::mojom::WebClientInitialState::can_attach) can_attach(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->can_attach;
  }

  static decltype(::glic::mojom::WebClientInitialState::panel_is_active) panel_is_active(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->panel_is_active;
  }

  static decltype(::glic::mojom::WebClientInitialState::browser_is_open) browser_is_open(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->browser_is_open;
  }

  static decltype(::glic::mojom::WebClientInitialState::instance_is_active) instance_is_active(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->instance_is_active;
  }

  static decltype(::glic::mojom::WebClientInitialState::always_detached_mode) always_detached_mode(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->always_detached_mode;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_zero_state_suggestions) enable_zero_state_suggestions(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_zero_state_suggestions;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_act_in_focused_tab) enable_act_in_focused_tab(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_act_in_focused_tab;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_scroll_to) enable_scroll_to(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_scroll_to;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_default_tab_context_setting_feature) enable_default_tab_context_setting_feature(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_default_tab_context_setting_feature;
  }

  static decltype(::glic::mojom::WebClientInitialState::default_tab_context_setting_enabled) default_tab_context_setting_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->default_tab_context_setting_enabled;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_closed_captioning_feature) enable_closed_captioning_feature(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_closed_captioning_feature;
  }

  static decltype(::glic::mojom::WebClientInitialState::closed_captioning_setting_enabled) closed_captioning_setting_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->closed_captioning_setting_enabled;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_maybe_refresh_user_status) enable_maybe_refresh_user_status(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_maybe_refresh_user_status;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_multi_tab) enable_multi_tab(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_multi_tab;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_get_context_actor) enable_get_context_actor(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_get_context_actor;
  }

  static const decltype(::glic::mojom::WebClientInitialState::host_capabilities)& host_capabilities(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->host_capabilities;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_get_page_metadata) enable_get_page_metadata(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_get_page_metadata;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_api_activation_gating) enable_api_activation_gating(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_api_activation_gating;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_capture_region) enable_capture_region(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_capture_region;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_web_actuation_setting_feature) enable_web_actuation_setting_feature(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_web_actuation_setting_feature;
  }

  static decltype(::glic::mojom::WebClientInitialState::actuation_on_web_setting_enabled) actuation_on_web_setting_enabled(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->actuation_on_web_setting_enabled;
  }

  static decltype(::glic::mojom::WebClientInitialState::can_act_on_web) can_act_on_web(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->can_act_on_web;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_activate_tab) enable_activate_tab(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_activate_tab;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_get_tab_by_id) enable_get_tab_by_id(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_get_tab_by_id;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_open_password_manager_settings_page) enable_open_password_manager_settings_page(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_open_password_manager_settings_page;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_load_and_extract_content) enable_load_and_extract_content(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_load_and_extract_content;
  }

  static decltype(::glic::mojom::WebClientInitialState::enable_trust_first_onboarding) enable_trust_first_onboarding(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->enable_trust_first_onboarding;
  }

  static decltype(::glic::mojom::WebClientInitialState::onboarding_completed) onboarding_completed(
      const ::glic::mojom::WebClientInitialStatePtr& input) {
    return input->onboarding_completed;
  }

  static bool Read(::glic::mojom::WebClientInitialState::DataView input, ::glic::mojom::WebClientInitialStatePtr* output);
};


template <>
struct  StructTraits<::glic::mojom::GetTabContextOptions::DataView,
                                         ::glic::mojom::GetTabContextOptionsPtr> {
  static bool IsNull(const ::glic::mojom::GetTabContextOptionsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::GetTabContextOptionsPtr* output) { output->reset(); }

  static decltype(::glic::mojom::GetTabContextOptions::include_inner_text) include_inner_text(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->include_inner_text;
  }

  static decltype(::glic::mojom::GetTabContextOptions::inner_text_bytes_limit) inner_text_bytes_limit(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->inner_text_bytes_limit;
  }

  static decltype(::glic::mojom::GetTabContextOptions::include_viewport_screenshot) include_viewport_screenshot(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->include_viewport_screenshot;
  }

  static decltype(::glic::mojom::GetTabContextOptions::include_annotated_page_content) include_annotated_page_content(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->include_annotated_page_content;
  }

  static decltype(::glic::mojom::GetTabContextOptions::max_meta_tags) max_meta_tags(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->max_meta_tags;
  }

  static decltype(::glic::mojom::GetTabContextOptions::include_pdf) include_pdf(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->include_pdf;
  }

  static decltype(::glic::mojom::GetTabContextOptions::pdf_size_limit) pdf_size_limit(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->pdf_size_limit;
  }

  static decltype(::glic::mojom::GetTabContextOptions::annotated_page_content_mode) annotated_page_content_mode(
      const ::glic::mojom::GetTabContextOptionsPtr& input) {
    return input->annotated_page_content_mode;
  }

  static bool Read(::glic::mojom::GetTabContextOptions::DataView input, ::glic::mojom::GetTabContextOptionsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::GetPinCandidatesOptions::DataView,
                                         ::glic::mojom::GetPinCandidatesOptionsPtr> {
  static bool IsNull(const ::glic::mojom::GetPinCandidatesOptionsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::GetPinCandidatesOptionsPtr* output) { output->reset(); }

  static decltype(::glic::mojom::GetPinCandidatesOptions::max_candidates) max_candidates(
      const ::glic::mojom::GetPinCandidatesOptionsPtr& input) {
    return input->max_candidates;
  }

  static const decltype(::glic::mojom::GetPinCandidatesOptions::query)& query(
      const ::glic::mojom::GetPinCandidatesOptionsPtr& input) {
    return input->query;
  }

  static bool Read(::glic::mojom::GetPinCandidatesOptions::DataView input, ::glic::mojom::GetPinCandidatesOptionsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ScrollToParams::DataView,
                                         ::glic::mojom::ScrollToParamsPtr> {
  static bool IsNull(const ::glic::mojom::ScrollToParamsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ScrollToParamsPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ScrollToParams::selector)& selector(
      const ::glic::mojom::ScrollToParamsPtr& input) {
    return input->selector;
  }

  static decltype(::glic::mojom::ScrollToParams::highlight) highlight(
      const ::glic::mojom::ScrollToParamsPtr& input) {
    return input->highlight;
  }

  static const decltype(::glic::mojom::ScrollToParams::document_id)& document_id(
      const ::glic::mojom::ScrollToParamsPtr& input) {
    return input->document_id;
  }

  static const decltype(::glic::mojom::ScrollToParams::url)& url(
      const ::glic::mojom::ScrollToParamsPtr& input) {
    return input->url;
  }

  static bool Read(::glic::mojom::ScrollToParams::DataView input, ::glic::mojom::ScrollToParamsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ScrollToTextSelector::DataView,
                                         ::glic::mojom::ScrollToTextSelectorPtr> {
  static bool IsNull(const ::glic::mojom::ScrollToTextSelectorPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ScrollToTextSelectorPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ScrollToTextSelector::text)& text(
      const ::glic::mojom::ScrollToTextSelectorPtr& input) {
    return input->text;
  }

  static decltype(::glic::mojom::ScrollToTextSelector::search_range_start_node_id) search_range_start_node_id(
      const ::glic::mojom::ScrollToTextSelectorPtr& input) {
    return input->search_range_start_node_id;
  }

  static bool Read(::glic::mojom::ScrollToTextSelector::DataView input, ::glic::mojom::ScrollToTextSelectorPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ScrollToTextFragmentSelector::DataView,
                                         ::glic::mojom::ScrollToTextFragmentSelectorPtr> {
  static bool IsNull(const ::glic::mojom::ScrollToTextFragmentSelectorPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ScrollToTextFragmentSelectorPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ScrollToTextFragmentSelector::text_start)& text_start(
      const ::glic::mojom::ScrollToTextFragmentSelectorPtr& input) {
    return input->text_start;
  }

  static const decltype(::glic::mojom::ScrollToTextFragmentSelector::text_end)& text_end(
      const ::glic::mojom::ScrollToTextFragmentSelectorPtr& input) {
    return input->text_end;
  }

  static decltype(::glic::mojom::ScrollToTextFragmentSelector::search_range_start_node_id) search_range_start_node_id(
      const ::glic::mojom::ScrollToTextFragmentSelectorPtr& input) {
    return input->search_range_start_node_id;
  }

  static bool Read(::glic::mojom::ScrollToTextFragmentSelector::DataView input, ::glic::mojom::ScrollToTextFragmentSelectorPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ScrollToNodeSelector::DataView,
                                         ::glic::mojom::ScrollToNodeSelectorPtr> {
  static bool IsNull(const ::glic::mojom::ScrollToNodeSelectorPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ScrollToNodeSelectorPtr* output) { output->reset(); }

  static decltype(::glic::mojom::ScrollToNodeSelector::node_id) node_id(
      const ::glic::mojom::ScrollToNodeSelectorPtr& input) {
    return input->node_id;
  }

  static bool Read(::glic::mojom::ScrollToNodeSelector::DataView input, ::glic::mojom::ScrollToNodeSelectorPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::SuggestionContent::DataView,
                                         ::glic::mojom::SuggestionContentPtr> {
  static bool IsNull(const ::glic::mojom::SuggestionContentPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::SuggestionContentPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::SuggestionContent::suggestion)& suggestion(
      const ::glic::mojom::SuggestionContentPtr& input) {
    return input->suggestion;
  }

  static bool Read(::glic::mojom::SuggestionContent::DataView input, ::glic::mojom::SuggestionContentPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ZeroStateSuggestions::DataView,
                                         ::glic::mojom::ZeroStateSuggestionsPtr> {
  static bool IsNull(const ::glic::mojom::ZeroStateSuggestionsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ZeroStateSuggestionsPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ZeroStateSuggestions::suggestions)& suggestions(
      const ::glic::mojom::ZeroStateSuggestionsPtr& input) {
    return input->suggestions;
  }

  static decltype(::glic::mojom::ZeroStateSuggestions::tab_id) tab_id(
      const ::glic::mojom::ZeroStateSuggestionsPtr& input) {
    return input->tab_id;
  }

  static const decltype(::glic::mojom::ZeroStateSuggestions::tab_url)& tab_url(
      const ::glic::mojom::ZeroStateSuggestionsPtr& input) {
    return input->tab_url;
  }

  static bool Read(::glic::mojom::ZeroStateSuggestions::DataView input, ::glic::mojom::ZeroStateSuggestionsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ZeroStateSuggestionsV2::DataView,
                                         ::glic::mojom::ZeroStateSuggestionsV2Ptr> {
  static bool IsNull(const ::glic::mojom::ZeroStateSuggestionsV2Ptr& input) { return !input; }
  static void SetToNull(::glic::mojom::ZeroStateSuggestionsV2Ptr* output) { output->reset(); }

  static const decltype(::glic::mojom::ZeroStateSuggestionsV2::suggestions)& suggestions(
      const ::glic::mojom::ZeroStateSuggestionsV2Ptr& input) {
    return input->suggestions;
  }

  static decltype(::glic::mojom::ZeroStateSuggestionsV2::is_pending) is_pending(
      const ::glic::mojom::ZeroStateSuggestionsV2Ptr& input) {
    return input->is_pending;
  }

  static bool Read(::glic::mojom::ZeroStateSuggestionsV2::DataView input, ::glic::mojom::ZeroStateSuggestionsV2Ptr* output);
};


template <>
struct  StructTraits<::glic::mojom::ZeroStateSuggestionsOptions::DataView,
                                         ::glic::mojom::ZeroStateSuggestionsOptionsPtr> {
  static bool IsNull(const ::glic::mojom::ZeroStateSuggestionsOptionsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ZeroStateSuggestionsOptionsPtr* output) { output->reset(); }

  static decltype(::glic::mojom::ZeroStateSuggestionsOptions::is_first_run) is_first_run(
      const ::glic::mojom::ZeroStateSuggestionsOptionsPtr& input) {
    return input->is_first_run;
  }

  static const decltype(::glic::mojom::ZeroStateSuggestionsOptions::supported_tools)& supported_tools(
      const ::glic::mojom::ZeroStateSuggestionsOptionsPtr& input) {
    return input->supported_tools;
  }

  static bool Read(::glic::mojom::ZeroStateSuggestionsOptions::DataView input, ::glic::mojom::ZeroStateSuggestionsOptionsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::PinCandidate::DataView,
                                         ::glic::mojom::PinCandidatePtr> {
  static bool IsNull(const ::glic::mojom::PinCandidatePtr& input) { return !input; }
  static void SetToNull(::glic::mojom::PinCandidatePtr* output) { output->reset(); }

  static  decltype(::glic::mojom::PinCandidate::tab_data)& tab_data(
       ::glic::mojom::PinCandidatePtr& input) {
    return input->tab_data;
  }

  static bool Read(::glic::mojom::PinCandidate::DataView input, ::glic::mojom::PinCandidatePtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ConversationInfo::DataView,
                                         ::glic::mojom::ConversationInfoPtr> {
  static bool IsNull(const ::glic::mojom::ConversationInfoPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ConversationInfoPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ConversationInfo::conversation_id)& conversation_id(
      const ::glic::mojom::ConversationInfoPtr& input) {
    return input->conversation_id;
  }

  static const decltype(::glic::mojom::ConversationInfo::conversation_title)& conversation_title(
      const ::glic::mojom::ConversationInfoPtr& input) {
    return input->conversation_title;
  }

  static bool Read(::glic::mojom::ConversationInfo::DataView input, ::glic::mojom::ConversationInfoPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::PanelOpeningData::DataView,
                                         ::glic::mojom::PanelOpeningDataPtr> {
  static bool IsNull(const ::glic::mojom::PanelOpeningDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::PanelOpeningDataPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::PanelOpeningData::panel_state)& panel_state(
      const ::glic::mojom::PanelOpeningDataPtr& input) {
    return input->panel_state;
  }

  static decltype(::glic::mojom::PanelOpeningData::invocation_source) invocation_source(
      const ::glic::mojom::PanelOpeningDataPtr& input) {
    return input->invocation_source;
  }

  static const decltype(::glic::mojom::PanelOpeningData::conversation_id)& conversation_id(
      const ::glic::mojom::PanelOpeningDataPtr& input) {
    return input->conversation_id;
  }

  static const decltype(::glic::mojom::PanelOpeningData::prompt_suggestion)& prompt_suggestion(
      const ::glic::mojom::PanelOpeningDataPtr& input) {
    return input->prompt_suggestion;
  }

  static const decltype(::glic::mojom::PanelOpeningData::recently_active_conversations)& recently_active_conversations(
      const ::glic::mojom::PanelOpeningDataPtr& input) {
    return input->recently_active_conversations;
  }

  static bool Read(::glic::mojom::PanelOpeningData::DataView input, ::glic::mojom::PanelOpeningDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::PanelState::DataView,
                                         ::glic::mojom::PanelStatePtr> {
  static bool IsNull(const ::glic::mojom::PanelStatePtr& input) { return !input; }
  static void SetToNull(::glic::mojom::PanelStatePtr* output) { output->reset(); }

  static decltype(::glic::mojom::PanelState::kind) kind(
      const ::glic::mojom::PanelStatePtr& input) {
    return input->kind;
  }

  static decltype(::glic::mojom::PanelState::window_id) window_id(
      const ::glic::mojom::PanelStatePtr& input) {
    return input->window_id;
  }

  static bool Read(::glic::mojom::PanelState::DataView input, ::glic::mojom::PanelStatePtr* output);
};


template <>
struct  StructTraits<::glic::mojom::OnResponseStoppedDetails::DataView,
                                         ::glic::mojom::OnResponseStoppedDetailsPtr> {
  static bool IsNull(const ::glic::mojom::OnResponseStoppedDetailsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::OnResponseStoppedDetailsPtr* output) { output->reset(); }

  static decltype(::glic::mojom::OnResponseStoppedDetails::cause) cause(
      const ::glic::mojom::OnResponseStoppedDetailsPtr& input) {
    return input->cause;
  }

  static bool Read(::glic::mojom::OnResponseStoppedDetails::DataView input, ::glic::mojom::OnResponseStoppedDetailsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::OpenPanelInfo::DataView,
                                         ::glic::mojom::OpenPanelInfoPtr> {
  static bool IsNull(const ::glic::mojom::OpenPanelInfoPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::OpenPanelInfoPtr* output) { output->reset(); }

  static decltype(::glic::mojom::OpenPanelInfo::web_client_mode) web_client_mode(
      const ::glic::mojom::OpenPanelInfoPtr& input) {
    return input->web_client_mode;
  }

  static const decltype(::glic::mojom::OpenPanelInfo::panelSize)& panelSize(
      const ::glic::mojom::OpenPanelInfoPtr& input) {
    return input->panelSize;
  }

  static const decltype(::glic::mojom::OpenPanelInfo::resizeDuration)& resizeDuration(
      const ::glic::mojom::OpenPanelInfoPtr& input) {
    return input->resizeDuration;
  }

  static decltype(::glic::mojom::OpenPanelInfo::can_user_resize) can_user_resize(
      const ::glic::mojom::OpenPanelInfoPtr& input) {
    return input->can_user_resize;
  }

  static bool Read(::glic::mojom::OpenPanelInfo::DataView input, ::glic::mojom::OpenPanelInfoPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ContextData::DataView,
                                         ::glic::mojom::ContextDataPtr> {
  static bool IsNull(const ::glic::mojom::ContextDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ContextDataPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ContextData::mime_type)& mime_type(
      const ::glic::mojom::ContextDataPtr& input) {
    return input->mime_type;
  }

  static  decltype(::glic::mojom::ContextData::data)& data(
       ::glic::mojom::ContextDataPtr& input) {
    return input->data;
  }

  static bool Read(::glic::mojom::ContextData::DataView input, ::glic::mojom::ContextDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::AdditionalContext::DataView,
                                         ::glic::mojom::AdditionalContextPtr> {
  static bool IsNull(const ::glic::mojom::AdditionalContextPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::AdditionalContextPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::AdditionalContext::name)& name(
      const ::glic::mojom::AdditionalContextPtr& input) {
    return input->name;
  }

  static decltype(::glic::mojom::AdditionalContext::tab_id) tab_id(
      const ::glic::mojom::AdditionalContextPtr& input) {
    return input->tab_id;
  }

  static const decltype(::glic::mojom::AdditionalContext::origin)& origin(
      const ::glic::mojom::AdditionalContextPtr& input) {
    return input->origin;
  }

  static const decltype(::glic::mojom::AdditionalContext::frameUrl)& frameUrl(
      const ::glic::mojom::AdditionalContextPtr& input) {
    return input->frameUrl;
  }

  static  decltype(::glic::mojom::AdditionalContext::parts)& parts(
       ::glic::mojom::AdditionalContextPtr& input) {
    return input->parts;
  }

  static bool Read(::glic::mojom::AdditionalContext::DataView input, ::glic::mojom::AdditionalContextPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::TabContext::DataView,
                                         ::glic::mojom::TabContextPtr> {
  static bool IsNull(const ::glic::mojom::TabContextPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::TabContextPtr* output) { output->reset(); }

  static  decltype(::glic::mojom::TabContext::tab_data)& tab_data(
       ::glic::mojom::TabContextPtr& input) {
    return input->tab_data;
  }

  static const decltype(::glic::mojom::TabContext::web_page_data)& web_page_data(
      const ::glic::mojom::TabContextPtr& input) {
    return input->web_page_data;
  }

  static const decltype(::glic::mojom::TabContext::viewport_screenshot)& viewport_screenshot(
      const ::glic::mojom::TabContextPtr& input) {
    return input->viewport_screenshot;
  }

  static const decltype(::glic::mojom::TabContext::pdf_document_data)& pdf_document_data(
      const ::glic::mojom::TabContextPtr& input) {
    return input->pdf_document_data;
  }

  static  decltype(::glic::mojom::TabContext::annotated_page_data)& annotated_page_data(
       ::glic::mojom::TabContextPtr& input) {
    return input->annotated_page_data;
  }

  static bool Read(::glic::mojom::TabContext::DataView input, ::glic::mojom::TabContextPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::WebPageData::DataView,
                                         ::glic::mojom::WebPageDataPtr> {
  static bool IsNull(const ::glic::mojom::WebPageDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::WebPageDataPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::WebPageData::main_document)& main_document(
      const ::glic::mojom::WebPageDataPtr& input) {
    return input->main_document;
  }

  static bool Read(::glic::mojom::WebPageData::DataView input, ::glic::mojom::WebPageDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::DocumentData::DataView,
                                         ::glic::mojom::DocumentDataPtr> {
  static bool IsNull(const ::glic::mojom::DocumentDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::DocumentDataPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::DocumentData::origin)& origin(
      const ::glic::mojom::DocumentDataPtr& input) {
    return input->origin;
  }

  static const decltype(::glic::mojom::DocumentData::inner_text)& inner_text(
      const ::glic::mojom::DocumentDataPtr& input) {
    return input->inner_text;
  }

  static decltype(::glic::mojom::DocumentData::inner_text_truncated) inner_text_truncated(
      const ::glic::mojom::DocumentDataPtr& input) {
    return input->inner_text_truncated;
  }

  static bool Read(::glic::mojom::DocumentData::DataView input, ::glic::mojom::DocumentDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::PdfDocumentData::DataView,
                                         ::glic::mojom::PdfDocumentDataPtr> {
  static bool IsNull(const ::glic::mojom::PdfDocumentDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::PdfDocumentDataPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::PdfDocumentData::origin)& origin(
      const ::glic::mojom::PdfDocumentDataPtr& input) {
    return input->origin;
  }

  static const decltype(::glic::mojom::PdfDocumentData::pdf_data)& pdf_data(
      const ::glic::mojom::PdfDocumentDataPtr& input) {
    return input->pdf_data;
  }

  static decltype(::glic::mojom::PdfDocumentData::size_limit_exceeded) size_limit_exceeded(
      const ::glic::mojom::PdfDocumentDataPtr& input) {
    return input->size_limit_exceeded;
  }

  static bool Read(::glic::mojom::PdfDocumentData::DataView input, ::glic::mojom::PdfDocumentDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::TabData::DataView,
                                         ::glic::mojom::TabDataPtr> {
  static bool IsNull(const ::glic::mojom::TabDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::TabDataPtr* output) { output->reset(); }

  static decltype(::glic::mojom::TabData::tab_id) tab_id(
      const ::glic::mojom::TabDataPtr& input) {
    return input->tab_id;
  }

  static decltype(::glic::mojom::TabData::window_id) window_id(
      const ::glic::mojom::TabDataPtr& input) {
    return input->window_id;
  }

  static const decltype(::glic::mojom::TabData::url)& url(
      const ::glic::mojom::TabDataPtr& input) {
    return input->url;
  }

  static const decltype(::glic::mojom::TabData::title)& title(
      const ::glic::mojom::TabDataPtr& input) {
    return input->title;
  }

  static  decltype(::glic::mojom::TabData::favicon)& favicon(
       ::glic::mojom::TabDataPtr& input) {
    return input->favicon;
  }

  static const decltype(::glic::mojom::TabData::favicon_url)& favicon_url(
      const ::glic::mojom::TabDataPtr& input) {
    return input->favicon_url;
  }

  static const decltype(::glic::mojom::TabData::document_mime_type)& document_mime_type(
      const ::glic::mojom::TabDataPtr& input) {
    return input->document_mime_type;
  }

  static decltype(::glic::mojom::TabData::is_observable) is_observable(
      const ::glic::mojom::TabDataPtr& input) {
    return input->is_observable;
  }

  static decltype(::glic::mojom::TabData::is_media_active) is_media_active(
      const ::glic::mojom::TabDataPtr& input) {
    return input->is_media_active;
  }

  static decltype(::glic::mojom::TabData::is_tab_content_captured) is_tab_content_captured(
      const ::glic::mojom::TabDataPtr& input) {
    return input->is_tab_content_captured;
  }

  static decltype(::glic::mojom::TabData::is_active_in_window) is_active_in_window(
      const ::glic::mojom::TabDataPtr& input) {
    return input->is_active_in_window;
  }

  static decltype(::glic::mojom::TabData::is_window_active) is_window_active(
      const ::glic::mojom::TabDataPtr& input) {
    return input->is_window_active;
  }

  static bool Read(::glic::mojom::TabData::DataView input, ::glic::mojom::TabDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::NoFocusedTabData::DataView,
                                         ::glic::mojom::NoFocusedTabDataPtr> {
  static bool IsNull(const ::glic::mojom::NoFocusedTabDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::NoFocusedTabDataPtr* output) { output->reset(); }

  static  decltype(::glic::mojom::NoFocusedTabData::active_tab_data)& active_tab_data(
       ::glic::mojom::NoFocusedTabDataPtr& input) {
    return input->active_tab_data;
  }

  static const decltype(::glic::mojom::NoFocusedTabData::no_focus_reason)& no_focus_reason(
      const ::glic::mojom::NoFocusedTabDataPtr& input) {
    return input->no_focus_reason;
  }

  static bool Read(::glic::mojom::NoFocusedTabData::DataView input, ::glic::mojom::NoFocusedTabDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::AnnotatedPageData::DataView,
                                         ::glic::mojom::AnnotatedPageDataPtr> {
  static bool IsNull(const ::glic::mojom::AnnotatedPageDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::AnnotatedPageDataPtr* output) { output->reset(); }

  static  decltype(::glic::mojom::AnnotatedPageData::annotated_page_content)& annotated_page_content(
       ::glic::mojom::AnnotatedPageDataPtr& input) {
    return input->annotated_page_content;
  }

  static const decltype(::glic::mojom::AnnotatedPageData::metadata)& metadata(
      const ::glic::mojom::AnnotatedPageDataPtr& input) {
    return input->metadata;
  }

  static bool Read(::glic::mojom::AnnotatedPageData::DataView input, ::glic::mojom::AnnotatedPageDataPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ImageOriginAnnotations::DataView,
                                         ::glic::mojom::ImageOriginAnnotationsPtr> {
  static bool IsNull(const ::glic::mojom::ImageOriginAnnotationsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ImageOriginAnnotationsPtr* output) { output->reset(); }

  static bool Read(::glic::mojom::ImageOriginAnnotations::DataView input, ::glic::mojom::ImageOriginAnnotationsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::Journal::DataView,
                                         ::glic::mojom::JournalPtr> {
  static bool IsNull(const ::glic::mojom::JournalPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::JournalPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::Journal::data)& data(
      const ::glic::mojom::JournalPtr& input) {
    return input->data;
  }

  static bool Read(::glic::mojom::Journal::DataView input, ::glic::mojom::JournalPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::CaptureRegionResult::DataView,
                                         ::glic::mojom::CaptureRegionResultPtr> {
  static bool IsNull(const ::glic::mojom::CaptureRegionResultPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::CaptureRegionResultPtr* output) { output->reset(); }

  static decltype(::glic::mojom::CaptureRegionResult::tab_id) tab_id(
      const ::glic::mojom::CaptureRegionResultPtr& input) {
    return input->tab_id;
  }

  static const decltype(::glic::mojom::CaptureRegionResult::region)& region(
      const ::glic::mojom::CaptureRegionResultPtr& input) {
    return input->region;
  }

  static bool Read(::glic::mojom::CaptureRegionResult::DataView input, ::glic::mojom::CaptureRegionResultPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::Screenshot::DataView,
                                         ::glic::mojom::ScreenshotPtr> {
  static bool IsNull(const ::glic::mojom::ScreenshotPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ScreenshotPtr* output) { output->reset(); }

  static decltype(::glic::mojom::Screenshot::width_pixels) width_pixels(
      const ::glic::mojom::ScreenshotPtr& input) {
    return input->width_pixels;
  }

  static decltype(::glic::mojom::Screenshot::height_pixels) height_pixels(
      const ::glic::mojom::ScreenshotPtr& input) {
    return input->height_pixels;
  }

  static const decltype(::glic::mojom::Screenshot::data)& data(
      const ::glic::mojom::ScreenshotPtr& input) {
    return input->data;
  }

  static const decltype(::glic::mojom::Screenshot::mime_type)& mime_type(
      const ::glic::mojom::ScreenshotPtr& input) {
    return input->mime_type;
  }

  static const decltype(::glic::mojom::Screenshot::origin_annotations)& origin_annotations(
      const ::glic::mojom::ScreenshotPtr& input) {
    return input->origin_annotations;
  }

  static bool Read(::glic::mojom::Screenshot::DataView input, ::glic::mojom::ScreenshotPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::OpenSettingsOptions::DataView,
                                         ::glic::mojom::OpenSettingsOptionsPtr> {
  static bool IsNull(const ::glic::mojom::OpenSettingsOptionsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::OpenSettingsOptionsPtr* output) { output->reset(); }

  static decltype(::glic::mojom::OpenSettingsOptions::highlightField) highlightField(
      const ::glic::mojom::OpenSettingsOptionsPtr& input) {
    return input->highlightField;
  }

  static bool Read(::glic::mojom::OpenSettingsOptions::DataView input, ::glic::mojom::OpenSettingsOptionsPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ViewChangeRequestActuation::DataView,
                                         ::glic::mojom::ViewChangeRequestActuationPtr> {
  static bool IsNull(const ::glic::mojom::ViewChangeRequestActuationPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ViewChangeRequestActuationPtr* output) { output->reset(); }

  static bool Read(::glic::mojom::ViewChangeRequestActuation::DataView input, ::glic::mojom::ViewChangeRequestActuationPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ViewChangeRequestConversation::DataView,
                                         ::glic::mojom::ViewChangeRequestConversationPtr> {
  static bool IsNull(const ::glic::mojom::ViewChangeRequestConversationPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ViewChangeRequestConversationPtr* output) { output->reset(); }

  static bool Read(::glic::mojom::ViewChangeRequestConversation::DataView input, ::glic::mojom::ViewChangeRequestConversationPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ViewChangeRequest::DataView,
                                         ::glic::mojom::ViewChangeRequestPtr> {
  static bool IsNull(const ::glic::mojom::ViewChangeRequestPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ViewChangeRequestPtr* output) { output->reset(); }

  static const decltype(::glic::mojom::ViewChangeRequest::details)& details(
      const ::glic::mojom::ViewChangeRequestPtr& input) {
    return input->details;
  }

  static bool Read(::glic::mojom::ViewChangeRequest::DataView input, ::glic::mojom::ViewChangeRequestPtr* output);
};


template <>
struct  StructTraits<::glic::mojom::ViewChangedNotification::DataView,
                                         ::glic::mojom::ViewChangedNotificationPtr> {
  static bool IsNull(const ::glic::mojom::ViewChangedNotificationPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ViewChangedNotificationPtr* output) { output->reset(); }

  static decltype(::glic::mojom::ViewChangedNotification::current_view) current_view(
      const ::glic::mojom::ViewChangedNotificationPtr& input) {
    return input->current_view;
  }

  static bool Read(::glic::mojom::ViewChangedNotification::DataView input, ::glic::mojom::ViewChangedNotificationPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::GetContextResult::DataView,
                                        ::glic::mojom::GetContextResultPtr> {
  static bool IsNull(const ::glic::mojom::GetContextResultPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::GetContextResultPtr* output) { output->reset(); }

  static ::glic::mojom::GetContextResult::Tag GetTag(const ::glic::mojom::GetContextResultPtr& input) {
    return input->which();
  }

  static const std::string& error_reason(const ::glic::mojom::GetContextResultPtr& input) {
    return input->get_error_reason();
  }

  static  ::glic::mojom::TabContextPtr& tab_context( ::glic::mojom::GetContextResultPtr& input) {
    return input->get_tab_context();
  }

  static bool Read(::glic::mojom::GetContextResult::DataView input, ::glic::mojom::GetContextResultPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::CaptureScreenshotResult::DataView,
                                        ::glic::mojom::CaptureScreenshotResultPtr> {
  static bool IsNull(const ::glic::mojom::CaptureScreenshotResultPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::CaptureScreenshotResultPtr* output) { output->reset(); }

  static ::glic::mojom::CaptureScreenshotResult::Tag GetTag(const ::glic::mojom::CaptureScreenshotResultPtr& input) {
    return input->which();
  }

  static  ::glic::mojom::CaptureScreenshotErrorReason error_reason(const ::glic::mojom::CaptureScreenshotResultPtr& input) {
    return input->get_error_reason();
  }

  static const ::glic::mojom::ScreenshotPtr& screenshot(const ::glic::mojom::CaptureScreenshotResultPtr& input) {
    return input->get_screenshot();
  }

  static bool Read(::glic::mojom::CaptureScreenshotResult::DataView input, ::glic::mojom::CaptureScreenshotResultPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::ScrollToSelector::DataView,
                                        ::glic::mojom::ScrollToSelectorPtr> {
  static bool IsNull(const ::glic::mojom::ScrollToSelectorPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ScrollToSelectorPtr* output) { output->reset(); }

  static ::glic::mojom::ScrollToSelector::Tag GetTag(const ::glic::mojom::ScrollToSelectorPtr& input) {
    return input->which();
  }

  static const ::glic::mojom::ScrollToTextSelectorPtr& exact_text_selector(const ::glic::mojom::ScrollToSelectorPtr& input) {
    return input->get_exact_text_selector();
  }

  static const ::glic::mojom::ScrollToTextFragmentSelectorPtr& text_fragment_selector(const ::glic::mojom::ScrollToSelectorPtr& input) {
    return input->get_text_fragment_selector();
  }

  static const ::glic::mojom::ScrollToNodeSelectorPtr& node_selector(const ::glic::mojom::ScrollToSelectorPtr& input) {
    return input->get_node_selector();
  }

  static bool Read(::glic::mojom::ScrollToSelector::DataView input, ::glic::mojom::ScrollToSelectorPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::AdditionalContextPart::DataView,
                                        ::glic::mojom::AdditionalContextPartPtr> {
  static bool IsNull(const ::glic::mojom::AdditionalContextPartPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::AdditionalContextPartPtr* output) { output->reset(); }

  static ::glic::mojom::AdditionalContextPart::Tag GetTag(const ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->which();
  }

  static  ::glic::mojom::ContextDataPtr& data( ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->get_data();
  }

  static const ::glic::mojom::ScreenshotPtr& screenshot(const ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->get_screenshot();
  }

  static const ::glic::mojom::WebPageDataPtr& web_page_data(const ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->get_web_page_data();
  }

  static  ::glic::mojom::AnnotatedPageDataPtr& annotated_page_data( ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->get_annotated_page_data();
  }

  static const ::glic::mojom::PdfDocumentDataPtr& pdf_document_data(const ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->get_pdf_document_data();
  }

  static  ::glic::mojom::TabContextPtr& tab_context( ::glic::mojom::AdditionalContextPartPtr& input) {
    return input->get_tab_context();
  }

  static bool Read(::glic::mojom::AdditionalContextPart::DataView input, ::glic::mojom::AdditionalContextPartPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::FocusedTabData::DataView,
                                        ::glic::mojom::FocusedTabDataPtr> {
  static bool IsNull(const ::glic::mojom::FocusedTabDataPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::FocusedTabDataPtr* output) { output->reset(); }

  static ::glic::mojom::FocusedTabData::Tag GetTag(const ::glic::mojom::FocusedTabDataPtr& input) {
    return input->which();
  }

  static  ::glic::mojom::TabDataPtr& focused_tab( ::glic::mojom::FocusedTabDataPtr& input) {
    return input->get_focused_tab();
  }

  static  ::glic::mojom::NoFocusedTabDataPtr& no_focused_tab_data( ::glic::mojom::FocusedTabDataPtr& input) {
    return input->get_no_focused_tab_data();
  }

  static bool Read(::glic::mojom::FocusedTabData::DataView input, ::glic::mojom::FocusedTabDataPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::CapturedRegion::DataView,
                                        ::glic::mojom::CapturedRegionPtr> {
  static bool IsNull(const ::glic::mojom::CapturedRegionPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::CapturedRegionPtr* output) { output->reset(); }

  static ::glic::mojom::CapturedRegion::Tag GetTag(const ::glic::mojom::CapturedRegionPtr& input) {
    return input->which();
  }

  static const ::gfx::Rect& rect(const ::glic::mojom::CapturedRegionPtr& input) {
    return input->get_rect();
  }

  static bool Read(::glic::mojom::CapturedRegion::DataView input, ::glic::mojom::CapturedRegionPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::ViewChangeRequestDetails::DataView,
                                        ::glic::mojom::ViewChangeRequestDetailsPtr> {
  static bool IsNull(const ::glic::mojom::ViewChangeRequestDetailsPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::ViewChangeRequestDetailsPtr* output) { output->reset(); }

  static ::glic::mojom::ViewChangeRequestDetails::Tag GetTag(const ::glic::mojom::ViewChangeRequestDetailsPtr& input) {
    return input->which();
  }

  static const ::glic::mojom::ViewChangeRequestActuationPtr& actuation(const ::glic::mojom::ViewChangeRequestDetailsPtr& input) {
    return input->get_actuation();
  }

  static const ::glic::mojom::ViewChangeRequestConversationPtr& conversation(const ::glic::mojom::ViewChangeRequestDetailsPtr& input) {
    return input->get_conversation();
  }

  static bool Read(::glic::mojom::ViewChangeRequestDetails::DataView input, ::glic::mojom::ViewChangeRequestDetailsPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::DataView,
                                        ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr> {
  static bool IsNull(const ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::Tag GetTag(const ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  int32_t success(const ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::glic::mojom::CreateTaskErrorReason failure(const ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::glic::mojom::WebClientHandler_CreateTask_ResponseParam_Result::DataView input, ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultPtr* output);
};


template <>
struct  UnionTraits<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::DataView,
                                        ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr> {
  static bool IsNull(const ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::Tag GetTag(const ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static  ::mojo_base::ProtoWrapper& success( ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static  ::glic::mojom::PerformActionsErrorReason failure(const ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::glic::mojom::WebClientHandler_PerformActions_ResponseParam_Result::DataView input, ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_H_