// chrome/browser/glic/host/glic.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/glic/host/glic.mojom-shared-internal.h"
#include "chrome/browser/glic/host/glic_features.mojom-shared.h"
#include "chrome/common/actor_webui.mojom-shared.h"
#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace glic::mojom {
class GetContextResultWithActionResultCodeDataView;

class UserProfileInfoDataView;

class WebClientInitialStateDataView;

class GetTabContextOptionsDataView;

class GetPinCandidatesOptionsDataView;

class ScrollToParamsDataView;

class ScrollToTextSelectorDataView;

class ScrollToTextFragmentSelectorDataView;

class ScrollToNodeSelectorDataView;

class SuggestionContentDataView;

class ZeroStateSuggestionsDataView;

class ZeroStateSuggestionsV2DataView;

class ZeroStateSuggestionsOptionsDataView;

class PinCandidateDataView;

class ConversationInfoDataView;

class PanelOpeningDataDataView;

class PanelStateDataView;

class OnResponseStoppedDetailsDataView;

class OpenPanelInfoDataView;

class ContextDataDataView;

class AdditionalContextDataView;

class TabContextDataView;

class WebPageDataDataView;

class DocumentDataDataView;

class PdfDocumentDataDataView;

class TabDataDataView;

class NoFocusedTabDataDataView;

class AnnotatedPageDataDataView;

class ImageOriginAnnotationsDataView;

class JournalDataView;

class CaptureRegionResultDataView;

class ScreenshotDataView;

class OpenSettingsOptionsDataView;

class ViewChangeRequestActuationDataView;

class ViewChangeRequestConversationDataView;

class ViewChangeRequestDataView;

class ViewChangedNotificationDataView;

class GetContextResultDataView;
class CaptureScreenshotResultDataView;
class ScrollToSelectorDataView;
class AdditionalContextPartDataView;
class FocusedTabDataDataView;
class CapturedRegionDataView;
class ViewChangeRequestDetailsDataView;
class WebClientHandler_CreateTask_ResponseParam_ResultDataView;
class WebClientHandler_PerformActions_ResponseParam_ResultDataView;


}  // glic::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::glic::mojom::GetContextResultWithActionResultCodeDataView> {
  using Data = ::glic::mojom::internal::GetContextResultWithActionResultCode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::UserProfileInfoDataView> {
  using Data = ::glic::mojom::internal::UserProfileInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::WebClientInitialStateDataView> {
  using Data = ::glic::mojom::internal::WebClientInitialState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::GetTabContextOptionsDataView> {
  using Data = ::glic::mojom::internal::GetTabContextOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::GetPinCandidatesOptionsDataView> {
  using Data = ::glic::mojom::internal::GetPinCandidatesOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ScrollToParamsDataView> {
  using Data = ::glic::mojom::internal::ScrollToParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ScrollToTextSelectorDataView> {
  using Data = ::glic::mojom::internal::ScrollToTextSelector_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ScrollToTextFragmentSelectorDataView> {
  using Data = ::glic::mojom::internal::ScrollToTextFragmentSelector_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ScrollToNodeSelectorDataView> {
  using Data = ::glic::mojom::internal::ScrollToNodeSelector_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::SuggestionContentDataView> {
  using Data = ::glic::mojom::internal::SuggestionContent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ZeroStateSuggestionsDataView> {
  using Data = ::glic::mojom::internal::ZeroStateSuggestions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ZeroStateSuggestionsV2DataView> {
  using Data = ::glic::mojom::internal::ZeroStateSuggestionsV2_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ZeroStateSuggestionsOptionsDataView> {
  using Data = ::glic::mojom::internal::ZeroStateSuggestionsOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::PinCandidateDataView> {
  using Data = ::glic::mojom::internal::PinCandidate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ConversationInfoDataView> {
  using Data = ::glic::mojom::internal::ConversationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::PanelOpeningDataDataView> {
  using Data = ::glic::mojom::internal::PanelOpeningData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::PanelStateDataView> {
  using Data = ::glic::mojom::internal::PanelState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::OnResponseStoppedDetailsDataView> {
  using Data = ::glic::mojom::internal::OnResponseStoppedDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::OpenPanelInfoDataView> {
  using Data = ::glic::mojom::internal::OpenPanelInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ContextDataDataView> {
  using Data = ::glic::mojom::internal::ContextData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::AdditionalContextDataView> {
  using Data = ::glic::mojom::internal::AdditionalContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::TabContextDataView> {
  using Data = ::glic::mojom::internal::TabContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::WebPageDataDataView> {
  using Data = ::glic::mojom::internal::WebPageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::DocumentDataDataView> {
  using Data = ::glic::mojom::internal::DocumentData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::PdfDocumentDataDataView> {
  using Data = ::glic::mojom::internal::PdfDocumentData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::TabDataDataView> {
  using Data = ::glic::mojom::internal::TabData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::NoFocusedTabDataDataView> {
  using Data = ::glic::mojom::internal::NoFocusedTabData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::AnnotatedPageDataDataView> {
  using Data = ::glic::mojom::internal::AnnotatedPageData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ImageOriginAnnotationsDataView> {
  using Data = ::glic::mojom::internal::ImageOriginAnnotations_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::JournalDataView> {
  using Data = ::glic::mojom::internal::Journal_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::CaptureRegionResultDataView> {
  using Data = ::glic::mojom::internal::CaptureRegionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ScreenshotDataView> {
  using Data = ::glic::mojom::internal::Screenshot_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::OpenSettingsOptionsDataView> {
  using Data = ::glic::mojom::internal::OpenSettingsOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ViewChangeRequestActuationDataView> {
  using Data = ::glic::mojom::internal::ViewChangeRequestActuation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ViewChangeRequestConversationDataView> {
  using Data = ::glic::mojom::internal::ViewChangeRequestConversation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ViewChangeRequestDataView> {
  using Data = ::glic::mojom::internal::ViewChangeRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::ViewChangedNotificationDataView> {
  using Data = ::glic::mojom::internal::ViewChangedNotification_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::glic::mojom::GetContextResultDataView> {
  using Data = ::glic::mojom::internal::GetContextResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::CaptureScreenshotResultDataView> {
  using Data = ::glic::mojom::internal::CaptureScreenshotResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::ScrollToSelectorDataView> {
  using Data = ::glic::mojom::internal::ScrollToSelector_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::AdditionalContextPartDataView> {
  using Data = ::glic::mojom::internal::AdditionalContextPart_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::FocusedTabDataDataView> {
  using Data = ::glic::mojom::internal::FocusedTabData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::CapturedRegionDataView> {
  using Data = ::glic::mojom::internal::CapturedRegion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::ViewChangeRequestDetailsDataView> {
  using Data = ::glic::mojom::internal::ViewChangeRequestDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView> {
  using Data = ::glic::mojom::internal::WebClientHandler_CreateTask_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView> {
  using Data = ::glic::mojom::internal::WebClientHandler_PerformActions_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace glic::mojom {


enum class ProfileReadyState : int32_t {
  
  kUnknownError = 0,
  
  kSignInRequired = 1,
  
  kReady = 2,
  
  kIneligible = 3,
  
  kDisabledByAdmin = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ProfileReadyState value);
inline bool IsKnownEnumValue(ProfileReadyState value) {
  return internal::ProfileReadyState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebUiState : int32_t {
  
  kUninitialized = 0,
  
  kBeginLoad = 1,
  
  kShowLoading = 2,
  
  kHoldLoading = 3,
  
  kFinishLoading = 4,
  
  kError = 5,
  
  kOffline = 6,
  
  kUnavailable = 7,
  
  kReady = 8,
  
  kUnresponsive = 9,
  
  kSignIn = 10,
  
  kGuestError = 11,
  
  kDisabledByAdmin = 12,
  kMinValue = 0,
  kMaxValue = 12,
};

 std::ostream& operator<<(std::ostream& os, WebUiState value);
inline bool IsKnownEnumValue(WebUiState value) {
  return internal::WebUiState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MetricUserInputReactionType : int32_t {
  
  kUnknown = 0,
  
  kCanned = 1,
  
  kModel = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, MetricUserInputReactionType value);
inline bool IsKnownEnumValue(MetricUserInputReactionType value) {
  return internal::MetricUserInputReactionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline MetricUserInputReactionType ToKnownEnumValue(MetricUserInputReactionType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return MetricUserInputReactionType::kDefaultValue;
}


enum class PrepareForClientResult : int32_t {
  
  kSuccess = 0,
  
  kErrorResyncingCookies = 1,
  
  kRequiresSignIn = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PrepareForClientResult value);
inline bool IsKnownEnumValue(PrepareForClientResult value) {
  return internal::PrepareForClientResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PerformActionsErrorReason : int32_t {
  
  kUnknown = 0,
  
  kInvalidProto = 1,
  
  kMissingTaskId = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, PerformActionsErrorReason value);
inline bool IsKnownEnumValue(PerformActionsErrorReason value) {
  return internal::PerformActionsErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline PerformActionsErrorReason ToKnownEnumValue(PerformActionsErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return PerformActionsErrorReason::kDefaultValue;
}


enum class CreateTaskErrorReason : int32_t {
  
  kUnknown = 0,
  
  kTaskSystemUnavailable = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, CreateTaskErrorReason value);
inline bool IsKnownEnumValue(CreateTaskErrorReason value) {
  return internal::CreateTaskErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CreateTaskErrorReason ToKnownEnumValue(CreateTaskErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CreateTaskErrorReason::kDefaultValue;
}


enum class ActorTaskState : int32_t {
  
  kUnknown = 0,
  
  kIdle = 1,
  
  kActing = 2,
  
  kPaused = 3,
  
  kStopped = 4,
  kMinValue = 0,
  kMaxValue = 4,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ActorTaskState value);
inline bool IsKnownEnumValue(ActorTaskState value) {
  return internal::ActorTaskState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ActorTaskState ToKnownEnumValue(ActorTaskState value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ActorTaskState::kDefaultValue;
}


enum class ActorTaskPauseReason : int32_t {
  
  kPausedByModel = 0,
  
  kPausedByUser = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ActorTaskPauseReason value);
inline bool IsKnownEnumValue(ActorTaskPauseReason value) {
  return internal::ActorTaskPauseReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ActorTaskPauseReason ToKnownEnumValue(ActorTaskPauseReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ActorTaskPauseReason::kDefaultValue;
}


enum class ActorTaskStopReason : int32_t {
  
  kTaskComplete = 0,
  
  kStoppedByUser = 1,
  
  kModelError = 2,
  
  kUserStartedNewChat = 3,
  
  kUserLoadedPreviousChat = 4,
  kMinValue = 0,
  kMaxValue = 4,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ActorTaskStopReason value);
inline bool IsKnownEnumValue(ActorTaskStopReason value) {
  return internal::ActorTaskStopReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ActorTaskStopReason ToKnownEnumValue(ActorTaskStopReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ActorTaskStopReason::kDefaultValue;
}


enum class CaptureScreenshotErrorReason : int32_t {
  
  kUnknown = 0,
  
  kScreenCaptureRequestThrottled = 1,
  
  kUserCancelledScreenPickerDialog = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, CaptureScreenshotErrorReason value);
inline bool IsKnownEnumValue(CaptureScreenshotErrorReason value) {
  return internal::CaptureScreenshotErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CaptureScreenshotErrorReason ToKnownEnumValue(CaptureScreenshotErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CaptureScreenshotErrorReason::kDefaultValue;
}


enum class Platform : int32_t {
  
  kUnknown = 0,
  
  kMacOS = 1,
  
  kWindows = 2,
  
  kLinux = 3,
  
  kChromeOS = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, Platform value);
inline bool IsKnownEnumValue(Platform value) {
  return internal::Platform_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ScrollToErrorReason : int32_t {
  
  kNotSupported = 0,
  
  kNewerScrollToCall = 1,
  
  kNoFocusedTab = 2,
  
  kNoMatchFound = 3,
  
  kFocusedTabChangedOrNavigated = 4,
  
  kNoMatchingDocument = 5,
  
  kSearchRangeInvalid = 6,
  
  kTabContextPermissionDisabled = 7,
  
  kDroppedByWebClient = 8,
  kMinValue = 0,
  kMaxValue = 8,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ScrollToErrorReason value);
inline bool IsKnownEnumValue(ScrollToErrorReason value) {
  return internal::ScrollToErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ScrollToErrorReason ToKnownEnumValue(ScrollToErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ScrollToErrorReason::kDefaultValue;
}


enum class SwitchConversationErrorReason : int32_t {
  
  kUnknown = 0,
  kMinValue = 0,
  kMaxValue = 0,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SwitchConversationErrorReason value);
inline bool IsKnownEnumValue(SwitchConversationErrorReason value) {
  return internal::SwitchConversationErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SwitchConversationErrorReason ToKnownEnumValue(SwitchConversationErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SwitchConversationErrorReason::kDefaultValue;
}


enum class RegisterConversationErrorReason : int32_t {
  
  kUnknown = 0,
  
  kInstanceAlreadyHasConversationId = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, RegisterConversationErrorReason value);
inline bool IsKnownEnumValue(RegisterConversationErrorReason value) {
  return internal::RegisterConversationErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline RegisterConversationErrorReason ToKnownEnumValue(RegisterConversationErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return RegisterConversationErrorReason::kDefaultValue;
}


enum class PanelStateKind : int32_t {
  
  kHidden = 0,
  
  kDetached = 1,
  
  kAttached = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PanelStateKind value);
inline bool IsKnownEnumValue(PanelStateKind value) {
  return internal::PanelStateKind_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InvocationSource : int32_t {
  
  kOsButton = 0,
  
  kOsButtonMenu = 1,
  
  kOsHotkey = 2,
  
  kTopChromeButton = 3,
  
  kFre = 4,
  
  kProfilePicker = 5,
  
  kNudge = 6,
  
  kThreeDotsMenu = 7,
  
  kUnsupported = 8,
  
  kWhatsNew = 9,
  
  kAfterSignIn = 10,
  
  kSharedTab = 11,
  
  kActorTaskIcon = 12,
  
  kSharedImage = 13,
  
  kHandoffButton = 14,
  kMinValue = 0,
  kMaxValue = 14,
  kDefaultValue = 8
};

 std::ostream& operator<<(std::ostream& os, InvocationSource value);
inline bool IsKnownEnumValue(InvocationSource value) {
  return internal::InvocationSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InvocationSource ToKnownEnumValue(InvocationSource value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InvocationSource::kDefaultValue;
}


enum class WebClientMode : int32_t {
  
  kUnknown = 2,
  
  kText = 0,
  
  kAudio = 1,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 2
};

 std::ostream& operator<<(std::ostream& os, WebClientMode value);
inline bool IsKnownEnumValue(WebClientMode value) {
  return internal::WebClientMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline WebClientMode ToKnownEnumValue(WebClientMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return WebClientMode::kDefaultValue;
}


enum class WebClientModel : int32_t {
  
  kDefault = 0,
  
  kActor = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, WebClientModel value);
inline bool IsKnownEnumValue(WebClientModel value) {
  return internal::WebClientModel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline WebClientModel ToKnownEnumValue(WebClientModel value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return WebClientModel::kDefaultValue;
}


enum class WebUseCounter : int32_t {
  
  kDefault = 0,
  
  kSubmitPromptWithAutoMode = 1,
  
  kTaskInterruptedForUserConfirmation = 2,
  
  kTaskInterruptedForUserClarification = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, WebUseCounter value);
inline bool IsKnownEnumValue(WebUseCounter value) {
  return internal::WebUseCounter_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline WebUseCounter ToKnownEnumValue(WebUseCounter value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return WebUseCounter::kDefaultValue;
}


enum class ResponseStopCause : int32_t {
  
  kUnknown = 0,
  
  kUser = 1,
  
  kOther = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ResponseStopCause value);
inline bool IsKnownEnumValue(ResponseStopCause value) {
  return internal::ResponseStopCause_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ResponseStopCause ToKnownEnumValue(ResponseStopCause value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ResponseStopCause::kDefaultValue;
}


enum class CaptureRegionErrorReason : int32_t {
  
  kUnknown = 0,
  
  kNoFocusableTab = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, CaptureRegionErrorReason value);
inline bool IsKnownEnumValue(CaptureRegionErrorReason value) {
  return internal::CaptureRegionErrorReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CaptureRegionErrorReason ToKnownEnumValue(CaptureRegionErrorReason value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CaptureRegionErrorReason::kDefaultValue;
}


enum class SettingsPageField : int32_t {
  
  kNone = 0,
  
  kOsHotkey = 1,
  
  kOsEntrypointToggle = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, SettingsPageField value);
inline bool IsKnownEnumValue(SettingsPageField value) {
  return internal::SettingsPageField_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline SettingsPageField ToKnownEnumValue(SettingsPageField value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return SettingsPageField::kDefaultValue;
}


enum class HostCapability : int32_t {
  
  kScrollToPdf = 0,
  
  kResetSizeAndLocationOnOpen = 1,
  
  kGetModelQualityClientId = 2,
  
  kMultiInstance = 3,
  
  kTrustFirstOnboardingArm1 = 4,
  
  kTrustFirstOnboardingArm2 = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, HostCapability value);
inline bool IsKnownEnumValue(HostCapability value) {
  return internal::HostCapability_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CurrentView : int32_t {
  
  kConversation = 0,
  
  kActuation = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CurrentView value);
inline bool IsKnownEnumValue(CurrentView value) {
  return internal::CurrentView_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PinCandidatesObserverInterfaceBase {};

using PinCandidatesObserverPtrDataView =
    mojo::InterfacePtrDataView<PinCandidatesObserverInterfaceBase>;
using PinCandidatesObserverRequestDataView =
    mojo::InterfaceRequestDataView<PinCandidatesObserverInterfaceBase>;
using PinCandidatesObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PinCandidatesObserverInterfaceBase>;
using PinCandidatesObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PinCandidatesObserverInterfaceBase>;
class WebClientHandlerInterfaceBase {};

using WebClientHandlerPtrDataView =
    mojo::InterfacePtrDataView<WebClientHandlerInterfaceBase>;
using WebClientHandlerRequestDataView =
    mojo::InterfaceRequestDataView<WebClientHandlerInterfaceBase>;
using WebClientHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebClientHandlerInterfaceBase>;
using WebClientHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebClientHandlerInterfaceBase>;
class WebClientInterfaceBase {};

using WebClientPtrDataView =
    mojo::InterfacePtrDataView<WebClientInterfaceBase>;
using WebClientRequestDataView =
    mojo::InterfaceRequestDataView<WebClientInterfaceBase>;
using WebClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebClientInterfaceBase>;
using WebClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebClientInterfaceBase>;
class CaptureRegionObserverInterfaceBase {};

using CaptureRegionObserverPtrDataView =
    mojo::InterfacePtrDataView<CaptureRegionObserverInterfaceBase>;
using CaptureRegionObserverRequestDataView =
    mojo::InterfaceRequestDataView<CaptureRegionObserverInterfaceBase>;
using CaptureRegionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CaptureRegionObserverInterfaceBase>;
using CaptureRegionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CaptureRegionObserverInterfaceBase>;


class GetContextResultWithActionResultCodeDataView {
 public:
  GetContextResultWithActionResultCodeDataView() = default;

  GetContextResultWithActionResultCodeDataView(
      internal::GetContextResultWithActionResultCode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGetContextResultDataView(
      GetContextResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGetContextResult(UserType* output) {
    
    auto* pointer = !data_->get_context_result.is_null() ? &data_->get_context_result : nullptr;
    return mojo::internal::Deserialize<::glic::mojom::GetContextResultDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> action_result() const {

    return data_->action_result_$flag
        ? std::make_optional(data_->action_result_$value)
        : std::nullopt;
  }
 private:
  internal::GetContextResultWithActionResultCode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserProfileInfoDataView {
 public:
  UserProfileInfoDataView() = default;

  UserProfileInfoDataView(
      internal::UserProfileInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAvatarIconDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvatarIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `avatar_icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAvatarIcon` instead "
    "of `ReadAvatarIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->avatar_icon.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLocalProfileNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalProfileName(UserType* output) {
    
    auto* pointer = data_->local_profile_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEmailDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmail(UserType* output) {
    
    auto* pointer = data_->email.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGivenNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGivenName(UserType* output) {
    
    auto* pointer = data_->given_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_managed() const {
    return data_->is_managed;
  }
 private:
  internal::UserProfileInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebClientInitialStateDataView {
 public:
  WebClientInitialStateDataView() = default;

  WebClientInitialStateDataView(
      internal::WebClientInitialState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPanelStateDataView(
      PanelStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPanelState(UserType* output) {
    
    auto* pointer = data_->panel_state.Get();
    return mojo::internal::Deserialize<::glic::mojom::PanelStateDataView>(
        pointer, output, message_);
  }
  inline void GetFocusedTabDataDataView(
      FocusedTabDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFocusedTabData(UserType* output) {
    
    auto* pointer = !data_->focused_tab_data.is_null() ? &data_->focused_tab_data : nullptr;
    return mojo::internal::Deserialize<::glic::mojom::FocusedTabDataDataView>(
        pointer, output, message_);
  }
  bool microphone_permission_enabled() const {
    return data_->microphone_permission_enabled;
  }
  bool location_permission_enabled() const {
    return data_->location_permission_enabled;
  }
  bool tab_context_permission_enabled() const {
    return data_->tab_context_permission_enabled;
  }
  bool os_location_permission_enabled() const {
    return data_->os_location_permission_enabled;
  }
  inline void GetHotkeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHotkey(UserType* output) {
    
    auto* pointer = data_->hotkey.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetChromeVersionDataView(
      ::mojo_base::mojom::VersionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChromeVersion(UserType* output) {
    
    auto* pointer = data_->chrome_version.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::VersionDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPlatform(UserType* output) const {
    auto data_value = data_->platform;
    return mojo::internal::Deserialize<::glic::mojom::Platform>(
        data_value, output);
  }
  Platform platform() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::Platform>(data_->platform));
  }
  bool can_attach() const {
    return data_->can_attach;
  }
  bool panel_is_active() const {
    return data_->panel_is_active;
  }
  bool browser_is_open() const {
    return data_->browser_is_open;
  }
  bool instance_is_active() const {
    return data_->instance_is_active;
  }
  bool always_detached_mode() const {
    return data_->always_detached_mode;
  }
  bool enable_zero_state_suggestions() const {
    return data_->enable_zero_state_suggestions;
  }
  bool enable_act_in_focused_tab() const {
    return data_->enable_act_in_focused_tab;
  }
  bool enable_scroll_to() const {
    return data_->enable_scroll_to;
  }
  bool enable_default_tab_context_setting_feature() const {
    return data_->enable_default_tab_context_setting_feature;
  }
  bool default_tab_context_setting_enabled() const {
    return data_->default_tab_context_setting_enabled;
  }
  bool enable_closed_captioning_feature() const {
    return data_->enable_closed_captioning_feature;
  }
  bool closed_captioning_setting_enabled() const {
    return data_->closed_captioning_setting_enabled;
  }
  bool enable_maybe_refresh_user_status() const {
    return data_->enable_maybe_refresh_user_status;
  }
  bool enable_multi_tab() const {
    return data_->enable_multi_tab;
  }
  bool enable_get_context_actor() const {
    return data_->enable_get_context_actor;
  }
  inline void GetHostCapabilitiesDataView(
      mojo::ArrayDataView<HostCapability>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostCapabilities(UserType* output) {
    
    auto* pointer = data_->host_capabilities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::glic::mojom::HostCapability>>(
        pointer, output, message_);
  }
  bool enable_get_page_metadata() const {
    return data_->enable_get_page_metadata;
  }
  bool enable_api_activation_gating() const {
    return data_->enable_api_activation_gating;
  }
  bool enable_capture_region() const {
    return data_->enable_capture_region;
  }
  bool enable_web_actuation_setting_feature() const {
    return data_->enable_web_actuation_setting_feature;
  }
  bool actuation_on_web_setting_enabled() const {
    return data_->actuation_on_web_setting_enabled;
  }
  bool can_act_on_web() const {
    return data_->can_act_on_web;
  }
  bool enable_activate_tab() const {
    return data_->enable_activate_tab;
  }
  bool enable_get_tab_by_id() const {
    return data_->enable_get_tab_by_id;
  }
  bool enable_open_password_manager_settings_page() const {
    return data_->enable_open_password_manager_settings_page;
  }
  bool enable_load_and_extract_content() const {
    return data_->enable_load_and_extract_content;
  }
  bool enable_trust_first_onboarding() const {
    return data_->enable_trust_first_onboarding;
  }
  bool onboarding_completed() const {
    return data_->onboarding_completed;
  }
 private:
  internal::WebClientInitialState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetTabContextOptionsDataView {
 public:
  GetTabContextOptionsDataView() = default;

  GetTabContextOptionsDataView(
      internal::GetTabContextOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool include_inner_text() const {
    return data_->include_inner_text;
  }
  uint32_t inner_text_bytes_limit() const {
    return data_->inner_text_bytes_limit;
  }
  bool include_viewport_screenshot() const {
    return data_->include_viewport_screenshot;
  }
  bool include_annotated_page_content() const {
    return data_->include_annotated_page_content;
  }
  uint32_t max_meta_tags() const {
    return data_->max_meta_tags;
  }
  bool include_pdf() const {
    return data_->include_pdf;
  }
  uint32_t pdf_size_limit() const {
    return data_->pdf_size_limit;
  }
  uint32_t annotated_page_content_mode() const {
    return data_->annotated_page_content_mode;
  }
 private:
  internal::GetTabContextOptions_Data* data_ = nullptr;
};


class GetPinCandidatesOptionsDataView {
 public:
  GetPinCandidatesOptionsDataView() = default;

  GetPinCandidatesOptionsDataView(
      internal::GetPinCandidatesOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t max_candidates() const {
    return data_->max_candidates;
  }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `query` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadQuery` instead "
    "of `ReadQuery if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GetPinCandidatesOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollToParamsDataView {
 public:
  ScrollToParamsDataView() = default;

  ScrollToParamsDataView(
      internal::ScrollToParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSelectorDataView(
      ScrollToSelectorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelector(UserType* output) {
    
    auto* pointer = !data_->selector.is_null() ? &data_->selector : nullptr;
    return mojo::internal::Deserialize<::glic::mojom::ScrollToSelectorDataView>(
        pointer, output, message_);
  }
  bool highlight() const {
    return data_->highlight;
  }
  inline void GetDocumentIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `document_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDocumentId` instead "
    "of `ReadDocumentId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->document_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ScrollToParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollToTextSelectorDataView {
 public:
  ScrollToTextSelectorDataView() = default;

  ScrollToTextSelectorDataView(
      internal::ScrollToTextSelector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> search_range_start_node_id() const {

    return data_->search_range_start_node_id_$flag
        ? std::make_optional(data_->search_range_start_node_id_$value)
        : std::nullopt;
  }
 private:
  internal::ScrollToTextSelector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollToTextFragmentSelectorDataView {
 public:
  ScrollToTextFragmentSelectorDataView() = default;

  ScrollToTextFragmentSelectorDataView(
      internal::ScrollToTextFragmentSelector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextStartDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextStart(UserType* output) {
    
    auto* pointer = data_->text_start.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextEndDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextEnd(UserType* output) {
    
    auto* pointer = data_->text_end.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> search_range_start_node_id() const {

    return data_->search_range_start_node_id_$flag
        ? std::make_optional(data_->search_range_start_node_id_$value)
        : std::nullopt;
  }
 private:
  internal::ScrollToTextFragmentSelector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollToNodeSelectorDataView {
 public:
  ScrollToNodeSelectorDataView() = default;

  ScrollToNodeSelectorDataView(
      internal::ScrollToNodeSelector_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t node_id() const {
    return data_->node_id;
  }
 private:
  internal::ScrollToNodeSelector_Data* data_ = nullptr;
};


class SuggestionContentDataView {
 public:
  SuggestionContentDataView() = default;

  SuggestionContentDataView(
      internal::SuggestionContent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSuggestionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestion(UserType* output) {
    
    auto* pointer = data_->suggestion.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SuggestionContent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ZeroStateSuggestionsDataView {
 public:
  ZeroStateSuggestionsDataView() = default;

  ZeroStateSuggestionsDataView(
      internal::ZeroStateSuggestions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSuggestionsDataView(
      mojo::ArrayDataView<SuggestionContentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestions(UserType* output) {
    
    auto* pointer = data_->suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::glic::mojom::SuggestionContentDataView>>(
        pointer, output, message_);
  }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetTabUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabUrl(UserType* output) {
    
    auto* pointer = data_->tab_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ZeroStateSuggestions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ZeroStateSuggestionsV2DataView {
 public:
  ZeroStateSuggestionsV2DataView() = default;

  ZeroStateSuggestionsV2DataView(
      internal::ZeroStateSuggestionsV2_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSuggestionsDataView(
      mojo::ArrayDataView<SuggestionContentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSuggestions(UserType* output) {
    
    auto* pointer = data_->suggestions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::glic::mojom::SuggestionContentDataView>>(
        pointer, output, message_);
  }
  bool is_pending() const {
    return data_->is_pending;
  }
 private:
  internal::ZeroStateSuggestionsV2_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ZeroStateSuggestionsOptionsDataView {
 public:
  ZeroStateSuggestionsOptionsDataView() = default;

  ZeroStateSuggestionsOptionsDataView(
      internal::ZeroStateSuggestionsOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_first_run() const {
    return data_->is_first_run;
  }
  inline void GetSupportedToolsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedTools(UserType* output) {
    
    auto* pointer = data_->supported_tools.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ZeroStateSuggestionsOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PinCandidateDataView {
 public:
  PinCandidateDataView() = default;

  PinCandidateDataView(
      internal::PinCandidate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabDataDataView(
      TabDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabData(UserType* output) {
    
    auto* pointer = data_->tab_data.Get();
    return mojo::internal::Deserialize<::glic::mojom::TabDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::PinCandidate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConversationInfoDataView {
 public:
  ConversationInfoDataView() = default;

  ConversationInfoDataView(
      internal::ConversationInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConversationIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConversationId(UserType* output) {
    
    auto* pointer = data_->conversation_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConversationTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConversationTitle(UserType* output) {
    
    auto* pointer = data_->conversation_title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ConversationInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PanelOpeningDataDataView {
 public:
  PanelOpeningDataDataView() = default;

  PanelOpeningDataDataView(
      internal::PanelOpeningData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPanelStateDataView(
      PanelStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPanelState(UserType* output) {
    
    auto* pointer = data_->panel_state.Get();
    return mojo::internal::Deserialize<::glic::mojom::PanelStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInvocationSource(UserType* output) const {
    auto data_value = data_->invocation_source;
    return mojo::internal::Deserialize<::glic::mojom::InvocationSource>(
        data_value, output);
  }
  InvocationSource invocation_source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::InvocationSource>(data_->invocation_source));
  }
  inline void GetConversationIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConversationId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `conversation_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConversationId` instead "
    "of `ReadConversationId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->conversation_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPromptSuggestionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPromptSuggestion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `prompt_suggestion` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPromptSuggestion` instead "
    "of `ReadPromptSuggestion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prompt_suggestion.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRecentlyActiveConversationsDataView(
      mojo::ArrayDataView<ConversationInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecentlyActiveConversations(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::glic::mojom::ConversationInfoDataView>, UserType>(),
    "Attempting to read the optional `recently_active_conversations` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecentlyActiveConversations` instead "
    "of `ReadRecentlyActiveConversations if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recently_active_conversations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::glic::mojom::ConversationInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PanelOpeningData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PanelStateDataView {
 public:
  PanelStateDataView() = default;

  PanelStateDataView(
      internal::PanelState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadKind(UserType* output) const {
    auto data_value = data_->kind;
    return mojo::internal::Deserialize<::glic::mojom::PanelStateKind>(
        data_value, output);
  }
  PanelStateKind kind() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::PanelStateKind>(data_->kind));
  }
  std::optional<int32_t> window_id() const {

    return data_->window_id_$flag
        ? std::make_optional(data_->window_id_$value)
        : std::nullopt;
  }
 private:
  internal::PanelState_Data* data_ = nullptr;
};


class OnResponseStoppedDetailsDataView {
 public:
  OnResponseStoppedDetailsDataView() = default;

  OnResponseStoppedDetailsDataView(
      internal::OnResponseStoppedDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCause(UserType* output) const {
    auto data_value = data_->cause;
    return mojo::internal::Deserialize<::glic::mojom::ResponseStopCause>(
        data_value, output);
  }
  ResponseStopCause cause() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::ResponseStopCause>(data_->cause));
  }
 private:
  internal::OnResponseStoppedDetails_Data* data_ = nullptr;
};


class OpenPanelInfoDataView {
 public:
  OpenPanelInfoDataView() = default;

  OpenPanelInfoDataView(
      internal::OpenPanelInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadWebClientMode(UserType* output) const {
    auto data_value = data_->web_client_mode;
    return mojo::internal::Deserialize<::glic::mojom::WebClientMode>(
        data_value, output);
  }
  WebClientMode web_client_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::WebClientMode>(data_->web_client_mode));
  }
  inline void GetPanelSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPanelSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `panelSize` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPanelSize` instead "
    "of `ReadPanelSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->panelSize.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetResizeDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResizeDuration(UserType* output) {
    
    auto* pointer = data_->resizeDuration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool can_user_resize() const {
    return data_->can_user_resize;
  }
 private:
  internal::OpenPanelInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContextDataDataView {
 public:
  ContextDataDataView() = default;

  ContextDataDataView(
      internal::ContextData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContextData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdditionalContextDataView {
 public:
  AdditionalContextDataView() = default;

  AdditionalContextDataView(
      internal::AdditionalContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<int32_t> tab_id() const {

    return data_->tab_id_$flag
        ? std::make_optional(data_->tab_id_$value)
        : std::nullopt;
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrigin` instead "
    "of `ReadOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetFrameUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `frameUrl` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameUrl` instead "
    "of `ReadFrameUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frameUrl.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPartsDataView(
      mojo::ArrayDataView<AdditionalContextPartDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParts(UserType* output) {
    
    auto* pointer = data_->parts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::glic::mojom::AdditionalContextPartDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AdditionalContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabContextDataView {
 public:
  TabContextDataView() = default;

  TabContextDataView(
      internal::TabContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabDataDataView(
      TabDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabData(UserType* output) {
    
    auto* pointer = data_->tab_data.Get();
    return mojo::internal::Deserialize<::glic::mojom::TabDataDataView>(
        pointer, output, message_);
  }
  inline void GetWebPageDataDataView(
      WebPageDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebPageData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::glic::mojom::WebPageDataDataView, UserType>(),
    "Attempting to read the optional `web_page_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebPageData` instead "
    "of `ReadWebPageData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->web_page_data.Get();
    return mojo::internal::Deserialize<::glic::mojom::WebPageDataDataView>(
        pointer, output, message_);
  }
  inline void GetViewportScreenshotDataView(
      ScreenshotDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportScreenshot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::glic::mojom::ScreenshotDataView, UserType>(),
    "Attempting to read the optional `viewport_screenshot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewportScreenshot` instead "
    "of `ReadViewportScreenshot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->viewport_screenshot.Get();
    return mojo::internal::Deserialize<::glic::mojom::ScreenshotDataView>(
        pointer, output, message_);
  }
  inline void GetPdfDocumentDataDataView(
      PdfDocumentDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfDocumentData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::glic::mojom::PdfDocumentDataDataView, UserType>(),
    "Attempting to read the optional `pdf_document_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPdfDocumentData` instead "
    "of `ReadPdfDocumentData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pdf_document_data.Get();
    return mojo::internal::Deserialize<::glic::mojom::PdfDocumentDataDataView>(
        pointer, output, message_);
  }
  inline void GetAnnotatedPageDataDataView(
      AnnotatedPageDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnnotatedPageData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::glic::mojom::AnnotatedPageDataDataView, UserType>(),
    "Attempting to read the optional `annotated_page_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnnotatedPageData` instead "
    "of `ReadAnnotatedPageData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->annotated_page_data.Get();
    return mojo::internal::Deserialize<::glic::mojom::AnnotatedPageDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebPageDataDataView {
 public:
  WebPageDataDataView() = default;

  WebPageDataDataView(
      internal::WebPageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMainDocumentDataView(
      DocumentDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainDocument(UserType* output) {
    
    auto* pointer = data_->main_document.Get();
    return mojo::internal::Deserialize<::glic::mojom::DocumentDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebPageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DocumentDataDataView {
 public:
  DocumentDataDataView() = default;

  DocumentDataDataView(
      internal::DocumentData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInnerTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerText(UserType* output) {
    
    auto* pointer = data_->inner_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool inner_text_truncated() const {
    return data_->inner_text_truncated;
  }
 private:
  internal::DocumentData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfDocumentDataDataView {
 public:
  PdfDocumentDataDataView() = default;

  PdfDocumentDataDataView(
      internal::PdfDocumentData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetPdfDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPdfData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `pdf_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPdfData` instead "
    "of `ReadPdfData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pdf_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  bool size_limit_exceeded() const {
    return data_->size_limit_exceeded;
  }
 private:
  internal::PdfDocumentData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabDataDataView {
 public:
  TabDataDataView() = default;

  TabDataDataView(
      internal::TabData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  int32_t window_id() const {
    return data_->window_id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFaviconDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFavicon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `favicon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFavicon` instead "
    "of `ReadFavicon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->favicon.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `favicon_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFaviconUrl` instead "
    "of `ReadFaviconUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetDocumentMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentMimeType(UserType* output) {
    
    auto* pointer = data_->document_mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  std::optional<bool> is_observable() const {

    return data_->is_observable_$flag
        ? std::make_optional(!!data_->is_observable_$value)
        : std::nullopt;
  }
  std::optional<bool> is_media_active() const {

    return data_->is_media_active_$flag
        ? std::make_optional(!!data_->is_media_active_$value)
        : std::nullopt;
  }
  std::optional<bool> is_tab_content_captured() const {

    return data_->is_tab_content_captured_$flag
        ? std::make_optional(!!data_->is_tab_content_captured_$value)
        : std::nullopt;
  }
  std::optional<bool> is_active_in_window() const {

    return data_->is_active_in_window_$flag
        ? std::make_optional(!!data_->is_active_in_window_$value)
        : std::nullopt;
  }
  std::optional<bool> is_window_active() const {

    return data_->is_window_active_$flag
        ? std::make_optional(!!data_->is_window_active_$value)
        : std::nullopt;
  }
 private:
  internal::TabData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NoFocusedTabDataDataView {
 public:
  NoFocusedTabDataDataView() = default;

  NoFocusedTabDataDataView(
      internal::NoFocusedTabData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActiveTabDataDataView(
      TabDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActiveTabData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::glic::mojom::TabDataDataView, UserType>(),
    "Attempting to read the optional `active_tab_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActiveTabData` instead "
    "of `ReadActiveTabData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->active_tab_data.Get();
    return mojo::internal::Deserialize<::glic::mojom::TabDataDataView>(
        pointer, output, message_);
  }
  inline void GetNoFocusReasonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoFocusReason(UserType* output) {
    
    auto* pointer = data_->no_focus_reason.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::NoFocusedTabData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AnnotatedPageDataDataView {
 public:
  AnnotatedPageDataDataView() = default;

  AnnotatedPageDataDataView(
      internal::AnnotatedPageData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAnnotatedPageContentDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnnotatedPageContent(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ProtoWrapperDataView, UserType>(),
    "Attempting to read the optional `annotated_page_content` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnnotatedPageContent` instead "
    "of `ReadAnnotatedPageContent if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->annotated_page_content.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::blink::mojom::PageMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PageMetadataDataView, UserType>(),
    "Attempting to read the optional `metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetadata` instead "
    "of `ReadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::blink::mojom::PageMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnnotatedPageData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ImageOriginAnnotationsDataView {
 public:
  ImageOriginAnnotationsDataView() = default;

  ImageOriginAnnotationsDataView(
      internal::ImageOriginAnnotations_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ImageOriginAnnotations_Data* data_ = nullptr;
};


class JournalDataView {
 public:
  JournalDataView() = default;

  JournalDataView(
      internal::Journal_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Journal_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CaptureRegionResultDataView {
 public:
  CaptureRegionResultDataView() = default;

  CaptureRegionResultDataView(
      internal::CaptureRegionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetRegionDataView(
      CapturedRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = !data_->region.is_null() ? &data_->region : nullptr;
    return mojo::internal::Deserialize<::glic::mojom::CapturedRegionDataView>(
        pointer, output, message_);
  }
 private:
  internal::CaptureRegionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScreenshotDataView {
 public:
  ScreenshotDataView() = default;

  ScreenshotDataView(
      internal::Screenshot_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t width_pixels() const {
    return data_->width_pixels;
  }
  uint32_t height_pixels() const {
    return data_->height_pixels;
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginAnnotationsDataView(
      ImageOriginAnnotationsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginAnnotations(UserType* output) {
    
    auto* pointer = data_->origin_annotations.Get();
    return mojo::internal::Deserialize<::glic::mojom::ImageOriginAnnotationsDataView>(
        pointer, output, message_);
  }
 private:
  internal::Screenshot_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OpenSettingsOptionsDataView {
 public:
  OpenSettingsOptionsDataView() = default;

  OpenSettingsOptionsDataView(
      internal::OpenSettingsOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadHighlightField(UserType* output) const {
    auto data_value = data_->highlightField;
    return mojo::internal::Deserialize<::glic::mojom::SettingsPageField>(
        data_value, output);
  }
  SettingsPageField highlightField() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::SettingsPageField>(data_->highlightField));
  }
 private:
  internal::OpenSettingsOptions_Data* data_ = nullptr;
};


class ViewChangeRequestActuationDataView {
 public:
  ViewChangeRequestActuationDataView() = default;

  ViewChangeRequestActuationDataView(
      internal::ViewChangeRequestActuation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ViewChangeRequestActuation_Data* data_ = nullptr;
};


class ViewChangeRequestConversationDataView {
 public:
  ViewChangeRequestConversationDataView() = default;

  ViewChangeRequestConversationDataView(
      internal::ViewChangeRequestConversation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ViewChangeRequestConversation_Data* data_ = nullptr;
};


class ViewChangeRequestDataView {
 public:
  ViewChangeRequestDataView() = default;

  ViewChangeRequestDataView(
      internal::ViewChangeRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDetailsDataView(
      ViewChangeRequestDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = !data_->details.is_null() ? &data_->details : nullptr;
    return mojo::internal::Deserialize<::glic::mojom::ViewChangeRequestDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ViewChangeRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewChangedNotificationDataView {
 public:
  ViewChangedNotificationDataView() = default;

  ViewChangedNotificationDataView(
      internal::ViewChangedNotification_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentView(UserType* output) const {
    auto data_value = data_->current_view;
    return mojo::internal::Deserialize<::glic::mojom::CurrentView>(
        data_value, output);
  }
  CurrentView current_view() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::glic::mojom::CurrentView>(data_->current_view));
  }
 private:
  internal::ViewChangedNotification_Data* data_ = nullptr;
};


class GetContextResultDataView {
 public:
  using Tag = internal::GetContextResult_Data::GetContextResult_Tag;

  GetContextResultDataView() = default;

  GetContextResultDataView(
      internal::GetContextResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_reason() const { return data_->tag == Tag::kErrorReason; }
  inline void GetErrorReasonDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    
    CHECK(is_error_reason());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error_reason.Get(), output, message_);
  }
  bool is_tab_context() const { return data_->tag == Tag::kTabContext; }
  inline void GetTabContextDataView(
      TabContextDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabContext(UserType* output) const {
    
    CHECK(is_tab_context());
    return mojo::internal::Deserialize<::glic::mojom::TabContextDataView>(
        data_->data.f_tab_context.Get(), output, message_);
  }

 private:
  internal::GetContextResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CaptureScreenshotResultDataView {
 public:
  using Tag = internal::CaptureScreenshotResult_Data::CaptureScreenshotResult_Tag;

  CaptureScreenshotResultDataView() = default;

  CaptureScreenshotResultDataView(
      internal::CaptureScreenshotResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_reason() const { return data_->tag == Tag::kErrorReason; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorReason(UserType* output) const {
    CHECK(is_error_reason());
    return mojo::internal::Deserialize<::glic::mojom::CaptureScreenshotErrorReason>(
        data_->data.f_error_reason, output);
  }
  CaptureScreenshotErrorReason error_reason() const {
    CHECK(is_error_reason());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::CaptureScreenshotErrorReason>(data_->data.f_error_reason));
  }
  bool is_screenshot() const { return data_->tag == Tag::kScreenshot; }
  inline void GetScreenshotDataView(
      ScreenshotDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScreenshot(UserType* output) const {
    
    CHECK(is_screenshot());
    return mojo::internal::Deserialize<::glic::mojom::ScreenshotDataView>(
        data_->data.f_screenshot.Get(), output, message_);
  }

 private:
  internal::CaptureScreenshotResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ScrollToSelectorDataView {
 public:
  using Tag = internal::ScrollToSelector_Data::ScrollToSelector_Tag;

  ScrollToSelectorDataView() = default;

  ScrollToSelectorDataView(
      internal::ScrollToSelector_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_exact_text_selector() const { return data_->tag == Tag::kExactTextSelector; }
  inline void GetExactTextSelectorDataView(
      ScrollToTextSelectorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadExactTextSelector(UserType* output) const {
    
    CHECK(is_exact_text_selector());
    return mojo::internal::Deserialize<::glic::mojom::ScrollToTextSelectorDataView>(
        data_->data.f_exact_text_selector.Get(), output, message_);
  }
  bool is_text_fragment_selector() const { return data_->tag == Tag::kTextFragmentSelector; }
  inline void GetTextFragmentSelectorDataView(
      ScrollToTextFragmentSelectorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTextFragmentSelector(UserType* output) const {
    
    CHECK(is_text_fragment_selector());
    return mojo::internal::Deserialize<::glic::mojom::ScrollToTextFragmentSelectorDataView>(
        data_->data.f_text_fragment_selector.Get(), output, message_);
  }
  bool is_node_selector() const { return data_->tag == Tag::kNodeSelector; }
  inline void GetNodeSelectorDataView(
      ScrollToNodeSelectorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNodeSelector(UserType* output) const {
    
    CHECK(is_node_selector());
    return mojo::internal::Deserialize<::glic::mojom::ScrollToNodeSelectorDataView>(
        data_->data.f_node_selector.Get(), output, message_);
  }

 private:
  internal::ScrollToSelector_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class AdditionalContextPartDataView {
 public:
  using Tag = internal::AdditionalContextPart_Data::AdditionalContextPart_Tag;

  AdditionalContextPartDataView() = default;

  AdditionalContextPartDataView(
      internal::AdditionalContextPart_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      ContextDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<::glic::mojom::ContextDataDataView>(
        data_->data.f_data.Get(), output, message_);
  }
  bool is_screenshot() const { return data_->tag == Tag::kScreenshot; }
  inline void GetScreenshotDataView(
      ScreenshotDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadScreenshot(UserType* output) const {
    
    CHECK(is_screenshot());
    return mojo::internal::Deserialize<::glic::mojom::ScreenshotDataView>(
        data_->data.f_screenshot.Get(), output, message_);
  }
  bool is_web_page_data() const { return data_->tag == Tag::kWebPageData; }
  inline void GetWebPageDataDataView(
      WebPageDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadWebPageData(UserType* output) const {
    
    CHECK(is_web_page_data());
    return mojo::internal::Deserialize<::glic::mojom::WebPageDataDataView>(
        data_->data.f_web_page_data.Get(), output, message_);
  }
  bool is_annotated_page_data() const { return data_->tag == Tag::kAnnotatedPageData; }
  inline void GetAnnotatedPageDataDataView(
      AnnotatedPageDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAnnotatedPageData(UserType* output) const {
    
    CHECK(is_annotated_page_data());
    return mojo::internal::Deserialize<::glic::mojom::AnnotatedPageDataDataView>(
        data_->data.f_annotated_page_data.Get(), output, message_);
  }
  bool is_pdf_document_data() const { return data_->tag == Tag::kPdfDocumentData; }
  inline void GetPdfDocumentDataDataView(
      PdfDocumentDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPdfDocumentData(UserType* output) const {
    
    CHECK(is_pdf_document_data());
    return mojo::internal::Deserialize<::glic::mojom::PdfDocumentDataDataView>(
        data_->data.f_pdf_document_data.Get(), output, message_);
  }
  bool is_tab_context() const { return data_->tag == Tag::kTabContext; }
  inline void GetTabContextDataView(
      TabContextDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabContext(UserType* output) const {
    
    CHECK(is_tab_context());
    return mojo::internal::Deserialize<::glic::mojom::TabContextDataView>(
        data_->data.f_tab_context.Get(), output, message_);
  }

 private:
  internal::AdditionalContextPart_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class FocusedTabDataDataView {
 public:
  using Tag = internal::FocusedTabData_Data::FocusedTabData_Tag;

  FocusedTabDataDataView() = default;

  FocusedTabDataDataView(
      internal::FocusedTabData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_focused_tab() const { return data_->tag == Tag::kFocusedTab; }
  inline void GetFocusedTabDataView(
      TabDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFocusedTab(UserType* output) const {
    
    CHECK(is_focused_tab());
    return mojo::internal::Deserialize<::glic::mojom::TabDataDataView>(
        data_->data.f_focused_tab.Get(), output, message_);
  }
  bool is_no_focused_tab_data() const { return data_->tag == Tag::kNoFocusedTabData; }
  inline void GetNoFocusedTabDataDataView(
      NoFocusedTabDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNoFocusedTabData(UserType* output) const {
    
    CHECK(is_no_focused_tab_data());
    return mojo::internal::Deserialize<::glic::mojom::NoFocusedTabDataDataView>(
        data_->data.f_no_focused_tab_data.Get(), output, message_);
  }

 private:
  internal::FocusedTabData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class CapturedRegionDataView {
 public:
  using Tag = internal::CapturedRegion_Data::CapturedRegion_Tag;

  CapturedRegionDataView() = default;

  CapturedRegionDataView(
      internal::CapturedRegion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_rect() const { return data_->tag == Tag::kRect; }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) const {
    
    CHECK(is_rect());
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        data_->data.f_rect.Get(), output, message_);
  }

 private:
  internal::CapturedRegion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class ViewChangeRequestDetailsDataView {
 public:
  using Tag = internal::ViewChangeRequestDetails_Data::ViewChangeRequestDetails_Tag;

  ViewChangeRequestDetailsDataView() = default;

  ViewChangeRequestDetailsDataView(
      internal::ViewChangeRequestDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_actuation() const { return data_->tag == Tag::kActuation; }
  inline void GetActuationDataView(
      ViewChangeRequestActuationDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadActuation(UserType* output) const {
    
    CHECK(is_actuation());
    return mojo::internal::Deserialize<::glic::mojom::ViewChangeRequestActuationDataView>(
        data_->data.f_actuation.Get(), output, message_);
  }
  bool is_conversation() const { return data_->tag == Tag::kConversation; }
  inline void GetConversationDataView(
      ViewChangeRequestConversationDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadConversation(UserType* output) const {
    
    CHECK(is_conversation());
    return mojo::internal::Deserialize<::glic::mojom::ViewChangeRequestConversationDataView>(
        data_->data.f_conversation.Get(), output, message_);
  }

 private:
  internal::ViewChangeRequestDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class WebClientHandler_CreateTask_ResponseParam_ResultDataView {
 public:
  using Tag = internal::WebClientHandler_CreateTask_ResponseParam_Result_Data::WebClientHandler_CreateTask_ResponseParam_Result_Tag;

  WebClientHandler_CreateTask_ResponseParam_ResultDataView() = default;

  WebClientHandler_CreateTask_ResponseParam_ResultDataView(
      internal::WebClientHandler_CreateTask_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  int32_t success() const {
    CHECK(is_success());
    return data_->data.f_success;
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::glic::mojom::CreateTaskErrorReason>(
        data_->data.f_failure, output);
  }
  CreateTaskErrorReason failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::CreateTaskErrorReason>(data_->data.f_failure));
  }

 private:
  internal::WebClientHandler_CreateTask_ResponseParam_Result_Data* data_ = nullptr;
};



class WebClientHandler_PerformActions_ResponseParam_ResultDataView {
 public:
  using Tag = internal::WebClientHandler_PerformActions_ResponseParam_Result_Data::WebClientHandler_PerformActions_ResponseParam_Result_Tag;

  WebClientHandler_PerformActions_ResponseParam_ResultDataView() = default;

  WebClientHandler_PerformActions_ResponseParam_ResultDataView(
      internal::WebClientHandler_PerformActions_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::glic::mojom::PerformActionsErrorReason>(
        data_->data.f_failure, output);
  }
  PerformActionsErrorReason failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::PerformActionsErrorReason>(data_->data.f_failure));
  }

 private:
  internal::WebClientHandler_PerformActions_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // glic::mojom

#endif  // CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_DATA_VIEW_H_