// chrome/browser/glic/fre/glic_fre.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_GLIC_FRE_GLIC_FRE_MOJOM_H_
#define CHROME_BROWSER_GLIC_FRE_GLIC_FRE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/glic/fre/glic_fre.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/glic/fre/glic_fre.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/glic/fre/glic_fre.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace glic::mojom {

class FrePageHandlerFactoryProxy;

template <typename ImplRefTraits>
class FrePageHandlerFactoryStub;

class FrePageHandlerFactoryRequestValidator;


class FrePageHandlerFactory
    : public FrePageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.FrePageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrePageHandlerFactoryInterfaceBase;
  using Proxy_ = FrePageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrePageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = FrePageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrePageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingReceiver<FrePageHandler> receiver) = 0;
};

class FrePageHandlerProxy;

template <typename ImplRefTraits>
class FrePageHandlerStub;

class FrePageHandlerRequestValidator;
class FrePageHandlerResponseValidator;


class FrePageHandler
    : public FrePageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "glic.mojom.FrePageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrePageHandlerInterfaceBase;
  using Proxy_ = FrePageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrePageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = FrePageHandlerRequestValidator;
  using ResponseValidator_ = FrePageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAcceptFreMinVersion = 0,
    kRejectFreMinVersion = 0,
    kDismissFreMinVersion = 0,
    kFreReloadedMinVersion = 0,
    kPrepareForClientMinVersion = 0,
    kValidateAndOpenLinkInNewTabMinVersion = 0,
    kWebUiStateChangedMinVersion = 0,
    kExceededTimeoutErrorMinVersion = 0,
    kLogWebUiLoadCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AcceptFre_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RejectFre_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DismissFre_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FreReloaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrepareForClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ValidateAndOpenLinkInNewTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WebUiStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExceededTimeoutError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogWebUiLoadComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrePageHandler() = default;

  virtual void AcceptFre() = 0;

  virtual void RejectFre() = 0;

  virtual void DismissFre(FreWebUiState panel) = 0;

  virtual void FreReloaded() = 0;

  using PrepareForClientCallback = base::OnceCallback<void(bool)>;
  using PrepareForClientMojoCallback = base::OnceCallback<void(bool)>;

  virtual void PrepareForClient(PrepareForClientCallback callback) = 0;

  virtual void ValidateAndOpenLinkInNewTab(const ::GURL& url) = 0;

  virtual void WebUiStateChanged(FreWebUiState new_state) = 0;

  virtual void ExceededTimeoutError() = 0;

  virtual void LogWebUiLoadComplete() = 0;
};



class  FrePageHandlerFactoryProxy
    : public FrePageHandlerFactory {
 public:
  using InterfaceType = FrePageHandlerFactory;

  explicit FrePageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingReceiver<FrePageHandler> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrePageHandlerProxy
    : public FrePageHandler {
 public:
  using InterfaceType = FrePageHandler;

  explicit FrePageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AcceptFre() final;
  
  void RejectFre() final;
  
  void DismissFre(FreWebUiState panel) final;
  
  void FreReloaded() final;
  
  void PrepareForClient(PrepareForClientCallback callback) final;
  
  void ValidateAndOpenLinkInNewTab(const ::GURL& url) final;
  
  void WebUiStateChanged(FreWebUiState new_state) final;
  
  void ExceededTimeoutError() final;
  
  void LogWebUiLoadComplete() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrePageHandlerFactoryStubDispatch {
 public:
  static bool Accept(FrePageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrePageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrePageHandlerFactory>>
class FrePageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrePageHandlerFactoryStub() = default;
  ~FrePageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrePageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrePageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrePageHandlerStubDispatch {
 public:
  static bool Accept(FrePageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrePageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrePageHandler>>
class FrePageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrePageHandlerStub() = default;
  ~FrePageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrePageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrePageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrePageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrePageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrePageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // glic::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_GLIC_FRE_GLIC_FRE_MOJOM_H_