// chrome/browser/glic/fre/glic_fre.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/glic/fre/glic_fre.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/glic/fre/glic_fre.mojom-params-data.h"
namespace glic {
namespace mojom {

NOINLINE static const char* FreWebUiStateToStringHelper(FreWebUiState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FreWebUiState::kUninitialized:
      return "kUninitialized";
    case FreWebUiState::kBeginLoading:
      return "kBeginLoading";
    case FreWebUiState::kShowLoading:
      return "kShowLoading";
    case FreWebUiState::kHoldLoading:
      return "kHoldLoading";
    case FreWebUiState::kFinishLoading:
      return "kFinishLoading";
    case FreWebUiState::kError:
      return "kError";
    case FreWebUiState::kOffline:
      return "kOffline";
    case FreWebUiState::kReady:
      return "kReady";
    case FreWebUiState::kDisabledByAdmin:
      return "kDisabledByAdmin";
    default:
      return nullptr;
  }
}

std::string FreWebUiStateToString(FreWebUiState value) {
  const char *str = FreWebUiStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FreWebUiState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FreWebUiState value) {
  return os << FreWebUiStateToString(value);
}

namespace internal {


// static
bool FrePageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const FrePageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FrePageHandlerFactory_CreatePageHandler_Params_Data::FrePageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_AcceptFre_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_AcceptFre_Params_Data* object =
      static_cast<const FrePageHandler_AcceptFre_Params_Data*>(data);

  return true;
}

FrePageHandler_AcceptFre_Params_Data::FrePageHandler_AcceptFre_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_RejectFre_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_RejectFre_Params_Data* object =
      static_cast<const FrePageHandler_RejectFre_Params_Data*>(data);

  return true;
}

FrePageHandler_RejectFre_Params_Data::FrePageHandler_RejectFre_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_DismissFre_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_DismissFre_Params_Data* object =
      static_cast<const FrePageHandler_DismissFre_Params_Data*>(data);


  if (!::glic::mojom::internal::FreWebUiState_Data
        ::Validate(object->panel, validation_context))
    return false;

  return true;
}

FrePageHandler_DismissFre_Params_Data::FrePageHandler_DismissFre_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_FreReloaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_FreReloaded_Params_Data* object =
      static_cast<const FrePageHandler_FreReloaded_Params_Data*>(data);

  return true;
}

FrePageHandler_FreReloaded_Params_Data::FrePageHandler_FreReloaded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_PrepareForClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_PrepareForClient_Params_Data* object =
      static_cast<const FrePageHandler_PrepareForClient_Params_Data*>(data);

  return true;
}

FrePageHandler_PrepareForClient_Params_Data::FrePageHandler_PrepareForClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_PrepareForClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_PrepareForClient_ResponseParams_Data* object =
      static_cast<const FrePageHandler_PrepareForClient_ResponseParams_Data*>(data);

  return true;
}

FrePageHandler_PrepareForClient_ResponseParams_Data::FrePageHandler_PrepareForClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data* object =
      static_cast<const FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data::FrePageHandler_ValidateAndOpenLinkInNewTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_WebUiStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_WebUiStateChanged_Params_Data* object =
      static_cast<const FrePageHandler_WebUiStateChanged_Params_Data*>(data);


  if (!::glic::mojom::internal::FreWebUiState_Data
        ::Validate(object->new_state, validation_context))
    return false;

  return true;
}

FrePageHandler_WebUiStateChanged_Params_Data::FrePageHandler_WebUiStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_ExceededTimeoutError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_ExceededTimeoutError_Params_Data* object =
      static_cast<const FrePageHandler_ExceededTimeoutError_Params_Data*>(data);

  return true;
}

FrePageHandler_ExceededTimeoutError_Params_Data::FrePageHandler_ExceededTimeoutError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrePageHandler_LogWebUiLoadComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrePageHandler_LogWebUiLoadComplete_Params_Data* object =
      static_cast<const FrePageHandler_LogWebUiLoadComplete_Params_Data*>(data);

  return true;
}

FrePageHandler_LogWebUiLoadComplete_Params_Data::FrePageHandler_LogWebUiLoadComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace glic

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::FreWebUiState>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::FreWebUiState value) {
  return std::move(context).WriteString(::glic::mojom::FreWebUiStateToString(value));
}

} // namespace perfetto