// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/devtools/protocol/storage.h"

#include "chrome/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace protocol {
namespace Storage {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Storage";
const char Metainfo::commandPrefix[] = "Storage.";
const char Metainfo::version[] = "1.3";



namespace InterestGroupAccessTypeEnum {
const char Join[] = "join";
const char Leave[] = "leave";
const char Update[] = "update";
const char Loaded[] = "loaded";
const char Bid[] = "bid";
const char Win[] = "win";
const char AdditionalBid[] = "additionalBid";
const char AdditionalBidWin[] = "additionalBidWin";
const char TopLevelBid[] = "topLevelBid";
const char TopLevelAdditionalBid[] = "topLevelAdditionalBid";
const char Clear[] = "clear";
} // namespace InterestGroupAccessTypeEnum


namespace InterestGroupAuctionEventTypeEnum {
const char Started[] = "started";
const char ConfigResolved[] = "configResolved";
} // namespace InterestGroupAuctionEventTypeEnum


namespace InterestGroupAuctionFetchTypeEnum {
const char BidderJs[] = "bidderJs";
const char BidderWasm[] = "bidderWasm";
const char SellerJs[] = "sellerJs";
const char BidderTrustedSignals[] = "bidderTrustedSignals";
const char SellerTrustedSignals[] = "sellerTrustedSignals";
} // namespace InterestGroupAuctionFetchTypeEnum


namespace SharedStorageAccessScopeEnum {
const char Window[] = "window";
const char SharedStorageWorklet[] = "sharedStorageWorklet";
const char ProtectedAudienceWorklet[] = "protectedAudienceWorklet";
const char Header[] = "header";
} // namespace SharedStorageAccessScopeEnum


namespace SharedStorageAccessMethodEnum {
const char AddModule[] = "addModule";
const char CreateWorklet[] = "createWorklet";
const char SelectURL[] = "selectURL";
const char Run[] = "run";
const char BatchUpdate[] = "batchUpdate";
const char Set[] = "set";
const char Append[] = "append";
const char Delete[] = "delete";
const char Clear[] = "clear";
const char Get[] = "get";
const char Keys[] = "keys";
const char Values[] = "values";
const char Entries[] = "entries";
const char Length[] = "length";
const char RemainingBudget[] = "remainingBudget";
} // namespace SharedStorageAccessMethodEnum


CRDTP_BEGIN_DESERIALIZER(SharedStoragePrivateAggregationConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("contextId", m_contextId),
    CRDTP_DESERIALIZE_FIELD("filteringIdMaxBytes", m_filteringIdMaxBytes),
    CRDTP_DESERIALIZE_FIELD_OPT("maxContributions", m_maxContributions),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStoragePrivateAggregationConfig)
    CRDTP_SERIALIZE_FIELD("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin);
    CRDTP_SERIALIZE_FIELD("contextId", m_contextId);
    CRDTP_SERIALIZE_FIELD("filteringIdMaxBytes", m_filteringIdMaxBytes);
    CRDTP_SERIALIZE_FIELD("maxContributions", m_maxContributions);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageReportingMetadata)
    CRDTP_DESERIALIZE_FIELD("eventType", m_eventType),
    CRDTP_DESERIALIZE_FIELD("reportingUrl", m_reportingUrl),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageReportingMetadata)
    CRDTP_SERIALIZE_FIELD("eventType", m_eventType);
    CRDTP_SERIALIZE_FIELD("reportingUrl", m_reportingUrl);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageUrlWithMetadata)
    CRDTP_DESERIALIZE_FIELD("reportingMetadata", m_reportingMetadata),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageUrlWithMetadata)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("reportingMetadata", m_reportingMetadata);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SharedStorageAccessParams)
    CRDTP_DESERIALIZE_FIELD_OPT("batchSize", m_batchSize),
    CRDTP_DESERIALIZE_FIELD_OPT("batchUpdateId", m_batchUpdateId),
    CRDTP_DESERIALIZE_FIELD_OPT("dataOrigin", m_dataOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("ignoreIfPresent", m_ignoreIfPresent),
    CRDTP_DESERIALIZE_FIELD_OPT("keepAlive", m_keepAlive),
    CRDTP_DESERIALIZE_FIELD_OPT("key", m_key),
    CRDTP_DESERIALIZE_FIELD_OPT("operationId", m_operationId),
    CRDTP_DESERIALIZE_FIELD_OPT("operationName", m_operationName),
    CRDTP_DESERIALIZE_FIELD_OPT("privateAggregationConfig", m_privateAggregationConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("scriptSourceUrl", m_scriptSourceUrl),
    CRDTP_DESERIALIZE_FIELD_OPT("serializedData", m_serializedData),
    CRDTP_DESERIALIZE_FIELD_OPT("urlsWithMetadata", m_urlsWithMetadata),
    CRDTP_DESERIALIZE_FIELD_OPT("urnUuid", m_urnUuid),
    CRDTP_DESERIALIZE_FIELD_OPT("value", m_value),
    CRDTP_DESERIALIZE_FIELD_OPT("withLock", m_withLock),
    CRDTP_DESERIALIZE_FIELD_OPT("workletOrdinal", m_workletOrdinal),
    CRDTP_DESERIALIZE_FIELD_OPT("workletTargetId", m_workletTargetId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SharedStorageAccessParams)
    CRDTP_SERIALIZE_FIELD("scriptSourceUrl", m_scriptSourceUrl);
    CRDTP_SERIALIZE_FIELD("dataOrigin", m_dataOrigin);
    CRDTP_SERIALIZE_FIELD("operationName", m_operationName);
    CRDTP_SERIALIZE_FIELD("operationId", m_operationId);
    CRDTP_SERIALIZE_FIELD("keepAlive", m_keepAlive);
    CRDTP_SERIALIZE_FIELD("privateAggregationConfig", m_privateAggregationConfig);
    CRDTP_SERIALIZE_FIELD("serializedData", m_serializedData);
    CRDTP_SERIALIZE_FIELD("urlsWithMetadata", m_urlsWithMetadata);
    CRDTP_SERIALIZE_FIELD("urnUuid", m_urnUuid);
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("ignoreIfPresent", m_ignoreIfPresent);
    CRDTP_SERIALIZE_FIELD("workletOrdinal", m_workletOrdinal);
    CRDTP_SERIALIZE_FIELD("workletTargetId", m_workletTargetId);
    CRDTP_SERIALIZE_FIELD("withLock", m_withLock);
    CRDTP_SERIALIZE_FIELD("batchUpdateId", m_batchUpdateId);
    CRDTP_SERIALIZE_FIELD("batchSize", m_batchSize);
CRDTP_END_SERIALIZER();


namespace StorageBucketsDurabilityEnum {
const char Relaxed[] = "relaxed";
const char Strict[] = "strict";
} // namespace StorageBucketsDurabilityEnum


CRDTP_BEGIN_DESERIALIZER(StorageBucket)
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
    CRDTP_DESERIALIZE_FIELD("storageKey", m_storageKey),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StorageBucket)
    CRDTP_SERIALIZE_FIELD("storageKey", m_storageKey);
    CRDTP_SERIALIZE_FIELD("name", m_name);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(StorageBucketInfo)
    CRDTP_DESERIALIZE_FIELD("bucket", m_bucket),
    CRDTP_DESERIALIZE_FIELD("durability", m_durability),
    CRDTP_DESERIALIZE_FIELD("expiration", m_expiration),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("persistent", m_persistent),
    CRDTP_DESERIALIZE_FIELD("quota", m_quota),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StorageBucketInfo)
    CRDTP_SERIALIZE_FIELD("bucket", m_bucket);
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("expiration", m_expiration);
    CRDTP_SERIALIZE_FIELD("quota", m_quota);
    CRDTP_SERIALIZE_FIELD("persistent", m_persistent);
    CRDTP_SERIALIZE_FIELD("durability", m_durability);
CRDTP_END_SERIALIZER();


namespace AttributionReportingSourceTypeEnum {
const char Navigation[] = "navigation";
const char Event[] = "event";
} // namespace AttributionReportingSourceTypeEnum





CRDTP_BEGIN_DESERIALIZER(AttributionReportingFilterDataEntry)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("values", m_values),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingFilterDataEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("values", m_values);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingFilterConfig)
    CRDTP_DESERIALIZE_FIELD("filterValues", m_filterValues),
    CRDTP_DESERIALIZE_FIELD_OPT("lookbackWindow", m_lookbackWindow),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingFilterConfig)
    CRDTP_SERIALIZE_FIELD("filterValues", m_filterValues);
    CRDTP_SERIALIZE_FIELD("lookbackWindow", m_lookbackWindow);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingFilterPair)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("notFilters", m_notFilters),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingFilterPair)
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
    CRDTP_SERIALIZE_FIELD("notFilters", m_notFilters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregationKeysEntry)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregationKeysEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingEventReportWindows)
    CRDTP_DESERIALIZE_FIELD("ends", m_ends),
    CRDTP_DESERIALIZE_FIELD("start", m_start),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingEventReportWindows)
    CRDTP_SERIALIZE_FIELD("start", m_start);
    CRDTP_SERIALIZE_FIELD("ends", m_ends);
CRDTP_END_SERIALIZER();


namespace AttributionReportingTriggerDataMatchingEnum {
const char Exact[] = "exact";
const char Modulus[] = "modulus";
} // namespace AttributionReportingTriggerDataMatchingEnum


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableDebugReportingData)
    CRDTP_DESERIALIZE_FIELD("keyPiece", m_keyPiece),
    CRDTP_DESERIALIZE_FIELD("types", m_types),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableDebugReportingData)
    CRDTP_SERIALIZE_FIELD("keyPiece", m_keyPiece);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("types", m_types);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableDebugReportingConfig)
    CRDTP_DESERIALIZE_FIELD_OPT("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("budget", m_budget),
    CRDTP_DESERIALIZE_FIELD("debugData", m_debugData),
    CRDTP_DESERIALIZE_FIELD("keyPiece", m_keyPiece),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableDebugReportingConfig)
    CRDTP_SERIALIZE_FIELD("budget", m_budget);
    CRDTP_SERIALIZE_FIELD("keyPiece", m_keyPiece);
    CRDTP_SERIALIZE_FIELD("debugData", m_debugData);
    CRDTP_SERIALIZE_FIELD("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionScopesData)
    CRDTP_DESERIALIZE_FIELD("limit", m_limit),
    CRDTP_DESERIALIZE_FIELD("maxEventStates", m_maxEventStates),
    CRDTP_DESERIALIZE_FIELD("values", m_values),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionScopesData)
    CRDTP_SERIALIZE_FIELD("values", m_values);
    CRDTP_SERIALIZE_FIELD("limit", m_limit);
    CRDTP_SERIALIZE_FIELD("maxEventStates", m_maxEventStates);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingNamedBudgetDef)
    CRDTP_DESERIALIZE_FIELD("budget", m_budget),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingNamedBudgetDef)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("budget", m_budget);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingSourceRegistration)
    CRDTP_DESERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig),
    CRDTP_DESERIALIZE_FIELD("aggregatableReportWindow", m_aggregatableReportWindow),
    CRDTP_DESERIALIZE_FIELD("aggregationKeys", m_aggregationKeys),
    CRDTP_DESERIALIZE_FIELD_OPT("debugKey", m_debugKey),
    CRDTP_DESERIALIZE_FIELD("debugReporting", m_debugReporting),
    CRDTP_DESERIALIZE_FIELD("destinationLimitPriority", m_destinationLimitPriority),
    CRDTP_DESERIALIZE_FIELD("destinationSites", m_destinationSites),
    CRDTP_DESERIALIZE_FIELD("eventId", m_eventId),
    CRDTP_DESERIALIZE_FIELD("eventLevelEpsilon", m_eventLevelEpsilon),
    CRDTP_DESERIALIZE_FIELD("eventReportWindows", m_eventReportWindows),
    CRDTP_DESERIALIZE_FIELD("expiry", m_expiry),
    CRDTP_DESERIALIZE_FIELD("filterData", m_filterData),
    CRDTP_DESERIALIZE_FIELD("maxEventLevelReports", m_maxEventLevelReports),
    CRDTP_DESERIALIZE_FIELD("namedBudgets", m_namedBudgets),
    CRDTP_DESERIALIZE_FIELD("priority", m_priority),
    CRDTP_DESERIALIZE_FIELD("reportingOrigin", m_reportingOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("scopesData", m_scopesData),
    CRDTP_DESERIALIZE_FIELD("sourceOrigin", m_sourceOrigin),
    CRDTP_DESERIALIZE_FIELD("time", m_time),
    CRDTP_DESERIALIZE_FIELD("triggerData", m_triggerData),
    CRDTP_DESERIALIZE_FIELD("triggerDataMatching", m_triggerDataMatching),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingSourceRegistration)
    CRDTP_SERIALIZE_FIELD("time", m_time);
    CRDTP_SERIALIZE_FIELD("expiry", m_expiry);
    CRDTP_SERIALIZE_FIELD("triggerData", m_triggerData);
    CRDTP_SERIALIZE_FIELD("eventReportWindows", m_eventReportWindows);
    CRDTP_SERIALIZE_FIELD("aggregatableReportWindow", m_aggregatableReportWindow);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("sourceOrigin", m_sourceOrigin);
    CRDTP_SERIALIZE_FIELD("reportingOrigin", m_reportingOrigin);
    CRDTP_SERIALIZE_FIELD("destinationSites", m_destinationSites);
    CRDTP_SERIALIZE_FIELD("eventId", m_eventId);
    CRDTP_SERIALIZE_FIELD("priority", m_priority);
    CRDTP_SERIALIZE_FIELD("filterData", m_filterData);
    CRDTP_SERIALIZE_FIELD("aggregationKeys", m_aggregationKeys);
    CRDTP_SERIALIZE_FIELD("debugKey", m_debugKey);
    CRDTP_SERIALIZE_FIELD("triggerDataMatching", m_triggerDataMatching);
    CRDTP_SERIALIZE_FIELD("destinationLimitPriority", m_destinationLimitPriority);
    CRDTP_SERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig);
    CRDTP_SERIALIZE_FIELD("scopesData", m_scopesData);
    CRDTP_SERIALIZE_FIELD("maxEventLevelReports", m_maxEventLevelReports);
    CRDTP_SERIALIZE_FIELD("namedBudgets", m_namedBudgets);
    CRDTP_SERIALIZE_FIELD("debugReporting", m_debugReporting);
    CRDTP_SERIALIZE_FIELD("eventLevelEpsilon", m_eventLevelEpsilon);
CRDTP_END_SERIALIZER();


namespace AttributionReportingSourceRegistrationResultEnum {
const char Success[] = "success";
const char InternalError[] = "internalError";
const char InsufficientSourceCapacity[] = "insufficientSourceCapacity";
const char InsufficientUniqueDestinationCapacity[] = "insufficientUniqueDestinationCapacity";
const char ExcessiveReportingOrigins[] = "excessiveReportingOrigins";
const char ProhibitedByBrowserPolicy[] = "prohibitedByBrowserPolicy";
const char SuccessNoised[] = "successNoised";
const char DestinationReportingLimitReached[] = "destinationReportingLimitReached";
const char DestinationGlobalLimitReached[] = "destinationGlobalLimitReached";
const char DestinationBothLimitsReached[] = "destinationBothLimitsReached";
const char ReportingOriginsPerSiteLimitReached[] = "reportingOriginsPerSiteLimitReached";
const char ExceedsMaxChannelCapacity[] = "exceedsMaxChannelCapacity";
const char ExceedsMaxScopesChannelCapacity[] = "exceedsMaxScopesChannelCapacity";
const char ExceedsMaxTriggerStateCardinality[] = "exceedsMaxTriggerStateCardinality";
const char ExceedsMaxEventStatesLimit[] = "exceedsMaxEventStatesLimit";
const char DestinationPerDayReportingLimitReached[] = "destinationPerDayReportingLimitReached";
} // namespace AttributionReportingSourceRegistrationResultEnum


namespace AttributionReportingSourceRegistrationTimeConfigEnum {
const char Include[] = "include";
const char Exclude[] = "exclude";
} // namespace AttributionReportingSourceRegistrationTimeConfigEnum


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableValueDictEntry)
    CRDTP_DESERIALIZE_FIELD("filteringId", m_filteringId),
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableValueDictEntry)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("filteringId", m_filteringId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableValueEntry)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("values", m_values),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableValueEntry)
    CRDTP_SERIALIZE_FIELD("values", m_values);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingEventTriggerData)
    CRDTP_DESERIALIZE_FIELD("data", m_data),
    CRDTP_DESERIALIZE_FIELD_OPT("dedupKey", m_dedupKey),
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("priority", m_priority),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingEventTriggerData)
    CRDTP_SERIALIZE_FIELD("data", m_data);
    CRDTP_SERIALIZE_FIELD("priority", m_priority);
    CRDTP_SERIALIZE_FIELD("dedupKey", m_dedupKey);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableTriggerData)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("keyPiece", m_keyPiece),
    CRDTP_DESERIALIZE_FIELD("sourceKeys", m_sourceKeys),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableTriggerData)
    CRDTP_SERIALIZE_FIELD("keyPiece", m_keyPiece);
    CRDTP_SERIALIZE_FIELD("sourceKeys", m_sourceKeys);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingAggregatableDedupKey)
    CRDTP_DESERIALIZE_FIELD_OPT("dedupKey", m_dedupKey),
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingAggregatableDedupKey)
    CRDTP_SERIALIZE_FIELD("dedupKey", m_dedupKey);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingNamedBudgetCandidate)
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD_OPT("name", m_name),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingNamedBudgetCandidate)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AttributionReportingTriggerRegistration)
    CRDTP_DESERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig),
    CRDTP_DESERIALIZE_FIELD("aggregatableDedupKeys", m_aggregatableDedupKeys),
    CRDTP_DESERIALIZE_FIELD("aggregatableFilteringIdMaxBytes", m_aggregatableFilteringIdMaxBytes),
    CRDTP_DESERIALIZE_FIELD("aggregatableTriggerData", m_aggregatableTriggerData),
    CRDTP_DESERIALIZE_FIELD("aggregatableValues", m_aggregatableValues),
    CRDTP_DESERIALIZE_FIELD_OPT("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin),
    CRDTP_DESERIALIZE_FIELD_OPT("debugKey", m_debugKey),
    CRDTP_DESERIALIZE_FIELD("debugReporting", m_debugReporting),
    CRDTP_DESERIALIZE_FIELD("eventTriggerData", m_eventTriggerData),
    CRDTP_DESERIALIZE_FIELD("filters", m_filters),
    CRDTP_DESERIALIZE_FIELD("namedBudgets", m_namedBudgets),
    CRDTP_DESERIALIZE_FIELD("scopes", m_scopes),
    CRDTP_DESERIALIZE_FIELD("sourceRegistrationTimeConfig", m_sourceRegistrationTimeConfig),
    CRDTP_DESERIALIZE_FIELD_OPT("triggerContextId", m_triggerContextId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AttributionReportingTriggerRegistration)
    CRDTP_SERIALIZE_FIELD("filters", m_filters);
    CRDTP_SERIALIZE_FIELD("debugKey", m_debugKey);
    CRDTP_SERIALIZE_FIELD("aggregatableDedupKeys", m_aggregatableDedupKeys);
    CRDTP_SERIALIZE_FIELD("eventTriggerData", m_eventTriggerData);
    CRDTP_SERIALIZE_FIELD("aggregatableTriggerData", m_aggregatableTriggerData);
    CRDTP_SERIALIZE_FIELD("aggregatableValues", m_aggregatableValues);
    CRDTP_SERIALIZE_FIELD("aggregatableFilteringIdMaxBytes", m_aggregatableFilteringIdMaxBytes);
    CRDTP_SERIALIZE_FIELD("debugReporting", m_debugReporting);
    CRDTP_SERIALIZE_FIELD("aggregationCoordinatorOrigin", m_aggregationCoordinatorOrigin);
    CRDTP_SERIALIZE_FIELD("sourceRegistrationTimeConfig", m_sourceRegistrationTimeConfig);
    CRDTP_SERIALIZE_FIELD("triggerContextId", m_triggerContextId);
    CRDTP_SERIALIZE_FIELD("aggregatableDebugReportingConfig", m_aggregatableDebugReportingConfig);
    CRDTP_SERIALIZE_FIELD("scopes", m_scopes);
    CRDTP_SERIALIZE_FIELD("namedBudgets", m_namedBudgets);
CRDTP_END_SERIALIZER();


namespace AttributionReportingEventLevelResultEnum {
const char Success[] = "success";
const char SuccessDroppedLowerPriority[] = "successDroppedLowerPriority";
const char InternalError[] = "internalError";
const char NoCapacityForAttributionDestination[] = "noCapacityForAttributionDestination";
const char NoMatchingSources[] = "noMatchingSources";
const char Deduplicated[] = "deduplicated";
const char ExcessiveAttributions[] = "excessiveAttributions";
const char PriorityTooLow[] = "priorityTooLow";
const char NeverAttributedSource[] = "neverAttributedSource";
const char ExcessiveReportingOrigins[] = "excessiveReportingOrigins";
const char NoMatchingSourceFilterData[] = "noMatchingSourceFilterData";
const char ProhibitedByBrowserPolicy[] = "prohibitedByBrowserPolicy";
const char NoMatchingConfigurations[] = "noMatchingConfigurations";
const char ExcessiveReports[] = "excessiveReports";
const char FalselyAttributedSource[] = "falselyAttributedSource";
const char ReportWindowPassed[] = "reportWindowPassed";
const char NotRegistered[] = "notRegistered";
const char ReportWindowNotStarted[] = "reportWindowNotStarted";
const char NoMatchingTriggerData[] = "noMatchingTriggerData";
} // namespace AttributionReportingEventLevelResultEnum


namespace AttributionReportingAggregatableResultEnum {
const char Success[] = "success";
const char InternalError[] = "internalError";
const char NoCapacityForAttributionDestination[] = "noCapacityForAttributionDestination";
const char NoMatchingSources[] = "noMatchingSources";
const char ExcessiveAttributions[] = "excessiveAttributions";
const char ExcessiveReportingOrigins[] = "excessiveReportingOrigins";
const char NoHistograms[] = "noHistograms";
const char InsufficientBudget[] = "insufficientBudget";
const char InsufficientNamedBudget[] = "insufficientNamedBudget";
const char NoMatchingSourceFilterData[] = "noMatchingSourceFilterData";
const char NotRegistered[] = "notRegistered";
const char ProhibitedByBrowserPolicy[] = "prohibitedByBrowserPolicy";
const char Deduplicated[] = "deduplicated";
const char ReportWindowPassed[] = "reportWindowPassed";
const char ExcessiveReports[] = "excessiveReports";
} // namespace AttributionReportingAggregatableResultEnum


namespace AttributionReportingReportResultEnum {
const char Sent[] = "sent";
const char Prohibited[] = "prohibited";
const char FailedToAssemble[] = "failedToAssemble";
const char Expired[] = "expired";
} // namespace AttributionReportingReportResultEnum


CRDTP_BEGIN_DESERIALIZER(RelatedWebsiteSet)
    CRDTP_DESERIALIZE_FIELD("associatedSites", m_associatedSites),
    CRDTP_DESERIALIZE_FIELD("primarySites", m_primarySites),
    CRDTP_DESERIALIZE_FIELD("serviceSites", m_serviceSites),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(RelatedWebsiteSet)
    CRDTP_SERIALIZE_FIELD("primarySites", m_primarySites);
    CRDTP_SERIALIZE_FIELD("associatedSites", m_associatedSites);
    CRDTP_SERIALIZE_FIELD("serviceSites", m_serviceSites);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::CacheStorageContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& cacheName)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    serializer.AddField(crdtp::MakeSpan("cacheName"), cacheName);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.cacheStorageContentUpdated", serializer.Finish()));
}

void Frontend::CacheStorageListUpdated(const String& origin, const String& storageKey, const String& bucketId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.cacheStorageListUpdated", serializer.Finish()));
}

void Frontend::IndexedDBContentUpdated(const String& origin, const String& storageKey, const String& bucketId, const String& databaseName, const String& objectStoreName)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    serializer.AddField(crdtp::MakeSpan("databaseName"), databaseName);
    serializer.AddField(crdtp::MakeSpan("objectStoreName"), objectStoreName);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.indexedDBContentUpdated", serializer.Finish()));
}

void Frontend::IndexedDBListUpdated(const String& origin, const String& storageKey, const String& bucketId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("storageKey"), storageKey);
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.indexedDBListUpdated", serializer.Finish()));
}

void Frontend::InterestGroupAccessed(double accessTime, const String& type, const String& ownerOrigin, const String& name, std::optional<String> componentSellerOrigin, std::optional<double> bid, std::optional<String> bidCurrency, std::optional<String> uniqueAuctionId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("accessTime"), accessTime);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("ownerOrigin"), ownerOrigin);
    serializer.AddField(crdtp::MakeSpan("name"), name);
    serializer.AddField(crdtp::MakeSpan("componentSellerOrigin"), componentSellerOrigin);
    serializer.AddField(crdtp::MakeSpan("bid"), bid);
    serializer.AddField(crdtp::MakeSpan("bidCurrency"), bidCurrency);
    serializer.AddField(crdtp::MakeSpan("uniqueAuctionId"), uniqueAuctionId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.interestGroupAccessed", serializer.Finish()));
}

void Frontend::InterestGroupAuctionEventOccurred(double eventTime, const String& type, const String& uniqueAuctionId, std::optional<String> parentAuctionId, std::unique_ptr<protocol::DictionaryValue> auctionConfig)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("eventTime"), eventTime);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("uniqueAuctionId"), uniqueAuctionId);
    serializer.AddField(crdtp::MakeSpan("parentAuctionId"), parentAuctionId);
    serializer.AddField(crdtp::MakeSpan("auctionConfig"), auctionConfig);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.interestGroupAuctionEventOccurred", serializer.Finish()));
}

void Frontend::InterestGroupAuctionNetworkRequestCreated(const String& type, const String& requestId, std::unique_ptr<protocol::Array<String>> auctions)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("auctions"), auctions);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.interestGroupAuctionNetworkRequestCreated", serializer.Finish()));
}

void Frontend::SharedStorageAccessed(double accessTime, const String& scope, const String& method, const String& mainFrameId, const String& ownerOrigin, const String& ownerSite, std::unique_ptr<protocol::Storage::SharedStorageAccessParams> params)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("accessTime"), accessTime);
    serializer.AddField(crdtp::MakeSpan("scope"), scope);
    serializer.AddField(crdtp::MakeSpan("method"), method);
    serializer.AddField(crdtp::MakeSpan("mainFrameId"), mainFrameId);
    serializer.AddField(crdtp::MakeSpan("ownerOrigin"), ownerOrigin);
    serializer.AddField(crdtp::MakeSpan("ownerSite"), ownerSite);
    serializer.AddField(crdtp::MakeSpan("params"), params);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.sharedStorageAccessed", serializer.Finish()));
}

void Frontend::SharedStorageWorkletOperationExecutionFinished(double finishedTime, int executionTime, const String& method, const String& operationId, const String& workletTargetId, const String& mainFrameId, const String& ownerOrigin)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("finishedTime"), finishedTime);
    serializer.AddField(crdtp::MakeSpan("executionTime"), executionTime);
    serializer.AddField(crdtp::MakeSpan("method"), method);
    serializer.AddField(crdtp::MakeSpan("operationId"), operationId);
    serializer.AddField(crdtp::MakeSpan("workletTargetId"), workletTargetId);
    serializer.AddField(crdtp::MakeSpan("mainFrameId"), mainFrameId);
    serializer.AddField(crdtp::MakeSpan("ownerOrigin"), ownerOrigin);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.sharedStorageWorkletOperationExecutionFinished", serializer.Finish()));
}

void Frontend::StorageBucketCreatedOrUpdated(std::unique_ptr<protocol::Storage::StorageBucketInfo> bucketInfo)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("bucketInfo"), bucketInfo);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.storageBucketCreatedOrUpdated", serializer.Finish()));
}

void Frontend::StorageBucketDeleted(const String& bucketId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("bucketId"), bucketId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.storageBucketDeleted", serializer.Finish()));
}

void Frontend::AttributionReportingSourceRegistered(std::unique_ptr<protocol::Storage::AttributionReportingSourceRegistration> registration, const String& result)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("registration"), registration);
    serializer.AddField(crdtp::MakeSpan("result"), result);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingSourceRegistered", serializer.Finish()));
}

void Frontend::AttributionReportingTriggerRegistered(std::unique_ptr<protocol::Storage::AttributionReportingTriggerRegistration> registration, const String& eventLevel, const String& aggregatable)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("registration"), registration);
    serializer.AddField(crdtp::MakeSpan("eventLevel"), eventLevel);
    serializer.AddField(crdtp::MakeSpan("aggregatable"), aggregatable);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingTriggerRegistered", serializer.Finish()));
}

void Frontend::AttributionReportingReportSent(const String& url, std::unique_ptr<protocol::DictionaryValue> body, const String& result, std::optional<int> netError, std::optional<String> netErrorName, std::optional<int> httpStatusCode)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("body"), body);
    serializer.AddField(crdtp::MakeSpan("result"), result);
    serializer.AddField(crdtp::MakeSpan("netError"), netError);
    serializer.AddField(crdtp::MakeSpan("netErrorName"), netErrorName);
    serializer.AddField(crdtp::MakeSpan("httpStatusCode"), httpStatusCode);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingReportSent", serializer.Finish()));
}

void Frontend::AttributionReportingVerboseDebugReportSent(const String& url, std::unique_ptr<protocol::Array<protocol::DictionaryValue>> body, std::optional<int> netError, std::optional<String> netErrorName, std::optional<int> httpStatusCode)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("body"), body);
    serializer.AddField(crdtp::MakeSpan("netError"), netError);
    serializer.AddField(crdtp::MakeSpan("netErrorName"), netErrorName);
    serializer.AddField(crdtp::MakeSpan("httpStatusCode"), httpStatusCode);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Storage.attributionReportingVerboseDebugReportSent", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void runBounceTrackingMitigations(const crdtp::Dispatchable& dispatchable);
    void getRelatedWebsiteSets(const crdtp::Dispatchable& dispatchable);
    void getAffectedUrlsForThirdPartyCookieMetadata(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("getAffectedUrlsForThirdPartyCookieMetadata"),
          &DomainDispatcherImpl::getAffectedUrlsForThirdPartyCookieMetadata
    },
    {
          crdtp::SpanFrom("getRelatedWebsiteSets"),
          &DomainDispatcherImpl::getRelatedWebsiteSets
    },
    {
          crdtp::SpanFrom("runBounceTrackingMitigations"),
          &DomainDispatcherImpl::runBounceTrackingMitigations
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class RunBounceTrackingMitigationsCallbackImpl : public Backend::RunBounceTrackingMitigationsCallback, public DomainDispatcher::Callback {
public:
    RunBounceTrackingMitigationsCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.runBounceTrackingMitigations"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<String>> deletedSites) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("deletedSites"), deletedSites);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::runBounceTrackingMitigations(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->RunBounceTrackingMitigations(std::make_unique<RunBounceTrackingMitigationsCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetRelatedWebsiteSetsCallbackImpl : public Backend::GetRelatedWebsiteSetsCallback, public DomainDispatcher::Callback {
public:
    GetRelatedWebsiteSetsCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Storage.getRelatedWebsiteSets"), message) { }

    void sendSuccess(std::unique_ptr<protocol::Array<protocol::Storage::RelatedWebsiteSet>> sets) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("sets"), sets);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {


}  // namespace

void DomainDispatcherImpl::getRelatedWebsiteSets(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    m_backend->GetRelatedWebsiteSets(std::make_unique<GetRelatedWebsiteSetsCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct getAffectedUrlsForThirdPartyCookieMetadataParams : public crdtp::DeserializableProtocolObject<getAffectedUrlsForThirdPartyCookieMetadataParams> {
    String firstPartyUrl;
    std::unique_ptr<protocol::Array<String>> thirdPartyUrls;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getAffectedUrlsForThirdPartyCookieMetadataParams)
    CRDTP_DESERIALIZE_FIELD("firstPartyUrl", firstPartyUrl),
    CRDTP_DESERIALIZE_FIELD("thirdPartyUrls", thirdPartyUrls),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getAffectedUrlsForThirdPartyCookieMetadata(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getAffectedUrlsForThirdPartyCookieMetadataParams params;
    if (!getAffectedUrlsForThirdPartyCookieMetadataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_matchedUrls;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->GetAffectedUrlsForThirdPartyCookieMetadata(params.firstPartyUrl, std::move(params.thirdPartyUrls), &out_matchedUrls);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Storage.getAffectedUrlsForThirdPartyCookieMetadata"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("matchedUrls"), out_matchedUrls);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Storage"), SortedRedirects(), std::move(dispatcher));
}

} // Storage
} // namespace protocol
