// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_PWA_h
#define protocol_PWA_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace PWA {
class FileHandlerAccept;
class FileHandler;
using DisplayMode = String;

// ------------- Forward and enum declarations.

namespace DisplayModeEnum {
 extern const char Standalone[];
 extern const char Browser[];
} // namespace DisplayModeEnum

// ------------- Type and builder declarations.

class  FileHandlerAccept : public ::crdtp::ProtocolObject<FileHandlerAccept> {
public:
    ~FileHandlerAccept() override;  // Defined below

    String GetMediaType() { return m_mediaType; }
    void SetMediaType(const String& value);  // Defined below

    protocol::Array<String>* GetFileExtensions() { return m_fileExtensions.get(); }
    void SetFileExtensions(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class FileHandlerAcceptBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            MediaTypeSet = 1 << 1,
            FileExtensionsSet = 1 << 2,
            AllFieldsSet = (MediaTypeSet | FileExtensionsSet | 0)};


        FileHandlerAcceptBuilder<STATE | MediaTypeSet>& SetMediaType(const String& value);  // Defined below

        FileHandlerAcceptBuilder<STATE | FileExtensionsSet>& SetFileExtensions(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<FileHandlerAccept> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FileHandlerAccept;
        FileHandlerAcceptBuilder() : m_result(new FileHandlerAccept()) { }

        template<int STEP> FileHandlerAcceptBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FileHandlerAcceptBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::PWA::FileHandlerAccept> m_result;
    };

    static FileHandlerAcceptBuilder<0> Create()
    {
        return FileHandlerAcceptBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FileHandlerAccept();  // Defined below

    String m_mediaType;
    std::unique_ptr<protocol::Array<String>> m_fileExtensions;
};


class  FileHandler : public ::crdtp::ProtocolObject<FileHandler> {
public:
    ~FileHandler() override;  // Defined below

    String GetAction() { return m_action; }
    void SetAction(const String& value);  // Defined below

    protocol::Array<protocol::PWA::FileHandlerAccept>* GetAccepts() { return m_accepts.get(); }
    void SetAccepts(std::unique_ptr<protocol::Array<protocol::PWA::FileHandlerAccept>> value);  // Defined below

    String GetDisplayName() { return m_displayName; }
    void SetDisplayName(const String& value);  // Defined below

    template<int STATE>
    class FileHandlerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ActionSet = 1 << 1,
            AcceptsSet = 1 << 2,
            DisplayNameSet = 1 << 3,
            AllFieldsSet = (ActionSet | AcceptsSet | DisplayNameSet | 0)};


        FileHandlerBuilder<STATE | ActionSet>& SetAction(const String& value);  // Defined below

        FileHandlerBuilder<STATE | AcceptsSet>& SetAccepts(std::unique_ptr<protocol::Array<protocol::PWA::FileHandlerAccept>> value);  // Defined below

        FileHandlerBuilder<STATE | DisplayNameSet>& SetDisplayName(const String& value);  // Defined below

        std::unique_ptr<FileHandler> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class FileHandler;
        FileHandlerBuilder() : m_result(new FileHandler()) { }

        template<int STEP> FileHandlerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FileHandlerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::PWA::FileHandler> m_result;
    };

    static FileHandlerBuilder<0> Create()
    {
        return FileHandlerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    FileHandler();  // Defined below

    String m_action;
    std::unique_ptr<protocol::Array<protocol::PWA::FileHandlerAccept>> m_accepts;
    String m_displayName;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline FileHandlerAccept::~FileHandlerAccept() = default;
inline void FileHandlerAccept::SetMediaType(const String& value) { m_mediaType = value; }
inline void FileHandlerAccept::SetFileExtensions(std::unique_ptr<protocol::Array<String>> value) { m_fileExtensions = std::move(value); }

template<int STATE>
inline FileHandlerAccept::FileHandlerAcceptBuilder<STATE | FileHandlerAccept::FileHandlerAcceptBuilder<STATE>::MediaTypeSet>&
FileHandlerAccept::FileHandlerAcceptBuilder<STATE>::SetMediaType(const String& value) {
  static_assert(!(STATE & MediaTypeSet), "property mediaType should not be set yet");
  m_result->SetMediaType(value);
  return castState<MediaTypeSet>();
}
template<int STATE>
inline FileHandlerAccept::FileHandlerAcceptBuilder<STATE | FileHandlerAccept::FileHandlerAcceptBuilder<STATE>::FileExtensionsSet>&
FileHandlerAccept::FileHandlerAcceptBuilder<STATE>::SetFileExtensions(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & FileExtensionsSet), "property fileExtensions should not be set yet");
  m_result->SetFileExtensions(std::move(value));
  return castState<FileExtensionsSet>();
}

inline FileHandlerAccept::FileHandlerAccept() {
}
inline FileHandler::~FileHandler() = default;
inline void FileHandler::SetAction(const String& value) { m_action = value; }
inline void FileHandler::SetAccepts(std::unique_ptr<protocol::Array<protocol::PWA::FileHandlerAccept>> value) { m_accepts = std::move(value); }
inline void FileHandler::SetDisplayName(const String& value) { m_displayName = value; }

template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE | FileHandler::FileHandlerBuilder<STATE>::ActionSet>&
FileHandler::FileHandlerBuilder<STATE>::SetAction(const String& value) {
  static_assert(!(STATE & ActionSet), "property action should not be set yet");
  m_result->SetAction(value);
  return castState<ActionSet>();
}
template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE | FileHandler::FileHandlerBuilder<STATE>::AcceptsSet>&
FileHandler::FileHandlerBuilder<STATE>::SetAccepts(std::unique_ptr<protocol::Array<protocol::PWA::FileHandlerAccept>> value) {
  static_assert(!(STATE & AcceptsSet), "property accepts should not be set yet");
  m_result->SetAccepts(std::move(value));
  return castState<AcceptsSet>();
}
template<int STATE>
inline FileHandler::FileHandlerBuilder<STATE | FileHandler::FileHandlerBuilder<STATE>::DisplayNameSet>&
FileHandler::FileHandlerBuilder<STATE>::SetDisplayName(const String& value) {
  static_assert(!(STATE & DisplayNameSet), "property displayName should not be set yet");
  m_result->SetDisplayName(value);
  return castState<DisplayNameSet>();
}

inline FileHandler::FileHandler() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    class  GetOsAppStateCallback {
    public:
        virtual void sendSuccess(int badgeCount, std::unique_ptr<protocol::Array<protocol::PWA::FileHandler>> fileHandlers) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetOsAppStateCallback() { }
    };
    virtual void GetOsAppState(const String& in_manifestId, std::unique_ptr<GetOsAppStateCallback> callback) = 0;
    class  InstallCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~InstallCallback() { }
    };
    virtual void Install(const String& in_manifestId, std::optional<String> in_installUrlOrBundleUrl, std::unique_ptr<InstallCallback> callback) = 0;
    class  UninstallCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~UninstallCallback() { }
    };
    virtual void Uninstall(const String& in_manifestId, std::unique_ptr<UninstallCallback> callback) = 0;
    class  LaunchCallback {
    public:
        virtual void sendSuccess(const String& targetId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~LaunchCallback() { }
    };
    virtual void Launch(const String& in_manifestId, std::optional<String> in_url, std::unique_ptr<LaunchCallback> callback) = 0;
    class  LaunchFilesInAppCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::Array<String>> targetIds) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~LaunchFilesInAppCallback() { }
    };
    virtual void LaunchFilesInApp(const String& in_manifestId, std::unique_ptr<protocol::Array<String>> in_files, std::unique_ptr<LaunchFilesInAppCallback> callback) = 0;
    virtual DispatchResponse OpenCurrentPageInApp(const String& in_manifestId) = 0;
    class  ChangeAppUserSettingsCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~ChangeAppUserSettingsCallback() { }
    };
    virtual void ChangeAppUserSettings(const String& in_manifestId, std::optional<bool> in_linkCapturing, std::optional<String> in_displayMode, std::unique_ptr<ChangeAppUserSettingsCallback> callback) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace PWA
} // namespace protocol

#endif // !defined(protocol_PWA_h)
