// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Emulation_h
#define protocol_Emulation_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "chrome/browser/devtools/protocol/page.h"

namespace protocol {
namespace Emulation {
class ScreenOrientation;
class WorkAreaInsets;
using ScreenId = String;
class ScreenInfo;

// ------------- Forward and enum declarations.

namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
 extern const char* Mobile;
 extern const char* Desktop;
} // ConfigurationEnum
} // SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
 extern const char* None;
 extern const char* BlurredVision;
 extern const char* ReducedContrast;
 extern const char* Achromatopsia;
 extern const char* Deuteranopia;
 extern const char* Protanopia;
 extern const char* Tritanopia;
} // TypeEnum
} // SetEmulatedVisionDeficiency

// ------------- Type and builder declarations.

class  ScreenOrientation : public ::crdtp::ProtocolObject<ScreenOrientation> {
public:
    ~ScreenOrientation() override;  // Defined below

    struct  TypeEnum {
        static const char* PortraitPrimary;
        static const char* PortraitSecondary;
        static const char* LandscapePrimary;
        static const char* LandscapeSecondary;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value);  // Defined below

    int GetAngle() { return m_angle; }
    void SetAngle(int value);  // Defined below

    template<int STATE>
    class ScreenOrientationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AngleSet = 1 << 2,
            AllFieldsSet = (TypeSet | AngleSet | 0)};


        ScreenOrientationBuilder<STATE | TypeSet>& SetType(const String& value);  // Defined below

        ScreenOrientationBuilder<STATE | AngleSet>& SetAngle(int value);  // Defined below

        std::unique_ptr<ScreenOrientation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenOrientation;
        ScreenOrientationBuilder() : m_result(new ScreenOrientation()) { }

        template<int STEP> ScreenOrientationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenOrientationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenOrientation> m_result;
    };

    static ScreenOrientationBuilder<0> Create()
    {
        return ScreenOrientationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenOrientation();  // Defined below

    String m_type;
    int m_angle;
};


class  WorkAreaInsets : public ::crdtp::ProtocolObject<WorkAreaInsets> {
public:
    ~WorkAreaInsets() override;  // Defined below

    bool HasTop() { return !!m_top; }
    int GetTop(int defaultValue) const {
       return m_top.value_or(defaultValue);
    }
    const std::optional<int>& GetTop() const {
       return m_top;
    }
    void SetTop(int value);  // Defined below

    bool HasLeft() { return !!m_left; }
    int GetLeft(int defaultValue) const {
       return m_left.value_or(defaultValue);
    }
    const std::optional<int>& GetLeft() const {
       return m_left;
    }
    void SetLeft(int value);  // Defined below

    bool HasBottom() { return !!m_bottom; }
    int GetBottom(int defaultValue) const {
       return m_bottom.value_or(defaultValue);
    }
    const std::optional<int>& GetBottom() const {
       return m_bottom;
    }
    void SetBottom(int value);  // Defined below

    bool HasRight() { return !!m_right; }
    int GetRight(int defaultValue) const {
       return m_right.value_or(defaultValue);
    }
    const std::optional<int>& GetRight() const {
       return m_right;
    }
    void SetRight(int value);  // Defined below

    template<int STATE>
    class WorkAreaInsetsBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            AllFieldsSet = (0)};


        WorkAreaInsetsBuilder<STATE>& SetTop(int value);  // Defined below

        WorkAreaInsetsBuilder<STATE>& SetLeft(int value);  // Defined below

        WorkAreaInsetsBuilder<STATE>& SetBottom(int value);  // Defined below

        WorkAreaInsetsBuilder<STATE>& SetRight(int value);  // Defined below

        std::unique_ptr<WorkAreaInsets> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WorkAreaInsets;
        WorkAreaInsetsBuilder() : m_result(new WorkAreaInsets()) { }

        template<int STEP> WorkAreaInsetsBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WorkAreaInsetsBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::WorkAreaInsets> m_result;
    };

    static WorkAreaInsetsBuilder<0> Create()
    {
        return WorkAreaInsetsBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WorkAreaInsets();  // Defined below

    std::optional<int> m_top;
    std::optional<int> m_left;
    std::optional<int> m_bottom;
    std::optional<int> m_right;
};


class  ScreenInfo : public ::crdtp::ProtocolObject<ScreenInfo> {
public:
    ~ScreenInfo() override;  // Defined below

    int GetLeft() { return m_left; }
    void SetLeft(int value);  // Defined below

    int GetTop() { return m_top; }
    void SetTop(int value);  // Defined below

    int GetWidth() { return m_width; }
    void SetWidth(int value);  // Defined below

    int GetHeight() { return m_height; }
    void SetHeight(int value);  // Defined below

    int GetAvailLeft() { return m_availLeft; }
    void SetAvailLeft(int value);  // Defined below

    int GetAvailTop() { return m_availTop; }
    void SetAvailTop(int value);  // Defined below

    int GetAvailWidth() { return m_availWidth; }
    void SetAvailWidth(int value);  // Defined below

    int GetAvailHeight() { return m_availHeight; }
    void SetAvailHeight(int value);  // Defined below

    double GetDevicePixelRatio() { return m_devicePixelRatio; }
    void SetDevicePixelRatio(double value);  // Defined below

    protocol::Emulation::ScreenOrientation* GetOrientation() { return m_orientation.get(); }
    void SetOrientation(std::unique_ptr<protocol::Emulation::ScreenOrientation> value);  // Defined below

    int GetColorDepth() { return m_colorDepth; }
    void SetColorDepth(int value);  // Defined below

    bool GetIsExtended() { return m_isExtended; }
    void SetIsExtended(bool value);  // Defined below

    bool GetIsInternal() { return m_isInternal; }
    void SetIsInternal(bool value);  // Defined below

    bool GetIsPrimary() { return m_isPrimary; }
    void SetIsPrimary(bool value);  // Defined below

    String GetLabel() { return m_label; }
    void SetLabel(const String& value);  // Defined below

    String GetId() { return m_id; }
    void SetId(const String& value);  // Defined below

    template<int STATE>
    class ScreenInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LeftSet = 1 << 1,
            TopSet = 1 << 2,
            WidthSet = 1 << 3,
            HeightSet = 1 << 4,
            AvailLeftSet = 1 << 5,
            AvailTopSet = 1 << 6,
            AvailWidthSet = 1 << 7,
            AvailHeightSet = 1 << 8,
            DevicePixelRatioSet = 1 << 9,
            OrientationSet = 1 << 10,
            ColorDepthSet = 1 << 11,
            IsExtendedSet = 1 << 12,
            IsInternalSet = 1 << 13,
            IsPrimarySet = 1 << 14,
            LabelSet = 1 << 15,
            IdSet = 1 << 16,
            AllFieldsSet = (LeftSet | TopSet | WidthSet | HeightSet | AvailLeftSet | AvailTopSet | AvailWidthSet | AvailHeightSet | DevicePixelRatioSet | OrientationSet | ColorDepthSet | IsExtendedSet | IsInternalSet | IsPrimarySet | LabelSet | IdSet | 0)};


        ScreenInfoBuilder<STATE | LeftSet>& SetLeft(int value);  // Defined below

        ScreenInfoBuilder<STATE | TopSet>& SetTop(int value);  // Defined below

        ScreenInfoBuilder<STATE | WidthSet>& SetWidth(int value);  // Defined below

        ScreenInfoBuilder<STATE | HeightSet>& SetHeight(int value);  // Defined below

        ScreenInfoBuilder<STATE | AvailLeftSet>& SetAvailLeft(int value);  // Defined below

        ScreenInfoBuilder<STATE | AvailTopSet>& SetAvailTop(int value);  // Defined below

        ScreenInfoBuilder<STATE | AvailWidthSet>& SetAvailWidth(int value);  // Defined below

        ScreenInfoBuilder<STATE | AvailHeightSet>& SetAvailHeight(int value);  // Defined below

        ScreenInfoBuilder<STATE | DevicePixelRatioSet>& SetDevicePixelRatio(double value);  // Defined below

        ScreenInfoBuilder<STATE | OrientationSet>& SetOrientation(std::unique_ptr<protocol::Emulation::ScreenOrientation> value);  // Defined below

        ScreenInfoBuilder<STATE | ColorDepthSet>& SetColorDepth(int value);  // Defined below

        ScreenInfoBuilder<STATE | IsExtendedSet>& SetIsExtended(bool value);  // Defined below

        ScreenInfoBuilder<STATE | IsInternalSet>& SetIsInternal(bool value);  // Defined below

        ScreenInfoBuilder<STATE | IsPrimarySet>& SetIsPrimary(bool value);  // Defined below

        ScreenInfoBuilder<STATE | LabelSet>& SetLabel(const String& value);  // Defined below

        ScreenInfoBuilder<STATE | IdSet>& SetId(const String& value);  // Defined below

        std::unique_ptr<ScreenInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenInfo;
        ScreenInfoBuilder() : m_result(new ScreenInfo()) { }

        template<int STEP> ScreenInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenInfo> m_result;
    };

    static ScreenInfoBuilder<0> Create()
    {
        return ScreenInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenInfo();  // Defined below

    int m_left;
    int m_top;
    int m_width;
    int m_height;
    int m_availLeft;
    int m_availTop;
    int m_availWidth;
    int m_availHeight;
    double m_devicePixelRatio;
    std::unique_ptr<protocol::Emulation::ScreenOrientation> m_orientation;
    int m_colorDepth;
    bool m_isExtended;
    bool m_isInternal;
    bool m_isPrimary;
    String m_label;
    String m_id;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline ScreenOrientation::~ScreenOrientation() = default;
inline void ScreenOrientation::SetType(const String& value) { m_type = value; }
inline void ScreenOrientation::SetAngle(int value) { m_angle = value; }

template<int STATE>
inline ScreenOrientation::ScreenOrientationBuilder<STATE | ScreenOrientation::ScreenOrientationBuilder<STATE>::TypeSet>&
ScreenOrientation::ScreenOrientationBuilder<STATE>::SetType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->SetType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline ScreenOrientation::ScreenOrientationBuilder<STATE | ScreenOrientation::ScreenOrientationBuilder<STATE>::AngleSet>&
ScreenOrientation::ScreenOrientationBuilder<STATE>::SetAngle(int value) {
  static_assert(!(STATE & AngleSet), "property angle should not be set yet");
  m_result->SetAngle(value);
  return castState<AngleSet>();
}

inline ScreenOrientation::ScreenOrientation() {
  m_angle = 0;
}
inline WorkAreaInsets::~WorkAreaInsets() = default;
inline void WorkAreaInsets::SetTop(int value) { m_top = value; }
inline void WorkAreaInsets::SetLeft(int value) { m_left = value; }
inline void WorkAreaInsets::SetBottom(int value) { m_bottom = value; }
inline void WorkAreaInsets::SetRight(int value) { m_right = value; }

template<int STATE>
inline WorkAreaInsets::WorkAreaInsetsBuilder<STATE>& WorkAreaInsets::WorkAreaInsetsBuilder<STATE>::SetTop(int value) {
  m_result->SetTop(value);
  return *this;
}
template<int STATE>
inline WorkAreaInsets::WorkAreaInsetsBuilder<STATE>& WorkAreaInsets::WorkAreaInsetsBuilder<STATE>::SetLeft(int value) {
  m_result->SetLeft(value);
  return *this;
}
template<int STATE>
inline WorkAreaInsets::WorkAreaInsetsBuilder<STATE>& WorkAreaInsets::WorkAreaInsetsBuilder<STATE>::SetBottom(int value) {
  m_result->SetBottom(value);
  return *this;
}
template<int STATE>
inline WorkAreaInsets::WorkAreaInsetsBuilder<STATE>& WorkAreaInsets::WorkAreaInsetsBuilder<STATE>::SetRight(int value) {
  m_result->SetRight(value);
  return *this;
}

inline WorkAreaInsets::WorkAreaInsets() {
}
inline ScreenInfo::~ScreenInfo() = default;
inline void ScreenInfo::SetLeft(int value) { m_left = value; }
inline void ScreenInfo::SetTop(int value) { m_top = value; }
inline void ScreenInfo::SetWidth(int value) { m_width = value; }
inline void ScreenInfo::SetHeight(int value) { m_height = value; }
inline void ScreenInfo::SetAvailLeft(int value) { m_availLeft = value; }
inline void ScreenInfo::SetAvailTop(int value) { m_availTop = value; }
inline void ScreenInfo::SetAvailWidth(int value) { m_availWidth = value; }
inline void ScreenInfo::SetAvailHeight(int value) { m_availHeight = value; }
inline void ScreenInfo::SetDevicePixelRatio(double value) { m_devicePixelRatio = value; }
inline void ScreenInfo::SetOrientation(std::unique_ptr<protocol::Emulation::ScreenOrientation> value) { m_orientation = std::move(value); }
inline void ScreenInfo::SetColorDepth(int value) { m_colorDepth = value; }
inline void ScreenInfo::SetIsExtended(bool value) { m_isExtended = value; }
inline void ScreenInfo::SetIsInternal(bool value) { m_isInternal = value; }
inline void ScreenInfo::SetIsPrimary(bool value) { m_isPrimary = value; }
inline void ScreenInfo::SetLabel(const String& value) { m_label = value; }
inline void ScreenInfo::SetId(const String& value) { m_id = value; }

template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::LeftSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetLeft(int value) {
  static_assert(!(STATE & LeftSet), "property left should not be set yet");
  m_result->SetLeft(value);
  return castState<LeftSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::TopSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetTop(int value) {
  static_assert(!(STATE & TopSet), "property top should not be set yet");
  m_result->SetTop(value);
  return castState<TopSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::WidthSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetWidth(int value) {
  static_assert(!(STATE & WidthSet), "property width should not be set yet");
  m_result->SetWidth(value);
  return castState<WidthSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::HeightSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetHeight(int value) {
  static_assert(!(STATE & HeightSet), "property height should not be set yet");
  m_result->SetHeight(value);
  return castState<HeightSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::AvailLeftSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetAvailLeft(int value) {
  static_assert(!(STATE & AvailLeftSet), "property availLeft should not be set yet");
  m_result->SetAvailLeft(value);
  return castState<AvailLeftSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::AvailTopSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetAvailTop(int value) {
  static_assert(!(STATE & AvailTopSet), "property availTop should not be set yet");
  m_result->SetAvailTop(value);
  return castState<AvailTopSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::AvailWidthSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetAvailWidth(int value) {
  static_assert(!(STATE & AvailWidthSet), "property availWidth should not be set yet");
  m_result->SetAvailWidth(value);
  return castState<AvailWidthSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::AvailHeightSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetAvailHeight(int value) {
  static_assert(!(STATE & AvailHeightSet), "property availHeight should not be set yet");
  m_result->SetAvailHeight(value);
  return castState<AvailHeightSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::DevicePixelRatioSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetDevicePixelRatio(double value) {
  static_assert(!(STATE & DevicePixelRatioSet), "property devicePixelRatio should not be set yet");
  m_result->SetDevicePixelRatio(value);
  return castState<DevicePixelRatioSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::OrientationSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetOrientation(std::unique_ptr<protocol::Emulation::ScreenOrientation> value) {
  static_assert(!(STATE & OrientationSet), "property orientation should not be set yet");
  m_result->SetOrientation(std::move(value));
  return castState<OrientationSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::ColorDepthSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetColorDepth(int value) {
  static_assert(!(STATE & ColorDepthSet), "property colorDepth should not be set yet");
  m_result->SetColorDepth(value);
  return castState<ColorDepthSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::IsExtendedSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetIsExtended(bool value) {
  static_assert(!(STATE & IsExtendedSet), "property isExtended should not be set yet");
  m_result->SetIsExtended(value);
  return castState<IsExtendedSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::IsInternalSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetIsInternal(bool value) {
  static_assert(!(STATE & IsInternalSet), "property isInternal should not be set yet");
  m_result->SetIsInternal(value);
  return castState<IsInternalSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::IsPrimarySet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetIsPrimary(bool value) {
  static_assert(!(STATE & IsPrimarySet), "property isPrimary should not be set yet");
  m_result->SetIsPrimary(value);
  return castState<IsPrimarySet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::LabelSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetLabel(const String& value) {
  static_assert(!(STATE & LabelSet), "property label should not be set yet");
  m_result->SetLabel(value);
  return castState<LabelSet>();
}
template<int STATE>
inline ScreenInfo::ScreenInfoBuilder<STATE | ScreenInfo::ScreenInfoBuilder<STATE>::IdSet>&
ScreenInfo::ScreenInfoBuilder<STATE>::SetId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->SetId(value);
  return castState<IdSet>();
}

inline ScreenInfo::ScreenInfo() {
  m_left = 0;
  m_top = 0;
  m_width = 0;
  m_height = 0;
  m_availLeft = 0;
  m_availTop = 0;
  m_availWidth = 0;
  m_availHeight = 0;
  m_devicePixelRatio = 0;
  m_colorDepth = 0;
  m_isExtended = false;
  m_isInternal = false;
  m_isPrimary = false;
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse SetAutomationOverride(bool in_enabled) = 0;
    virtual DispatchResponse GetScreenInfos(std::unique_ptr<protocol::Array<protocol::Emulation::ScreenInfo>>* out_screenInfos) = 0;
    virtual DispatchResponse AddScreen(int in_left, int in_top, int in_width, int in_height, std::unique_ptr<protocol::Emulation::WorkAreaInsets> in_workAreaInsets, std::optional<double> in_devicePixelRatio, std::optional<int> in_rotation, std::optional<int> in_colorDepth, std::optional<String> in_label, std::optional<bool> in_isInternal, std::unique_ptr<protocol::Emulation::ScreenInfo>* out_screenInfo) = 0;
    virtual DispatchResponse RemoveScreen(const String& in_screenId) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void VirtualTimeBudgetExpired();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Emulation
} // namespace protocol

#endif // !defined(protocol_Emulation_h)
