// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Cast_h
#define protocol_Cast_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace Cast {
class Sink;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class  Sink : public ::crdtp::ProtocolObject<Sink> {
public:
    ~Sink() override;  // Defined below

    String GetName() { return m_name; }
    void SetName(const String& value);  // Defined below

    String GetId() { return m_id; }
    void SetId(const String& value);  // Defined below

    bool HasSession() { return !!m_session; }
    String GetSession(const String& defaultValue) const {
       return m_session.value_or(defaultValue);
    }
    const std::optional<String>& GetSession() const {
       return m_session;
    }
    void SetSession(const String& value);  // Defined below

    template<int STATE>
    class SinkBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            IdSet = 1 << 2,
            AllFieldsSet = (NameSet | IdSet | 0)};


        SinkBuilder<STATE | NameSet>& SetName(const String& value);  // Defined below

        SinkBuilder<STATE | IdSet>& SetId(const String& value);  // Defined below

        SinkBuilder<STATE>& SetSession(const String& value);  // Defined below

        std::unique_ptr<Sink> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Sink;
        SinkBuilder() : m_result(new Sink()) { }

        template<int STEP> SinkBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SinkBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Cast::Sink> m_result;
    };

    static SinkBuilder<0> Create()
    {
        return SinkBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Sink();  // Defined below

    String m_name;
    String m_id;
    std::optional<String> m_session;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Sink::~Sink() = default;
inline void Sink::SetName(const String& value) { m_name = value; }
inline void Sink::SetId(const String& value) { m_id = value; }
inline void Sink::SetSession(const String& value) { m_session = value; }

template<int STATE>
inline Sink::SinkBuilder<STATE | Sink::SinkBuilder<STATE>::NameSet>&
Sink::SinkBuilder<STATE>::SetName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->SetName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Sink::SinkBuilder<STATE | Sink::SinkBuilder<STATE>::IdSet>&
Sink::SinkBuilder<STATE>::SetId(const String& value) {
  static_assert(!(STATE & IdSet), "property id should not be set yet");
  m_result->SetId(value);
  return castState<IdSet>();
}
template<int STATE>
inline Sink::SinkBuilder<STATE>& Sink::SinkBuilder<STATE>::SetSession(const String& value) {
  m_result->SetSession(value);
  return *this;
}

inline Sink::Sink() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable(std::optional<String> in_presentationUrl) = 0;
    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse SetSinkToUse(const String& in_sinkName) = 0;
    class  StartDesktopMirroringCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StartDesktopMirroringCallback() { }
    };
    virtual void StartDesktopMirroring(const String& in_sinkName, std::unique_ptr<StartDesktopMirroringCallback> callback) = 0;
    class  StartTabMirroringCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~StartTabMirroringCallback() { }
    };
    virtual void StartTabMirroring(const String& in_sinkName, std::unique_ptr<StartTabMirroringCallback> callback) = 0;
    virtual DispatchResponse StopCasting(const String& in_sinkName) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void SinksUpdated(std::unique_ptr<protocol::Array<protocol::Cast::Sink>> sinks);
    void IssueUpdated(const String& issueMessage);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Cast
} // namespace protocol

#endif // !defined(protocol_Cast_h)
