// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/devtools/protocol/autofill.h"

#include "chrome/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace protocol {
namespace Autofill {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Autofill";
const char Metainfo::commandPrefix[] = "Autofill.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(CreditCard)
    CRDTP_DESERIALIZE_FIELD("cvc", m_cvc),
    CRDTP_DESERIALIZE_FIELD("expiryMonth", m_expiryMonth),
    CRDTP_DESERIALIZE_FIELD("expiryYear", m_expiryYear),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("number", m_number),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CreditCard)
    CRDTP_SERIALIZE_FIELD("number", m_number);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("expiryMonth", m_expiryMonth);
    CRDTP_SERIALIZE_FIELD("expiryYear", m_expiryYear);
    CRDTP_SERIALIZE_FIELD("cvc", m_cvc);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AddressField)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AddressField)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AddressFields)
    CRDTP_DESERIALIZE_FIELD("fields", m_fields),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AddressFields)
    CRDTP_SERIALIZE_FIELD("fields", m_fields);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Address)
    CRDTP_DESERIALIZE_FIELD("fields", m_fields),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Address)
    CRDTP_SERIALIZE_FIELD("fields", m_fields);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AddressUI)
    CRDTP_DESERIALIZE_FIELD("addressFields", m_addressFields),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AddressUI)
    CRDTP_SERIALIZE_FIELD("addressFields", m_addressFields);
CRDTP_END_SERIALIZER();


namespace FillingStrategyEnum {
const char AutocompleteAttribute[] = "autocompleteAttribute";
const char AutofillInferred[] = "autofillInferred";
} // namespace FillingStrategyEnum


CRDTP_BEGIN_DESERIALIZER(FilledField)
    CRDTP_DESERIALIZE_FIELD("autofillType", m_autofillType),
    CRDTP_DESERIALIZE_FIELD("fieldId", m_fieldId),
    CRDTP_DESERIALIZE_FIELD("fillingStrategy", m_fillingStrategy),
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD("htmlType", m_htmlType),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(FilledField)
    CRDTP_SERIALIZE_FIELD("htmlType", m_htmlType);
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("autofillType", m_autofillType);
    CRDTP_SERIALIZE_FIELD("fillingStrategy", m_fillingStrategy);
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("fieldId", m_fieldId);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::AddressFormFilled(std::unique_ptr<protocol::Array<protocol::Autofill::FilledField>> filledFields, std::unique_ptr<protocol::Autofill::AddressUI> addressUi)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("filledFields"), filledFields);
    serializer.AddField(crdtp::MakeSpan("addressUi"), addressUi);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Autofill.addressFormFilled", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void trigger(const crdtp::Dispatchable& dispatchable);
    void setAddresses(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("setAddresses"),
          &DomainDispatcherImpl::setAddresses
    },
    {
          crdtp::SpanFrom("trigger"),
          &DomainDispatcherImpl::trigger
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class TriggerCallbackImpl : public Backend::TriggerCallback, public DomainDispatcher::Callback {
public:
    TriggerCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Autofill.trigger"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct triggerParams : public crdtp::DeserializableProtocolObject<triggerParams> {
    int fieldId;
    std::optional<String> frameId;
    std::unique_ptr<protocol::Autofill::CreditCard> card;
    std::unique_ptr<protocol::Autofill::Address> address;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(triggerParams)
    CRDTP_DESERIALIZE_FIELD_OPT("address", address),
    CRDTP_DESERIALIZE_FIELD_OPT("card", card),
    CRDTP_DESERIALIZE_FIELD("fieldId", fieldId),
    CRDTP_DESERIALIZE_FIELD_OPT("frameId", frameId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::trigger(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    triggerParams params;
    if (!triggerParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->Trigger(params.fieldId, std::move(params.frameId), std::move(params.card), std::move(params.address), std::make_unique<TriggerCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class SetAddressesCallbackImpl : public Backend::SetAddressesCallback, public DomainDispatcher::Callback {
public:
    SetAddressesCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Autofill.setAddresses"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct setAddressesParams : public crdtp::DeserializableProtocolObject<setAddressesParams> {
    std::unique_ptr<protocol::Array<protocol::Autofill::Address>> addresses;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAddressesParams)
    CRDTP_DESERIALIZE_FIELD("addresses", addresses),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAddresses(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAddressesParams params;
    if (!setAddressesParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->SetAddresses(std::move(params.addresses), std::make_unique<SetAddressesCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Autofill.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Autofill.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Autofill"), SortedRedirects(), std::move(dispatcher));
}

} // Autofill
} // namespace protocol
