// chrome/browser/contextual_tasks/contextual_tasks_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/contextual_tasks/contextual_tasks_types.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace contextual_tasks_internals::mojom {

class ContextualTasksInternalsPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class ContextualTasksInternalsPageHandlerFactoryStub;

class ContextualTasksInternalsPageHandlerFactoryRequestValidator;


class ContextualTasksInternalsPageHandlerFactory
    : public ContextualTasksInternalsPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "contextual_tasks_internals.mojom.ContextualTasksInternalsPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContextualTasksInternalsPageHandlerFactoryInterfaceBase;
  using Proxy_ = ContextualTasksInternalsPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContextualTasksInternalsPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ContextualTasksInternalsPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContextualTasksInternalsPageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<ContextualTasksInternalsPage> page, ::mojo::PendingReceiver<ContextualTasksInternalsPageHandler> handler) = 0;
};

class ContextualTasksInternalsPageHandlerProxy;

template <typename ImplRefTraits>
class ContextualTasksInternalsPageHandlerStub;

class ContextualTasksInternalsPageHandlerRequestValidator;
class ContextualTasksInternalsPageHandlerResponseValidator;


class ContextualTasksInternalsPageHandler
    : public ContextualTasksInternalsPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "contextual_tasks_internals.mojom.ContextualTasksInternalsPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContextualTasksInternalsPageHandlerInterfaceBase;
  using Proxy_ = ContextualTasksInternalsPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContextualTasksInternalsPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ContextualTasksInternalsPageHandlerRequestValidator;
  using ResponseValidator_ = ContextualTasksInternalsPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetRelevantContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetRelevantContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContextualTasksInternalsPageHandler() = default;

  using GetRelevantContextCallback = base::OnceCallback<void(GetRelevantContextResponsePtr)>;
  using GetRelevantContextMojoCallback = base::OnceCallback<void(GetRelevantContextResponsePtr)>;

  virtual void GetRelevantContext(GetRelevantContextRequestPtr request, GetRelevantContextCallback callback) = 0;
};

class ContextualTasksInternalsPageProxy;

template <typename ImplRefTraits>
class ContextualTasksInternalsPageStub;

class ContextualTasksInternalsPageRequestValidator;


class ContextualTasksInternalsPage
    : public ContextualTasksInternalsPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "contextual_tasks_internals.mojom.ContextualTasksInternalsPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContextualTasksInternalsPageInterfaceBase;
  using Proxy_ = ContextualTasksInternalsPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContextualTasksInternalsPageStub<ImplRefTraits>;

  using RequestValidator_ = ContextualTasksInternalsPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLogMessageAddedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLogMessageAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContextualTasksInternalsPage() = default;

  virtual void OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) = 0;
};



class  ContextualTasksInternalsPageHandlerFactoryProxy
    : public ContextualTasksInternalsPageHandlerFactory {
 public:
  using InterfaceType = ContextualTasksInternalsPageHandlerFactory;

  explicit ContextualTasksInternalsPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<ContextualTasksInternalsPage> page, ::mojo::PendingReceiver<ContextualTasksInternalsPageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ContextualTasksInternalsPageHandlerProxy
    : public ContextualTasksInternalsPageHandler {
 public:
  using InterfaceType = ContextualTasksInternalsPageHandler;

  explicit ContextualTasksInternalsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetRelevantContext(GetRelevantContextRequestPtr request, GetRelevantContextCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ContextualTasksInternalsPageProxy
    : public ContextualTasksInternalsPage {
 public:
  using InterfaceType = ContextualTasksInternalsPage;

  explicit ContextualTasksInternalsPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ContextualTasksInternalsPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(ContextualTasksInternalsPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContextualTasksInternalsPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContextualTasksInternalsPageHandlerFactory>>
class ContextualTasksInternalsPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContextualTasksInternalsPageHandlerFactoryStub() = default;
  ~ContextualTasksInternalsPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextualTasksInternalsPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextualTasksInternalsPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContextualTasksInternalsPageHandlerStubDispatch {
 public:
  static bool Accept(ContextualTasksInternalsPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContextualTasksInternalsPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContextualTasksInternalsPageHandler>>
class ContextualTasksInternalsPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContextualTasksInternalsPageHandlerStub() = default;
  ~ContextualTasksInternalsPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextualTasksInternalsPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextualTasksInternalsPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContextualTasksInternalsPageStubDispatch {
 public:
  static bool Accept(ContextualTasksInternalsPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContextualTasksInternalsPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContextualTasksInternalsPage>>
class ContextualTasksInternalsPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContextualTasksInternalsPageStub() = default;
  ~ContextualTasksInternalsPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextualTasksInternalsPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextualTasksInternalsPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ContextualTasksInternalsPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContextualTasksInternalsPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContextualTasksInternalsPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ContextualTasksInternalsPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  GetRelevantContextRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetRelevantContextRequest, T>::value>;
  using DataView = GetRelevantContextRequestDataView;
  using Data_ = internal::GetRelevantContextRequest_Data;

  template <typename... Args>
  static GetRelevantContextRequestPtr New(Args&&... args) {
    return GetRelevantContextRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetRelevantContextRequestPtr From(const U& u) {
    return mojo::TypeConverter<GetRelevantContextRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetRelevantContextRequest>::Convert(*this);
  }


  GetRelevantContextRequest();

  GetRelevantContextRequest(
      const std::string& query,
      ::contextual_tasks::mojom::TabSelectionMode tab_selection_mode,
      float min_model_score);


  ~GetRelevantContextRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetRelevantContextRequestPtr>
  GetRelevantContextRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetRelevantContextRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetRelevantContextRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetRelevantContextRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetRelevantContextRequest_UnserializedMessageContext<
            UserType, GetRelevantContextRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetRelevantContextRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetRelevantContextRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetRelevantContextRequest_UnserializedMessageContext<
            UserType, GetRelevantContextRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetRelevantContextRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string query;
  
  ::contextual_tasks::mojom::TabSelectionMode tab_selection_mode;
  
  float min_model_score;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetRelevantContextRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  Tab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tab, T>::value>;
  using DataView = TabDataView;
  using Data_ = internal::Tab_Data;

  template <typename... Args>
  static TabPtr New(Args&&... args) {
    return TabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabPtr From(const U& u) {
    return mojo::TypeConverter<TabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tab>::Convert(*this);
  }


  Tab();

  Tab(
      const std::string& title,
      const ::GURL& url);


  ~Tab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabPtr>
  TabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GetRelevantContextResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetRelevantContextResponse, T>::value>;
  using DataView = GetRelevantContextResponseDataView;
  using Data_ = internal::GetRelevantContextResponse_Data;

  template <typename... Args>
  static GetRelevantContextResponsePtr New(Args&&... args) {
    return GetRelevantContextResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetRelevantContextResponsePtr From(const U& u) {
    return mojo::TypeConverter<GetRelevantContextResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetRelevantContextResponse>::Convert(*this);
  }


  GetRelevantContextResponse();

  explicit GetRelevantContextResponse(
      std::vector<TabPtr> relevant_tabs);

GetRelevantContextResponse(const GetRelevantContextResponse&) = delete;
GetRelevantContextResponse& operator=(const GetRelevantContextResponse&) = delete;

  ~GetRelevantContextResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetRelevantContextResponsePtr>
  GetRelevantContextResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetRelevantContextResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetRelevantContextResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetRelevantContextResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetRelevantContextResponse_UnserializedMessageContext<
            UserType, GetRelevantContextResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetRelevantContextResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetRelevantContextResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetRelevantContextResponse_UnserializedMessageContext<
            UserType, GetRelevantContextResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetRelevantContextResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<TabPtr> relevant_tabs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetRelevantContextResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GetRelevantContextRequestPtr GetRelevantContextRequest::Clone() const {
  return New(
      mojo::Clone(query),
      mojo::Clone(tab_selection_mode),
      mojo::Clone(min_model_score)
  );
}

template <typename T, GetRelevantContextRequest::EnableIfSame<T>*>
bool GetRelevantContextRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  if (!mojo::Equals(this->tab_selection_mode, other_struct.tab_selection_mode))
    return false;
  if (!mojo::Equals(this->min_model_score, other_struct.min_model_score))
    return false;
  return true;
}

template <typename T, GetRelevantContextRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  if (lhs.tab_selection_mode < rhs.tab_selection_mode)
    return true;
  if (rhs.tab_selection_mode < lhs.tab_selection_mode)
    return false;
  if (lhs.min_model_score < rhs.min_model_score)
    return true;
  if (rhs.min_model_score < lhs.min_model_score)
    return false;
  return false;
}
template <typename StructPtrType>
TabPtr Tab::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(url)
  );
}

template <typename T, Tab::EnableIfSame<T>*>
bool Tab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, Tab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
GetRelevantContextResponsePtr GetRelevantContextResponse::Clone() const {
  return New(
      mojo::Clone(relevant_tabs)
  );
}

template <typename T, GetRelevantContextResponse::EnableIfSame<T>*>
bool GetRelevantContextResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->relevant_tabs, other_struct.relevant_tabs))
    return false;
  return true;
}

template <typename T, GetRelevantContextResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.relevant_tabs < rhs.relevant_tabs)
    return true;
  if (rhs.relevant_tabs < lhs.relevant_tabs)
    return false;
  return false;
}


}  // contextual_tasks_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::contextual_tasks_internals::mojom::GetRelevantContextRequest::DataView,
                                         ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr> {
  static bool IsNull(const ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr& input) { return !input; }
  static void SetToNull(::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr* output) { output->reset(); }

  static const decltype(::contextual_tasks_internals::mojom::GetRelevantContextRequest::query)& query(
      const ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr& input) {
    return input->query;
  }

  static decltype(::contextual_tasks_internals::mojom::GetRelevantContextRequest::tab_selection_mode) tab_selection_mode(
      const ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr& input) {
    return input->tab_selection_mode;
  }

  static decltype(::contextual_tasks_internals::mojom::GetRelevantContextRequest::min_model_score) min_model_score(
      const ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr& input) {
    return input->min_model_score;
  }

  static bool Read(::contextual_tasks_internals::mojom::GetRelevantContextRequest::DataView input, ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr* output);
};


template <>
struct  StructTraits<::contextual_tasks_internals::mojom::Tab::DataView,
                                         ::contextual_tasks_internals::mojom::TabPtr> {
  static bool IsNull(const ::contextual_tasks_internals::mojom::TabPtr& input) { return !input; }
  static void SetToNull(::contextual_tasks_internals::mojom::TabPtr* output) { output->reset(); }

  static const decltype(::contextual_tasks_internals::mojom::Tab::title)& title(
      const ::contextual_tasks_internals::mojom::TabPtr& input) {
    return input->title;
  }

  static const decltype(::contextual_tasks_internals::mojom::Tab::url)& url(
      const ::contextual_tasks_internals::mojom::TabPtr& input) {
    return input->url;
  }

  static bool Read(::contextual_tasks_internals::mojom::Tab::DataView input, ::contextual_tasks_internals::mojom::TabPtr* output);
};


template <>
struct  StructTraits<::contextual_tasks_internals::mojom::GetRelevantContextResponse::DataView,
                                         ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr> {
  static bool IsNull(const ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr& input) { return !input; }
  static void SetToNull(::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr* output) { output->reset(); }

  static const decltype(::contextual_tasks_internals::mojom::GetRelevantContextResponse::relevant_tabs)& relevant_tabs(
      const ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr& input) {
    return input->relevant_tabs;
  }

  static bool Read(::contextual_tasks_internals::mojom::GetRelevantContextResponse::DataView input, ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_H_