// chrome/browser/contextual_tasks/contextual_tasks_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-params-data.h"
#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared-message-ids.h"

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-import-headers.h"
#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-test-utils.h"


namespace contextual_tasks_internals::mojom {
GetRelevantContextRequest::GetRelevantContextRequest()
    : query(),
      tab_selection_mode(),
      min_model_score() {}

GetRelevantContextRequest::GetRelevantContextRequest(
    const std::string& query_in,
    ::contextual_tasks::mojom::TabSelectionMode tab_selection_mode_in,
    float min_model_score_in)
    : query(std::move(query_in)),
      tab_selection_mode(std::move(tab_selection_mode_in)),
      min_model_score(std::move(min_model_score_in)) {}

GetRelevantContextRequest::~GetRelevantContextRequest() = default;
size_t GetRelevantContextRequest::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->query);
  seed = mojo::internal::Hash(seed, this->tab_selection_mode);
  seed = mojo::internal::Hash(seed, this->min_model_score);
  return seed;
}

void GetRelevantContextRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "query"), this->query,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_selection_mode"), this->tab_selection_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::contextual_tasks::mojom::TabSelectionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_model_score"), this->min_model_score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetRelevantContextRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tab::Tab()
    : title(),
      url() {}

Tab::Tab(
    const std::string& title_in,
    const ::GURL& url_in)
    : title(std::move(title_in)),
      url(std::move(url_in)) {}

Tab::~Tab() = default;

void Tab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetRelevantContextResponse::GetRelevantContextResponse()
    : relevant_tabs() {}

GetRelevantContextResponse::GetRelevantContextResponse(
    std::vector<TabPtr> relevant_tabs_in)
    : relevant_tabs(std::move(relevant_tabs_in)) {}

GetRelevantContextResponse::~GetRelevantContextResponse() = default;

void GetRelevantContextResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relevant_tabs"), this->relevant_tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetRelevantContextResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ContextualTasksInternalsPageHandlerFactory::IPCStableHashFunction ContextualTasksInternalsPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContextualTasksInternalsPageHandlerFactory>(message.name())) {
    case messages::ContextualTasksInternalsPageHandlerFactory::kCreatePageHandler: {
      return &ContextualTasksInternalsPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContextualTasksInternalsPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContextualTasksInternalsPageHandlerFactory>(message.name())) {
      case messages::ContextualTasksInternalsPageHandlerFactory::kCreatePageHandler:
            return "Receive contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::ContextualTasksInternalsPageHandlerFactory>(message.name())) {
      case messages::ContextualTasksInternalsPageHandlerFactory::kCreatePageHandler:
            return "Receive reply contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContextualTasksInternalsPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe41d29e9;  // IPCStableHash for contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContextualTasksInternalsPageHandlerFactoryProxy::ContextualTasksInternalsPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContextualTasksInternalsPageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<ContextualTasksInternalsPage> in_page, ::mojo::PendingReceiver<ContextualTasksInternalsPageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<ContextualTasksInternalsPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<ContextualTasksInternalsPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextualTasksInternalsPageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks_internals::mojom::internal::ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::contextual_tasks_internals::mojom::ContextualTasksInternalsPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in ContextualTasksInternalsPageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ContextualTasksInternalsPageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextualTasksInternalsPageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContextualTasksInternalsPageHandlerFactoryStubDispatch::Accept(
    ContextualTasksInternalsPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContextualTasksInternalsPageHandlerFactory>(message->header()->name)) {
    case messages::ContextualTasksInternalsPageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContextualTasksInternalsPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<ContextualTasksInternalsPage> p_page{};
      ::mojo::PendingReceiver<ContextualTasksInternalsPageHandler> p_handler{};
      ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextualTasksInternalsPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool ContextualTasksInternalsPageHandlerFactoryStubDispatch::AcceptWithResponder(
    ContextualTasksInternalsPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContextualTasksInternalsPageHandlerFactory>(message->header()->name)) {
    case messages::ContextualTasksInternalsPageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContextualTasksInternalsPageHandlerFactoryValidationInfo[] = {
    { &internal::ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContextualTasksInternalsPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandlerFactory::Name_,
    kContextualTasksInternalsPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ContextualTasksInternalsPageHandler::IPCStableHashFunction ContextualTasksInternalsPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContextualTasksInternalsPageHandler>(message.name())) {
    case messages::ContextualTasksInternalsPageHandler::kGetRelevantContext: {
      return &ContextualTasksInternalsPageHandler::GetRelevantContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContextualTasksInternalsPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContextualTasksInternalsPageHandler>(message.name())) {
      case messages::ContextualTasksInternalsPageHandler::kGetRelevantContext:
            return "Receive contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::GetRelevantContext";
    }
  } else {
    switch (static_cast<messages::ContextualTasksInternalsPageHandler>(message.name())) {
      case messages::ContextualTasksInternalsPageHandler::kGetRelevantContext:
            return "Receive reply contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::GetRelevantContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContextualTasksInternalsPageHandler::GetRelevantContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd8bad7f5;  // IPCStableHash for contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::GetRelevantContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback(
      ContextualTasksInternalsPageHandler::GetRelevantContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback(const ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback&) = delete;
  ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback& operator=(const ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ContextualTasksInternalsPageHandler::GetRelevantContextCallback callback_;
};

ContextualTasksInternalsPageHandlerProxy::ContextualTasksInternalsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContextualTasksInternalsPageHandlerProxy::GetRelevantContext(
    GetRelevantContextRequestPtr in_request, GetRelevantContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::GetRelevantContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type GetRelevantContextRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextualTasksInternalsPageHandler::kGetRelevantContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks_internals::mojom::internal::ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::contextual_tasks_internals::mojom::GetRelevantContextRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in ContextualTasksInternalsPageHandler.GetRelevantContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextualTasksInternalsPageHandler::Name_);
  message.set_method_name("GetRelevantContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ContextualTasksInternalsPageHandler::GetRelevantContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder> proxy(
        new ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ContextualTasksInternalsPageHandler::GetRelevantContextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetRelevantContextResponsePtr in_response);
};

bool ContextualTasksInternalsPageHandler_GetRelevantContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ContextualTasksInternalsPageHandler.0
  bool success = true;
  GetRelevantContextResponsePtr p_response{};
  ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ContextualTasksInternalsPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder::Run(
    GetRelevantContextResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::GetRelevantContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type GetRelevantContextResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextualTasksInternalsPageHandler::kGetRelevantContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks_internals::mojom::internal::ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::contextual_tasks_internals::mojom::GetRelevantContextResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextualTasksInternalsPageHandler::Name_);
  message.set_method_name("GetRelevantContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ContextualTasksInternalsPageHandlerStubDispatch::Accept(
    ContextualTasksInternalsPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContextualTasksInternalsPageHandler>(message->header()->name)) {
    case messages::ContextualTasksInternalsPageHandler::kGetRelevantContext: {
      break;
    }
  }
  return false;
}

// static
bool ContextualTasksInternalsPageHandlerStubDispatch::AcceptWithResponder(
    ContextualTasksInternalsPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContextualTasksInternalsPageHandler>(message->header()->name)) {
    case messages::ContextualTasksInternalsPageHandler::kGetRelevantContext: {
      internal::ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data* params =
          reinterpret_cast<
              internal::ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ContextualTasksInternalsPageHandler.0
      bool success = true;
      GetRelevantContextRequestPtr p_request{};
      ContextualTasksInternalsPageHandler_GetRelevantContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextualTasksInternalsPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          ContextualTasksInternalsPageHandler_GetRelevantContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRelevantContext(        
        std::move(p_request), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContextualTasksInternalsPageHandlerValidationInfo[] = {
    { &internal::ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data::Validate,
     &internal::ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data::Validate},
};

bool ContextualTasksInternalsPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::Name_,
    kContextualTasksInternalsPageHandlerValidationInfo);
}

bool ContextualTasksInternalsPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::contextual_tasks_internals::mojom::ContextualTasksInternalsPageHandler::Name_,
    kContextualTasksInternalsPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

ContextualTasksInternalsPage::IPCStableHashFunction ContextualTasksInternalsPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContextualTasksInternalsPage>(message.name())) {
    case messages::ContextualTasksInternalsPage::kOnLogMessageAdded: {
      return &ContextualTasksInternalsPage::OnLogMessageAdded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContextualTasksInternalsPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContextualTasksInternalsPage>(message.name())) {
      case messages::ContextualTasksInternalsPage::kOnLogMessageAdded:
            return "Receive contextual_tasks_internals::mojom::ContextualTasksInternalsPage::OnLogMessageAdded";
    }
  } else {
    switch (static_cast<messages::ContextualTasksInternalsPage>(message.name())) {
      case messages::ContextualTasksInternalsPage::kOnLogMessageAdded:
            return "Receive reply contextual_tasks_internals::mojom::ContextualTasksInternalsPage::OnLogMessageAdded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContextualTasksInternalsPage::OnLogMessageAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec2ef05a;  // IPCStableHash for contextual_tasks_internals::mojom::ContextualTasksInternalsPage::OnLogMessageAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContextualTasksInternalsPageProxy::ContextualTasksInternalsPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContextualTasksInternalsPageProxy::OnLogMessageAdded(
    ::base::Time in_event_time, const std::string& in_source_file, int64_t in_source_line, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks_internals::mojom::ContextualTasksInternalsPage::OnLogMessageAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_time"), in_event_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_line"), in_source_line,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextualTasksInternalsPage::kOnLogMessageAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks_internals::mojom::internal::ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_time)::BaseType> event_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_event_time,
    event_time_fragment);

  params->event_time.Set(
      event_time_fragment.is_null() ? nullptr : event_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_time in ContextualTasksInternalsPage.OnLogMessageAdded request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_file in ContextualTasksInternalsPage.OnLogMessageAdded request");

  params->source_line = in_source_line;
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ContextualTasksInternalsPage.OnLogMessageAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextualTasksInternalsPage::Name_);
  message.set_method_name("OnLogMessageAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContextualTasksInternalsPageStubDispatch::Accept(
    ContextualTasksInternalsPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContextualTasksInternalsPage>(message->header()->name)) {
    case messages::ContextualTasksInternalsPage::kOnLogMessageAdded: {
      DCHECK(message->is_serialized());
      internal::ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data* params =
          reinterpret_cast<internal::ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContextualTasksInternalsPage.0
      bool success = true;
      ::base::Time p_event_time{};
      std::string p_source_file{};
      int64_t p_source_line{};
      std::string p_message{};
      ContextualTasksInternalsPage_OnLogMessageAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventTime(&p_event_time))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_source_line = input_data_view.source_line();
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextualTasksInternalsPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLogMessageAdded(        
        std::move(p_event_time), 
        std::move(p_source_file), 
        std::move(p_source_line), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool ContextualTasksInternalsPageStubDispatch::AcceptWithResponder(
    ContextualTasksInternalsPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContextualTasksInternalsPage>(message->header()->name)) {
    case messages::ContextualTasksInternalsPage::kOnLogMessageAdded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContextualTasksInternalsPageValidationInfo[] = {
    { &internal::ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContextualTasksInternalsPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::contextual_tasks_internals::mojom::ContextualTasksInternalsPage::Name_,
    kContextualTasksInternalsPageValidationInfo);
}



}  // contextual_tasks_internals::mojom


namespace mojo {


// static
bool StructTraits<::contextual_tasks_internals::mojom::GetRelevantContextRequest::DataView, ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr>::Read(
    ::contextual_tasks_internals::mojom::GetRelevantContextRequest::DataView input,
    ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr* output) {
  bool success = true;
  ::contextual_tasks_internals::mojom::GetRelevantContextRequestPtr result(::contextual_tasks_internals::mojom::GetRelevantContextRequest::New());
  
      if (success && !input.ReadQuery(&result->query))
        success = false;
      if (success && !input.ReadTabSelectionMode(&result->tab_selection_mode))
        success = false;
      if (success)
        result->min_model_score = input.min_model_score();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::contextual_tasks_internals::mojom::Tab::DataView, ::contextual_tasks_internals::mojom::TabPtr>::Read(
    ::contextual_tasks_internals::mojom::Tab::DataView input,
    ::contextual_tasks_internals::mojom::TabPtr* output) {
  bool success = true;
  ::contextual_tasks_internals::mojom::TabPtr result(::contextual_tasks_internals::mojom::Tab::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::contextual_tasks_internals::mojom::GetRelevantContextResponse::DataView, ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr>::Read(
    ::contextual_tasks_internals::mojom::GetRelevantContextResponse::DataView input,
    ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr* output) {
  bool success = true;
  ::contextual_tasks_internals::mojom::GetRelevantContextResponsePtr result(::contextual_tasks_internals::mojom::GetRelevantContextResponse::New());
  
      if (success && !input.ReadRelevantTabs(&result->relevant_tabs))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace contextual_tasks_internals::mojom {


void ContextualTasksInternalsPageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<ContextualTasksInternalsPage> page, ::mojo::PendingReceiver<ContextualTasksInternalsPageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
ContextualTasksInternalsPageHandlerFactoryAsyncWaiter::ContextualTasksInternalsPageHandlerFactoryAsyncWaiter(
    ContextualTasksInternalsPageHandlerFactory* proxy) : proxy_(proxy) {}

ContextualTasksInternalsPageHandlerFactoryAsyncWaiter::~ContextualTasksInternalsPageHandlerFactoryAsyncWaiter() = default;





void ContextualTasksInternalsPageHandlerInterceptorForTesting::GetRelevantContext(GetRelevantContextRequestPtr request, GetRelevantContextCallback callback) {
  GetForwardingInterface()->GetRelevantContext(
    std::move(request)
    , std::move(callback));
}
ContextualTasksInternalsPageHandlerAsyncWaiter::ContextualTasksInternalsPageHandlerAsyncWaiter(
    ContextualTasksInternalsPageHandler* proxy) : proxy_(proxy) {}

ContextualTasksInternalsPageHandlerAsyncWaiter::~ContextualTasksInternalsPageHandlerAsyncWaiter() = default;


void ContextualTasksInternalsPageHandlerAsyncWaiter::GetRelevantContext(
    GetRelevantContextRequestPtr request, GetRelevantContextResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->GetRelevantContext(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop,
             GetRelevantContextResponsePtr* out_response
,
             GetRelevantContextResponsePtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

GetRelevantContextResponsePtr ContextualTasksInternalsPageHandlerAsyncWaiter::GetRelevantContext(
    GetRelevantContextRequestPtr request) {
  GetRelevantContextResponsePtr async_wait_result;
  GetRelevantContext(std::move(request),&async_wait_result);
  return async_wait_result;
}




void ContextualTasksInternalsPageInterceptorForTesting::OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) {
  GetForwardingInterface()->OnLogMessageAdded(
    std::move(event_time)
    , 
    std::move(source_file)
    , 
    std::move(source_line)
    , 
    std::move(message)
    );
}
ContextualTasksInternalsPageAsyncWaiter::ContextualTasksInternalsPageAsyncWaiter(
    ContextualTasksInternalsPage* proxy) : proxy_(proxy) {}

ContextualTasksInternalsPageAsyncWaiter::~ContextualTasksInternalsPageAsyncWaiter() = default;







}  // contextual_tasks_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif