// chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared-internal.h"
#include "chrome/browser/contextual_tasks/contextual_tasks_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::contextual_tasks_internals::mojom::GetRelevantContextRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::contextual_tasks_internals::mojom::GetRelevantContextRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::contextual_tasks_internals::mojom::internal::GetRelevantContextRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::query(input)) in_query = Traits::query(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query)::BaseType> query_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_query,
      query_fragment);

    fragment->query.Set(
        query_fragment.is_null() ? nullptr : query_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->query.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query in GetRelevantContextRequest struct");

    
    mojo::internal::Serialize<::contextual_tasks::mojom::TabSelectionMode>(
      Traits::tab_selection_mode(input),
      &fragment->tab_selection_mode);

    fragment->min_model_score = Traits::min_model_score(input);
  }

  static bool Deserialize(::contextual_tasks_internals::mojom::internal::GetRelevantContextRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::contextual_tasks_internals::mojom::GetRelevantContextRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::contextual_tasks_internals::mojom::TabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::contextual_tasks_internals::mojom::TabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::contextual_tasks_internals::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Tab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Tab struct");
  }

  static bool Deserialize(::contextual_tasks_internals::mojom::internal::Tab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::contextual_tasks_internals::mojom::TabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::contextual_tasks_internals::mojom::GetRelevantContextResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::contextual_tasks_internals::mojom::GetRelevantContextResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::contextual_tasks_internals::mojom::internal::GetRelevantContextResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::relevant_tabs(input)) in_relevant_tabs = Traits::relevant_tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relevant_tabs)::BaseType>
        relevant_tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& relevant_tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::contextual_tasks_internals::mojom::TabDataView>>(
      in_relevant_tabs,
      relevant_tabs_fragment,
      &relevant_tabs_validate_params);

    fragment->relevant_tabs.Set(
        relevant_tabs_fragment.is_null() ? nullptr : relevant_tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relevant_tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relevant_tabs in GetRelevantContextResponse struct");
  }

  static bool Deserialize(::contextual_tasks_internals::mojom::internal::GetRelevantContextResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::contextual_tasks_internals::mojom::GetRelevantContextResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace contextual_tasks_internals::mojom {

inline void GetRelevantContextRequestDataView::GetQueryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void GetRelevantContextResponseDataView::GetRelevantTabsDataView(
    mojo::ArrayDataView<TabDataView>* output) {
  auto pointer = data_->relevant_tabs.Get();
  *output = mojo::ArrayDataView<TabDataView>(pointer, message_);
}



}  // contextual_tasks_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_SHARED_H_