// chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-params-data.h"
namespace contextual_tasks_internals {
namespace mojom {

namespace internal {


// static
bool GetRelevantContextRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetRelevantContextRequest_Data* object =
      static_cast<const GetRelevantContextRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }


  if (!::contextual_tasks::mojom::internal::TabSelectionMode_Data
        ::Validate(object->tab_selection_mode, validation_context))
    return false;

  return true;
}

GetRelevantContextRequest_Data::GetRelevantContextRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Tab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tab_Data* object =
      static_cast<const Tab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Tab_Data::Tab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetRelevantContextResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetRelevantContextResponse_Data* object =
      static_cast<const GetRelevantContextResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relevant_tabs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& relevant_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->relevant_tabs, validation_context,
                                         &relevant_tabs_validate_params)) {
    return false;
  }

  return true;
}

GetRelevantContextResponse_Data::GetRelevantContextResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data::ContextualTasksInternalsPageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data* object =
      static_cast<const ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data::ContextualTasksInternalsPageHandler_GetRelevantContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data* object =
      static_cast<const ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data::ContextualTasksInternalsPageHandler_GetRelevantContext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data* object =
      static_cast<const ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_file, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_file_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_file, validation_context,
                                         &source_file_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data::ContextualTasksInternalsPage_OnLogMessageAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace contextual_tasks_internals