// chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/contextual_tasks/contextual_tasks_internals.mojom-shared-internal.h"
#include "chrome/browser/contextual_tasks/contextual_tasks_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace contextual_tasks_internals::mojom {
class GetRelevantContextRequestDataView;

class TabDataView;

class GetRelevantContextResponseDataView;



}  // contextual_tasks_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::contextual_tasks_internals::mojom::GetRelevantContextRequestDataView> {
  using Data = ::contextual_tasks_internals::mojom::internal::GetRelevantContextRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::contextual_tasks_internals::mojom::TabDataView> {
  using Data = ::contextual_tasks_internals::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::contextual_tasks_internals::mojom::GetRelevantContextResponseDataView> {
  using Data = ::contextual_tasks_internals::mojom::internal::GetRelevantContextResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace contextual_tasks_internals::mojom {
// Interface base classes. They are used for type safety check.
class ContextualTasksInternalsPageHandlerFactoryInterfaceBase {};

using ContextualTasksInternalsPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<ContextualTasksInternalsPageHandlerFactoryInterfaceBase>;
using ContextualTasksInternalsPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ContextualTasksInternalsPageHandlerFactoryInterfaceBase>;
using ContextualTasksInternalsPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContextualTasksInternalsPageHandlerFactoryInterfaceBase>;
using ContextualTasksInternalsPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContextualTasksInternalsPageHandlerFactoryInterfaceBase>;
class ContextualTasksInternalsPageHandlerInterfaceBase {};

using ContextualTasksInternalsPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<ContextualTasksInternalsPageHandlerInterfaceBase>;
using ContextualTasksInternalsPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ContextualTasksInternalsPageHandlerInterfaceBase>;
using ContextualTasksInternalsPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContextualTasksInternalsPageHandlerInterfaceBase>;
using ContextualTasksInternalsPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContextualTasksInternalsPageHandlerInterfaceBase>;
class ContextualTasksInternalsPageInterfaceBase {};

using ContextualTasksInternalsPagePtrDataView =
    mojo::InterfacePtrDataView<ContextualTasksInternalsPageInterfaceBase>;
using ContextualTasksInternalsPageRequestDataView =
    mojo::InterfaceRequestDataView<ContextualTasksInternalsPageInterfaceBase>;
using ContextualTasksInternalsPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContextualTasksInternalsPageInterfaceBase>;
using ContextualTasksInternalsPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContextualTasksInternalsPageInterfaceBase>;


class GetRelevantContextRequestDataView {
 public:
  GetRelevantContextRequestDataView() = default;

  GetRelevantContextRequestDataView(
      internal::GetRelevantContextRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTabSelectionMode(UserType* output) const {
    auto data_value = data_->tab_selection_mode;
    return mojo::internal::Deserialize<::contextual_tasks::mojom::TabSelectionMode>(
        data_value, output);
  }
  ::contextual_tasks::mojom::TabSelectionMode tab_selection_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::contextual_tasks::mojom::TabSelectionMode>(data_->tab_selection_mode));
  }
  float min_model_score() const {
    return data_->min_model_score;
  }
 private:
  internal::GetRelevantContextRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetRelevantContextResponseDataView {
 public:
  GetRelevantContextResponseDataView() = default;

  GetRelevantContextResponseDataView(
      internal::GetRelevantContextResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelevantTabsDataView(
      mojo::ArrayDataView<TabDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelevantTabs(UserType* output) {
    
    auto* pointer = data_->relevant_tabs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::contextual_tasks_internals::mojom::TabDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GetRelevantContextResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // contextual_tasks_internals::mojom

#endif  // CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_INTERNALS_MOJOM_DATA_VIEW_H_