// chrome/browser/contextual_tasks/contextual_tasks.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_H_
#define CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace contextual_tasks::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "contextual_tasks.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetThreadUrlMinVersion = 0,
    kGetUrlForTaskMinVersion = 0,
    kSetTaskIdMinVersion = 0,
    kIsZeroStateMinVersion = 0,
    kSetThreadTitleMinVersion = 0,
    kCloseSidePanelMinVersion = 0,
    kShowThreadHistoryMinVersion = 0,
    kIsShownInTabMinVersion = 0,
    kOpenMyActivityUiMinVersion = 0,
    kOpenHelpUiMinVersion = 0,
    kOpenOnboardingHelpUiMinVersion = 0,
    kMoveTaskUiToNewTabMinVersion = 0,
    kOnTabClickedFromSourcesMenuMinVersion = 0,
    kOnWebviewMessageMinVersion = 0,
    kGetCommonSearchParamsMinVersion = 0,
    kOnboardingTooltipDismissedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetThreadUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUrlForTask_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTaskId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsZeroState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetThreadTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseSidePanel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowThreadHistory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsShownInTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenMyActivityUi_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenHelpUi_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenOnboardingHelpUi_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveTaskUiToNewTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnTabClickedFromSourcesMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWebviewMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCommonSearchParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnboardingTooltipDismissed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetThreadUrlCallback = base::OnceCallback<void(const ::GURL&)>;
  using GetThreadUrlMojoCallback = base::OnceCallback<void(const ::GURL&)>;

  virtual void GetThreadUrl(GetThreadUrlCallback callback) = 0;

  using GetUrlForTaskCallback = base::OnceCallback<void(const ::GURL&)>;
  using GetUrlForTaskMojoCallback = base::OnceCallback<void(const ::GURL&)>;

  virtual void GetUrlForTask(const ::base::Uuid& uuid, GetUrlForTaskCallback callback) = 0;

  virtual void SetTaskId(const ::base::Uuid& uuid) = 0;

  using IsZeroStateCallback = base::OnceCallback<void(bool)>;
  using IsZeroStateMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsZeroState(const ::GURL& url, IsZeroStateCallback callback) = 0;

  virtual void SetThreadTitle(const std::string& title) = 0;

  virtual void CloseSidePanel() = 0;

  virtual void ShowThreadHistory() = 0;

  using IsShownInTabCallback = base::OnceCallback<void(bool)>;
  using IsShownInTabMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsShownInTab(IsShownInTabCallback callback) = 0;

  virtual void OpenMyActivityUi() = 0;

  virtual void OpenHelpUi() = 0;

  virtual void OpenOnboardingHelpUi() = 0;

  virtual void MoveTaskUiToNewTab() = 0;

  virtual void OnTabClickedFromSourcesMenu(int32_t tab_id, const ::GURL& url) = 0;

  virtual void OnWebviewMessage(const std::vector<uint8_t>& message) = 0;

  using GetCommonSearchParamsCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;
  using GetCommonSearchParamsMojoCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;

  virtual void GetCommonSearchParams(bool is_dark_mode, bool is_side_panel, GetCommonSearchParamsCallback callback) = 0;

  virtual void OnboardingTooltipDismissed() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "contextual_tasks.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetThreadTitleMinVersion = 0,
    kSetTaskDetailsMinVersion = 0,
    kOnSidePanelStateChangedMinVersion = 0,
    kPostMessageToWebviewMinVersion = 0,
    kOnHandshakeCompleteMinVersion = 0,
    kSetOAuthTokenMinVersion = 0,
    kOnContextUpdatedMinVersion = 0,
    kHideInputMinVersion = 0,
    kRestoreInputMinVersion = 0,
    kOnZeroStateChangeMinVersion = 0,
    kOnAiPageStatusChangedMinVersion = 0,
    kOnLensOverlayStateChangedMinVersion = 0,
    kShowErrorPageMinVersion = 0,
    kHideErrorPageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetThreadTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTaskDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSidePanelStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PostMessageToWebview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHandshakeComplete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOAuthToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnContextUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HideInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RestoreInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnZeroStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAiPageStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLensOverlayStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowErrorPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HideErrorPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SetThreadTitle(const std::string& title) = 0;

  virtual void SetTaskDetails(const ::base::Uuid& uuid, const std::string& thread_id, const std::string& turn_id) = 0;

  virtual void OnSidePanelStateChanged() = 0;

  virtual void PostMessageToWebview(const std::vector<uint8_t>& message) = 0;

  virtual void OnHandshakeComplete() = 0;

  virtual void SetOAuthToken(const std::string& oauth_token) = 0;

  virtual void OnContextUpdated(std::vector<TabPtr> context_tabs) = 0;

  virtual void HideInput() = 0;

  virtual void RestoreInput() = 0;

  virtual void OnZeroStateChange(bool is_zero_state) = 0;

  virtual void OnAiPageStatusChanged(bool is_ai_page) = 0;

  virtual void OnLensOverlayStateChanged(bool is_showing) = 0;

  virtual void ShowErrorPage() = 0;

  virtual void HideErrorPage() = 0;
};

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "contextual_tasks.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> page_handler) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetThreadUrl(GetThreadUrlCallback callback) final;
  
  void GetUrlForTask(const ::base::Uuid& uuid, GetUrlForTaskCallback callback) final;
  
  void SetTaskId(const ::base::Uuid& uuid) final;
  
  void IsZeroState(const ::GURL& url, IsZeroStateCallback callback) final;
  
  void SetThreadTitle(const std::string& title) final;
  
  void CloseSidePanel() final;
  
  void ShowThreadHistory() final;
  
  void IsShownInTab(IsShownInTabCallback callback) final;
  
  void OpenMyActivityUi() final;
  
  void OpenHelpUi() final;
  
  void OpenOnboardingHelpUi() final;
  
  void MoveTaskUiToNewTab() final;
  
  void OnTabClickedFromSourcesMenu(int32_t tab_id, const ::GURL& url) final;
  
  void OnWebviewMessage(const std::vector<uint8_t>& message) final;
  
  void GetCommonSearchParams(bool is_dark_mode, bool is_side_panel, GetCommonSearchParamsCallback callback) final;
  
  void OnboardingTooltipDismissed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetThreadTitle(const std::string& title) final;
  
  void SetTaskDetails(const ::base::Uuid& uuid, const std::string& thread_id, const std::string& turn_id) final;
  
  void OnSidePanelStateChanged() final;
  
  void PostMessageToWebview(const std::vector<uint8_t>& message) final;
  
  void OnHandshakeComplete() final;
  
  void SetOAuthToken(const std::string& oauth_token) final;
  
  void OnContextUpdated(std::vector<TabPtr> context_tabs) final;
  
  void HideInput() final;
  
  void RestoreInput() final;
  
  void OnZeroStateChange(bool is_zero_state) final;
  
  void OnAiPageStatusChanged(bool is_ai_page) final;
  
  void OnLensOverlayStateChanged(bool is_showing) final;
  
  void ShowErrorPage() final;
  
  void HideErrorPage() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> page_handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  Tab {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Tab, T>::value>;
  using DataView = TabDataView;
  using Data_ = internal::Tab_Data;

  template <typename... Args>
  static TabPtr New(Args&&... args) {
    return TabPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabPtr From(const U& u) {
    return mojo::TypeConverter<TabPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Tab>::Convert(*this);
  }


  Tab();

  Tab(
      int32_t tab_id,
      const std::string& title,
      const ::GURL& url);


  ~Tab();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabPtr>
  TabPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Tab::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Tab::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Tab::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Tab::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Tab_UnserializedMessageContext<
            UserType, Tab::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Tab::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t tab_id;
  
  std::string title;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Tab::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TabPtr Tab::Clone() const {
  return New(
      mojo::Clone(tab_id),
      mojo::Clone(title),
      mojo::Clone(url)
  );
}

template <typename T, Tab::EnableIfSame<T>*>
bool Tab::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_id, other_struct.tab_id))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, Tab::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_id < rhs.tab_id)
    return true;
  if (rhs.tab_id < lhs.tab_id)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}


}  // contextual_tasks::mojom

namespace mojo {


template <>
struct  StructTraits<::contextual_tasks::mojom::Tab::DataView,
                                         ::contextual_tasks::mojom::TabPtr> {
  static bool IsNull(const ::contextual_tasks::mojom::TabPtr& input) { return !input; }
  static void SetToNull(::contextual_tasks::mojom::TabPtr* output) { output->reset(); }

  static decltype(::contextual_tasks::mojom::Tab::tab_id) tab_id(
      const ::contextual_tasks::mojom::TabPtr& input) {
    return input->tab_id;
  }

  static const decltype(::contextual_tasks::mojom::Tab::title)& title(
      const ::contextual_tasks::mojom::TabPtr& input) {
    return input->title;
  }

  static const decltype(::contextual_tasks::mojom::Tab::url)& url(
      const ::contextual_tasks::mojom::TabPtr& input) {
    return input->url;
  }

  static bool Read(::contextual_tasks::mojom::Tab::DataView input, ::contextual_tasks::mojom::TabPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_H_