// chrome/browser/contextual_tasks/contextual_tasks.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-params-data.h"
#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-shared-message-ids.h"

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-import-headers.h"
#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-test-utils.h"


namespace contextual_tasks::mojom {
Tab::Tab()
    : tab_id(),
      title(),
      url() {}

Tab::Tab(
    int32_t tab_id_in,
    const std::string& title_in,
    const ::GURL& url_in)
    : tab_id(std::move(tab_id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)) {}

Tab::~Tab() = default;

void Tab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetThreadUrl: {
      return &PageHandler::GetThreadUrl_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetUrlForTask: {
      return &PageHandler::GetUrlForTask_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetTaskId: {
      return &PageHandler::SetTaskId_Sym::IPCStableHash;
    }
    case messages::PageHandler::kIsZeroState: {
      return &PageHandler::IsZeroState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetThreadTitle: {
      return &PageHandler::SetThreadTitle_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloseSidePanel: {
      return &PageHandler::CloseSidePanel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowThreadHistory: {
      return &PageHandler::ShowThreadHistory_Sym::IPCStableHash;
    }
    case messages::PageHandler::kIsShownInTab: {
      return &PageHandler::IsShownInTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenMyActivityUi: {
      return &PageHandler::OpenMyActivityUi_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenHelpUi: {
      return &PageHandler::OpenHelpUi_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenOnboardingHelpUi: {
      return &PageHandler::OpenOnboardingHelpUi_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMoveTaskUiToNewTab: {
      return &PageHandler::MoveTaskUiToNewTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnTabClickedFromSourcesMenu: {
      return &PageHandler::OnTabClickedFromSourcesMenu_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnWebviewMessage: {
      return &PageHandler::OnWebviewMessage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetCommonSearchParams: {
      return &PageHandler::GetCommonSearchParams_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnboardingTooltipDismissed: {
      return &PageHandler::OnboardingTooltipDismissed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetThreadUrl:
            return "Receive contextual_tasks::mojom::PageHandler::GetThreadUrl";
      case messages::PageHandler::kGetUrlForTask:
            return "Receive contextual_tasks::mojom::PageHandler::GetUrlForTask";
      case messages::PageHandler::kSetTaskId:
            return "Receive contextual_tasks::mojom::PageHandler::SetTaskId";
      case messages::PageHandler::kIsZeroState:
            return "Receive contextual_tasks::mojom::PageHandler::IsZeroState";
      case messages::PageHandler::kSetThreadTitle:
            return "Receive contextual_tasks::mojom::PageHandler::SetThreadTitle";
      case messages::PageHandler::kCloseSidePanel:
            return "Receive contextual_tasks::mojom::PageHandler::CloseSidePanel";
      case messages::PageHandler::kShowThreadHistory:
            return "Receive contextual_tasks::mojom::PageHandler::ShowThreadHistory";
      case messages::PageHandler::kIsShownInTab:
            return "Receive contextual_tasks::mojom::PageHandler::IsShownInTab";
      case messages::PageHandler::kOpenMyActivityUi:
            return "Receive contextual_tasks::mojom::PageHandler::OpenMyActivityUi";
      case messages::PageHandler::kOpenHelpUi:
            return "Receive contextual_tasks::mojom::PageHandler::OpenHelpUi";
      case messages::PageHandler::kOpenOnboardingHelpUi:
            return "Receive contextual_tasks::mojom::PageHandler::OpenOnboardingHelpUi";
      case messages::PageHandler::kMoveTaskUiToNewTab:
            return "Receive contextual_tasks::mojom::PageHandler::MoveTaskUiToNewTab";
      case messages::PageHandler::kOnTabClickedFromSourcesMenu:
            return "Receive contextual_tasks::mojom::PageHandler::OnTabClickedFromSourcesMenu";
      case messages::PageHandler::kOnWebviewMessage:
            return "Receive contextual_tasks::mojom::PageHandler::OnWebviewMessage";
      case messages::PageHandler::kGetCommonSearchParams:
            return "Receive contextual_tasks::mojom::PageHandler::GetCommonSearchParams";
      case messages::PageHandler::kOnboardingTooltipDismissed:
            return "Receive contextual_tasks::mojom::PageHandler::OnboardingTooltipDismissed";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetThreadUrl:
            return "Receive reply contextual_tasks::mojom::PageHandler::GetThreadUrl";
      case messages::PageHandler::kGetUrlForTask:
            return "Receive reply contextual_tasks::mojom::PageHandler::GetUrlForTask";
      case messages::PageHandler::kSetTaskId:
            return "Receive reply contextual_tasks::mojom::PageHandler::SetTaskId";
      case messages::PageHandler::kIsZeroState:
            return "Receive reply contextual_tasks::mojom::PageHandler::IsZeroState";
      case messages::PageHandler::kSetThreadTitle:
            return "Receive reply contextual_tasks::mojom::PageHandler::SetThreadTitle";
      case messages::PageHandler::kCloseSidePanel:
            return "Receive reply contextual_tasks::mojom::PageHandler::CloseSidePanel";
      case messages::PageHandler::kShowThreadHistory:
            return "Receive reply contextual_tasks::mojom::PageHandler::ShowThreadHistory";
      case messages::PageHandler::kIsShownInTab:
            return "Receive reply contextual_tasks::mojom::PageHandler::IsShownInTab";
      case messages::PageHandler::kOpenMyActivityUi:
            return "Receive reply contextual_tasks::mojom::PageHandler::OpenMyActivityUi";
      case messages::PageHandler::kOpenHelpUi:
            return "Receive reply contextual_tasks::mojom::PageHandler::OpenHelpUi";
      case messages::PageHandler::kOpenOnboardingHelpUi:
            return "Receive reply contextual_tasks::mojom::PageHandler::OpenOnboardingHelpUi";
      case messages::PageHandler::kMoveTaskUiToNewTab:
            return "Receive reply contextual_tasks::mojom::PageHandler::MoveTaskUiToNewTab";
      case messages::PageHandler::kOnTabClickedFromSourcesMenu:
            return "Receive reply contextual_tasks::mojom::PageHandler::OnTabClickedFromSourcesMenu";
      case messages::PageHandler::kOnWebviewMessage:
            return "Receive reply contextual_tasks::mojom::PageHandler::OnWebviewMessage";
      case messages::PageHandler::kGetCommonSearchParams:
            return "Receive reply contextual_tasks::mojom::PageHandler::GetCommonSearchParams";
      case messages::PageHandler::kOnboardingTooltipDismissed:
            return "Receive reply contextual_tasks::mojom::PageHandler::OnboardingTooltipDismissed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetThreadUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14e76521;  // IPCStableHash for contextual_tasks::mojom::PageHandler::GetThreadUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetUrlForTask_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0bb5cb5d;  // IPCStableHash for contextual_tasks::mojom::PageHandler::GetUrlForTask
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetTaskId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4abb3dd0;  // IPCStableHash for contextual_tasks::mojom::PageHandler::SetTaskId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::IsZeroState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e67bc63;  // IPCStableHash for contextual_tasks::mojom::PageHandler::IsZeroState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetThreadTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61a3ee99;  // IPCStableHash for contextual_tasks::mojom::PageHandler::SetThreadTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloseSidePanel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5263a2b0;  // IPCStableHash for contextual_tasks::mojom::PageHandler::CloseSidePanel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowThreadHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7b2acad;  // IPCStableHash for contextual_tasks::mojom::PageHandler::ShowThreadHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::IsShownInTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b4988a6;  // IPCStableHash for contextual_tasks::mojom::PageHandler::IsShownInTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenMyActivityUi_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb7f41f8;  // IPCStableHash for contextual_tasks::mojom::PageHandler::OpenMyActivityUi
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenHelpUi_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe666f4b5;  // IPCStableHash for contextual_tasks::mojom::PageHandler::OpenHelpUi
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenOnboardingHelpUi_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc4bd320;  // IPCStableHash for contextual_tasks::mojom::PageHandler::OpenOnboardingHelpUi
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MoveTaskUiToNewTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x566627e0;  // IPCStableHash for contextual_tasks::mojom::PageHandler::MoveTaskUiToNewTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnTabClickedFromSourcesMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa06acd21;  // IPCStableHash for contextual_tasks::mojom::PageHandler::OnTabClickedFromSourcesMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnWebviewMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79e8c3a4;  // IPCStableHash for contextual_tasks::mojom::PageHandler::OnWebviewMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetCommonSearchParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65baa556;  // IPCStableHash for contextual_tasks::mojom::PageHandler::GetCommonSearchParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnboardingTooltipDismissed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1bde737;  // IPCStableHash for contextual_tasks::mojom::PageHandler::OnboardingTooltipDismissed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetThreadUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetThreadUrl_ForwardToCallback(
      PageHandler::GetThreadUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetThreadUrl_ForwardToCallback(const PageHandler_GetThreadUrl_ForwardToCallback&) = delete;
  PageHandler_GetThreadUrl_ForwardToCallback& operator=(const PageHandler_GetThreadUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetThreadUrlCallback callback_;
};

class PageHandler_GetUrlForTask_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetUrlForTask_ForwardToCallback(
      PageHandler::GetUrlForTaskCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetUrlForTask_ForwardToCallback(const PageHandler_GetUrlForTask_ForwardToCallback&) = delete;
  PageHandler_GetUrlForTask_ForwardToCallback& operator=(const PageHandler_GetUrlForTask_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetUrlForTaskCallback callback_;
};

class PageHandler_IsZeroState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_IsZeroState_ForwardToCallback(
      PageHandler::IsZeroStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_IsZeroState_ForwardToCallback(const PageHandler_IsZeroState_ForwardToCallback&) = delete;
  PageHandler_IsZeroState_ForwardToCallback& operator=(const PageHandler_IsZeroState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::IsZeroStateCallback callback_;
};

class PageHandler_IsShownInTab_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_IsShownInTab_ForwardToCallback(
      PageHandler::IsShownInTabCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_IsShownInTab_ForwardToCallback(const PageHandler_IsShownInTab_ForwardToCallback&) = delete;
  PageHandler_IsShownInTab_ForwardToCallback& operator=(const PageHandler_IsShownInTab_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::IsShownInTabCallback callback_;
};

class PageHandler_GetCommonSearchParams_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetCommonSearchParams_ForwardToCallback(
      PageHandler::GetCommonSearchParamsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetCommonSearchParams_ForwardToCallback(const PageHandler_GetCommonSearchParams_ForwardToCallback&) = delete;
  PageHandler_GetCommonSearchParams_ForwardToCallback& operator=(const PageHandler_GetCommonSearchParams_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetCommonSearchParamsCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetThreadUrl(
    GetThreadUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::GetThreadUrl");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetThreadUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_GetThreadUrl_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetThreadUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetThreadUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetUrlForTask(
    const ::base::Uuid& in_uuid, GetUrlForTaskCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::GetUrlForTask", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetUrlForTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_GetUrlForTask_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in PageHandler.GetUrlForTask request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetUrlForTask");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetUrlForTask_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetTaskId(
    const ::base::Uuid& in_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::SetTaskId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetTaskId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_SetTaskId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in PageHandler.SetTaskId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetTaskId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::IsZeroState(
    const ::GURL& in_url, IsZeroStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::IsZeroState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsZeroState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_IsZeroState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.IsZeroState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsZeroState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_IsZeroState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetThreadTitle(
    const std::string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::SetThreadTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetThreadTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_SetThreadTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in PageHandler.SetThreadTitle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetThreadTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::CloseSidePanel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::CloseSidePanel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseSidePanel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_CloseSidePanel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseSidePanel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowThreadHistory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::ShowThreadHistory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowThreadHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_ShowThreadHistory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowThreadHistory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::IsShownInTab(
    IsShownInTabCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::IsShownInTab");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsShownInTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_IsShownInTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsShownInTab");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_IsShownInTab_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenMyActivityUi(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::OpenMyActivityUi");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenMyActivityUi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_OpenMyActivityUi_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenMyActivityUi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenHelpUi(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::OpenHelpUi");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenHelpUi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_OpenHelpUi_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenHelpUi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenOnboardingHelpUi(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::OpenOnboardingHelpUi");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenOnboardingHelpUi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_OpenOnboardingHelpUi_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenOnboardingHelpUi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MoveTaskUiToNewTab(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::MoveTaskUiToNewTab");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMoveTaskUiToNewTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_MoveTaskUiToNewTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MoveTaskUiToNewTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnTabClickedFromSourcesMenu(
    int32_t in_tab_id, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::OnTabClickedFromSourcesMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnTabClickedFromSourcesMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_OnTabClickedFromSourcesMenu_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.OnTabClickedFromSourcesMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnTabClickedFromSourcesMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnWebviewMessage(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::OnWebviewMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnWebviewMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_OnWebviewMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in PageHandler.OnWebviewMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnWebviewMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetCommonSearchParams(
    bool in_is_dark_mode, bool in_is_side_panel, GetCommonSearchParamsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandler::GetCommonSearchParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_dark_mode"), in_is_dark_mode,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_side_panel"), in_is_side_panel,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetCommonSearchParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_GetCommonSearchParams_Params_Data> params(
          message);
  params.Allocate();

  params->is_dark_mode = in_is_dark_mode;

  params->is_side_panel = in_is_side_panel;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetCommonSearchParams");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetCommonSearchParams_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OnboardingTooltipDismissed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::PageHandler::OnboardingTooltipDismissed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnboardingTooltipDismissed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_OnboardingTooltipDismissed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnboardingTooltipDismissed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetThreadUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetThreadUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetThreadUrl_ProxyToResponder> proxy(
        new PageHandler_GetThreadUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetThreadUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetThreadUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetThreadUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetThreadUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url);
};

bool PageHandler_GetThreadUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetThreadUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetThreadUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  ::GURL p_url{};
  PageHandler_GetThreadUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void PageHandler_GetThreadUrl_ProxyToResponder::Run(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply contextual_tasks::mojom::PageHandler::GetThreadUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetThreadUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_GetThreadUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetThreadUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetUrlForTask_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetUrlForTaskCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetUrlForTask_ProxyToResponder> proxy(
        new PageHandler_GetUrlForTask_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetUrlForTask_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetUrlForTask_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetUrlForTask_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetUrlForTaskCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url);
};

bool PageHandler_GetUrlForTask_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetUrlForTask_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetUrlForTask_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  ::GURL p_url{};
  PageHandler_GetUrlForTask_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void PageHandler_GetUrlForTask_ProxyToResponder::Run(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply contextual_tasks::mojom::PageHandler::GetUrlForTask", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetUrlForTask), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_GetUrlForTask_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetUrlForTask");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_IsZeroState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::IsZeroStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_IsZeroState_ProxyToResponder> proxy(
        new PageHandler_IsZeroState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_IsZeroState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_IsZeroState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_IsZeroState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::IsZeroStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_zero_state);
};

bool PageHandler_IsZeroState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_IsZeroState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_IsZeroState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  bool p_is_zero_state{};
  PageHandler_IsZeroState_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_zero_state = input_data_view.is_zero_state();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_zero_state));
  }
  return true;
}

void PageHandler_IsZeroState_ProxyToResponder::Run(
    bool in_is_zero_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply contextual_tasks::mojom::PageHandler::IsZeroState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_zero_state"), in_is_zero_state,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsZeroState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_IsZeroState_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_zero_state = in_is_zero_state;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsZeroState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_IsShownInTab_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::IsShownInTabCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_IsShownInTab_ProxyToResponder> proxy(
        new PageHandler_IsShownInTab_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_IsShownInTab_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_IsShownInTab_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_IsShownInTab_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::IsShownInTabCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_in_tab);
};

bool PageHandler_IsShownInTab_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_IsShownInTab_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_IsShownInTab_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.7
  bool success = true;
  bool p_is_in_tab{};
  PageHandler_IsShownInTab_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_in_tab = input_data_view.is_in_tab();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_in_tab));
  }
  return true;
}

void PageHandler_IsShownInTab_ProxyToResponder::Run(
    bool in_is_in_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply contextual_tasks::mojom::PageHandler::IsShownInTab", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_in_tab"), in_is_in_tab,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kIsShownInTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_IsShownInTab_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_in_tab = in_is_in_tab;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("IsShownInTab");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetCommonSearchParams_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetCommonSearchParamsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetCommonSearchParams_ProxyToResponder> proxy(
        new PageHandler_GetCommonSearchParams_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetCommonSearchParams_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetCommonSearchParams_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetCommonSearchParams_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetCommonSearchParamsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<std::string, std::string>& in_params);
};

bool PageHandler_GetCommonSearchParams_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetCommonSearchParams_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetCommonSearchParams_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.14
  bool success = true;
  base::flat_map<std::string, std::string> p_params{};
  PageHandler_GetCommonSearchParams_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_params));
  }
  return true;
}

void PageHandler_GetCommonSearchParams_ProxyToResponder::Run(
    const base::flat_map<std::string, std::string>& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply contextual_tasks::mojom::PageHandler::GetCommonSearchParams", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetCommonSearchParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandler_GetCommonSearchParams_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType>
      params_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_params,
    params_fragment,
    &params_validate_params);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetCommonSearchParams");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetThreadUrl: {
      break;
    }
    case messages::PageHandler::kGetUrlForTask: {
      break;
    }
    case messages::PageHandler::kSetTaskId: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetTaskId_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetTaskId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      ::base::Uuid p_uuid{};
      PageHandler_SetTaskId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTaskId(        
        std::move(p_uuid));
      return true;
    }
    case messages::PageHandler::kIsZeroState: {
      break;
    }
    case messages::PageHandler::kSetThreadTitle: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetThreadTitle_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetThreadTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_title{};
      PageHandler_SetThreadTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThreadTitle(        
        std::move(p_title));
      return true;
    }
    case messages::PageHandler::kCloseSidePanel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseSidePanel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseSidePanel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      PageHandler_CloseSidePanel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseSidePanel(        );
      return true;
    }
    case messages::PageHandler::kShowThreadHistory: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowThreadHistory_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowThreadHistory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      PageHandler_ShowThreadHistory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowThreadHistory(        );
      return true;
    }
    case messages::PageHandler::kIsShownInTab: {
      break;
    }
    case messages::PageHandler::kOpenMyActivityUi: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenMyActivityUi_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenMyActivityUi_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_OpenMyActivityUi_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenMyActivityUi(        );
      return true;
    }
    case messages::PageHandler::kOpenHelpUi: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenHelpUi_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenHelpUi_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      PageHandler_OpenHelpUi_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenHelpUi(        );
      return true;
    }
    case messages::PageHandler::kOpenOnboardingHelpUi: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenOnboardingHelpUi_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenOnboardingHelpUi_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_OpenOnboardingHelpUi_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenOnboardingHelpUi(        );
      return true;
    }
    case messages::PageHandler::kMoveTaskUiToNewTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_MoveTaskUiToNewTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_MoveTaskUiToNewTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      PageHandler_MoveTaskUiToNewTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveTaskUiToNewTab(        );
      return true;
    }
    case messages::PageHandler::kOnTabClickedFromSourcesMenu: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnTabClickedFromSourcesMenu_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnTabClickedFromSourcesMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      int32_t p_tab_id{};
      ::GURL p_url{};
      PageHandler_OnTabClickedFromSourcesMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabClickedFromSourcesMenu(        
        std::move(p_tab_id), 
        std::move(p_url));
      return true;
    }
    case messages::PageHandler::kOnWebviewMessage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnWebviewMessage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnWebviewMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      std::vector<uint8_t> p_message{};
      PageHandler_OnWebviewMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebviewMessage(        
        std::move(p_message));
      return true;
    }
    case messages::PageHandler::kGetCommonSearchParams: {
      break;
    }
    case messages::PageHandler::kOnboardingTooltipDismissed: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnboardingTooltipDismissed_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnboardingTooltipDismissed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      PageHandler_OnboardingTooltipDismissed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnboardingTooltipDismissed(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetThreadUrl: {
      internal::PageHandler_GetThreadUrl_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetThreadUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetThreadUrl_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetThreadUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetThreadUrl(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetUrlForTask: {
      internal::PageHandler_GetUrlForTask_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetUrlForTask_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::base::Uuid p_uuid{};
      PageHandler_GetUrlForTask_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetUrlForTask_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUrlForTask(        
        std::move(p_uuid), std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetTaskId: {
      break;
    }
    case messages::PageHandler::kIsZeroState: {
      internal::PageHandler_IsZeroState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_IsZeroState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      ::GURL p_url{};
      PageHandler_IsZeroState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_IsZeroState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsZeroState(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetThreadTitle: {
      break;
    }
    case messages::PageHandler::kCloseSidePanel: {
      break;
    }
    case messages::PageHandler::kShowThreadHistory: {
      break;
    }
    case messages::PageHandler::kIsShownInTab: {
      internal::PageHandler_IsShownInTab_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_IsShownInTab_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_IsShownInTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          PageHandler_IsShownInTab_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsShownInTab(std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenMyActivityUi: {
      break;
    }
    case messages::PageHandler::kOpenHelpUi: {
      break;
    }
    case messages::PageHandler::kOpenOnboardingHelpUi: {
      break;
    }
    case messages::PageHandler::kMoveTaskUiToNewTab: {
      break;
    }
    case messages::PageHandler::kOnTabClickedFromSourcesMenu: {
      break;
    }
    case messages::PageHandler::kOnWebviewMessage: {
      break;
    }
    case messages::PageHandler::kGetCommonSearchParams: {
      internal::PageHandler_GetCommonSearchParams_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetCommonSearchParams_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      bool p_is_dark_mode{};
      bool p_is_side_panel{};
      PageHandler_GetCommonSearchParams_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_dark_mode = input_data_view.is_dark_mode();
      if (success)
        p_is_side_panel = input_data_view.is_side_panel();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      auto callback =
          PageHandler_GetCommonSearchParams_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCommonSearchParams(        
        std::move(p_is_dark_mode), 
        std::move(p_is_side_panel), std::move(callback));
      return true;
    }
    case messages::PageHandler::kOnboardingTooltipDismissed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetThreadUrl_Params_Data::Validate,
     &internal::PageHandler_GetThreadUrl_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetUrlForTask_Params_Data::Validate,
     &internal::PageHandler_GetUrlForTask_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetTaskId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_IsZeroState_Params_Data::Validate,
     &internal::PageHandler_IsZeroState_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetThreadTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_CloseSidePanel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowThreadHistory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_IsShownInTab_Params_Data::Validate,
     &internal::PageHandler_IsShownInTab_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenMyActivityUi_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenHelpUi_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenOnboardingHelpUi_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MoveTaskUiToNewTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnTabClickedFromSourcesMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnWebviewMessage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetCommonSearchParams_Params_Data::Validate,
     &internal::PageHandler_GetCommonSearchParams_ResponseParams_Data::Validate},
    { &internal::PageHandler_OnboardingTooltipDismissed_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::contextual_tasks::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::contextual_tasks::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSetThreadTitle: {
      return &Page::SetThreadTitle_Sym::IPCStableHash;
    }
    case messages::Page::kSetTaskDetails: {
      return &Page::SetTaskDetails_Sym::IPCStableHash;
    }
    case messages::Page::kOnSidePanelStateChanged: {
      return &Page::OnSidePanelStateChanged_Sym::IPCStableHash;
    }
    case messages::Page::kPostMessageToWebview: {
      return &Page::PostMessageToWebview_Sym::IPCStableHash;
    }
    case messages::Page::kOnHandshakeComplete: {
      return &Page::OnHandshakeComplete_Sym::IPCStableHash;
    }
    case messages::Page::kSetOAuthToken: {
      return &Page::SetOAuthToken_Sym::IPCStableHash;
    }
    case messages::Page::kOnContextUpdated: {
      return &Page::OnContextUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kHideInput: {
      return &Page::HideInput_Sym::IPCStableHash;
    }
    case messages::Page::kRestoreInput: {
      return &Page::RestoreInput_Sym::IPCStableHash;
    }
    case messages::Page::kOnZeroStateChange: {
      return &Page::OnZeroStateChange_Sym::IPCStableHash;
    }
    case messages::Page::kOnAiPageStatusChanged: {
      return &Page::OnAiPageStatusChanged_Sym::IPCStableHash;
    }
    case messages::Page::kOnLensOverlayStateChanged: {
      return &Page::OnLensOverlayStateChanged_Sym::IPCStableHash;
    }
    case messages::Page::kShowErrorPage: {
      return &Page::ShowErrorPage_Sym::IPCStableHash;
    }
    case messages::Page::kHideErrorPage: {
      return &Page::HideErrorPage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSetThreadTitle:
            return "Receive contextual_tasks::mojom::Page::SetThreadTitle";
      case messages::Page::kSetTaskDetails:
            return "Receive contextual_tasks::mojom::Page::SetTaskDetails";
      case messages::Page::kOnSidePanelStateChanged:
            return "Receive contextual_tasks::mojom::Page::OnSidePanelStateChanged";
      case messages::Page::kPostMessageToWebview:
            return "Receive contextual_tasks::mojom::Page::PostMessageToWebview";
      case messages::Page::kOnHandshakeComplete:
            return "Receive contextual_tasks::mojom::Page::OnHandshakeComplete";
      case messages::Page::kSetOAuthToken:
            return "Receive contextual_tasks::mojom::Page::SetOAuthToken";
      case messages::Page::kOnContextUpdated:
            return "Receive contextual_tasks::mojom::Page::OnContextUpdated";
      case messages::Page::kHideInput:
            return "Receive contextual_tasks::mojom::Page::HideInput";
      case messages::Page::kRestoreInput:
            return "Receive contextual_tasks::mojom::Page::RestoreInput";
      case messages::Page::kOnZeroStateChange:
            return "Receive contextual_tasks::mojom::Page::OnZeroStateChange";
      case messages::Page::kOnAiPageStatusChanged:
            return "Receive contextual_tasks::mojom::Page::OnAiPageStatusChanged";
      case messages::Page::kOnLensOverlayStateChanged:
            return "Receive contextual_tasks::mojom::Page::OnLensOverlayStateChanged";
      case messages::Page::kShowErrorPage:
            return "Receive contextual_tasks::mojom::Page::ShowErrorPage";
      case messages::Page::kHideErrorPage:
            return "Receive contextual_tasks::mojom::Page::HideErrorPage";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSetThreadTitle:
            return "Receive reply contextual_tasks::mojom::Page::SetThreadTitle";
      case messages::Page::kSetTaskDetails:
            return "Receive reply contextual_tasks::mojom::Page::SetTaskDetails";
      case messages::Page::kOnSidePanelStateChanged:
            return "Receive reply contextual_tasks::mojom::Page::OnSidePanelStateChanged";
      case messages::Page::kPostMessageToWebview:
            return "Receive reply contextual_tasks::mojom::Page::PostMessageToWebview";
      case messages::Page::kOnHandshakeComplete:
            return "Receive reply contextual_tasks::mojom::Page::OnHandshakeComplete";
      case messages::Page::kSetOAuthToken:
            return "Receive reply contextual_tasks::mojom::Page::SetOAuthToken";
      case messages::Page::kOnContextUpdated:
            return "Receive reply contextual_tasks::mojom::Page::OnContextUpdated";
      case messages::Page::kHideInput:
            return "Receive reply contextual_tasks::mojom::Page::HideInput";
      case messages::Page::kRestoreInput:
            return "Receive reply contextual_tasks::mojom::Page::RestoreInput";
      case messages::Page::kOnZeroStateChange:
            return "Receive reply contextual_tasks::mojom::Page::OnZeroStateChange";
      case messages::Page::kOnAiPageStatusChanged:
            return "Receive reply contextual_tasks::mojom::Page::OnAiPageStatusChanged";
      case messages::Page::kOnLensOverlayStateChanged:
            return "Receive reply contextual_tasks::mojom::Page::OnLensOverlayStateChanged";
      case messages::Page::kShowErrorPage:
            return "Receive reply contextual_tasks::mojom::Page::ShowErrorPage";
      case messages::Page::kHideErrorPage:
            return "Receive reply contextual_tasks::mojom::Page::HideErrorPage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SetThreadTitle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11c5721c;  // IPCStableHash for contextual_tasks::mojom::Page::SetThreadTitle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetTaskDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e4aafbf;  // IPCStableHash for contextual_tasks::mojom::Page::SetTaskDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnSidePanelStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee9b6f87;  // IPCStableHash for contextual_tasks::mojom::Page::OnSidePanelStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::PostMessageToWebview_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1cc35430;  // IPCStableHash for contextual_tasks::mojom::Page::PostMessageToWebview
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnHandshakeComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc124e9a8;  // IPCStableHash for contextual_tasks::mojom::Page::OnHandshakeComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::SetOAuthToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac7c644b;  // IPCStableHash for contextual_tasks::mojom::Page::SetOAuthToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnContextUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5eff780;  // IPCStableHash for contextual_tasks::mojom::Page::OnContextUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::HideInput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9235964c;  // IPCStableHash for contextual_tasks::mojom::Page::HideInput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::RestoreInput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x37cab50a;  // IPCStableHash for contextual_tasks::mojom::Page::RestoreInput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnZeroStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x116b8f83;  // IPCStableHash for contextual_tasks::mojom::Page::OnZeroStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnAiPageStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf07f1ee5;  // IPCStableHash for contextual_tasks::mojom::Page::OnAiPageStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::OnLensOverlayStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3681823c;  // IPCStableHash for contextual_tasks::mojom::Page::OnLensOverlayStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ShowErrorPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88dca8f8;  // IPCStableHash for contextual_tasks::mojom::Page::ShowErrorPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::HideErrorPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76db7956;  // IPCStableHash for contextual_tasks::mojom::Page::HideErrorPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SetThreadTitle(
    const std::string& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::SetThreadTitle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetThreadTitle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_SetThreadTitle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in Page.SetThreadTitle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetThreadTitle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetTaskDetails(
    const ::base::Uuid& in_uuid, const std::string& in_thread_id, const std::string& in_turn_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::SetTaskDetails", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uuid"), in_uuid,
                        "<value of type const ::base::Uuid&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thread_id"), in_thread_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("turn_id"), in_turn_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetTaskDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_SetTaskDetails_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->uuid)::BaseType> uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_uuid,
    uuid_fragment);

  params->uuid.Set(
      uuid_fragment.is_null() ? nullptr : uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null uuid in Page.SetTaskDetails request");
  mojo::internal::MessageFragment<
      typename decltype(params->thread_id)::BaseType> thread_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_thread_id,
    thread_id_fragment);

  params->thread_id.Set(
      thread_id_fragment.is_null() ? nullptr : thread_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->thread_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null thread_id in Page.SetTaskDetails request");
  mojo::internal::MessageFragment<
      typename decltype(params->turn_id)::BaseType> turn_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_turn_id,
    turn_id_fragment);

  params->turn_id.Set(
      turn_id_fragment.is_null() ? nullptr : turn_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->turn_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null turn_id in Page.SetTaskDetails request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetTaskDetails");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnSidePanelStateChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::Page::OnSidePanelStateChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnSidePanelStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_OnSidePanelStateChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnSidePanelStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::PostMessageToWebview(
    const std::vector<uint8_t>& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::PostMessageToWebview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kPostMessageToWebview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_PostMessageToWebview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType>
      message_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_message,
    message_fragment,
    &message_validate_params);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Page.PostMessageToWebview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("PostMessageToWebview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnHandshakeComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::Page::OnHandshakeComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnHandshakeComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_OnHandshakeComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnHandshakeComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::SetOAuthToken(
    const std::string& in_oauth_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::SetOAuthToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("oauth_token"), in_oauth_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSetOAuthToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_SetOAuthToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->oauth_token)::BaseType> oauth_token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_oauth_token,
    oauth_token_fragment);

  params->oauth_token.Set(
      oauth_token_fragment.is_null() ? nullptr : oauth_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->oauth_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null oauth_token in Page.SetOAuthToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SetOAuthToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnContextUpdated(
    std::vector<TabPtr> in_context_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::OnContextUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_tabs"), in_context_tabs,
                        "<value of type std::vector<TabPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnContextUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_OnContextUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context_tabs)::BaseType>
      context_tabs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& context_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::contextual_tasks::mojom::TabDataView>>(
    in_context_tabs,
    context_tabs_fragment,
    &context_tabs_validate_params);

  params->context_tabs.Set(
      context_tabs_fragment.is_null() ? nullptr : context_tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->context_tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null context_tabs in Page.OnContextUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnContextUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::HideInput(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::Page::HideInput");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kHideInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_HideInput_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("HideInput");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::RestoreInput(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::Page::RestoreInput");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kRestoreInput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_RestoreInput_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("RestoreInput");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnZeroStateChange(
    bool in_is_zero_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::OnZeroStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_zero_state"), in_is_zero_state,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnZeroStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_OnZeroStateChange_Params_Data> params(
          message);
  params.Allocate();

  params->is_zero_state = in_is_zero_state;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnZeroStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnAiPageStatusChanged(
    bool in_is_ai_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::OnAiPageStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ai_page"), in_is_ai_page,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnAiPageStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_OnAiPageStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_ai_page = in_is_ai_page;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnAiPageStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::OnLensOverlayStateChanged(
    bool in_is_showing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::Page::OnLensOverlayStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_showing"), in_is_showing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnLensOverlayStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_OnLensOverlayStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_showing = in_is_showing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnLensOverlayStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ShowErrorPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::Page::ShowErrorPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kShowErrorPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_ShowErrorPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ShowErrorPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::HideErrorPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send contextual_tasks::mojom::Page::HideErrorPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kHideErrorPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::Page_HideErrorPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("HideErrorPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSetThreadTitle: {
      DCHECK(message->is_serialized());
      internal::Page_SetThreadTitle_Params_Data* params =
          reinterpret_cast<internal::Page_SetThreadTitle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      std::string p_title{};
      Page_SetThreadTitle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThreadTitle(        
        std::move(p_title));
      return true;
    }
    case messages::Page::kSetTaskDetails: {
      DCHECK(message->is_serialized());
      internal::Page_SetTaskDetails_Params_Data* params =
          reinterpret_cast<internal::Page_SetTaskDetails_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ::base::Uuid p_uuid{};
      std::string p_thread_id{};
      std::string p_turn_id{};
      Page_SetTaskDetails_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUuid(&p_uuid))
        success = false;
      if (success && !input_data_view.ReadThreadId(&p_thread_id))
        success = false;
      if (success && !input_data_view.ReadTurnId(&p_turn_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTaskDetails(        
        std::move(p_uuid), 
        std::move(p_thread_id), 
        std::move(p_turn_id));
      return true;
    }
    case messages::Page::kOnSidePanelStateChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnSidePanelStateChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnSidePanelStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      Page_OnSidePanelStateChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSidePanelStateChanged(        );
      return true;
    }
    case messages::Page::kPostMessageToWebview: {
      DCHECK(message->is_serialized());
      internal::Page_PostMessageToWebview_Params_Data* params =
          reinterpret_cast<internal::Page_PostMessageToWebview_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      std::vector<uint8_t> p_message{};
      Page_PostMessageToWebview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToWebview(        
        std::move(p_message));
      return true;
    }
    case messages::Page::kOnHandshakeComplete: {
      DCHECK(message->is_serialized());
      internal::Page_OnHandshakeComplete_Params_Data* params =
          reinterpret_cast<internal::Page_OnHandshakeComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      Page_OnHandshakeComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHandshakeComplete(        );
      return true;
    }
    case messages::Page::kSetOAuthToken: {
      DCHECK(message->is_serialized());
      internal::Page_SetOAuthToken_Params_Data* params =
          reinterpret_cast<internal::Page_SetOAuthToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.5
      bool success = true;
      std::string p_oauth_token{};
      Page_SetOAuthToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOauthToken(&p_oauth_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOAuthToken(        
        std::move(p_oauth_token));
      return true;
    }
    case messages::Page::kOnContextUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_OnContextUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_OnContextUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.6
      bool success = true;
      std::vector<TabPtr> p_context_tabs{};
      Page_OnContextUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContextTabs(&p_context_tabs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContextUpdated(        
        std::move(p_context_tabs));
      return true;
    }
    case messages::Page::kHideInput: {
      DCHECK(message->is_serialized());
      internal::Page_HideInput_Params_Data* params =
          reinterpret_cast<internal::Page_HideInput_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.7
      bool success = true;
      Page_HideInput_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideInput(        );
      return true;
    }
    case messages::Page::kRestoreInput: {
      DCHECK(message->is_serialized());
      internal::Page_RestoreInput_Params_Data* params =
          reinterpret_cast<internal::Page_RestoreInput_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.8
      bool success = true;
      Page_RestoreInput_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestoreInput(        );
      return true;
    }
    case messages::Page::kOnZeroStateChange: {
      DCHECK(message->is_serialized());
      internal::Page_OnZeroStateChange_Params_Data* params =
          reinterpret_cast<internal::Page_OnZeroStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.9
      bool success = true;
      bool p_is_zero_state{};
      Page_OnZeroStateChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_zero_state = input_data_view.is_zero_state();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnZeroStateChange(        
        std::move(p_is_zero_state));
      return true;
    }
    case messages::Page::kOnAiPageStatusChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnAiPageStatusChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnAiPageStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.10
      bool success = true;
      bool p_is_ai_page{};
      Page_OnAiPageStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_ai_page = input_data_view.is_ai_page();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAiPageStatusChanged(        
        std::move(p_is_ai_page));
      return true;
    }
    case messages::Page::kOnLensOverlayStateChanged: {
      DCHECK(message->is_serialized());
      internal::Page_OnLensOverlayStateChanged_Params_Data* params =
          reinterpret_cast<internal::Page_OnLensOverlayStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.11
      bool success = true;
      bool p_is_showing{};
      Page_OnLensOverlayStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_showing = input_data_view.is_showing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLensOverlayStateChanged(        
        std::move(p_is_showing));
      return true;
    }
    case messages::Page::kShowErrorPage: {
      DCHECK(message->is_serialized());
      internal::Page_ShowErrorPage_Params_Data* params =
          reinterpret_cast<internal::Page_ShowErrorPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.12
      bool success = true;
      Page_ShowErrorPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowErrorPage(        );
      return true;
    }
    case messages::Page::kHideErrorPage: {
      DCHECK(message->is_serialized());
      internal::Page_HideErrorPage_Params_Data* params =
          reinterpret_cast<internal::Page_HideErrorPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.13
      bool success = true;
      Page_HideErrorPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HideErrorPage(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSetThreadTitle: {
      break;
    }
    case messages::Page::kSetTaskDetails: {
      break;
    }
    case messages::Page::kOnSidePanelStateChanged: {
      break;
    }
    case messages::Page::kPostMessageToWebview: {
      break;
    }
    case messages::Page::kOnHandshakeComplete: {
      break;
    }
    case messages::Page::kSetOAuthToken: {
      break;
    }
    case messages::Page::kOnContextUpdated: {
      break;
    }
    case messages::Page::kHideInput: {
      break;
    }
    case messages::Page::kRestoreInput: {
      break;
    }
    case messages::Page::kOnZeroStateChange: {
      break;
    }
    case messages::Page::kOnAiPageStatusChanged: {
      break;
    }
    case messages::Page::kOnLensOverlayStateChanged: {
      break;
    }
    case messages::Page::kShowErrorPage: {
      break;
    }
    case messages::Page::kHideErrorPage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SetThreadTitle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetTaskDetails_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnSidePanelStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_PostMessageToWebview_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnHandshakeComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_SetOAuthToken_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnContextUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_HideInput_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_RestoreInput_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnZeroStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnAiPageStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_OnLensOverlayStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ShowErrorPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_HideErrorPage_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::contextual_tasks::mojom::Page::Name_,
    kPageValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive contextual_tasks::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply contextual_tasks::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0695ffc9;  // IPCStableHash for contextual_tasks::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_page_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send contextual_tasks::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_handler"), in_page_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::contextual_tasks::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::contextual_tasks::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::contextual_tasks::mojom::PageHandlerInterfaceBase>>(
    in_page_handler,
    &params->page_handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page_handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page_handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_page_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_page_handler =
            input_data_view.TakePageHandler<decltype(p_page_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_page_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::contextual_tasks::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}



}  // contextual_tasks::mojom


namespace mojo {


// static
bool StructTraits<::contextual_tasks::mojom::Tab::DataView, ::contextual_tasks::mojom::TabPtr>::Read(
    ::contextual_tasks::mojom::Tab::DataView input,
    ::contextual_tasks::mojom::TabPtr* output) {
  bool success = true;
  ::contextual_tasks::mojom::TabPtr result(::contextual_tasks::mojom::Tab::New());
  
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace contextual_tasks::mojom {


void PageHandlerInterceptorForTesting::GetThreadUrl(GetThreadUrlCallback callback) {
  GetForwardingInterface()->GetThreadUrl(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetUrlForTask(const ::base::Uuid& uuid, GetUrlForTaskCallback callback) {
  GetForwardingInterface()->GetUrlForTask(
    std::move(uuid)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::SetTaskId(const ::base::Uuid& uuid) {
  GetForwardingInterface()->SetTaskId(
    std::move(uuid)
    );
}
void PageHandlerInterceptorForTesting::IsZeroState(const ::GURL& url, IsZeroStateCallback callback) {
  GetForwardingInterface()->IsZeroState(
    std::move(url)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::SetThreadTitle(const std::string& title) {
  GetForwardingInterface()->SetThreadTitle(
    std::move(title)
    );
}
void PageHandlerInterceptorForTesting::CloseSidePanel() {
  GetForwardingInterface()->CloseSidePanel();
}
void PageHandlerInterceptorForTesting::ShowThreadHistory() {
  GetForwardingInterface()->ShowThreadHistory();
}
void PageHandlerInterceptorForTesting::IsShownInTab(IsShownInTabCallback callback) {
  GetForwardingInterface()->IsShownInTab(std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenMyActivityUi() {
  GetForwardingInterface()->OpenMyActivityUi();
}
void PageHandlerInterceptorForTesting::OpenHelpUi() {
  GetForwardingInterface()->OpenHelpUi();
}
void PageHandlerInterceptorForTesting::OpenOnboardingHelpUi() {
  GetForwardingInterface()->OpenOnboardingHelpUi();
}
void PageHandlerInterceptorForTesting::MoveTaskUiToNewTab() {
  GetForwardingInterface()->MoveTaskUiToNewTab();
}
void PageHandlerInterceptorForTesting::OnTabClickedFromSourcesMenu(int32_t tab_id, const ::GURL& url) {
  GetForwardingInterface()->OnTabClickedFromSourcesMenu(
    std::move(tab_id)
    , 
    std::move(url)
    );
}
void PageHandlerInterceptorForTesting::OnWebviewMessage(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->OnWebviewMessage(
    std::move(message)
    );
}
void PageHandlerInterceptorForTesting::GetCommonSearchParams(bool is_dark_mode, bool is_side_panel, GetCommonSearchParamsCallback callback) {
  GetForwardingInterface()->GetCommonSearchParams(
    std::move(is_dark_mode)
    , 
    std::move(is_side_panel)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::OnboardingTooltipDismissed() {
  GetForwardingInterface()->OnboardingTooltipDismissed();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetThreadUrl(
    ::GURL* out_url) {
  base::RunLoop loop;
  proxy_->GetThreadUrl(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             const ::GURL& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

::GURL PageHandlerAsyncWaiter::GetThreadUrl(
    ) {
  ::GURL async_wait_result;
  GetThreadUrl(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetUrlForTask(
    const ::base::Uuid& uuid, ::GURL* out_url) {
  base::RunLoop loop;
  proxy_->GetUrlForTask(
      std::move(uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             const ::GURL& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

::GURL PageHandlerAsyncWaiter::GetUrlForTask(
    const ::base::Uuid& uuid) {
  ::GURL async_wait_result;
  GetUrlForTask(std::move(uuid),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::IsZeroState(
    const ::GURL& url, bool* out_is_zero_state) {
  base::RunLoop loop;
  proxy_->IsZeroState(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_zero_state
,
             bool is_zero_state) {*out_is_zero_state = std::move(is_zero_state);
            loop->Quit();
          },
          &loop,
          out_is_zero_state));
  loop.Run();
}

bool PageHandlerAsyncWaiter::IsZeroState(
    const ::GURL& url) {
  bool async_wait_result;
  IsZeroState(std::move(url),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::IsShownInTab(
    bool* out_is_in_tab) {
  base::RunLoop loop;
  proxy_->IsShownInTab(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_in_tab
,
             bool is_in_tab) {*out_is_in_tab = std::move(is_in_tab);
            loop->Quit();
          },
          &loop,
          out_is_in_tab));
  loop.Run();
}

bool PageHandlerAsyncWaiter::IsShownInTab(
    ) {
  bool async_wait_result;
  IsShownInTab(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetCommonSearchParams(
    bool is_dark_mode, bool is_side_panel, base::flat_map<std::string, std::string>* out_params) {
  base::RunLoop loop;
  proxy_->GetCommonSearchParams(
      std::move(is_dark_mode),
      std::move(is_side_panel),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, std::string>* out_params
,
             const base::flat_map<std::string, std::string>& params) {*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_params));
  loop.Run();
}

base::flat_map<std::string, std::string> PageHandlerAsyncWaiter::GetCommonSearchParams(
    bool is_dark_mode, bool is_side_panel) {
  base::flat_map<std::string, std::string> async_wait_result;
  GetCommonSearchParams(std::move(is_dark_mode),std::move(is_side_panel),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::SetThreadTitle(const std::string& title) {
  GetForwardingInterface()->SetThreadTitle(
    std::move(title)
    );
}
void PageInterceptorForTesting::SetTaskDetails(const ::base::Uuid& uuid, const std::string& thread_id, const std::string& turn_id) {
  GetForwardingInterface()->SetTaskDetails(
    std::move(uuid)
    , 
    std::move(thread_id)
    , 
    std::move(turn_id)
    );
}
void PageInterceptorForTesting::OnSidePanelStateChanged() {
  GetForwardingInterface()->OnSidePanelStateChanged();
}
void PageInterceptorForTesting::PostMessageToWebview(const std::vector<uint8_t>& message) {
  GetForwardingInterface()->PostMessageToWebview(
    std::move(message)
    );
}
void PageInterceptorForTesting::OnHandshakeComplete() {
  GetForwardingInterface()->OnHandshakeComplete();
}
void PageInterceptorForTesting::SetOAuthToken(const std::string& oauth_token) {
  GetForwardingInterface()->SetOAuthToken(
    std::move(oauth_token)
    );
}
void PageInterceptorForTesting::OnContextUpdated(std::vector<TabPtr> context_tabs) {
  GetForwardingInterface()->OnContextUpdated(
    std::move(context_tabs)
    );
}
void PageInterceptorForTesting::HideInput() {
  GetForwardingInterface()->HideInput();
}
void PageInterceptorForTesting::RestoreInput() {
  GetForwardingInterface()->RestoreInput();
}
void PageInterceptorForTesting::OnZeroStateChange(bool is_zero_state) {
  GetForwardingInterface()->OnZeroStateChange(
    std::move(is_zero_state)
    );
}
void PageInterceptorForTesting::OnAiPageStatusChanged(bool is_ai_page) {
  GetForwardingInterface()->OnAiPageStatusChanged(
    std::move(is_ai_page)
    );
}
void PageInterceptorForTesting::OnLensOverlayStateChanged(bool is_showing) {
  GetForwardingInterface()->OnLensOverlayStateChanged(
    std::move(is_showing)
    );
}
void PageInterceptorForTesting::ShowErrorPage() {
  GetForwardingInterface()->ShowErrorPage();
}
void PageInterceptorForTesting::HideErrorPage() {
  GetForwardingInterface()->HideErrorPage();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;





void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> page_handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(page_handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;







}  // contextual_tasks::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif