// chrome/browser/contextual_tasks/contextual_tasks.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UuidSpec as mojoBase_mojom_UuidSpec,
  Uuid as mojoBase_mojom_Uuid
} from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'contextual_tasks.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getThreadUrl(): Promise<{
        url: url_mojom_Url, }>;
  getUrlForTask(uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url, }>;
  setTaskId(uuid: mojoBase_mojom_Uuid): void;
  isZeroState(url: url_mojom_Url): Promise<{
        isZeroState: boolean, }>;
  setThreadTitle(title: string): void;
  closeSidePanel(): void;
  showThreadHistory(): void;
  isShownInTab(): Promise<{
        isInTab: boolean, }>;
  openMyActivityUi(): void;
  openHelpUi(): void;
  openOnboardingHelpUi(): void;
  moveTaskUiToNewTab(): void;
  onTabClickedFromSourcesMenu(tabId: number, url: url_mojom_Url): void;
  onWebviewMessage(message: number[]): void;
  getCommonSearchParams(isDarkMode: boolean, isSidePanel: boolean): Promise<{
        params: {[key: string]: string}, }>;
  onboardingTooltipDismissed(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getThreadUrl(): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetThreadUrl_ParamsSpec.$,
        PageHandler_GetThreadUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getUrlForTask(
      uuid: mojoBase_mojom_Uuid): Promise<{
        url: url_mojom_Url, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetUrlForTask_ParamsSpec.$,
        PageHandler_GetUrlForTask_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  setTaskId(
      uuid: mojoBase_mojom_Uuid): void {
    this.proxy.sendMessage(
        2,
        PageHandler_SetTaskId_ParamsSpec.$,
        null,
        [
          uuid
        ],
        false);
  }

  isZeroState(
      url: url_mojom_Url): Promise<{
        isZeroState: boolean, }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_IsZeroState_ParamsSpec.$,
        PageHandler_IsZeroState_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  setThreadTitle(
      title: string): void {
    this.proxy.sendMessage(
        4,
        PageHandler_SetThreadTitle_ParamsSpec.$,
        null,
        [
          title
        ],
        false);
  }

  closeSidePanel(): void {
    this.proxy.sendMessage(
        5,
        PageHandler_CloseSidePanel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  showThreadHistory(): void {
    this.proxy.sendMessage(
        6,
        PageHandler_ShowThreadHistory_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  isShownInTab(): Promise<{
        isInTab: boolean, }> {
    return this.proxy.sendMessage(
        7,
        PageHandler_IsShownInTab_ParamsSpec.$,
        PageHandler_IsShownInTab_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  openMyActivityUi(): void {
    this.proxy.sendMessage(
        8,
        PageHandler_OpenMyActivityUi_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openHelpUi(): void {
    this.proxy.sendMessage(
        9,
        PageHandler_OpenHelpUi_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openOnboardingHelpUi(): void {
    this.proxy.sendMessage(
        10,
        PageHandler_OpenOnboardingHelpUi_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  moveTaskUiToNewTab(): void {
    this.proxy.sendMessage(
        11,
        PageHandler_MoveTaskUiToNewTab_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onTabClickedFromSourcesMenu(
      tabId: number,
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        12,
        PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$,
        null,
        [
          tabId,
          url
        ],
        false);
  }

  onWebviewMessage(
      message: number[]): void {
    this.proxy.sendMessage(
        13,
        PageHandler_OnWebviewMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  getCommonSearchParams(
      isDarkMode: boolean,
      isSidePanel: boolean): Promise<{
        params: {[key: string]: string}, }> {
    return this.proxy.sendMessage(
        14,
        PageHandler_GetCommonSearchParams_ParamsSpec.$,
        PageHandler_GetCommonSearchParams_ResponseParamsSpec.$,
        [
          isDarkMode,
          isSidePanel
        ],
        false);
  }

  onboardingTooltipDismissed(): void {
    this.proxy.sendMessage(
        15,
        PageHandler_OnboardingTooltipDismissed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetThreadUrl_ParamsSpec.$,
        PageHandler_GetThreadUrl_ResponseParamsSpec.$,
        impl.getThreadUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetUrlForTask_ParamsSpec.$,
        PageHandler_GetUrlForTask_ResponseParamsSpec.$,
        impl.getUrlForTask.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_SetTaskId_ParamsSpec.$,
        null,
        impl.setTaskId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_IsZeroState_ParamsSpec.$,
        PageHandler_IsZeroState_ResponseParamsSpec.$,
        impl.isZeroState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_SetThreadTitle_ParamsSpec.$,
        null,
        impl.setThreadTitle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_CloseSidePanel_ParamsSpec.$,
        null,
        impl.closeSidePanel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_ShowThreadHistory_ParamsSpec.$,
        null,
        impl.showThreadHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_IsShownInTab_ParamsSpec.$,
        PageHandler_IsShownInTab_ResponseParamsSpec.$,
        impl.isShownInTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_OpenMyActivityUi_ParamsSpec.$,
        null,
        impl.openMyActivityUi.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_OpenHelpUi_ParamsSpec.$,
        null,
        impl.openHelpUi.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_OpenOnboardingHelpUi_ParamsSpec.$,
        null,
        impl.openOnboardingHelpUi.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_MoveTaskUiToNewTab_ParamsSpec.$,
        null,
        impl.moveTaskUiToNewTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$,
        null,
        impl.onTabClickedFromSourcesMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_OnWebviewMessage_ParamsSpec.$,
        null,
        impl.onWebviewMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_GetCommonSearchParams_ParamsSpec.$,
        PageHandler_GetCommonSearchParams_ResponseParamsSpec.$,
        impl.getCommonSearchParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_OnboardingTooltipDismissed_ParamsSpec.$,
        null,
        impl.onboardingTooltipDismissed.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "contextual_tasks.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getThreadUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUrlForTask: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTaskId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isZeroState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setThreadTitle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeSidePanel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showThreadHistory: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isShownInTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openMyActivityUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openHelpUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openOnboardingHelpUi: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  moveTaskUiToNewTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onTabClickedFromSourcesMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onWebviewMessage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getCommonSearchParams: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onboardingTooltipDismissed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getThreadUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetThreadUrl_ParamsSpec.$,
        PageHandler_GetThreadUrl_ResponseParamsSpec.$,
        this.getThreadUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getUrlForTask =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetUrlForTask_ParamsSpec.$,
        PageHandler_GetUrlForTask_ResponseParamsSpec.$,
        this.getUrlForTask.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setTaskId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_SetTaskId_ParamsSpec.$,
        null,
        this.setTaskId.createReceiverHandler(false /* expectsResponse */),
        false);
    this.isZeroState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_IsZeroState_ParamsSpec.$,
        PageHandler_IsZeroState_ResponseParamsSpec.$,
        this.isZeroState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setThreadTitle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_SetThreadTitle_ParamsSpec.$,
        null,
        this.setThreadTitle.createReceiverHandler(false /* expectsResponse */),
        false);
    this.closeSidePanel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_CloseSidePanel_ParamsSpec.$,
        null,
        this.closeSidePanel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showThreadHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_ShowThreadHistory_ParamsSpec.$,
        null,
        this.showThreadHistory.createReceiverHandler(false /* expectsResponse */),
        false);
    this.isShownInTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_IsShownInTab_ParamsSpec.$,
        PageHandler_IsShownInTab_ResponseParamsSpec.$,
        this.isShownInTab.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openMyActivityUi =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_OpenMyActivityUi_ParamsSpec.$,
        null,
        this.openMyActivityUi.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openHelpUi =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_OpenHelpUi_ParamsSpec.$,
        null,
        this.openHelpUi.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openOnboardingHelpUi =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_OpenOnboardingHelpUi_ParamsSpec.$,
        null,
        this.openOnboardingHelpUi.createReceiverHandler(false /* expectsResponse */),
        false);
    this.moveTaskUiToNewTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_MoveTaskUiToNewTab_ParamsSpec.$,
        null,
        this.moveTaskUiToNewTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onTabClickedFromSourcesMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$,
        null,
        this.onTabClickedFromSourcesMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onWebviewMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_OnWebviewMessage_ParamsSpec.$,
        null,
        this.onWebviewMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getCommonSearchParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_GetCommonSearchParams_ParamsSpec.$,
        PageHandler_GetCommonSearchParams_ResponseParamsSpec.$,
        this.getCommonSearchParams.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onboardingTooltipDismissed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_OnboardingTooltipDismissed_ParamsSpec.$,
        null,
        this.onboardingTooltipDismissed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'contextual_tasks.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  setThreadTitle(title: string): void;
  setTaskDetails(uuid: mojoBase_mojom_Uuid, threadId: string, turnId: string): void;
  onSidePanelStateChanged(): void;
  postMessageToWebview(message: number[]): void;
  onHandshakeComplete(): void;
  setOAuthToken(oauthToken: string): void;
  onContextUpdated(contextTabs: Tab[]): void;
  hideInput(): void;
  restoreInput(): void;
  onZeroStateChange(isZeroState: boolean): void;
  onAiPageStatusChanged(isAiPage: boolean): void;
  onLensOverlayStateChanged(isShowing: boolean): void;
  showErrorPage(): void;
  hideErrorPage(): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setThreadTitle(
      title: string): void {
    this.proxy.sendMessage(
        0,
        Page_SetThreadTitle_ParamsSpec.$,
        null,
        [
          title
        ],
        false);
  }

  setTaskDetails(
      uuid: mojoBase_mojom_Uuid,
      threadId: string,
      turnId: string): void {
    this.proxy.sendMessage(
        1,
        Page_SetTaskDetails_ParamsSpec.$,
        null,
        [
          uuid,
          threadId,
          turnId
        ],
        false);
  }

  onSidePanelStateChanged(): void {
    this.proxy.sendMessage(
        2,
        Page_OnSidePanelStateChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  postMessageToWebview(
      message: number[]): void {
    this.proxy.sendMessage(
        3,
        Page_PostMessageToWebview_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  onHandshakeComplete(): void {
    this.proxy.sendMessage(
        4,
        Page_OnHandshakeComplete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setOAuthToken(
      oauthToken: string): void {
    this.proxy.sendMessage(
        5,
        Page_SetOAuthToken_ParamsSpec.$,
        null,
        [
          oauthToken
        ],
        false);
  }

  onContextUpdated(
      contextTabs: Tab[]): void {
    this.proxy.sendMessage(
        6,
        Page_OnContextUpdated_ParamsSpec.$,
        null,
        [
          contextTabs
        ],
        false);
  }

  hideInput(): void {
    this.proxy.sendMessage(
        7,
        Page_HideInput_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  restoreInput(): void {
    this.proxy.sendMessage(
        8,
        Page_RestoreInput_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onZeroStateChange(
      isZeroState: boolean): void {
    this.proxy.sendMessage(
        9,
        Page_OnZeroStateChange_ParamsSpec.$,
        null,
        [
          isZeroState
        ],
        false);
  }

  onAiPageStatusChanged(
      isAiPage: boolean): void {
    this.proxy.sendMessage(
        10,
        Page_OnAiPageStatusChanged_ParamsSpec.$,
        null,
        [
          isAiPage
        ],
        false);
  }

  onLensOverlayStateChanged(
      isShowing: boolean): void {
    this.proxy.sendMessage(
        11,
        Page_OnLensOverlayStateChanged_ParamsSpec.$,
        null,
        [
          isShowing
        ],
        false);
  }

  showErrorPage(): void {
    this.proxy.sendMessage(
        12,
        Page_ShowErrorPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  hideErrorPage(): void {
    this.proxy.sendMessage(
        13,
        Page_HideErrorPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_SetThreadTitle_ParamsSpec.$,
        null,
        impl.setThreadTitle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_SetTaskDetails_ParamsSpec.$,
        null,
        impl.setTaskDetails.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OnSidePanelStateChanged_ParamsSpec.$,
        null,
        impl.onSidePanelStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_PostMessageToWebview_ParamsSpec.$,
        null,
        impl.postMessageToWebview.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Page_OnHandshakeComplete_ParamsSpec.$,
        null,
        impl.onHandshakeComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Page_SetOAuthToken_ParamsSpec.$,
        null,
        impl.setOAuthToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Page_OnContextUpdated_ParamsSpec.$,
        null,
        impl.onContextUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Page_HideInput_ParamsSpec.$,
        null,
        impl.hideInput.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Page_RestoreInput_ParamsSpec.$,
        null,
        impl.restoreInput.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Page_OnZeroStateChange_ParamsSpec.$,
        null,
        impl.onZeroStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Page_OnAiPageStatusChanged_ParamsSpec.$,
        null,
        impl.onAiPageStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        Page_OnLensOverlayStateChanged_ParamsSpec.$,
        null,
        impl.onLensOverlayStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        Page_ShowErrorPage_ParamsSpec.$,
        null,
        impl.showErrorPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        Page_HideErrorPage_ParamsSpec.$,
        null,
        impl.hideErrorPage.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "contextual_tasks.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setThreadTitle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTaskDetails: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onSidePanelStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  postMessageToWebview: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onHandshakeComplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setOAuthToken: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onContextUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hideInput: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restoreInput: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onZeroStateChange: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onAiPageStatusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onLensOverlayStateChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showErrorPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hideErrorPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setThreadTitle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_SetThreadTitle_ParamsSpec.$,
        null,
        this.setThreadTitle.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setTaskDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_SetTaskDetails_ParamsSpec.$,
        null,
        this.setTaskDetails.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onSidePanelStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OnSidePanelStateChanged_ParamsSpec.$,
        null,
        this.onSidePanelStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.postMessageToWebview =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_PostMessageToWebview_ParamsSpec.$,
        null,
        this.postMessageToWebview.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onHandshakeComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Page_OnHandshakeComplete_ParamsSpec.$,
        null,
        this.onHandshakeComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setOAuthToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Page_SetOAuthToken_ParamsSpec.$,
        null,
        this.setOAuthToken.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onContextUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Page_OnContextUpdated_ParamsSpec.$,
        null,
        this.onContextUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hideInput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Page_HideInput_ParamsSpec.$,
        null,
        this.hideInput.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restoreInput =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Page_RestoreInput_ParamsSpec.$,
        null,
        this.restoreInput.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onZeroStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Page_OnZeroStateChange_ParamsSpec.$,
        null,
        this.onZeroStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onAiPageStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Page_OnAiPageStatusChanged_ParamsSpec.$,
        null,
        this.onAiPageStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onLensOverlayStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        Page_OnLensOverlayStateChanged_ParamsSpec.$,
        null,
        this.onLensOverlayStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showErrorPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        Page_ShowErrorPage_ParamsSpec.$,
        null,
        this.showErrorPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hideErrorPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        Page_HideErrorPage_ParamsSpec.$,
        null,
        this.hideErrorPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'contextual_tasks.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, pageHandler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      pageHandler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          pageHandler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "contextual_tasks.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TabSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetThreadUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetThreadUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetUrlForTask_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetUrlForTask_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetTaskId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsZeroState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsZeroState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetThreadTitle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_CloseSidePanel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowThreadHistory_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsShownInTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsShownInTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenMyActivityUi_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenHelpUi_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenOnboardingHelpUi_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_MoveTaskUiToNewTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnWebviewMessage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetCommonSearchParams_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetCommonSearchParams_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnboardingTooltipDismissed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetThreadTitle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetTaskDetails_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnSidePanelStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_PostMessageToWebview_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnHandshakeComplete_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetOAuthToken_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnContextUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_HideInput_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_RestoreInput_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnZeroStateChange_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnAiPageStatusChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnLensOverlayStateChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ShowErrorPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_HideErrorPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TabMojoType {
  tabId: number;
  title: string;
  url: url_mojom_Url;
}


export type Tab = TabMojoType;
mojo.internal.Struct<TabMojoType>(
    TabSpec.$,
    'Tab',
    [
      mojo.internal.StructField<TabMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabMojoType, url_mojom_Url>(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_GetThreadUrl_ParamsMojoType {
}


export type PageHandler_GetThreadUrl_Params = PageHandler_GetThreadUrl_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetThreadUrl_ParamsMojoType>(
    PageHandler_GetThreadUrl_ParamsSpec.$,
    'PageHandler_GetThreadUrl_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetThreadUrl_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_GetThreadUrl_ResponseParams = PageHandler_GetThreadUrl_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetThreadUrl_ResponseParamsMojoType>(
    PageHandler_GetThreadUrl_ResponseParamsSpec.$,
    'PageHandler_GetThreadUrl_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetThreadUrl_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetUrlForTask_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type PageHandler_GetUrlForTask_Params = PageHandler_GetUrlForTask_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetUrlForTask_ParamsMojoType>(
    PageHandler_GetUrlForTask_ParamsSpec.$,
    'PageHandler_GetUrlForTask_Params',
    [
      mojo.internal.StructField<PageHandler_GetUrlForTask_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetUrlForTask_ResponseParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_GetUrlForTask_ResponseParams = PageHandler_GetUrlForTask_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetUrlForTask_ResponseParamsMojoType>(
    PageHandler_GetUrlForTask_ResponseParamsSpec.$,
    'PageHandler_GetUrlForTask_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetUrlForTask_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetTaskId_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type PageHandler_SetTaskId_Params = PageHandler_SetTaskId_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetTaskId_ParamsMojoType>(
    PageHandler_SetTaskId_ParamsSpec.$,
    'PageHandler_SetTaskId_Params',
    [
      mojo.internal.StructField<PageHandler_SetTaskId_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_IsZeroState_ParamsMojoType {
  url: url_mojom_Url;
}


export type PageHandler_IsZeroState_Params = PageHandler_IsZeroState_ParamsMojoType;
mojo.internal.Struct<PageHandler_IsZeroState_ParamsMojoType>(
    PageHandler_IsZeroState_ParamsSpec.$,
    'PageHandler_IsZeroState_Params',
    [
      mojo.internal.StructField<PageHandler_IsZeroState_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_IsZeroState_ResponseParamsMojoType {
  isZeroState: boolean;
}


export type PageHandler_IsZeroState_ResponseParams = PageHandler_IsZeroState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_IsZeroState_ResponseParamsMojoType>(
    PageHandler_IsZeroState_ResponseParamsSpec.$,
    'PageHandler_IsZeroState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_IsZeroState_ResponseParamsMojoType, boolean>(
        'isZeroState', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetThreadTitle_ParamsMojoType {
  title: string;
}


export type PageHandler_SetThreadTitle_Params = PageHandler_SetThreadTitle_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetThreadTitle_ParamsMojoType>(
    PageHandler_SetThreadTitle_ParamsSpec.$,
    'PageHandler_SetThreadTitle_Params',
    [
      mojo.internal.StructField<PageHandler_SetThreadTitle_ParamsMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_CloseSidePanel_ParamsMojoType {
}


export type PageHandler_CloseSidePanel_Params = PageHandler_CloseSidePanel_ParamsMojoType;
mojo.internal.Struct<PageHandler_CloseSidePanel_ParamsMojoType>(
    PageHandler_CloseSidePanel_ParamsSpec.$,
    'PageHandler_CloseSidePanel_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ShowThreadHistory_ParamsMojoType {
}


export type PageHandler_ShowThreadHistory_Params = PageHandler_ShowThreadHistory_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowThreadHistory_ParamsMojoType>(
    PageHandler_ShowThreadHistory_ParamsSpec.$,
    'PageHandler_ShowThreadHistory_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_IsShownInTab_ParamsMojoType {
}


export type PageHandler_IsShownInTab_Params = PageHandler_IsShownInTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_IsShownInTab_ParamsMojoType>(
    PageHandler_IsShownInTab_ParamsSpec.$,
    'PageHandler_IsShownInTab_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_IsShownInTab_ResponseParamsMojoType {
  isInTab: boolean;
}


export type PageHandler_IsShownInTab_ResponseParams = PageHandler_IsShownInTab_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_IsShownInTab_ResponseParamsMojoType>(
    PageHandler_IsShownInTab_ResponseParamsSpec.$,
    'PageHandler_IsShownInTab_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_IsShownInTab_ResponseParamsMojoType, boolean>(
        'isInTab', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenMyActivityUi_ParamsMojoType {
}


export type PageHandler_OpenMyActivityUi_Params = PageHandler_OpenMyActivityUi_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenMyActivityUi_ParamsMojoType>(
    PageHandler_OpenMyActivityUi_ParamsSpec.$,
    'PageHandler_OpenMyActivityUi_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenHelpUi_ParamsMojoType {
}


export type PageHandler_OpenHelpUi_Params = PageHandler_OpenHelpUi_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenHelpUi_ParamsMojoType>(
    PageHandler_OpenHelpUi_ParamsSpec.$,
    'PageHandler_OpenHelpUi_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenOnboardingHelpUi_ParamsMojoType {
}


export type PageHandler_OpenOnboardingHelpUi_Params = PageHandler_OpenOnboardingHelpUi_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenOnboardingHelpUi_ParamsMojoType>(
    PageHandler_OpenOnboardingHelpUi_ParamsSpec.$,
    'PageHandler_OpenOnboardingHelpUi_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_MoveTaskUiToNewTab_ParamsMojoType {
}


export type PageHandler_MoveTaskUiToNewTab_Params = PageHandler_MoveTaskUiToNewTab_ParamsMojoType;
mojo.internal.Struct<PageHandler_MoveTaskUiToNewTab_ParamsMojoType>(
    PageHandler_MoveTaskUiToNewTab_ParamsSpec.$,
    'PageHandler_MoveTaskUiToNewTab_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType {
  tabId: number;
  url: url_mojom_Url;
}


export type PageHandler_OnTabClickedFromSourcesMenu_Params = PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType>(
    PageHandler_OnTabClickedFromSourcesMenu_ParamsSpec.$,
    'PageHandler_OnTabClickedFromSourcesMenu_Params',
    [
      mojo.internal.StructField<PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType, number>(
        'tabId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnTabClickedFromSourcesMenu_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_OnWebviewMessage_ParamsMojoType {
  message: number[];
}


export type PageHandler_OnWebviewMessage_Params = PageHandler_OnWebviewMessage_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnWebviewMessage_ParamsMojoType>(
    PageHandler_OnWebviewMessage_ParamsSpec.$,
    'PageHandler_OnWebviewMessage_Params',
    [
      mojo.internal.StructField<PageHandler_OnWebviewMessage_ParamsMojoType, number[]>(
        'message', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetCommonSearchParams_ParamsMojoType {
  isDarkMode: boolean;
  isSidePanel: boolean;
}


export type PageHandler_GetCommonSearchParams_Params = PageHandler_GetCommonSearchParams_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetCommonSearchParams_ParamsMojoType>(
    PageHandler_GetCommonSearchParams_ParamsSpec.$,
    'PageHandler_GetCommonSearchParams_Params',
    [
      mojo.internal.StructField<PageHandler_GetCommonSearchParams_ParamsMojoType, boolean>(
        'isDarkMode', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetCommonSearchParams_ParamsMojoType, boolean>(
        'isSidePanel', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetCommonSearchParams_ResponseParamsMojoType {
  params: {[key: string]: string};
}


export type PageHandler_GetCommonSearchParams_ResponseParams = PageHandler_GetCommonSearchParams_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetCommonSearchParams_ResponseParamsMojoType>(
    PageHandler_GetCommonSearchParams_ResponseParamsSpec.$,
    'PageHandler_GetCommonSearchParams_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetCommonSearchParams_ResponseParamsMojoType, {[key: string]: string}>(
        'params', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnboardingTooltipDismissed_ParamsMojoType {
}


export type PageHandler_OnboardingTooltipDismissed_Params = PageHandler_OnboardingTooltipDismissed_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnboardingTooltipDismissed_ParamsMojoType>(
    PageHandler_OnboardingTooltipDismissed_ParamsSpec.$,
    'PageHandler_OnboardingTooltipDismissed_Params',
    [
    ],
    [[0, 8],]);





export interface Page_SetThreadTitle_ParamsMojoType {
  title: string;
}


export type Page_SetThreadTitle_Params = Page_SetThreadTitle_ParamsMojoType;
mojo.internal.Struct<Page_SetThreadTitle_ParamsMojoType>(
    Page_SetThreadTitle_ParamsSpec.$,
    'Page_SetThreadTitle_Params',
    [
      mojo.internal.StructField<Page_SetThreadTitle_ParamsMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SetTaskDetails_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
  threadId: string;
  turnId: string;
}


export type Page_SetTaskDetails_Params = Page_SetTaskDetails_ParamsMojoType;
mojo.internal.Struct<Page_SetTaskDetails_ParamsMojoType>(
    Page_SetTaskDetails_ParamsSpec.$,
    'Page_SetTaskDetails_Params',
    [
      mojo.internal.StructField<Page_SetTaskDetails_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_SetTaskDetails_ParamsMojoType, string>(
        'threadId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_SetTaskDetails_ParamsMojoType, string>(
        'turnId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface Page_OnSidePanelStateChanged_ParamsMojoType {
}


export type Page_OnSidePanelStateChanged_Params = Page_OnSidePanelStateChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnSidePanelStateChanged_ParamsMojoType>(
    Page_OnSidePanelStateChanged_ParamsSpec.$,
    'Page_OnSidePanelStateChanged_Params',
    [
    ],
    [[0, 8],]);





export interface Page_PostMessageToWebview_ParamsMojoType {
  message: number[];
}


export type Page_PostMessageToWebview_Params = Page_PostMessageToWebview_ParamsMojoType;
mojo.internal.Struct<Page_PostMessageToWebview_ParamsMojoType>(
    Page_PostMessageToWebview_ParamsSpec.$,
    'Page_PostMessageToWebview_Params',
    [
      mojo.internal.StructField<Page_PostMessageToWebview_ParamsMojoType, number[]>(
        'message', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnHandshakeComplete_ParamsMojoType {
}


export type Page_OnHandshakeComplete_Params = Page_OnHandshakeComplete_ParamsMojoType;
mojo.internal.Struct<Page_OnHandshakeComplete_ParamsMojoType>(
    Page_OnHandshakeComplete_ParamsSpec.$,
    'Page_OnHandshakeComplete_Params',
    [
    ],
    [[0, 8],]);





export interface Page_SetOAuthToken_ParamsMojoType {
  oauthToken: string;
}


export type Page_SetOAuthToken_Params = Page_SetOAuthToken_ParamsMojoType;
mojo.internal.Struct<Page_SetOAuthToken_ParamsMojoType>(
    Page_SetOAuthToken_ParamsSpec.$,
    'Page_SetOAuthToken_Params',
    [
      mojo.internal.StructField<Page_SetOAuthToken_ParamsMojoType, string>(
        'oauthToken', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnContextUpdated_ParamsMojoType {
  contextTabs: Tab[];
}


export type Page_OnContextUpdated_Params = Page_OnContextUpdated_ParamsMojoType;
mojo.internal.Struct<Page_OnContextUpdated_ParamsMojoType>(
    Page_OnContextUpdated_ParamsSpec.$,
    'Page_OnContextUpdated_Params',
    [
      mojo.internal.StructField<Page_OnContextUpdated_ParamsMojoType, Tab[]>(
        'contextTabs', 0,
        0,
        mojo.internal.Array(TabSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_HideInput_ParamsMojoType {
}


export type Page_HideInput_Params = Page_HideInput_ParamsMojoType;
mojo.internal.Struct<Page_HideInput_ParamsMojoType>(
    Page_HideInput_ParamsSpec.$,
    'Page_HideInput_Params',
    [
    ],
    [[0, 8],]);





export interface Page_RestoreInput_ParamsMojoType {
}


export type Page_RestoreInput_Params = Page_RestoreInput_ParamsMojoType;
mojo.internal.Struct<Page_RestoreInput_ParamsMojoType>(
    Page_RestoreInput_ParamsSpec.$,
    'Page_RestoreInput_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnZeroStateChange_ParamsMojoType {
  isZeroState: boolean;
}


export type Page_OnZeroStateChange_Params = Page_OnZeroStateChange_ParamsMojoType;
mojo.internal.Struct<Page_OnZeroStateChange_ParamsMojoType>(
    Page_OnZeroStateChange_ParamsSpec.$,
    'Page_OnZeroStateChange_Params',
    [
      mojo.internal.StructField<Page_OnZeroStateChange_ParamsMojoType, boolean>(
        'isZeroState', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnAiPageStatusChanged_ParamsMojoType {
  isAiPage: boolean;
}


export type Page_OnAiPageStatusChanged_Params = Page_OnAiPageStatusChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnAiPageStatusChanged_ParamsMojoType>(
    Page_OnAiPageStatusChanged_ParamsSpec.$,
    'Page_OnAiPageStatusChanged_Params',
    [
      mojo.internal.StructField<Page_OnAiPageStatusChanged_ParamsMojoType, boolean>(
        'isAiPage', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnLensOverlayStateChanged_ParamsMojoType {
  isShowing: boolean;
}


export type Page_OnLensOverlayStateChanged_Params = Page_OnLensOverlayStateChanged_ParamsMojoType;
mojo.internal.Struct<Page_OnLensOverlayStateChanged_ParamsMojoType>(
    Page_OnLensOverlayStateChanged_ParamsSpec.$,
    'Page_OnLensOverlayStateChanged_Params',
    [
      mojo.internal.StructField<Page_OnLensOverlayStateChanged_ParamsMojoType, boolean>(
        'isShowing', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ShowErrorPage_ParamsMojoType {
}


export type Page_ShowErrorPage_Params = Page_ShowErrorPage_ParamsMojoType;
mojo.internal.Struct<Page_ShowErrorPage_ParamsMojoType>(
    Page_ShowErrorPage_ParamsSpec.$,
    'Page_ShowErrorPage_Params',
    [
    ],
    [[0, 8],]);





export interface Page_HideErrorPage_ParamsMojoType {
}


export type Page_HideErrorPage_Params = Page_HideErrorPage_ParamsMojoType;
mojo.internal.Struct<Page_HideErrorPage_ParamsMojoType>(
    Page_HideErrorPage_ParamsSpec.$,
    'Page_HideErrorPage_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  pageHandler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'pageHandler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



