// chrome/browser/contextual_tasks/contextual_tasks.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_TEST_UTILS_H_

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom.h"


namespace contextual_tasks::mojom {


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetThreadUrl(GetThreadUrlCallback callback) override;
  void GetUrlForTask(const ::base::Uuid& uuid, GetUrlForTaskCallback callback) override;
  void SetTaskId(const ::base::Uuid& uuid) override;
  void IsZeroState(const ::GURL& url, IsZeroStateCallback callback) override;
  void SetThreadTitle(const std::string& title) override;
  void CloseSidePanel() override;
  void ShowThreadHistory() override;
  void IsShownInTab(IsShownInTabCallback callback) override;
  void OpenMyActivityUi() override;
  void OpenHelpUi() override;
  void OpenOnboardingHelpUi() override;
  void MoveTaskUiToNewTab() override;
  void OnTabClickedFromSourcesMenu(int32_t tab_id, const ::GURL& url) override;
  void OnWebviewMessage(const std::vector<uint8_t>& message) override;
  void GetCommonSearchParams(bool is_dark_mode, bool is_side_panel, GetCommonSearchParamsCallback callback) override;
  void OnboardingTooltipDismissed() override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetThreadUrl(
      ::GURL* out_url);
  ::GURL GetThreadUrl();
  void GetUrlForTask(
      const ::base::Uuid& uuid, ::GURL* out_url);
  ::GURL GetUrlForTask(const ::base::Uuid& uuid);
  void IsZeroState(
      const ::GURL& url, bool* out_is_zero_state);
  bool IsZeroState(const ::GURL& url);
  void IsShownInTab(
      bool* out_is_in_tab);
  bool IsShownInTab();
  void GetCommonSearchParams(
      bool is_dark_mode, bool is_side_panel, base::flat_map<std::string, std::string>* out_params);
  base::flat_map<std::string, std::string> GetCommonSearchParams(bool is_dark_mode, bool is_side_panel);

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void SetThreadTitle(const std::string& title) override;
  void SetTaskDetails(const ::base::Uuid& uuid, const std::string& thread_id, const std::string& turn_id) override;
  void OnSidePanelStateChanged() override;
  void PostMessageToWebview(const std::vector<uint8_t>& message) override;
  void OnHandshakeComplete() override;
  void SetOAuthToken(const std::string& oauth_token) override;
  void OnContextUpdated(std::vector<TabPtr> context_tabs) override;
  void HideInput() override;
  void RestoreInput() override;
  void OnZeroStateChange(bool is_zero_state) override;
  void OnAiPageStatusChanged(bool is_ai_page) override;
  void OnLensOverlayStateChanged(bool is_showing) override;
  void ShowErrorPage() override;
  void HideErrorPage() override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> page_handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};




}  // contextual_tasks::mojom

#endif  // CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_TEST_UTILS_H_