// chrome/browser/contextual_tasks/contextual_tasks.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-params-data.h"
namespace contextual_tasks {
namespace mojom {

namespace internal {


// static
bool Tab_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Tab_Data* object =
      static_cast<const Tab_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

Tab_Data::Tab_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetThreadUrl_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetThreadUrl_Params_Data* object =
      static_cast<const PageHandler_GetThreadUrl_Params_Data*>(data);

  return true;
}

PageHandler_GetThreadUrl_Params_Data::PageHandler_GetThreadUrl_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetThreadUrl_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetThreadUrl_ResponseParams_Data* object =
      static_cast<const PageHandler_GetThreadUrl_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_GetThreadUrl_ResponseParams_Data::PageHandler_GetThreadUrl_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetUrlForTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetUrlForTask_Params_Data* object =
      static_cast<const PageHandler_GetUrlForTask_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

PageHandler_GetUrlForTask_Params_Data::PageHandler_GetUrlForTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetUrlForTask_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetUrlForTask_ResponseParams_Data* object =
      static_cast<const PageHandler_GetUrlForTask_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_GetUrlForTask_ResponseParams_Data::PageHandler_GetUrlForTask_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetTaskId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetTaskId_Params_Data* object =
      static_cast<const PageHandler_SetTaskId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

PageHandler_SetTaskId_Params_Data::PageHandler_SetTaskId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IsZeroState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IsZeroState_Params_Data* object =
      static_cast<const PageHandler_IsZeroState_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_IsZeroState_Params_Data::PageHandler_IsZeroState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IsZeroState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IsZeroState_ResponseParams_Data* object =
      static_cast<const PageHandler_IsZeroState_ResponseParams_Data*>(data);

  return true;
}

PageHandler_IsZeroState_ResponseParams_Data::PageHandler_IsZeroState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetThreadTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetThreadTitle_Params_Data* object =
      static_cast<const PageHandler_SetThreadTitle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetThreadTitle_Params_Data::PageHandler_SetThreadTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CloseSidePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CloseSidePanel_Params_Data* object =
      static_cast<const PageHandler_CloseSidePanel_Params_Data*>(data);

  return true;
}

PageHandler_CloseSidePanel_Params_Data::PageHandler_CloseSidePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ShowThreadHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ShowThreadHistory_Params_Data* object =
      static_cast<const PageHandler_ShowThreadHistory_Params_Data*>(data);

  return true;
}

PageHandler_ShowThreadHistory_Params_Data::PageHandler_ShowThreadHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IsShownInTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IsShownInTab_Params_Data* object =
      static_cast<const PageHandler_IsShownInTab_Params_Data*>(data);

  return true;
}

PageHandler_IsShownInTab_Params_Data::PageHandler_IsShownInTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IsShownInTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IsShownInTab_ResponseParams_Data* object =
      static_cast<const PageHandler_IsShownInTab_ResponseParams_Data*>(data);

  return true;
}

PageHandler_IsShownInTab_ResponseParams_Data::PageHandler_IsShownInTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenMyActivityUi_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenMyActivityUi_Params_Data* object =
      static_cast<const PageHandler_OpenMyActivityUi_Params_Data*>(data);

  return true;
}

PageHandler_OpenMyActivityUi_Params_Data::PageHandler_OpenMyActivityUi_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenHelpUi_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenHelpUi_Params_Data* object =
      static_cast<const PageHandler_OpenHelpUi_Params_Data*>(data);

  return true;
}

PageHandler_OpenHelpUi_Params_Data::PageHandler_OpenHelpUi_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenOnboardingHelpUi_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenOnboardingHelpUi_Params_Data* object =
      static_cast<const PageHandler_OpenOnboardingHelpUi_Params_Data*>(data);

  return true;
}

PageHandler_OpenOnboardingHelpUi_Params_Data::PageHandler_OpenOnboardingHelpUi_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MoveTaskUiToNewTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MoveTaskUiToNewTab_Params_Data* object =
      static_cast<const PageHandler_MoveTaskUiToNewTab_Params_Data*>(data);

  return true;
}

PageHandler_MoveTaskUiToNewTab_Params_Data::PageHandler_MoveTaskUiToNewTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnTabClickedFromSourcesMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnTabClickedFromSourcesMenu_Params_Data* object =
      static_cast<const PageHandler_OnTabClickedFromSourcesMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_OnTabClickedFromSourcesMenu_Params_Data::PageHandler_OnTabClickedFromSourcesMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnWebviewMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnWebviewMessage_Params_Data* object =
      static_cast<const PageHandler_OnWebviewMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnWebviewMessage_Params_Data::PageHandler_OnWebviewMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetCommonSearchParams_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetCommonSearchParams_Params_Data* object =
      static_cast<const PageHandler_GetCommonSearchParams_Params_Data*>(data);

  return true;
}

PageHandler_GetCommonSearchParams_Params_Data::PageHandler_GetCommonSearchParams_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetCommonSearchParams_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetCommonSearchParams_ResponseParams_Data* object =
      static_cast<const PageHandler_GetCommonSearchParams_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetCommonSearchParams_ResponseParams_Data::PageHandler_GetCommonSearchParams_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnboardingTooltipDismissed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnboardingTooltipDismissed_Params_Data* object =
      static_cast<const PageHandler_OnboardingTooltipDismissed_Params_Data*>(data);

  return true;
}

PageHandler_OnboardingTooltipDismissed_Params_Data::PageHandler_OnboardingTooltipDismissed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetThreadTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetThreadTitle_Params_Data* object =
      static_cast<const Page_SetThreadTitle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

Page_SetThreadTitle_Params_Data::Page_SetThreadTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetTaskDetails_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetTaskDetails_Params_Data* object =
      static_cast<const Page_SetTaskDetails_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thread_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& thread_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->thread_id, validation_context,
                                         &thread_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->turn_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& turn_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->turn_id, validation_context,
                                         &turn_id_validate_params)) {
    return false;
  }

  return true;
}

Page_SetTaskDetails_Params_Data::Page_SetTaskDetails_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnSidePanelStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnSidePanelStateChanged_Params_Data* object =
      static_cast<const Page_OnSidePanelStateChanged_Params_Data*>(data);

  return true;
}

Page_OnSidePanelStateChanged_Params_Data::Page_OnSidePanelStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_PostMessageToWebview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_PostMessageToWebview_Params_Data* object =
      static_cast<const Page_PostMessageToWebview_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

Page_PostMessageToWebview_Params_Data::Page_PostMessageToWebview_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnHandshakeComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnHandshakeComplete_Params_Data* object =
      static_cast<const Page_OnHandshakeComplete_Params_Data*>(data);

  return true;
}

Page_OnHandshakeComplete_Params_Data::Page_OnHandshakeComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetOAuthToken_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetOAuthToken_Params_Data* object =
      static_cast<const Page_SetOAuthToken_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->oauth_token, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& oauth_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->oauth_token, validation_context,
                                         &oauth_token_validate_params)) {
    return false;
  }

  return true;
}

Page_SetOAuthToken_Params_Data::Page_SetOAuthToken_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnContextUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnContextUpdated_Params_Data* object =
      static_cast<const Page_OnContextUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_tabs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& context_tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->context_tabs, validation_context,
                                         &context_tabs_validate_params)) {
    return false;
  }

  return true;
}

Page_OnContextUpdated_Params_Data::Page_OnContextUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_HideInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_HideInput_Params_Data* object =
      static_cast<const Page_HideInput_Params_Data*>(data);

  return true;
}

Page_HideInput_Params_Data::Page_HideInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_RestoreInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_RestoreInput_Params_Data* object =
      static_cast<const Page_RestoreInput_Params_Data*>(data);

  return true;
}

Page_RestoreInput_Params_Data::Page_RestoreInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnZeroStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnZeroStateChange_Params_Data* object =
      static_cast<const Page_OnZeroStateChange_Params_Data*>(data);

  return true;
}

Page_OnZeroStateChange_Params_Data::Page_OnZeroStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnAiPageStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnAiPageStatusChanged_Params_Data* object =
      static_cast<const Page_OnAiPageStatusChanged_Params_Data*>(data);

  return true;
}

Page_OnAiPageStatusChanged_Params_Data::Page_OnAiPageStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnLensOverlayStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnLensOverlayStateChanged_Params_Data* object =
      static_cast<const Page_OnLensOverlayStateChanged_Params_Data*>(data);

  return true;
}

Page_OnLensOverlayStateChanged_Params_Data::Page_OnLensOverlayStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ShowErrorPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ShowErrorPage_Params_Data* object =
      static_cast<const Page_ShowErrorPage_Params_Data*>(data);

  return true;
}

Page_ShowErrorPage_Params_Data::Page_ShowErrorPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_HideErrorPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_HideErrorPage_Params_Data* object =
      static_cast<const Page_HideErrorPage_Params_Data*>(data);

  return true;
}

Page_HideErrorPage_Params_Data::Page_HideErrorPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page_handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page_handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace contextual_tasks