// chrome/browser/contextual_tasks/contextual_tasks.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/browser/contextual_tasks/contextual_tasks.mojom-shared-internal.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace contextual_tasks::mojom {
class TabDataView;



}  // contextual_tasks::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::contextual_tasks::mojom::TabDataView> {
  using Data = ::contextual_tasks::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace contextual_tasks::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // contextual_tasks::mojom

#endif  // CHROME_BROWSER_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_MOJOM_DATA_VIEW_H_