// chrome/browser/actor/ui/actor_overlay.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_H_
#define CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/actor/ui/actor_overlay.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/actor/ui/actor_overlay.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace actor::ui::mojom {

class ActorOverlayPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class ActorOverlayPageHandlerFactoryStub;

class ActorOverlayPageHandlerFactoryRequestValidator;


class ActorOverlayPageHandlerFactory
    : public ActorOverlayPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.ui.mojom.ActorOverlayPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActorOverlayPageHandlerFactoryInterfaceBase;
  using Proxy_ = ActorOverlayPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActorOverlayPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ActorOverlayPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActorOverlayPageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<ActorOverlayPage> page, ::mojo::PendingReceiver<ActorOverlayPageHandler> receiver) = 0;
};

class ActorOverlayPageHandlerProxy;

template <typename ImplRefTraits>
class ActorOverlayPageHandlerStub;

class ActorOverlayPageHandlerRequestValidator;
class ActorOverlayPageHandlerResponseValidator;


class ActorOverlayPageHandler
    : public ActorOverlayPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.ui.mojom.ActorOverlayPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActorOverlayPageHandlerInterfaceBase;
  using Proxy_ = ActorOverlayPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActorOverlayPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ActorOverlayPageHandlerRequestValidator;
  using ResponseValidator_ = ActorOverlayPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnHoverStatusChangedMinVersion = 0,
    kGetCurrentBorderGlowVisibilityMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnHoverStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCurrentBorderGlowVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActorOverlayPageHandler() = default;

  virtual void OnHoverStatusChanged(bool is_hovering) = 0;

  using GetCurrentBorderGlowVisibilityCallback = base::OnceCallback<void(bool)>;
  using GetCurrentBorderGlowVisibilityMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetCurrentBorderGlowVisibility(GetCurrentBorderGlowVisibilityCallback callback) = 0;
};

class ActorOverlayPageProxy;

template <typename ImplRefTraits>
class ActorOverlayPageStub;

class ActorOverlayPageRequestValidator;


class ActorOverlayPage
    : public ActorOverlayPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor.ui.mojom.ActorOverlayPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ActorOverlayPageInterfaceBase;
  using Proxy_ = ActorOverlayPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = ActorOverlayPageStub<ImplRefTraits>;

  using RequestValidator_ = ActorOverlayPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetScrimBackgroundMinVersion = 0,
    kSetBorderGlowVisibilityMinVersion = 0,
    kSetThemeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetScrimBackground_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBorderGlowVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ActorOverlayPage() = default;

  virtual void SetScrimBackground(bool is_visible) = 0;

  virtual void SetBorderGlowVisibility(bool is_visible) = 0;

  virtual void SetTheme(ThemePtr theme) = 0;
};



class  ActorOverlayPageHandlerFactoryProxy
    : public ActorOverlayPageHandlerFactory {
 public:
  using InterfaceType = ActorOverlayPageHandlerFactory;

  explicit ActorOverlayPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<ActorOverlayPage> page, ::mojo::PendingReceiver<ActorOverlayPageHandler> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ActorOverlayPageHandlerProxy
    : public ActorOverlayPageHandler {
 public:
  using InterfaceType = ActorOverlayPageHandler;

  explicit ActorOverlayPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnHoverStatusChanged(bool is_hovering) final;
  
  void GetCurrentBorderGlowVisibility(GetCurrentBorderGlowVisibilityCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ActorOverlayPageProxy
    : public ActorOverlayPage {
 public:
  using InterfaceType = ActorOverlayPage;

  explicit ActorOverlayPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetScrimBackground(bool is_visible) final;
  
  void SetBorderGlowVisibility(bool is_visible) final;
  
  void SetTheme(ThemePtr theme) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ActorOverlayPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(ActorOverlayPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActorOverlayPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActorOverlayPageHandlerFactory>>
class ActorOverlayPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActorOverlayPageHandlerFactoryStub() = default;
  ~ActorOverlayPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActorOverlayPageHandlerStubDispatch {
 public:
  static bool Accept(ActorOverlayPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActorOverlayPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActorOverlayPageHandler>>
class ActorOverlayPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActorOverlayPageHandlerStub() = default;
  ~ActorOverlayPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActorOverlayPageStubDispatch {
 public:
  static bool Accept(ActorOverlayPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ActorOverlayPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ActorOverlayPage>>
class ActorOverlayPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ActorOverlayPageStub() = default;
  ~ActorOverlayPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ActorOverlayPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ActorOverlayPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ActorOverlayPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ActorOverlayPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ActorOverlayPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  Theme {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Theme, T>::value>;
  using DataView = ThemeDataView;
  using Data_ = internal::Theme_Data;

  template <typename... Args>
  static ThemePtr New(Args&&... args) {
    return ThemePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ThemePtr From(const U& u) {
    return mojo::TypeConverter<ThemePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Theme>::Convert(*this);
  }


  Theme();

  Theme(
      ::SkColor border_color,
      ::SkColor border_glow_color,
      std::vector<::SkColor> scrim_colors);


  ~Theme();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ThemePtr>
  ThemePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Theme::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Theme::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor border_color;
  
  ::SkColor border_glow_color;
  
  std::vector<::SkColor> scrim_colors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ThemePtr Theme::Clone() const {
  return New(
      mojo::Clone(border_color),
      mojo::Clone(border_glow_color),
      mojo::Clone(scrim_colors)
  );
}

template <typename T, Theme::EnableIfSame<T>*>
bool Theme::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->border_color, other_struct.border_color))
    return false;
  if (!mojo::Equals(this->border_glow_color, other_struct.border_glow_color))
    return false;
  if (!mojo::Equals(this->scrim_colors, other_struct.scrim_colors))
    return false;
  return true;
}

template <typename T, Theme::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.border_color < rhs.border_color)
    return true;
  if (rhs.border_color < lhs.border_color)
    return false;
  if (lhs.border_glow_color < rhs.border_glow_color)
    return true;
  if (rhs.border_glow_color < lhs.border_glow_color)
    return false;
  if (lhs.scrim_colors < rhs.scrim_colors)
    return true;
  if (rhs.scrim_colors < lhs.scrim_colors)
    return false;
  return false;
}


}  // actor::ui::mojom

namespace mojo {


template <>
struct  StructTraits<::actor::ui::mojom::Theme::DataView,
                                         ::actor::ui::mojom::ThemePtr> {
  static bool IsNull(const ::actor::ui::mojom::ThemePtr& input) { return !input; }
  static void SetToNull(::actor::ui::mojom::ThemePtr* output) { output->reset(); }

  static const decltype(::actor::ui::mojom::Theme::border_color)& border_color(
      const ::actor::ui::mojom::ThemePtr& input) {
    return input->border_color;
  }

  static const decltype(::actor::ui::mojom::Theme::border_glow_color)& border_glow_color(
      const ::actor::ui::mojom::ThemePtr& input) {
    return input->border_glow_color;
  }

  static const decltype(::actor::ui::mojom::Theme::scrim_colors)& scrim_colors(
      const ::actor::ui::mojom::ThemePtr& input) {
    return input->scrim_colors;
  }

  static bool Read(::actor::ui::mojom::Theme::DataView input, ::actor::ui::mojom::ThemePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_H_