// chrome/browser/actor/ui/actor_overlay.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/actor/ui/actor_overlay.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-params-data.h"
#include "chrome/browser/actor/ui/actor_overlay.mojom-shared-message-ids.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-import-headers.h"
#include "chrome/browser/actor/ui/actor_overlay.mojom-test-utils.h"


namespace actor::ui::mojom {
Theme::Theme()
    : border_color(),
      border_glow_color(),
      scrim_colors() {}

Theme::Theme(
    ::SkColor border_color_in,
    ::SkColor border_glow_color_in,
    std::vector<::SkColor> scrim_colors_in)
    : border_color(std::move(border_color_in)),
      border_glow_color(std::move(border_glow_color_in)),
      scrim_colors(std::move(scrim_colors_in)) {}

Theme::~Theme() = default;

void Theme::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "border_color"), this->border_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "border_glow_color"), this->border_glow_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scrim_colors"), this->scrim_colors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::SkColor>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Theme::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ActorOverlayPageHandlerFactory::IPCStableHashFunction ActorOverlayPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message.name())) {
    case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler: {
      return &ActorOverlayPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActorOverlayPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message.name())) {
      case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler:
            return "Receive actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message.name())) {
      case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler:
            return "Receive reply actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActorOverlayPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9802811;  // IPCStableHash for actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActorOverlayPageHandlerFactoryProxy::ActorOverlayPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActorOverlayPageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<ActorOverlayPage> in_page, ::mojo::PendingReceiver<ActorOverlayPageHandler> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<ActorOverlayPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<ActorOverlayPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::actor::ui::mojom::ActorOverlayPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in ActorOverlayPageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::actor::ui::mojom::ActorOverlayPageHandlerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in ActorOverlayPageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActorOverlayPageHandlerFactoryStubDispatch::Accept(
    ActorOverlayPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message->header()->name)) {
    case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<ActorOverlayPage> p_page{};
      ::mojo::PendingReceiver<ActorOverlayPageHandler> p_receiver{};
      ActorOverlayPageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ActorOverlayPageHandlerFactoryStubDispatch::AcceptWithResponder(
    ActorOverlayPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActorOverlayPageHandlerFactory>(message->header()->name)) {
    case messages::ActorOverlayPageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActorOverlayPageHandlerFactoryValidationInfo[] = {
    { &internal::ActorOverlayPageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActorOverlayPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPageHandlerFactory::Name_,
    kActorOverlayPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ActorOverlayPageHandler::IPCStableHashFunction ActorOverlayPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActorOverlayPageHandler>(message.name())) {
    case messages::ActorOverlayPageHandler::kOnHoverStatusChanged: {
      return &ActorOverlayPageHandler::OnHoverStatusChanged_Sym::IPCStableHash;
    }
    case messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility: {
      return &ActorOverlayPageHandler::GetCurrentBorderGlowVisibility_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActorOverlayPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActorOverlayPageHandler>(message.name())) {
      case messages::ActorOverlayPageHandler::kOnHoverStatusChanged:
            return "Receive actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged";
      case messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility:
            return "Receive actor::ui::mojom::ActorOverlayPageHandler::GetCurrentBorderGlowVisibility";
    }
  } else {
    switch (static_cast<messages::ActorOverlayPageHandler>(message.name())) {
      case messages::ActorOverlayPageHandler::kOnHoverStatusChanged:
            return "Receive reply actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged";
      case messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility:
            return "Receive reply actor::ui::mojom::ActorOverlayPageHandler::GetCurrentBorderGlowVisibility";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActorOverlayPageHandler::OnHoverStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b519a7f;  // IPCStableHash for actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ActorOverlayPageHandler::GetCurrentBorderGlowVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdeeef67b;  // IPCStableHash for actor::ui::mojom::ActorOverlayPageHandler::GetCurrentBorderGlowVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback(
      ActorOverlayPageHandler::GetCurrentBorderGlowVisibilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback(const ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback&) = delete;
  ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback& operator=(const ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ActorOverlayPageHandler::GetCurrentBorderGlowVisibilityCallback callback_;
};

ActorOverlayPageHandlerProxy::ActorOverlayPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActorOverlayPageHandlerProxy::OnHoverStatusChanged(
    bool in_is_hovering) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPageHandler::OnHoverStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_hovering"), in_is_hovering,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPageHandler::kOnHoverStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_hovering = in_is_hovering;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPageHandler::Name_);
  message.set_method_name("OnHoverStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ActorOverlayPageHandlerProxy::GetCurrentBorderGlowVisibility(
    GetCurrentBorderGlowVisibilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send actor::ui::mojom::ActorOverlayPageHandler::GetCurrentBorderGlowVisibility");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPageHandler::Name_);
  message.set_method_name("GetCurrentBorderGlowVisibility");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ActorOverlayPageHandler::GetCurrentBorderGlowVisibilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder> proxy(
        new ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ActorOverlayPageHandler::GetCurrentBorderGlowVisibilityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_visible);
};

bool ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ActorOverlayPageHandler.1
  bool success = true;
  bool p_is_visible{};
  ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_visible = input_data_view.is_visible();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ActorOverlayPageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_visible));
  }
  return true;
}

void ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder::Run(
    bool in_is_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply actor::ui::mojom::ActorOverlayPageHandler::GetCurrentBorderGlowVisibility", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_visible"), in_is_visible,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_visible = in_is_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPageHandler::Name_);
  message.set_method_name("GetCurrentBorderGlowVisibility");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ActorOverlayPageHandlerStubDispatch::Accept(
    ActorOverlayPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActorOverlayPageHandler>(message->header()->name)) {
    case messages::ActorOverlayPageHandler::kOnHoverStatusChanged: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPageHandler.0
      bool success = true;
      bool p_is_hovering{};
      ActorOverlayPageHandler_OnHoverStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_hovering = input_data_view.is_hovering();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHoverStatusChanged(        
        std::move(p_is_hovering));
      return true;
    }
    case messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility: {
      break;
    }
  }
  return false;
}

// static
bool ActorOverlayPageHandlerStubDispatch::AcceptWithResponder(
    ActorOverlayPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActorOverlayPageHandler>(message->header()->name)) {
    case messages::ActorOverlayPageHandler::kOnHoverStatusChanged: {
      break;
    }
    case messages::ActorOverlayPageHandler::kGetCurrentBorderGlowVisibility: {
      internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_Params_Data* params =
          reinterpret_cast<
              internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ActorOverlayPageHandler.1
      bool success = true;
      ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCurrentBorderGlowVisibility(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActorOverlayPageHandlerValidationInfo[] = {
    { &internal::ActorOverlayPageHandler_OnHoverStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_Params_Data::Validate,
     &internal::ActorOverlayPageHandler_GetCurrentBorderGlowVisibility_ResponseParams_Data::Validate},
};

bool ActorOverlayPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPageHandler::Name_,
    kActorOverlayPageHandlerValidationInfo);
}

bool ActorOverlayPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPageHandler::Name_,
    kActorOverlayPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

ActorOverlayPage::IPCStableHashFunction ActorOverlayPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ActorOverlayPage>(message.name())) {
    case messages::ActorOverlayPage::kSetScrimBackground: {
      return &ActorOverlayPage::SetScrimBackground_Sym::IPCStableHash;
    }
    case messages::ActorOverlayPage::kSetBorderGlowVisibility: {
      return &ActorOverlayPage::SetBorderGlowVisibility_Sym::IPCStableHash;
    }
    case messages::ActorOverlayPage::kSetTheme: {
      return &ActorOverlayPage::SetTheme_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ActorOverlayPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ActorOverlayPage>(message.name())) {
      case messages::ActorOverlayPage::kSetScrimBackground:
            return "Receive actor::ui::mojom::ActorOverlayPage::SetScrimBackground";
      case messages::ActorOverlayPage::kSetBorderGlowVisibility:
            return "Receive actor::ui::mojom::ActorOverlayPage::SetBorderGlowVisibility";
      case messages::ActorOverlayPage::kSetTheme:
            return "Receive actor::ui::mojom::ActorOverlayPage::SetTheme";
    }
  } else {
    switch (static_cast<messages::ActorOverlayPage>(message.name())) {
      case messages::ActorOverlayPage::kSetScrimBackground:
            return "Receive reply actor::ui::mojom::ActorOverlayPage::SetScrimBackground";
      case messages::ActorOverlayPage::kSetBorderGlowVisibility:
            return "Receive reply actor::ui::mojom::ActorOverlayPage::SetBorderGlowVisibility";
      case messages::ActorOverlayPage::kSetTheme:
            return "Receive reply actor::ui::mojom::ActorOverlayPage::SetTheme";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ActorOverlayPage::SetScrimBackground_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1444c612;  // IPCStableHash for actor::ui::mojom::ActorOverlayPage::SetScrimBackground
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ActorOverlayPage::SetBorderGlowVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbe648dce;  // IPCStableHash for actor::ui::mojom::ActorOverlayPage::SetBorderGlowVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ActorOverlayPage::SetTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51bc234b;  // IPCStableHash for actor::ui::mojom::ActorOverlayPage::SetTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ActorOverlayPageProxy::ActorOverlayPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ActorOverlayPageProxy::SetScrimBackground(
    bool in_is_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPage::SetScrimBackground", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_visible"), in_is_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPage::kSetScrimBackground), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPage_SetScrimBackground_Params_Data> params(
          message);
  params.Allocate();

  params->is_visible = in_is_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPage::Name_);
  message.set_method_name("SetScrimBackground");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ActorOverlayPageProxy::SetBorderGlowVisibility(
    bool in_is_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPage::SetBorderGlowVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_visible"), in_is_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPage::kSetBorderGlowVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPage_SetBorderGlowVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->is_visible = in_is_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPage::Name_);
  message.set_method_name("SetBorderGlowVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ActorOverlayPageProxy::SetTheme(
    ThemePtr in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send actor::ui::mojom::ActorOverlayPage::SetTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type ThemePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ActorOverlayPage::kSetTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::actor::ui::mojom::internal::ActorOverlayPage_SetTheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme)::BaseType> theme_fragment(
          params.message());
  
  mojo::internal::Serialize<::actor::ui::mojom::ThemeDataView>(
    in_theme,
    theme_fragment);

  params->theme.Set(
      theme_fragment.is_null() ? nullptr : theme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme in ActorOverlayPage.SetTheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ActorOverlayPage::Name_);
  message.set_method_name("SetTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ActorOverlayPageStubDispatch::Accept(
    ActorOverlayPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ActorOverlayPage>(message->header()->name)) {
    case messages::ActorOverlayPage::kSetScrimBackground: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPage_SetScrimBackground_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPage_SetScrimBackground_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPage.0
      bool success = true;
      bool p_is_visible{};
      ActorOverlayPage_SetScrimBackground_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_visible = input_data_view.is_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScrimBackground(        
        std::move(p_is_visible));
      return true;
    }
    case messages::ActorOverlayPage::kSetBorderGlowVisibility: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPage_SetBorderGlowVisibility_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPage_SetBorderGlowVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPage.1
      bool success = true;
      bool p_is_visible{};
      ActorOverlayPage_SetBorderGlowVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_visible = input_data_view.is_visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBorderGlowVisibility(        
        std::move(p_is_visible));
      return true;
    }
    case messages::ActorOverlayPage::kSetTheme: {
      DCHECK(message->is_serialized());
      internal::ActorOverlayPage_SetTheme_Params_Data* params =
          reinterpret_cast<internal::ActorOverlayPage_SetTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ActorOverlayPage.2
      bool success = true;
      ThemePtr p_theme{};
      ActorOverlayPage_SetTheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ActorOverlayPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTheme(        
        std::move(p_theme));
      return true;
    }
  }
  return false;
}

// static
bool ActorOverlayPageStubDispatch::AcceptWithResponder(
    ActorOverlayPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ActorOverlayPage>(message->header()->name)) {
    case messages::ActorOverlayPage::kSetScrimBackground: {
      break;
    }
    case messages::ActorOverlayPage::kSetBorderGlowVisibility: {
      break;
    }
    case messages::ActorOverlayPage::kSetTheme: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kActorOverlayPageValidationInfo[] = {
    { &internal::ActorOverlayPage_SetScrimBackground_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ActorOverlayPage_SetBorderGlowVisibility_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ActorOverlayPage_SetTheme_Params_Data::Validate,
     nullptr /* no response */},
};

bool ActorOverlayPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::actor::ui::mojom::ActorOverlayPage::Name_,
    kActorOverlayPageValidationInfo);
}



}  // actor::ui::mojom


namespace mojo {


// static
bool StructTraits<::actor::ui::mojom::Theme::DataView, ::actor::ui::mojom::ThemePtr>::Read(
    ::actor::ui::mojom::Theme::DataView input,
    ::actor::ui::mojom::ThemePtr* output) {
  bool success = true;
  ::actor::ui::mojom::ThemePtr result(::actor::ui::mojom::Theme::New());
  
      if (success && !input.ReadBorderColor(&result->border_color))
        success = false;
      if (success && !input.ReadBorderGlowColor(&result->border_glow_color))
        success = false;
      if (success && !input.ReadScrimColors(&result->scrim_colors))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace actor::ui::mojom {


void ActorOverlayPageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<ActorOverlayPage> page, ::mojo::PendingReceiver<ActorOverlayPageHandler> receiver) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(receiver)
    );
}
ActorOverlayPageHandlerFactoryAsyncWaiter::ActorOverlayPageHandlerFactoryAsyncWaiter(
    ActorOverlayPageHandlerFactory* proxy) : proxy_(proxy) {}

ActorOverlayPageHandlerFactoryAsyncWaiter::~ActorOverlayPageHandlerFactoryAsyncWaiter() = default;





void ActorOverlayPageHandlerInterceptorForTesting::OnHoverStatusChanged(bool is_hovering) {
  GetForwardingInterface()->OnHoverStatusChanged(
    std::move(is_hovering)
    );
}
void ActorOverlayPageHandlerInterceptorForTesting::GetCurrentBorderGlowVisibility(GetCurrentBorderGlowVisibilityCallback callback) {
  GetForwardingInterface()->GetCurrentBorderGlowVisibility(std::move(callback));
}
ActorOverlayPageHandlerAsyncWaiter::ActorOverlayPageHandlerAsyncWaiter(
    ActorOverlayPageHandler* proxy) : proxy_(proxy) {}

ActorOverlayPageHandlerAsyncWaiter::~ActorOverlayPageHandlerAsyncWaiter() = default;


void ActorOverlayPageHandlerAsyncWaiter::GetCurrentBorderGlowVisibility(
    bool* out_is_visible) {
  base::RunLoop loop;
  proxy_->GetCurrentBorderGlowVisibility(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_visible
,
             bool is_visible) {*out_is_visible = std::move(is_visible);
            loop->Quit();
          },
          &loop,
          out_is_visible));
  loop.Run();
}

bool ActorOverlayPageHandlerAsyncWaiter::GetCurrentBorderGlowVisibility(
    ) {
  bool async_wait_result;
  GetCurrentBorderGlowVisibility(&async_wait_result);
  return async_wait_result;
}




void ActorOverlayPageInterceptorForTesting::SetScrimBackground(bool is_visible) {
  GetForwardingInterface()->SetScrimBackground(
    std::move(is_visible)
    );
}
void ActorOverlayPageInterceptorForTesting::SetBorderGlowVisibility(bool is_visible) {
  GetForwardingInterface()->SetBorderGlowVisibility(
    std::move(is_visible)
    );
}
void ActorOverlayPageInterceptorForTesting::SetTheme(ThemePtr theme) {
  GetForwardingInterface()->SetTheme(
    std::move(theme)
    );
}
ActorOverlayPageAsyncWaiter::ActorOverlayPageAsyncWaiter(
    ActorOverlayPage* proxy) : proxy_(proxy) {}

ActorOverlayPageAsyncWaiter::~ActorOverlayPageAsyncWaiter() = default;







}  // actor::ui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif