// chrome/browser/actor/ui/actor_overlay.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_SHARED_H_
#define CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/actor/ui/actor_overlay.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/actor/ui/actor_overlay.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::ui::mojom::ThemeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::ui::mojom::ThemeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::ui::mojom::internal::Theme_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::border_color(input)) in_border_color = Traits::border_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->border_color)::BaseType> border_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_border_color,
      border_color_fragment);

    fragment->border_color.Set(
        border_color_fragment.is_null() ? nullptr : border_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->border_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null border_color in Theme struct");

    decltype(Traits::border_glow_color(input)) in_border_glow_color = Traits::border_glow_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->border_glow_color)::BaseType> border_glow_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_border_glow_color,
      border_glow_color_fragment);

    fragment->border_glow_color.Set(
        border_glow_color_fragment.is_null() ? nullptr : border_glow_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->border_glow_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null border_glow_color in Theme struct");

    decltype(Traits::scrim_colors(input)) in_scrim_colors = Traits::scrim_colors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scrim_colors)::BaseType>
        scrim_colors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scrim_colors_validate_params =
        mojo::internal::GetArrayValidator<3, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::SkColorDataView>>(
      in_scrim_colors,
      scrim_colors_fragment,
      &scrim_colors_validate_params);

    fragment->scrim_colors.Set(
        scrim_colors_fragment.is_null() ? nullptr : scrim_colors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scrim_colors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scrim_colors in Theme struct");
  }

  static bool Deserialize(::actor::ui::mojom::internal::Theme_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::ui::mojom::ThemeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace actor::ui::mojom {

inline void ThemeDataView::GetBorderColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->border_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetBorderGlowColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->border_glow_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetScrimColorsDataView(
    mojo::ArrayDataView<::skia::mojom::SkColorDataView>* output) {
  auto pointer = data_->scrim_colors.Get();
  *output = mojo::ArrayDataView<::skia::mojom::SkColorDataView>(pointer, message_);
}



}  // actor::ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_ACTOR_UI_ACTOR_OVERLAY_MOJOM_SHARED_H_