// cc/mojom/synced_scroll_offset.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_SYNCED_SCROLL_OFFSET_MOJOM_H_
#define CC_MOJOM_SYNCED_SCROLL_OFFSET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/synced_scroll_offset.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/synced_scroll_offset.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/synced_scroll_offset.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "cc/mojom/synced_scroll_offset_mojom_traits.h"




namespace cc::mojom {








class  SyncedScrollOffset {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyncedScrollOffset, T>::value>;
  using DataView = SyncedScrollOffsetDataView;
  using Data_ = internal::SyncedScrollOffset_Data;

  template <typename... Args>
  static SyncedScrollOffsetPtr New(Args&&... args) {
    return SyncedScrollOffsetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyncedScrollOffsetPtr From(const U& u) {
    return mojo::TypeConverter<SyncedScrollOffsetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyncedScrollOffset>::Convert(*this);
  }


  SyncedScrollOffset();

  explicit SyncedScrollOffset(
      const ::gfx::PointF& scroll_offset);


  ~SyncedScrollOffset();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyncedScrollOffsetPtr>
  SyncedScrollOffsetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncedScrollOffset::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncedScrollOffset::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyncedScrollOffset::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyncedScrollOffset_UnserializedMessageContext<
            UserType, SyncedScrollOffset::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SyncedScrollOffset::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SyncedScrollOffset::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyncedScrollOffset_UnserializedMessageContext<
            UserType, SyncedScrollOffset::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyncedScrollOffset::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF scroll_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyncedScrollOffset::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SyncedScrollOffsetPtr SyncedScrollOffset::Clone() const {
  return New(
      mojo::Clone(scroll_offset)
  );
}

template <typename T, SyncedScrollOffset::EnableIfSame<T>*>
bool SyncedScrollOffset::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scroll_offset, other_struct.scroll_offset))
    return false;
  return true;
}

template <typename T, SyncedScrollOffset::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scroll_offset < rhs.scroll_offset)
    return true;
  if (rhs.scroll_offset < lhs.scroll_offset)
    return false;
  return false;
}


}  // cc::mojom

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::SyncedScrollOffset::DataView,
                                         ::cc::mojom::SyncedScrollOffsetPtr> {
  static bool IsNull(const ::cc::mojom::SyncedScrollOffsetPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::SyncedScrollOffsetPtr* output) { output->reset(); }

  static const decltype(::cc::mojom::SyncedScrollOffset::scroll_offset)& scroll_offset(
      const ::cc::mojom::SyncedScrollOffsetPtr& input) {
    return input->scroll_offset;
  }

  static bool Read(::cc::mojom::SyncedScrollOffset::DataView input, ::cc::mojom::SyncedScrollOffsetPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_SYNCED_SCROLL_OFFSET_MOJOM_H_