// cc/mojom/synced_scroll_offset.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_SYNCED_SCROLL_OFFSET_MOJOM_SHARED_H_
#define CC_MOJOM_SYNCED_SCROLL_OFFSET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/synced_scroll_offset.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "cc/mojom/synced_scroll_offset.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::SyncedScrollOffsetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::SyncedScrollOffsetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::SyncedScrollOffset_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::scroll_offset(input)) in_scroll_offset = Traits::scroll_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_offset)::BaseType> scroll_offset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_scroll_offset,
      scroll_offset_fragment);

    fragment->scroll_offset.Set(
        scroll_offset_fragment.is_null() ? nullptr : scroll_offset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scroll_offset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scroll_offset in SyncedScrollOffset struct");
  }

  static bool Deserialize(::cc::mojom::internal::SyncedScrollOffset_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::SyncedScrollOffsetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc::mojom {

inline void SyncedScrollOffsetDataView::GetScrollOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->scroll_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}



}  // cc::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CC_MOJOM_SYNCED_SCROLL_OFFSET_MOJOM_SHARED_H_