// cc/mojom/render_frame_metadata.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('viz.mojom.VerticalScrollDirection');
goog.require('viz.mojom.LocalSurfaceId');
goog.require('gfx.mojom.PointF');
goog.require('viz.mojom.Selection');
goog.require('gfx.mojom.Size');
goog.require('skia.mojom.SkColor4f');






goog.provide('cc.mojom.RenderFrameMetadataObserver');
goog.provide('cc.mojom.RenderFrameMetadataObserverReceiver');
goog.provide('cc.mojom.RenderFrameMetadataObserverCallbackRouter');
goog.provide('cc.mojom.RenderFrameMetadataObserverInterface');
goog.provide('cc.mojom.RenderFrameMetadataObserverRemote');
goog.provide('cc.mojom.RenderFrameMetadataObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
cc.mojom.RenderFrameMetadataObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        cc.mojom.RenderFrameMetadataObserver.$interfaceName,
        scope);
  }
};

/** @interface */
cc.mojom.RenderFrameMetadataObserverInterface = class {
  
  /**
   * @param { !boolean } enabled
   */

  reportAllFrameSubmissionsForTesting(enabled) {}
};

/**
 * @export
 * @implements { cc.mojom.RenderFrameMetadataObserverInterface }
 */
cc.mojom.RenderFrameMetadataObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!cc.mojom.RenderFrameMetadataObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          cc.mojom.RenderFrameMetadataObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!cc.mojom.RenderFrameMetadataObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } enabled
   */

  reportAllFrameSubmissionsForTesting(
      enabled) {
    this.proxy.sendMessage(
        0,
        cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RenderFrameMetadataObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
cc.mojom.RenderFrameMetadataObserverReceiver = class {
  /**
   * @param {!cc.mojom.RenderFrameMetadataObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!cc.mojom.RenderFrameMetadataObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        cc.mojom.RenderFrameMetadataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!cc.mojom.RenderFrameMetadataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsSpec.$,
        null,
        impl.reportAllFrameSubmissionsForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
cc.mojom.RenderFrameMetadataObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cc.mojom.RenderFrameMetadataObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!cc.mojom.RenderFrameMetadataObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new cc.mojom.RenderFrameMetadataObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RenderFrameMetadataObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
cc.mojom.RenderFrameMetadataObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      cc.mojom.RenderFrameMetadataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!cc.mojom.RenderFrameMetadataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportAllFrameSubmissionsForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsSpec.$,
        null,
        this.reportAllFrameSubmissionsForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('cc.mojom.RenderFrameMetadataObserverClient');
goog.provide('cc.mojom.RenderFrameMetadataObserverClientReceiver');
goog.provide('cc.mojom.RenderFrameMetadataObserverClientCallbackRouter');
goog.provide('cc.mojom.RenderFrameMetadataObserverClientInterface');
goog.provide('cc.mojom.RenderFrameMetadataObserverClientRemote');
goog.provide('cc.mojom.RenderFrameMetadataObserverClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
cc.mojom.RenderFrameMetadataObserverClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        cc.mojom.RenderFrameMetadataObserverClient.$interfaceName,
        scope);
  }
};

/** @interface */
cc.mojom.RenderFrameMetadataObserverClientInterface = class {
  
  /**
   * @param { !number } frameToken
   * @param { !cc.mojom.RenderFrameMetadata } metadata
   */

  onRenderFrameMetadataChanged(frameToken, metadata) {}
  
  /**
   * @param { !number } frameToken
   */

  onFrameSubmissionForTesting(frameToken) {}
};

/**
 * @export
 * @implements { cc.mojom.RenderFrameMetadataObserverClientInterface }
 */
cc.mojom.RenderFrameMetadataObserverClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!cc.mojom.RenderFrameMetadataObserverClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          cc.mojom.RenderFrameMetadataObserverClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!cc.mojom.RenderFrameMetadataObserverClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } frameToken
   * @param { !cc.mojom.RenderFrameMetadata } metadata
   */

  onRenderFrameMetadataChanged(
      frameToken,
      metadata) {
    this.proxy.sendMessage(
        0,
        cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsSpec.$,
        null,
        [
          frameToken,
          metadata
        ],
        false);
  }

  
  /**
   * @param { !number } frameToken
   */

  onFrameSubmissionForTesting(
      frameToken) {
    this.proxy.sendMessage(
        1,
        cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsSpec.$,
        null,
        [
          frameToken
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RenderFrameMetadataObserverClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
cc.mojom.RenderFrameMetadataObserverClientReceiver = class {
  /**
   * @param {!cc.mojom.RenderFrameMetadataObserverClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!cc.mojom.RenderFrameMetadataObserverClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        cc.mojom.RenderFrameMetadataObserverClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!cc.mojom.RenderFrameMetadataObserverClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsSpec.$,
        null,
        impl.onRenderFrameMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsSpec.$,
        null,
        impl.onFrameSubmissionForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
cc.mojom.RenderFrameMetadataObserverClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cc.mojom.RenderFrameMetadataObserverClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!cc.mojom.RenderFrameMetadataObserverClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new cc.mojom.RenderFrameMetadataObserverClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RenderFrameMetadataObserverClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
cc.mojom.RenderFrameMetadataObserverClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      cc.mojom.RenderFrameMetadataObserverClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!cc.mojom.RenderFrameMetadataObserverClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRenderFrameMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsSpec.$,
        null,
        this.onRenderFrameMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFrameSubmissionForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsSpec.$,
        null,
        this.onFrameSubmissionForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('cc.mojom.DelegatedInkBrowserMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
cc.mojom.DelegatedInkBrowserMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('cc.mojom.RenderFrameMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
cc.mojom.RenderFrameMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    cc.mojom.DelegatedInkBrowserMetadataSpec.$,
    'DelegatedInkBrowserMetadata',
    [
      mojo.internal.StructField(
        'delegatedInkIsHovering', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('cc.mojom.DelegatedInkBrowserMetadata');

/** @record */
cc.mojom.DelegatedInkBrowserMetadata = class {
  constructor() {
    /** @export { !boolean } */
    this.delegatedInkIsHovering;
  }
};



mojo.internal.Struct(
    cc.mojom.RenderFrameMetadataSpec.$,
    'RenderFrameMetadata',
    [
      mojo.internal.StructField(
        'rootBackgroundColor', 0,
        0,
        skia.mojom.SkColor4fSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rootScrollOffset', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isScrollOffsetAtTop', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selection', 24,
        0,
        viz.mojom.SelectionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isMobileOptimized', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'delegatedInkMetadata', 32,
        0,
        cc.mojom.DelegatedInkBrowserMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceScaleFactor', 20,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'viewportSizeInPixels', 40,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localSurfaceId', 48,
        0,
        viz.mojom.LocalSurfaceIdSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageScaleFactor', 56,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'externalPageScaleFactor', 60,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topControlsHeight', 64,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'topControlsShownRatio', 68,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newVerticalScrollDirection', 72,
        0,
        viz.mojom.VerticalScrollDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryMainFrameItemSequenceNumber', 80,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 96],]);



goog.provide('cc.mojom.RenderFrameMetadata');

/** @record */
cc.mojom.RenderFrameMetadata = class {
  constructor() {
    /** @export { !skia.mojom.SkColor4f } */
    this.rootBackgroundColor;
    /** @export { (gfx.mojom.PointF|undefined) } */
    this.rootScrollOffset;
    /** @export { !boolean } */
    this.isScrollOffsetAtTop;
    /** @export { !viz.mojom.Selection } */
    this.selection;
    /** @export { !boolean } */
    this.isMobileOptimized;
    /** @export { (cc.mojom.DelegatedInkBrowserMetadata|undefined) } */
    this.delegatedInkMetadata;
    /** @export { !number } */
    this.deviceScaleFactor;
    /** @export { !gfx.mojom.Size } */
    this.viewportSizeInPixels;
    /** @export { (viz.mojom.LocalSurfaceId|undefined) } */
    this.localSurfaceId;
    /** @export { !number } */
    this.pageScaleFactor;
    /** @export { !number } */
    this.externalPageScaleFactor;
    /** @export { !number } */
    this.topControlsHeight;
    /** @export { !number } */
    this.topControlsShownRatio;
    /** @export { !viz.mojom.VerticalScrollDirection } */
    this.newVerticalScrollDirection;
    /** @export { !bigint } */
    this.primaryMainFrameItemSequenceNumber;
  }
};



mojo.internal.Struct(
    cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_ParamsSpec.$,
    'RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params');

/** @record */
cc.mojom.RenderFrameMetadataObserver_ReportAllFrameSubmissionsForTesting_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};



mojo.internal.Struct(
    cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_ParamsSpec.$,
    'RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'frameToken', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        cc.mojom.RenderFrameMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params');

/** @record */
cc.mojom.RenderFrameMetadataObserverClient_OnRenderFrameMetadataChanged_Params = class {
  constructor() {
    /** @export { !number } */
    this.frameToken;
    /** @export { !cc.mojom.RenderFrameMetadata } */
    this.metadata;
  }
};



mojo.internal.Struct(
    cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_ParamsSpec.$,
    'RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params',
    [
      mojo.internal.StructField(
        'frameToken', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params');

/** @record */
cc.mojom.RenderFrameMetadataObserverClient_OnFrameSubmissionForTesting_Params = class {
  constructor() {
    /** @export { !number } */
    this.frameToken;
  }
};

