// cc/mojom/render_frame_metadata.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_DATA_VIEW_H_
#define CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "cc/mojom/render_frame_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/selection.mojom-shared.h"
#include "services/viz/public/mojom/compositing/vertical_scroll_direction.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace cc::mojom {
class DelegatedInkBrowserMetadataDataView;

class RenderFrameMetadataDataView;



}  // cc::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cc::mojom::DelegatedInkBrowserMetadataDataView> {
  using Data = ::cc::mojom::internal::DelegatedInkBrowserMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cc::mojom::RenderFrameMetadataDataView> {
  using Data = ::cc::mojom::internal::RenderFrameMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cc::mojom {
// Interface base classes. They are used for type safety check.
class RenderFrameMetadataObserverInterfaceBase {};

using RenderFrameMetadataObserverPtrDataView =
    mojo::InterfacePtrDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverRequestDataView =
    mojo::InterfaceRequestDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderFrameMetadataObserverInterfaceBase>;
using RenderFrameMetadataObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderFrameMetadataObserverInterfaceBase>;
class RenderFrameMetadataObserverClientInterfaceBase {};

using RenderFrameMetadataObserverClientPtrDataView =
    mojo::InterfacePtrDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientRequestDataView =
    mojo::InterfaceRequestDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RenderFrameMetadataObserverClientInterfaceBase>;
using RenderFrameMetadataObserverClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RenderFrameMetadataObserverClientInterfaceBase>;


class DelegatedInkBrowserMetadataDataView {
 public:
  DelegatedInkBrowserMetadataDataView() = default;

  DelegatedInkBrowserMetadataDataView(
      internal::DelegatedInkBrowserMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool delegated_ink_is_hovering() const {
    return data_->delegated_ink_is_hovering;
  }
 private:
  internal::DelegatedInkBrowserMetadata_Data* data_ = nullptr;
};


class RenderFrameMetadataDataView {
 public:
  RenderFrameMetadataDataView() = default;

  RenderFrameMetadataDataView(
      internal::RenderFrameMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRootBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootBackgroundColor(UserType* output) {
    
    auto* pointer = data_->root_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetRootScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootScrollOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `root_scroll_offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRootScrollOffset` instead "
    "of `ReadRootScrollOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->root_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  bool is_scroll_offset_at_top() const {
    return data_->is_scroll_offset_at_top;
  }
  inline void GetSelectionDataView(
      ::viz::mojom::SelectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::viz::mojom::SelectionDataView>(
        pointer, output, message_);
  }
  bool is_mobile_optimized() const {
    return data_->is_mobile_optimized;
  }
  inline void GetDelegatedInkMetadataDataView(
      DelegatedInkBrowserMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDelegatedInkMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::DelegatedInkBrowserMetadataDataView, UserType>(),
    "Attempting to read the optional `delegated_ink_metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDelegatedInkMetadata` instead "
    "of `ReadDelegatedInkMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->delegated_ink_metadata.Get();
    return mojo::internal::Deserialize<::cc::mojom::DelegatedInkBrowserMetadataDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetViewportSizeInPixelsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportSizeInPixels(UserType* output) {
    
    auto* pointer = data_->viewport_size_in_pixels.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceId` instead "
    "of `ReadLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float external_page_scale_factor() const {
    return data_->external_page_scale_factor;
  }
  float top_controls_height() const {
    return data_->top_controls_height;
  }
  float top_controls_shown_ratio() const {
    return data_->top_controls_shown_ratio;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNewVerticalScrollDirection(UserType* output) const {
    auto data_value = data_->new_vertical_scroll_direction;
    return mojo::internal::Deserialize<::viz::mojom::VerticalScrollDirection>(
        data_value, output);
  }
  ::viz::mojom::VerticalScrollDirection new_vertical_scroll_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::VerticalScrollDirection>(data_->new_vertical_scroll_direction));
  }
  int64_t primary_main_frame_item_sequence_number() const {
    return data_->primary_main_frame_item_sequence_number;
  }
 private:
  internal::RenderFrameMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cc::mojom

#endif  // CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_DATA_VIEW_H_