// cc/mojom/paint_flags.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_PAINT_FLAGS_MOJOM_BLINK_H_
#define CC_MOJOM_PAINT_FLAGS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/paint_flags.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/paint_flags.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/paint_flags.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace cc::mojom::blink {





class  DynamicRangeLimit {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DynamicRangeLimit, T>::value>;
  using DataView = DynamicRangeLimitDataView;
  using Data_ = internal::DynamicRangeLimit_Data;

  template <typename... Args>
  static DynamicRangeLimitPtr New(Args&&... args) {
    return DynamicRangeLimitPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DynamicRangeLimitPtr From(const U& u) {
    return mojo::TypeConverter<DynamicRangeLimitPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DynamicRangeLimit>::Convert(*this);
  }


  DynamicRangeLimit();

  DynamicRangeLimit(
      float standard_mix,
      float constrained_high_mix);


  ~DynamicRangeLimit();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DynamicRangeLimitPtr>
  DynamicRangeLimitPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DynamicRangeLimit::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DynamicRangeLimit::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DynamicRangeLimit::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DynamicRangeLimit_UnserializedMessageContext<
            UserType, DynamicRangeLimit::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DynamicRangeLimit::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DynamicRangeLimit::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DynamicRangeLimit_UnserializedMessageContext<
            UserType, DynamicRangeLimit::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DynamicRangeLimit::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float standard_mix;
  
  float constrained_high_mix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DynamicRangeLimit::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
DynamicRangeLimitPtr DynamicRangeLimit::Clone() const {
  return New(
      mojo::Clone(standard_mix),
      mojo::Clone(constrained_high_mix)
  );
}

template <typename T, DynamicRangeLimit::EnableIfSame<T>*>
bool DynamicRangeLimit::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->standard_mix, other_struct.standard_mix))
    return false;
  if (!mojo::Equals(this->constrained_high_mix, other_struct.constrained_high_mix))
    return false;
  return true;
}

template <typename T, DynamicRangeLimit::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.standard_mix < rhs.standard_mix)
    return true;
  if (rhs.standard_mix < lhs.standard_mix)
    return false;
  if (lhs.constrained_high_mix < rhs.constrained_high_mix)
    return true;
  if (rhs.constrained_high_mix < lhs.constrained_high_mix)
    return false;
  return false;
}


}  // cc::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::blink::DynamicRangeLimit::DataView,
                                         ::cc::mojom::blink::DynamicRangeLimitPtr> {
  static bool IsNull(const ::cc::mojom::blink::DynamicRangeLimitPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::blink::DynamicRangeLimitPtr* output) { output->reset(); }

  static decltype(::cc::mojom::blink::DynamicRangeLimit::standard_mix) standard_mix(
      const ::cc::mojom::blink::DynamicRangeLimitPtr& input) {
    return input->standard_mix;
  }

  static decltype(::cc::mojom::blink::DynamicRangeLimit::constrained_high_mix) constrained_high_mix(
      const ::cc::mojom::blink::DynamicRangeLimitPtr& input) {
    return input->constrained_high_mix;
  }

  static bool Read(::cc::mojom::blink::DynamicRangeLimit::DataView input, ::cc::mojom::blink::DynamicRangeLimitPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_PAINT_FLAGS_MOJOM_BLINK_H_