// cc/mojom/layer_tree_debug_state.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_LAYER_TREE_DEBUG_STATE_MOJOM_BLINK_H_
#define CC_MOJOM_LAYER_TREE_DEBUG_STATE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/layer_tree_debug_state.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/layer_tree_debug_state.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/layer_tree_debug_state.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace cc::mojom::blink {








class  LayerTreeDebugState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerTreeDebugState, T>::value>;
  using DataView = LayerTreeDebugStateDataView;
  using Data_ = internal::LayerTreeDebugState_Data;

  template <typename... Args>
  static LayerTreeDebugStatePtr New(Args&&... args) {
    return LayerTreeDebugStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerTreeDebugStatePtr From(const U& u) {
    return mojo::TypeConverter<LayerTreeDebugStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerTreeDebugState>::Convert(*this);
  }


  LayerTreeDebugState();

  LayerTreeDebugState(
      bool debugger_paused,
      bool show_fps_counter,
      bool show_render_pass_borders,
      bool show_surface_borders,
      bool show_layer_borders,
      bool show_layout_shift_regions,
      bool show_paint_rects,
      bool show_property_changed_rects,
      bool show_surface_damage_rects,
      bool show_screen_space_rects,
      bool show_touch_event_handler_rects,
      bool show_wheel_event_handler_rects,
      bool show_scroll_event_handler_rects,
      bool show_main_thread_scroll_hit_test_rects,
      bool show_main_thread_scroll_repaint_rects,
      bool show_raster_inducing_scroll_rects,
      bool show_layer_animation_bounds_rects,
      int32_t slow_down_raster_scale_factor,
      bool rasterize_only_visible_content,
      bool record_rendering_stats);


  ~LayerTreeDebugState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerTreeDebugStatePtr>
  LayerTreeDebugStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerTreeDebugState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerTreeDebugState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerTreeDebugState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerTreeDebugState_UnserializedMessageContext<
            UserType, LayerTreeDebugState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerTreeDebugState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerTreeDebugState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerTreeDebugState_UnserializedMessageContext<
            UserType, LayerTreeDebugState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerTreeDebugState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool debugger_paused;
  
  bool show_fps_counter;
  
  bool show_render_pass_borders;
  
  bool show_surface_borders;
  
  bool show_layer_borders;
  
  bool show_layout_shift_regions;
  
  bool show_paint_rects;
  
  bool show_property_changed_rects;
  
  bool show_surface_damage_rects;
  
  bool show_screen_space_rects;
  
  bool show_touch_event_handler_rects;
  
  bool show_wheel_event_handler_rects;
  
  bool show_scroll_event_handler_rects;
  
  bool show_main_thread_scroll_hit_test_rects;
  
  bool show_main_thread_scroll_repaint_rects;
  
  bool show_raster_inducing_scroll_rects;
  
  bool show_layer_animation_bounds_rects;
  
  int32_t slow_down_raster_scale_factor;
  
  bool rasterize_only_visible_content;
  
  bool record_rendering_stats;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerTreeDebugState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LayerTreeDebugStatePtr LayerTreeDebugState::Clone() const {
  return New(
      mojo::Clone(debugger_paused),
      mojo::Clone(show_fps_counter),
      mojo::Clone(show_render_pass_borders),
      mojo::Clone(show_surface_borders),
      mojo::Clone(show_layer_borders),
      mojo::Clone(show_layout_shift_regions),
      mojo::Clone(show_paint_rects),
      mojo::Clone(show_property_changed_rects),
      mojo::Clone(show_surface_damage_rects),
      mojo::Clone(show_screen_space_rects),
      mojo::Clone(show_touch_event_handler_rects),
      mojo::Clone(show_wheel_event_handler_rects),
      mojo::Clone(show_scroll_event_handler_rects),
      mojo::Clone(show_main_thread_scroll_hit_test_rects),
      mojo::Clone(show_main_thread_scroll_repaint_rects),
      mojo::Clone(show_raster_inducing_scroll_rects),
      mojo::Clone(show_layer_animation_bounds_rects),
      mojo::Clone(slow_down_raster_scale_factor),
      mojo::Clone(rasterize_only_visible_content),
      mojo::Clone(record_rendering_stats)
  );
}

template <typename T, LayerTreeDebugState::EnableIfSame<T>*>
bool LayerTreeDebugState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->debugger_paused, other_struct.debugger_paused))
    return false;
  if (!mojo::Equals(this->show_fps_counter, other_struct.show_fps_counter))
    return false;
  if (!mojo::Equals(this->show_render_pass_borders, other_struct.show_render_pass_borders))
    return false;
  if (!mojo::Equals(this->show_surface_borders, other_struct.show_surface_borders))
    return false;
  if (!mojo::Equals(this->show_layer_borders, other_struct.show_layer_borders))
    return false;
  if (!mojo::Equals(this->show_layout_shift_regions, other_struct.show_layout_shift_regions))
    return false;
  if (!mojo::Equals(this->show_paint_rects, other_struct.show_paint_rects))
    return false;
  if (!mojo::Equals(this->show_property_changed_rects, other_struct.show_property_changed_rects))
    return false;
  if (!mojo::Equals(this->show_surface_damage_rects, other_struct.show_surface_damage_rects))
    return false;
  if (!mojo::Equals(this->show_screen_space_rects, other_struct.show_screen_space_rects))
    return false;
  if (!mojo::Equals(this->show_touch_event_handler_rects, other_struct.show_touch_event_handler_rects))
    return false;
  if (!mojo::Equals(this->show_wheel_event_handler_rects, other_struct.show_wheel_event_handler_rects))
    return false;
  if (!mojo::Equals(this->show_scroll_event_handler_rects, other_struct.show_scroll_event_handler_rects))
    return false;
  if (!mojo::Equals(this->show_main_thread_scroll_hit_test_rects, other_struct.show_main_thread_scroll_hit_test_rects))
    return false;
  if (!mojo::Equals(this->show_main_thread_scroll_repaint_rects, other_struct.show_main_thread_scroll_repaint_rects))
    return false;
  if (!mojo::Equals(this->show_raster_inducing_scroll_rects, other_struct.show_raster_inducing_scroll_rects))
    return false;
  if (!mojo::Equals(this->show_layer_animation_bounds_rects, other_struct.show_layer_animation_bounds_rects))
    return false;
  if (!mojo::Equals(this->slow_down_raster_scale_factor, other_struct.slow_down_raster_scale_factor))
    return false;
  if (!mojo::Equals(this->rasterize_only_visible_content, other_struct.rasterize_only_visible_content))
    return false;
  if (!mojo::Equals(this->record_rendering_stats, other_struct.record_rendering_stats))
    return false;
  return true;
}

template <typename T, LayerTreeDebugState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.debugger_paused < rhs.debugger_paused)
    return true;
  if (rhs.debugger_paused < lhs.debugger_paused)
    return false;
  if (lhs.show_fps_counter < rhs.show_fps_counter)
    return true;
  if (rhs.show_fps_counter < lhs.show_fps_counter)
    return false;
  if (lhs.show_render_pass_borders < rhs.show_render_pass_borders)
    return true;
  if (rhs.show_render_pass_borders < lhs.show_render_pass_borders)
    return false;
  if (lhs.show_surface_borders < rhs.show_surface_borders)
    return true;
  if (rhs.show_surface_borders < lhs.show_surface_borders)
    return false;
  if (lhs.show_layer_borders < rhs.show_layer_borders)
    return true;
  if (rhs.show_layer_borders < lhs.show_layer_borders)
    return false;
  if (lhs.show_layout_shift_regions < rhs.show_layout_shift_regions)
    return true;
  if (rhs.show_layout_shift_regions < lhs.show_layout_shift_regions)
    return false;
  if (lhs.show_paint_rects < rhs.show_paint_rects)
    return true;
  if (rhs.show_paint_rects < lhs.show_paint_rects)
    return false;
  if (lhs.show_property_changed_rects < rhs.show_property_changed_rects)
    return true;
  if (rhs.show_property_changed_rects < lhs.show_property_changed_rects)
    return false;
  if (lhs.show_surface_damage_rects < rhs.show_surface_damage_rects)
    return true;
  if (rhs.show_surface_damage_rects < lhs.show_surface_damage_rects)
    return false;
  if (lhs.show_screen_space_rects < rhs.show_screen_space_rects)
    return true;
  if (rhs.show_screen_space_rects < lhs.show_screen_space_rects)
    return false;
  if (lhs.show_touch_event_handler_rects < rhs.show_touch_event_handler_rects)
    return true;
  if (rhs.show_touch_event_handler_rects < lhs.show_touch_event_handler_rects)
    return false;
  if (lhs.show_wheel_event_handler_rects < rhs.show_wheel_event_handler_rects)
    return true;
  if (rhs.show_wheel_event_handler_rects < lhs.show_wheel_event_handler_rects)
    return false;
  if (lhs.show_scroll_event_handler_rects < rhs.show_scroll_event_handler_rects)
    return true;
  if (rhs.show_scroll_event_handler_rects < lhs.show_scroll_event_handler_rects)
    return false;
  if (lhs.show_main_thread_scroll_hit_test_rects < rhs.show_main_thread_scroll_hit_test_rects)
    return true;
  if (rhs.show_main_thread_scroll_hit_test_rects < lhs.show_main_thread_scroll_hit_test_rects)
    return false;
  if (lhs.show_main_thread_scroll_repaint_rects < rhs.show_main_thread_scroll_repaint_rects)
    return true;
  if (rhs.show_main_thread_scroll_repaint_rects < lhs.show_main_thread_scroll_repaint_rects)
    return false;
  if (lhs.show_raster_inducing_scroll_rects < rhs.show_raster_inducing_scroll_rects)
    return true;
  if (rhs.show_raster_inducing_scroll_rects < lhs.show_raster_inducing_scroll_rects)
    return false;
  if (lhs.show_layer_animation_bounds_rects < rhs.show_layer_animation_bounds_rects)
    return true;
  if (rhs.show_layer_animation_bounds_rects < lhs.show_layer_animation_bounds_rects)
    return false;
  if (lhs.slow_down_raster_scale_factor < rhs.slow_down_raster_scale_factor)
    return true;
  if (rhs.slow_down_raster_scale_factor < lhs.slow_down_raster_scale_factor)
    return false;
  if (lhs.rasterize_only_visible_content < rhs.rasterize_only_visible_content)
    return true;
  if (rhs.rasterize_only_visible_content < lhs.rasterize_only_visible_content)
    return false;
  if (lhs.record_rendering_stats < rhs.record_rendering_stats)
    return true;
  if (rhs.record_rendering_stats < lhs.record_rendering_stats)
    return false;
  return false;
}


}  // cc::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::blink::LayerTreeDebugState::DataView,
                                         ::cc::mojom::blink::LayerTreeDebugStatePtr> {
  static bool IsNull(const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) { return !input; }
  static void SetToNull(::cc::mojom::blink::LayerTreeDebugStatePtr* output) { output->reset(); }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::debugger_paused) debugger_paused(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->debugger_paused;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_fps_counter) show_fps_counter(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_fps_counter;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_render_pass_borders) show_render_pass_borders(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_render_pass_borders;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_surface_borders) show_surface_borders(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_surface_borders;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_layer_borders) show_layer_borders(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_layer_borders;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_layout_shift_regions) show_layout_shift_regions(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_layout_shift_regions;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_paint_rects) show_paint_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_paint_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_property_changed_rects) show_property_changed_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_property_changed_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_surface_damage_rects) show_surface_damage_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_surface_damage_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_screen_space_rects) show_screen_space_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_screen_space_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_touch_event_handler_rects) show_touch_event_handler_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_touch_event_handler_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_wheel_event_handler_rects) show_wheel_event_handler_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_wheel_event_handler_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_scroll_event_handler_rects) show_scroll_event_handler_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_scroll_event_handler_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_main_thread_scroll_hit_test_rects) show_main_thread_scroll_hit_test_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_main_thread_scroll_hit_test_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_main_thread_scroll_repaint_rects) show_main_thread_scroll_repaint_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_main_thread_scroll_repaint_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_raster_inducing_scroll_rects) show_raster_inducing_scroll_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_raster_inducing_scroll_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::show_layer_animation_bounds_rects) show_layer_animation_bounds_rects(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->show_layer_animation_bounds_rects;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::slow_down_raster_scale_factor) slow_down_raster_scale_factor(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->slow_down_raster_scale_factor;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::rasterize_only_visible_content) rasterize_only_visible_content(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->rasterize_only_visible_content;
  }

  static decltype(::cc::mojom::blink::LayerTreeDebugState::record_rendering_stats) record_rendering_stats(
      const ::cc::mojom::blink::LayerTreeDebugStatePtr& input) {
    return input->record_rendering_stats;
  }

  static bool Read(::cc::mojom::blink::LayerTreeDebugState::DataView input, ::cc::mojom::blink::LayerTreeDebugStatePtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_LAYER_TREE_DEBUG_STATE_MOJOM_BLINK_H_