// cc/mojom/layer_selection_bound.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_DATA_VIEW_H_
#define CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "cc/mojom/layer_selection_bound.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/selection_bound.mojom-shared.h"


namespace cc::mojom {
class LayerSelectionBoundDataView;

class LayerSelectionDataView;



}  // cc::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cc::mojom::LayerSelectionBoundDataView> {
  using Data = ::cc::mojom::internal::LayerSelectionBound_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cc::mojom::LayerSelectionDataView> {
  using Data = ::cc::mojom::internal::LayerSelection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cc::mojom {


class LayerSelectionBoundDataView {
 public:
  LayerSelectionBoundDataView() = default;

  LayerSelectionBoundDataView(
      internal::LayerSelectionBound_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::gfx::mojom::SelectionBoundType>(
        data_value, output);
  }
  ::gfx::mojom::SelectionBoundType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::SelectionBoundType>(data_->type));
  }
  inline void GetEdgeStartDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEdgeStart(UserType* output) {
    
    auto* pointer = data_->edge_start.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetEdgeEndDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEdgeEnd(UserType* output) {
    
    auto* pointer = data_->edge_end.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  int32_t layer_id() const {
    return data_->layer_id;
  }
  bool hidden() const {
    return data_->hidden;
  }
 private:
  internal::LayerSelectionBound_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayerSelectionDataView {
 public:
  LayerSelectionDataView() = default;

  LayerSelectionDataView(
      internal::LayerSelection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartDataView(
      LayerSelectionBoundDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStart(UserType* output) {
    
    auto* pointer = data_->start.Get();
    return mojo::internal::Deserialize<::cc::mojom::LayerSelectionBoundDataView>(
        pointer, output, message_);
  }
  inline void GetEndDataView(
      LayerSelectionBoundDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnd(UserType* output) {
    
    auto* pointer = data_->end.Get();
    return mojo::internal::Deserialize<::cc::mojom::LayerSelectionBoundDataView>(
        pointer, output, message_);
  }
 private:
  internal::LayerSelection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cc::mojom

#endif  // CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_DATA_VIEW_H_