// cc/mojom/layer_selection_bound.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_BLINK_H_
#define CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/layer_selection_bound.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/layer_selection_bound.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/layer_selection_bound.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/selection_bound.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace cc::mojom::blink {









class  LayerSelectionBound {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerSelectionBound, T>::value>;
  using DataView = LayerSelectionBoundDataView;
  using Data_ = internal::LayerSelectionBound_Data;

  template <typename... Args>
  static LayerSelectionBoundPtr New(Args&&... args) {
    return LayerSelectionBoundPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerSelectionBoundPtr From(const U& u) {
    return mojo::TypeConverter<LayerSelectionBoundPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerSelectionBound>::Convert(*this);
  }


  LayerSelectionBound();

  LayerSelectionBound(
      ::gfx::SelectionBound::Type type,
      const ::gfx::Point& edge_start,
      const ::gfx::Point& edge_end,
      int32_t layer_id,
      bool hidden);


  ~LayerSelectionBound();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerSelectionBoundPtr>
  LayerSelectionBoundPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerSelectionBound::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerSelectionBound::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerSelectionBound::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerSelectionBound_UnserializedMessageContext<
            UserType, LayerSelectionBound::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerSelectionBound::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerSelectionBound::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerSelectionBound_UnserializedMessageContext<
            UserType, LayerSelectionBound::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerSelectionBound::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::SelectionBound::Type type;
  
  ::gfx::Point edge_start;
  
  ::gfx::Point edge_end;
  
  int32_t layer_id;
  
  bool hidden;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerSelectionBound::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LayerSelection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerSelection, T>::value>;
  using DataView = LayerSelectionDataView;
  using Data_ = internal::LayerSelection_Data;

  template <typename... Args>
  static LayerSelectionPtr New(Args&&... args) {
    return LayerSelectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerSelectionPtr From(const U& u) {
    return mojo::TypeConverter<LayerSelectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerSelection>::Convert(*this);
  }


  LayerSelection();

  LayerSelection(
      LayerSelectionBoundPtr start,
      LayerSelectionBoundPtr end);

LayerSelection(const LayerSelection&) = delete;
LayerSelection& operator=(const LayerSelection&) = delete;

  ~LayerSelection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerSelectionPtr>
  LayerSelectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerSelection::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LayerSelection::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerSelection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerSelection_UnserializedMessageContext<
            UserType, LayerSelection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerSelection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerSelection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerSelection_UnserializedMessageContext<
            UserType, LayerSelection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerSelection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  LayerSelectionBoundPtr start;
  
  LayerSelectionBoundPtr end;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerSelection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LayerSelectionBoundPtr LayerSelectionBound::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(edge_start),
      mojo::Clone(edge_end),
      mojo::Clone(layer_id),
      mojo::Clone(hidden)
  );
}

template <typename T, LayerSelectionBound::EnableIfSame<T>*>
bool LayerSelectionBound::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->edge_start, other_struct.edge_start))
    return false;
  if (!mojo::Equals(this->edge_end, other_struct.edge_end))
    return false;
  if (!mojo::Equals(this->layer_id, other_struct.layer_id))
    return false;
  if (!mojo::Equals(this->hidden, other_struct.hidden))
    return false;
  return true;
}

template <typename T, LayerSelectionBound::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.edge_start < rhs.edge_start)
    return true;
  if (rhs.edge_start < lhs.edge_start)
    return false;
  if (lhs.edge_end < rhs.edge_end)
    return true;
  if (rhs.edge_end < lhs.edge_end)
    return false;
  if (lhs.layer_id < rhs.layer_id)
    return true;
  if (rhs.layer_id < lhs.layer_id)
    return false;
  if (lhs.hidden < rhs.hidden)
    return true;
  if (rhs.hidden < lhs.hidden)
    return false;
  return false;
}
template <typename StructPtrType>
LayerSelectionPtr LayerSelection::Clone() const {
  return New(
      mojo::Clone(start),
      mojo::Clone(end)
  );
}

template <typename T, LayerSelection::EnableIfSame<T>*>
bool LayerSelection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start, other_struct.start))
    return false;
  if (!mojo::Equals(this->end, other_struct.end))
    return false;
  return true;
}

template <typename T, LayerSelection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start < rhs.start)
    return true;
  if (rhs.start < lhs.start)
    return false;
  if (lhs.end < rhs.end)
    return true;
  if (rhs.end < lhs.end)
    return false;
  return false;
}


}  // cc::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::blink::LayerSelectionBound::DataView,
                                         ::cc::mojom::blink::LayerSelectionBoundPtr> {
  static bool IsNull(const ::cc::mojom::blink::LayerSelectionBoundPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::blink::LayerSelectionBoundPtr* output) { output->reset(); }

  static decltype(::cc::mojom::blink::LayerSelectionBound::type) type(
      const ::cc::mojom::blink::LayerSelectionBoundPtr& input) {
    return input->type;
  }

  static const decltype(::cc::mojom::blink::LayerSelectionBound::edge_start)& edge_start(
      const ::cc::mojom::blink::LayerSelectionBoundPtr& input) {
    return input->edge_start;
  }

  static const decltype(::cc::mojom::blink::LayerSelectionBound::edge_end)& edge_end(
      const ::cc::mojom::blink::LayerSelectionBoundPtr& input) {
    return input->edge_end;
  }

  static decltype(::cc::mojom::blink::LayerSelectionBound::layer_id) layer_id(
      const ::cc::mojom::blink::LayerSelectionBoundPtr& input) {
    return input->layer_id;
  }

  static decltype(::cc::mojom::blink::LayerSelectionBound::hidden) hidden(
      const ::cc::mojom::blink::LayerSelectionBoundPtr& input) {
    return input->hidden;
  }

  static bool Read(::cc::mojom::blink::LayerSelectionBound::DataView input, ::cc::mojom::blink::LayerSelectionBoundPtr* output);
};


template <>
struct  StructTraits<::cc::mojom::blink::LayerSelection::DataView,
                                         ::cc::mojom::blink::LayerSelectionPtr> {
  static bool IsNull(const ::cc::mojom::blink::LayerSelectionPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::blink::LayerSelectionPtr* output) { output->reset(); }

  static const decltype(::cc::mojom::blink::LayerSelection::start)& start(
      const ::cc::mojom::blink::LayerSelectionPtr& input) {
    return input->start;
  }

  static const decltype(::cc::mojom::blink::LayerSelection::end)& end(
      const ::cc::mojom::blink::LayerSelectionPtr& input) {
    return input->end;
  }

  static bool Read(::cc::mojom::blink::LayerSelection::DataView input, ::cc::mojom::blink::LayerSelectionPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_LAYER_SELECTION_BOUND_MOJOM_BLINK_H_