// cc/mojom/browser_controls_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_BROWSER_CONTROLS_PARAMS_MOJOM_BLINK_H_
#define CC_MOJOM_BROWSER_CONTROLS_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/browser_controls_params.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_params.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_params.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "cc/mojom/browser_controls_params_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace cc::mojom::blink {








class BLINK_PLATFORM_EXPORT BrowserControlsParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BrowserControlsParams, T>::value>;
  using DataView = BrowserControlsParamsDataView;
  using Data_ = internal::BrowserControlsParams_Data;

  template <typename... Args>
  static BrowserControlsParamsPtr New(Args&&... args) {
    return BrowserControlsParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BrowserControlsParamsPtr From(const U& u) {
    return mojo::TypeConverter<BrowserControlsParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BrowserControlsParams>::Convert(*this);
  }


  BrowserControlsParams();

  BrowserControlsParams(
      float top_controls_height,
      float top_controls_min_height,
      float bottom_controls_height,
      float bottom_controls_min_height,
      bool animate_browser_controls_height_changes,
      bool browser_controls_shrink_blink_size,
      bool only_expand_top_controls_at_page_top);


  ~BrowserControlsParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BrowserControlsParamsPtr>
  BrowserControlsParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserControlsParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserControlsParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BrowserControlsParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BrowserControlsParams_UnserializedMessageContext<
            UserType, BrowserControlsParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BrowserControlsParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BrowserControlsParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BrowserControlsParams_UnserializedMessageContext<
            UserType, BrowserControlsParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BrowserControlsParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float top_controls_height;
  
  float top_controls_min_height;
  
  float bottom_controls_height;
  
  float bottom_controls_min_height;
  
  bool animate_browser_controls_height_changes;
  
  bool browser_controls_shrink_blink_size;
  
  bool only_expand_top_controls_at_page_top;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BrowserControlsParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BrowserControlsParamsPtr BrowserControlsParams::Clone() const {
  return New(
      mojo::Clone(top_controls_height),
      mojo::Clone(top_controls_min_height),
      mojo::Clone(bottom_controls_height),
      mojo::Clone(bottom_controls_min_height),
      mojo::Clone(animate_browser_controls_height_changes),
      mojo::Clone(browser_controls_shrink_blink_size),
      mojo::Clone(only_expand_top_controls_at_page_top)
  );
}

template <typename T, BrowserControlsParams::EnableIfSame<T>*>
bool BrowserControlsParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_controls_height, other_struct.top_controls_height))
    return false;
  if (!mojo::Equals(this->top_controls_min_height, other_struct.top_controls_min_height))
    return false;
  if (!mojo::Equals(this->bottom_controls_height, other_struct.bottom_controls_height))
    return false;
  if (!mojo::Equals(this->bottom_controls_min_height, other_struct.bottom_controls_min_height))
    return false;
  if (!mojo::Equals(this->animate_browser_controls_height_changes, other_struct.animate_browser_controls_height_changes))
    return false;
  if (!mojo::Equals(this->browser_controls_shrink_blink_size, other_struct.browser_controls_shrink_blink_size))
    return false;
  if (!mojo::Equals(this->only_expand_top_controls_at_page_top, other_struct.only_expand_top_controls_at_page_top))
    return false;
  return true;
}

template <typename T, BrowserControlsParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_controls_height < rhs.top_controls_height)
    return true;
  if (rhs.top_controls_height < lhs.top_controls_height)
    return false;
  if (lhs.top_controls_min_height < rhs.top_controls_min_height)
    return true;
  if (rhs.top_controls_min_height < lhs.top_controls_min_height)
    return false;
  if (lhs.bottom_controls_height < rhs.bottom_controls_height)
    return true;
  if (rhs.bottom_controls_height < lhs.bottom_controls_height)
    return false;
  if (lhs.bottom_controls_min_height < rhs.bottom_controls_min_height)
    return true;
  if (rhs.bottom_controls_min_height < lhs.bottom_controls_min_height)
    return false;
  if (lhs.animate_browser_controls_height_changes < rhs.animate_browser_controls_height_changes)
    return true;
  if (rhs.animate_browser_controls_height_changes < lhs.animate_browser_controls_height_changes)
    return false;
  if (lhs.browser_controls_shrink_blink_size < rhs.browser_controls_shrink_blink_size)
    return true;
  if (rhs.browser_controls_shrink_blink_size < lhs.browser_controls_shrink_blink_size)
    return false;
  if (lhs.only_expand_top_controls_at_page_top < rhs.only_expand_top_controls_at_page_top)
    return true;
  if (rhs.only_expand_top_controls_at_page_top < lhs.only_expand_top_controls_at_page_top)
    return false;
  return false;
}


}  // cc::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::cc::mojom::blink::BrowserControlsParams::DataView,
                                         ::cc::mojom::blink::BrowserControlsParamsPtr> {
  static bool IsNull(const ::cc::mojom::blink::BrowserControlsParamsPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::blink::BrowserControlsParamsPtr* output) { output->reset(); }

  static decltype(::cc::mojom::blink::BrowserControlsParams::top_controls_height) top_controls_height(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->top_controls_height;
  }

  static decltype(::cc::mojom::blink::BrowserControlsParams::top_controls_min_height) top_controls_min_height(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->top_controls_min_height;
  }

  static decltype(::cc::mojom::blink::BrowserControlsParams::bottom_controls_height) bottom_controls_height(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->bottom_controls_height;
  }

  static decltype(::cc::mojom::blink::BrowserControlsParams::bottom_controls_min_height) bottom_controls_min_height(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->bottom_controls_min_height;
  }

  static decltype(::cc::mojom::blink::BrowserControlsParams::animate_browser_controls_height_changes) animate_browser_controls_height_changes(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->animate_browser_controls_height_changes;
  }

  static decltype(::cc::mojom::blink::BrowserControlsParams::browser_controls_shrink_blink_size) browser_controls_shrink_blink_size(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->browser_controls_shrink_blink_size;
  }

  static decltype(::cc::mojom::blink::BrowserControlsParams::only_expand_top_controls_at_page_top) only_expand_top_controls_at_page_top(
      const ::cc::mojom::blink::BrowserControlsParamsPtr& input) {
    return input->only_expand_top_controls_at_page_top;
  }

  static bool Read(::cc::mojom::blink::BrowserControlsParams::DataView input, ::cc::mojom::blink::BrowserControlsParamsPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_BROWSER_CONTROLS_PARAMS_MOJOM_BLINK_H_