// cc/mojom/browser_controls_offset_tags.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAGS_MOJOM_H_
#define CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/browser_controls_offset_tags.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_offset_tags.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_offset_tags.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/offset_tag.mojom.h"
#include <string>
#include <vector>




#include "cc/mojom/browser_controls_offset_tag_modifications_mojom_traits.h"




namespace cc::mojom {








class  BrowserControlsOffsetTags {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BrowserControlsOffsetTags, T>::value>;
  using DataView = BrowserControlsOffsetTagsDataView;
  using Data_ = internal::BrowserControlsOffsetTags_Data;

  template <typename... Args>
  static BrowserControlsOffsetTagsPtr New(Args&&... args) {
    return BrowserControlsOffsetTagsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BrowserControlsOffsetTagsPtr From(const U& u) {
    return mojo::TypeConverter<BrowserControlsOffsetTagsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BrowserControlsOffsetTags>::Convert(*this);
  }


  BrowserControlsOffsetTags();

  BrowserControlsOffsetTags(
      const ::viz::OffsetTag& top_controls_offset_tag,
      const ::viz::OffsetTag& content_offset_tag,
      const ::viz::OffsetTag& bottom_controls_offset_tag);


  ~BrowserControlsOffsetTags();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BrowserControlsOffsetTagsPtr>
  BrowserControlsOffsetTagsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserControlsOffsetTags::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserControlsOffsetTags::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BrowserControlsOffsetTags::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BrowserControlsOffsetTags_UnserializedMessageContext<
            UserType, BrowserControlsOffsetTags::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BrowserControlsOffsetTags::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BrowserControlsOffsetTags::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BrowserControlsOffsetTags_UnserializedMessageContext<
            UserType, BrowserControlsOffsetTags::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BrowserControlsOffsetTags::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::OffsetTag top_controls_offset_tag;
  
  ::viz::OffsetTag content_offset_tag;
  
  ::viz::OffsetTag bottom_controls_offset_tag;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BrowserControlsOffsetTagsPtr BrowserControlsOffsetTags::Clone() const {
  return New(
      mojo::Clone(top_controls_offset_tag),
      mojo::Clone(content_offset_tag),
      mojo::Clone(bottom_controls_offset_tag)
  );
}

template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>*>
bool BrowserControlsOffsetTags::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_controls_offset_tag, other_struct.top_controls_offset_tag))
    return false;
  if (!mojo::Equals(this->content_offset_tag, other_struct.content_offset_tag))
    return false;
  if (!mojo::Equals(this->bottom_controls_offset_tag, other_struct.bottom_controls_offset_tag))
    return false;
  return true;
}

template <typename T, BrowserControlsOffsetTags::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_controls_offset_tag < rhs.top_controls_offset_tag)
    return true;
  if (rhs.top_controls_offset_tag < lhs.top_controls_offset_tag)
    return false;
  if (lhs.content_offset_tag < rhs.content_offset_tag)
    return true;
  if (rhs.content_offset_tag < lhs.content_offset_tag)
    return false;
  if (lhs.bottom_controls_offset_tag < rhs.bottom_controls_offset_tag)
    return true;
  if (rhs.bottom_controls_offset_tag < lhs.bottom_controls_offset_tag)
    return false;
  return false;
}


}  // cc::mojom

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::BrowserControlsOffsetTags::DataView,
                                         ::cc::mojom::BrowserControlsOffsetTagsPtr> {
  static bool IsNull(const ::cc::mojom::BrowserControlsOffsetTagsPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::BrowserControlsOffsetTagsPtr* output) { output->reset(); }

  static const decltype(::cc::mojom::BrowserControlsOffsetTags::top_controls_offset_tag)& top_controls_offset_tag(
      const ::cc::mojom::BrowserControlsOffsetTagsPtr& input) {
    return input->top_controls_offset_tag;
  }

  static const decltype(::cc::mojom::BrowserControlsOffsetTags::content_offset_tag)& content_offset_tag(
      const ::cc::mojom::BrowserControlsOffsetTagsPtr& input) {
    return input->content_offset_tag;
  }

  static const decltype(::cc::mojom::BrowserControlsOffsetTags::bottom_controls_offset_tag)& bottom_controls_offset_tag(
      const ::cc::mojom::BrowserControlsOffsetTagsPtr& input) {
    return input->bottom_controls_offset_tag;
  }

  static bool Read(::cc::mojom::BrowserControlsOffsetTags::DataView input, ::cc::mojom::BrowserControlsOffsetTagsPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAGS_MOJOM_H_