// cc/mojom/browser_controls_offset_tags.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAGS_MOJOM_SHARED_H_
#define CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/browser_controls_offset_tags.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"




#include "cc/mojom/browser_controls_offset_tags.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::BrowserControlsOffsetTagsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::BrowserControlsOffsetTagsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::BrowserControlsOffsetTags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::top_controls_offset_tag(input)) in_top_controls_offset_tag = Traits::top_controls_offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_controls_offset_tag)::BaseType> top_controls_offset_tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
      in_top_controls_offset_tag,
      top_controls_offset_tag_fragment);

    fragment->top_controls_offset_tag.Set(
        top_controls_offset_tag_fragment.is_null() ? nullptr : top_controls_offset_tag_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_controls_offset_tag.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_controls_offset_tag in BrowserControlsOffsetTags struct");

    decltype(Traits::content_offset_tag(input)) in_content_offset_tag = Traits::content_offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_offset_tag)::BaseType> content_offset_tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
      in_content_offset_tag,
      content_offset_tag_fragment);

    fragment->content_offset_tag.Set(
        content_offset_tag_fragment.is_null() ? nullptr : content_offset_tag_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_offset_tag.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_offset_tag in BrowserControlsOffsetTags struct");

    decltype(Traits::bottom_controls_offset_tag(input)) in_bottom_controls_offset_tag = Traits::bottom_controls_offset_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bottom_controls_offset_tag)::BaseType> bottom_controls_offset_tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
      in_bottom_controls_offset_tag,
      bottom_controls_offset_tag_fragment);

    fragment->bottom_controls_offset_tag.Set(
        bottom_controls_offset_tag_fragment.is_null() ? nullptr : bottom_controls_offset_tag_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bottom_controls_offset_tag.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bottom_controls_offset_tag in BrowserControlsOffsetTags struct");
  }

  static bool Deserialize(::cc::mojom::internal::BrowserControlsOffsetTags_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::BrowserControlsOffsetTagsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc::mojom {

inline void BrowserControlsOffsetTagsDataView::GetTopControlsOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->top_controls_offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}
inline void BrowserControlsOffsetTagsDataView::GetContentOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->content_offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}
inline void BrowserControlsOffsetTagsDataView::GetBottomControlsOffsetTagDataView(
    ::viz::mojom::OffsetTagDataView* output) {
  auto pointer = data_->bottom_controls_offset_tag.Get();
  *output = ::viz::mojom::OffsetTagDataView(pointer, message_);
}



}  // cc::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAGS_MOJOM_SHARED_H_