// cc/mojom/browser_controls_offset_tag_modifications.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAG_MODIFICATIONS_MOJOM_H_
#define CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAG_MODIFICATIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-features.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_offset_tags.mojom.h"
#include <string>
#include <vector>




#include "cc/mojom/browser_controls_offset_tag_modifications_mojom_traits.h"




namespace cc::mojom {








class  BrowserControlsOffsetTagModifications {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BrowserControlsOffsetTagModifications, T>::value>;
  using DataView = BrowserControlsOffsetTagModificationsDataView;
  using Data_ = internal::BrowserControlsOffsetTagModifications_Data;

  template <typename... Args>
  static BrowserControlsOffsetTagModificationsPtr New(Args&&... args) {
    return BrowserControlsOffsetTagModificationsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BrowserControlsOffsetTagModificationsPtr From(const U& u) {
    return mojo::TypeConverter<BrowserControlsOffsetTagModificationsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BrowserControlsOffsetTagModifications>::Convert(*this);
  }


  BrowserControlsOffsetTagModifications();

  BrowserControlsOffsetTagModifications(
      const ::cc::BrowserControlsOffsetTags& tags,
      int32_t top_controls_additional_height,
      int32_t bottom_controls_additional_height);


  ~BrowserControlsOffsetTagModifications();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BrowserControlsOffsetTagModificationsPtr>
  BrowserControlsOffsetTagModificationsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserControlsOffsetTagModifications::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BrowserControlsOffsetTagModifications::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BrowserControlsOffsetTagModifications::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BrowserControlsOffsetTagModifications_UnserializedMessageContext<
            UserType, BrowserControlsOffsetTagModifications::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BrowserControlsOffsetTagModifications::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BrowserControlsOffsetTagModifications::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BrowserControlsOffsetTagModifications_UnserializedMessageContext<
            UserType, BrowserControlsOffsetTagModifications::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BrowserControlsOffsetTagModifications::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::cc::BrowserControlsOffsetTags tags;
  
  int32_t top_controls_additional_height;
  
  int32_t bottom_controls_additional_height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BrowserControlsOffsetTagModificationsPtr BrowserControlsOffsetTagModifications::Clone() const {
  return New(
      mojo::Clone(tags),
      mojo::Clone(top_controls_additional_height),
      mojo::Clone(bottom_controls_additional_height)
  );
}

template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>*>
bool BrowserControlsOffsetTagModifications::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tags, other_struct.tags))
    return false;
  if (!mojo::Equals(this->top_controls_additional_height, other_struct.top_controls_additional_height))
    return false;
  if (!mojo::Equals(this->bottom_controls_additional_height, other_struct.bottom_controls_additional_height))
    return false;
  return true;
}

template <typename T, BrowserControlsOffsetTagModifications::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tags < rhs.tags)
    return true;
  if (rhs.tags < lhs.tags)
    return false;
  if (lhs.top_controls_additional_height < rhs.top_controls_additional_height)
    return true;
  if (rhs.top_controls_additional_height < lhs.top_controls_additional_height)
    return false;
  if (lhs.bottom_controls_additional_height < rhs.bottom_controls_additional_height)
    return true;
  if (rhs.bottom_controls_additional_height < lhs.bottom_controls_additional_height)
    return false;
  return false;
}


}  // cc::mojom

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::BrowserControlsOffsetTagModifications::DataView,
                                         ::cc::mojom::BrowserControlsOffsetTagModificationsPtr> {
  static bool IsNull(const ::cc::mojom::BrowserControlsOffsetTagModificationsPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::BrowserControlsOffsetTagModificationsPtr* output) { output->reset(); }

  static const decltype(::cc::mojom::BrowserControlsOffsetTagModifications::tags)& tags(
      const ::cc::mojom::BrowserControlsOffsetTagModificationsPtr& input) {
    return input->tags;
  }

  static decltype(::cc::mojom::BrowserControlsOffsetTagModifications::top_controls_additional_height) top_controls_additional_height(
      const ::cc::mojom::BrowserControlsOffsetTagModificationsPtr& input) {
    return input->top_controls_additional_height;
  }

  static decltype(::cc::mojom::BrowserControlsOffsetTagModifications::bottom_controls_additional_height) bottom_controls_additional_height(
      const ::cc::mojom::BrowserControlsOffsetTagModificationsPtr& input) {
    return input->bottom_controls_additional_height;
  }

  static bool Read(::cc::mojom::BrowserControlsOffsetTagModifications::DataView input, ::cc::mojom::BrowserControlsOffsetTagModificationsPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_BROWSER_CONTROLS_OFFSET_TAG_MODIFICATIONS_MOJOM_H_