// url/mojom/scheme_host_port.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "url/mojom/scheme_host_port.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "url/mojom/scheme_host_port.mojom-params-data.h"
#include "url/mojom/scheme_host_port.mojom-shared-message-ids.h"

#include "url/mojom/scheme_host_port.mojom-blink-import-headers.h"
#include "url/mojom/scheme_host_port.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace url::mojom::blink {
SchemeHostPort::SchemeHostPort()
    : scheme(),
      host(),
      port() {}

SchemeHostPort::SchemeHostPort(
    const ::blink::String& scheme_in,
    const ::blink::String& host_in,
    uint16_t port_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)) {}

SchemeHostPort::~SchemeHostPort() = default;

void SchemeHostPort::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SchemeHostPort::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // url::mojom::blink


namespace mojo {


// static
bool StructTraits<::url::mojom::blink::SchemeHostPort::DataView, ::url::mojom::blink::SchemeHostPortPtr>::Read(
    ::url::mojom::blink::SchemeHostPort::DataView input,
    ::url::mojom::blink::SchemeHostPortPtr* output) {
  bool success = true;
  ::url::mojom::blink::SchemeHostPortPtr result(::url::mojom::blink::SchemeHostPort::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace url::mojom::blink {




}  // url::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif