import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
export declare const blurredRectUrl = "//resources/cr_components/search/images/eclipse_wave_blurred_rect.png";
export interface AudioWaveElement {
    $: {
        eclipseSvgWrapper: HTMLElement;
        eclipseSvg: SVGElement;
        mask: SVGMaskElement;
        thinPath: SVGPathElement;
        lowerGlowPath: SVGPathElement;
        clipPathShape: SVGPathElement;
    };
}
/**
 * Voice input visualizer.
 */
export declare class AudioWaveElement extends CrLitElement {
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        isListening: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        isExpanding_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        transcript: {
            type: StringConstructor;
        };
        receivedSpeech: {
            type: BooleanConstructor;
        };
    };
    accessor isListening: boolean;
    accessor transcript: string;
    accessor receivedSpeech: boolean;
    protected accessor isExpanding_: boolean;
    private containerWidth_;
    private animationFrameId_;
    private decayingAmplitude_;
    private frame_;
    private lastUpdateTime_;
    private lastWordCount_;
    private volumeHistory_;
    private activeSimulatedBumps_;
    private firstSyllable_;
    private resizeObserver;
    connectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    disconnectedCallback(): void;
    protected onStartListen(): void;
    protected onStopListen(): void;
    private processFrame;
    protected drawEclipseWavePath(rawInputLevel: number): void;
    protected updateVolume(): void;
    protected handleNewWords(): void;
    protected triggerSyllableBumps(words: string[]): void;
    protected makeSimulatedAudioBump(durationMultiplier: number, durationOffset: number, startTime: number, maxVolMultiplier: number, maxVolOffset: number): void;
    protected getSimulatedAudioBumpsSum(): number;
}
declare global {
    interface HTMLElementTagNameMap {
        'audio-wave': AudioWaveElement;
    }
}
