import type { PageHandlerRemote, SearchQuery, UserFeedback } from './history_embeddings.mojom-webui.js';
import { PageCallbackRouter } from './history_embeddings.mojom-webui.js';
export interface HistoryEmbeddingsBrowserProxy {
    search(query: SearchQuery): void;
    sendQualityLog(selectedIndices: number[], numCharsForQuery: number): void;
    recordSearchResultsMetrics(nonEmptyResults: boolean, userClickedResult: boolean, answerShown: boolean, answerCitationClicked: boolean, otherHistoryResultClicked: boolean, queryWordCount: number): void;
    setUserFeedback(userFeedback: UserFeedback): void;
    maybeShowFeaturePromo(): void;
    openSettingsPage(): void;
    handler: PageHandlerRemote;
    callbackRouter: PageCallbackRouter;
}
export declare class HistoryEmbeddingsBrowserProxyImpl implements HistoryEmbeddingsBrowserProxy {
    static instance: HistoryEmbeddingsBrowserProxy | null;
    handler: PageHandlerRemote;
    callbackRouter: PageCallbackRouter;
    constructor(handler: PageHandlerRemote, callbackRouter?: PageCallbackRouter);
    static getInstance(): HistoryEmbeddingsBrowserProxy;
    static setInstance(newInstance: HistoryEmbeddingsBrowserProxy): void;
    search(query: SearchQuery): void;
    sendQualityLog(selectedIndices: number[], numCharsForQuery: number): void;
    recordSearchResultsMetrics(nonEmptyResults: boolean, userClickedResult: boolean, answerShown: boolean, answerCitationClicked: boolean, otherHistoryResultClicked: boolean, queryWordCount: number): void;
    setUserFeedback(userFeedback: UserFeedback): void;
    maybeShowFeaturePromo(): void;
    openSettingsPage(): void;
}
