import type { String16 } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { PageCallbackRouter, PriceTrackingHandlerRemote } from './price_tracking.mojom-webui.js';
import type { BookmarkProductInfo } from './shared.mojom-webui.js';
export interface PriceTrackingBrowserProxy {
    trackPriceForBookmark(bookmarkId: bigint): void;
    untrackPriceForBookmark(bookmarkId: bigint): void;
    setPriceTrackingStatusForCurrentUrl(track: boolean): void;
    getAllPriceTrackedBookmarkProductInfo(): Promise<{
        productInfos: BookmarkProductInfo[];
    }>;
    getAllShoppingBookmarkProductInfo(): Promise<{
        productInfos: BookmarkProductInfo[];
    }>;
    getParentBookmarkFolderNameForCurrentUrl(): Promise<{
        name: String16;
    }>;
    getShoppingCollectionBookmarkFolderId(): Promise<{
        collectionId: bigint;
    }>;
    showBookmarkEditorForCurrentUrl(): void;
    getCallbackRouter(): PageCallbackRouter;
}
export declare class PriceTrackingBrowserProxyImpl implements PriceTrackingBrowserProxy {
    handler: PriceTrackingHandlerRemote;
    callbackRouter: PageCallbackRouter;
    constructor();
    trackPriceForBookmark(bookmarkId: bigint): void;
    untrackPriceForBookmark(bookmarkId: bigint): void;
    setPriceTrackingStatusForCurrentUrl(track: boolean): void;
    getAllPriceTrackedBookmarkProductInfo(): Promise<{
        productInfos: BookmarkProductInfo[];
    }>;
    getAllShoppingBookmarkProductInfo(): Promise<{
        productInfos: BookmarkProductInfo[];
    }>;
    getShoppingCollectionBookmarkFolderId(): Promise<{
        collectionId: bigint;
    }>;
    getParentBookmarkFolderNameForCurrentUrl(): Promise<{
        name: String16;
    }>;
    showBookmarkEditorForCurrentUrl(): void;
    getCallbackRouter(): PageCallbackRouter;
    static getInstance(): PriceTrackingBrowserProxy;
    static setInstance(obj: PriceTrackingBrowserProxy): void;
}
