// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../cr_shared_vars.css.js";import{assertNotReached}from"//resources/js/assert.js";import{listenOnce}from"//resources/js/util.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./cr_drawer.css.js";import{getHtml}from"./cr_drawer.html.js";export class CrDrawerElement extends CrLitElement{static get is(){return"cr-drawer"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{heading:{type:String},show_:{type:Boolean,reflect:true},align:{type:String,reflect:true}}}#heading_accessor_storage="";get heading(){return this.#heading_accessor_storage}set heading(value){this.#heading_accessor_storage=value}#align_accessor_storage="ltr";get align(){return this.#align_accessor_storage}set align(value){this.#align_accessor_storage=value}#show__accessor_storage=false;get show_(){return this.#show__accessor_storage}set show_(value){this.#show__accessor_storage=value}get open(){return this.$.dialog.open}set open(_value){assertNotReached("Cannot set |open|.")}toggle(){if(this.open){this.cancel()}else{this.openDrawer()}}async openDrawer(){if(this.open){return}this.$.dialog.showModal();this.show_=true;await this.updateComplete;this.fire("cr-drawer-opening");listenOnce(this.$.dialog,"transitionend",(()=>{this.fire("cr-drawer-opened")}))}dismiss_(cancel){if(!this.open){return}this.show_=false;listenOnce(this.$.dialog,"transitionend",(()=>{this.$.dialog.close(cancel?"canceled":"closed")}))}cancel(){this.dismiss_(true)}close(){this.dismiss_(false)}wasCanceled(){return!this.open&&this.$.dialog.returnValue==="canceled"}onContainerClick_(event){event.stopPropagation()}onDialogClick_(){this.cancel()}onDialogCancel_(event){event.preventDefault();this.cancel()}onDialogClose_(){this.fire("close")}}customElements.define(CrDrawerElement.is,CrDrawerElement);