// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{sanitizeInnerHtml}from"//resources/js/parse_html_subset.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./searchbox_action.css.js";import{getHtml}from"./searchbox_action.html.js";export class SearchboxActionElement extends CrLitElement{static get is(){return"cr-searchbox-action"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{hint:{type:String},hintHtml_:{state:true,type:String},suggestionContents:{type:String},iconPath:{type:String},iconStyle_:{state:true,type:String},ariaLabel:{type:String},actionIndex:{type:Number}}}#hint_accessor_storage="";get hint(){return this.#hint_accessor_storage}set hint(value){this.#hint_accessor_storage=value}#hintHtml__accessor_storage=window.trustedTypes.emptyHTML;get hintHtml_(){return this.#hintHtml__accessor_storage}set hintHtml_(value){this.#hintHtml__accessor_storage=value}#suggestionContents_accessor_storage="";get suggestionContents(){return this.#suggestionContents_accessor_storage}set suggestionContents(value){this.#suggestionContents_accessor_storage=value}#iconPath_accessor_storage="";get iconPath(){return this.#iconPath_accessor_storage}set iconPath(value){this.#iconPath_accessor_storage=value}#iconStyle__accessor_storage="";get iconStyle_(){return this.#iconStyle__accessor_storage}set iconStyle_(value){this.#iconStyle__accessor_storage=value}#ariaLabel_accessor_storage="";get ariaLabel(){return this.#ariaLabel_accessor_storage}set ariaLabel(value){this.#ariaLabel_accessor_storage=value}#actionIndex_accessor_storage=-1;get actionIndex(){return this.#actionIndex_accessor_storage}set actionIndex(value){this.#actionIndex_accessor_storage=value}firstUpdated(){this.addEventListener("click",(event=>this.onActionClick_(event)));this.addEventListener("keydown",(event=>this.onActionKeyDown_(event)));this.addEventListener("mousedown",(event=>this.onActionMouseDown_(event)))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("hint")){this.hintHtml_=this.computeHintHtml_()}if(changedProperties.has("iconPath")){this.iconStyle_=this.computeActionIconStyle_()}}onActionClick_(e){this.fire("execute-action",{event:e,actionIndex:this.actionIndex});e.preventDefault();e.stopPropagation()}onActionKeyDown_(e){if(e.key&&(e.key==="Enter"||e.key===" ")){this.onActionClick_(e)}}onActionMouseDown_(e){e.preventDefault()}computeHintHtml_(){if(this.hint){return sanitizeInnerHtml(this.hint)}return window.trustedTypes.emptyHTML}computeActionIconStyle_(){if(this.iconPath.startsWith("data:image/")){return`background-image: url(${this.iconPath})`}return`-webkit-mask-image: url(${this.iconPath})`}}customElements.define(SearchboxActionElement.is,SearchboxActionElement);